ALTER TABLE ADR.PH_REGISTRY_DETAIL
  DROP CONSTRAINT PHREGDTL_PRPLHRTREG_FK;


ALTER TABLE ADR.PH_REGISTRY_DETAIL ADD (
  CONSTRAINT PHREGDTL_PRPLHRTREG_FK 
  FOREIGN KEY (PURPLE_HEART_REGISTRY_ID) 
  REFERENCES ADR.PURPLE_HEART_REGISTRY (PURPLE_HEART_REGISTRY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL
  DROP CONSTRAINT MONEYBNDTL_MONEYBEN_FK;


ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL ADD (
  CONSTRAINT MONEYBNDTL_MONEYBEN_FK 
  FOREIGN KEY (MONETARY_BENEFIT_ID) 
  REFERENCES ADR.MONETARY_BENEFIT (MONETARY_BENEFIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.CORRESPONDENCE
  DROP CONSTRAINT CORRESPONDENCE_EMAIL_TEMP_FK;


ALTER TABLE ADR.CORRESPONDENCE ADD (
  CONSTRAINT CORRESPONDENCE_EMAIL_TEMP_FK 
  FOREIGN KEY (EMAIL_TEMPLATE_ID) 
  REFERENCES ADR.COM_EMAIL_TEMPLATE (COM_EMAIL_TEMPLATE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION
  DROP CONSTRAINT RGSTRLODX_RGSTRYSTAT_FK;


ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION ADD (
  CONSTRAINT RGSTRLODX_RGSTRYSTAT_FK 
  FOREIGN KEY (REGISTRY_LOAD_STATISTICS_ID) 
  REFERENCES ADR.REGISTRY_LOAD_STATISTICS (REGISTRY_LOAD_STATISTICS_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_TRIGGERS
  DROP CONSTRAINT QRTZ_TRIGGER_TO_JOBS_FK;


ALTER TABLE ADR.QRTZ_TRIGGERS ADD (
  CONSTRAINT QRTZ_TRIGGER_TO_JOBS_FK 
  FOREIGN KEY (SCHED_NAME, JOB_NAME, JOB_GROUP) 
  REFERENCES ADR.QRTZ_JOB_DETAILS (SCHED_NAME,JOB_NAME,JOB_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS
  DROP CONSTRAINT QRTZ_SIMPLE_TRIG_TO_TRIG_FK;


ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS ADD (
  CONSTRAINT QRTZ_SIMPLE_TRIG_TO_TRIG_FK 
  FOREIGN KEY (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP) 
  REFERENCES ADR.QRTZ_TRIGGERS (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_CRON_TRIGGERS
  DROP CONSTRAINT QRTZ_CRON_TRIG_TO_TRIG_FK;


ALTER TABLE ADR.QRTZ_CRON_TRIGGERS ADD (
  CONSTRAINT QRTZ_CRON_TRIG_TO_TRIG_FK 
  FOREIGN KEY (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP) 
  REFERENCES ADR.QRTZ_TRIGGERS (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_BLOB_TRIGGERS
  DROP CONSTRAINT QRTZ_BLOB_TRIG_TO_TRIG_FK;


ALTER TABLE ADR.QRTZ_BLOB_TRIGGERS ADD (
  CONSTRAINT QRTZ_BLOB_TRIG_TO_TRIG_FK 
  FOREIGN KEY (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP) 
  REFERENCES ADR.QRTZ_TRIGGERS (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_SIMPROP_TRIGGERS
  DROP CONSTRAINT QRTZ_SIMPROP_TRIG_TO_TRIG_FK;


ALTER TABLE ADR.QRTZ_SIMPROP_TRIGGERS ADD (
  CONSTRAINT QRTZ_SIMPROP_TRIG_TO_TRIG_FK 
  FOREIGN KEY (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP) 
  REFERENCES ADR.QRTZ_TRIGGERS (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.DEPLOYMENT
  DROP CONSTRAINT DEP_ACT_FK;


ALTER TABLE ADR.DEPLOYMENT ADD (
  CONSTRAINT DEP_ACT_FK 
  FOREIGN KEY (ACTIVATION_ID) 
  REFERENCES ADR.ACTIVATION (ACTIVATION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PENSION
  DROP CONSTRAINT RELATIONSHIP51;


ALTER TABLE ADR.PENSION ADD (
  CONSTRAINT RELATIONSHIP51 
  FOREIGN KEY (PENSION_AWARD_REASON_ID) 
  REFERENCES ADR.PENSION_REASON (PENSION_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PENSION
  DROP CONSTRAINT RELATIONSHIP52;


ALTER TABLE ADR.PENSION ADD (
  CONSTRAINT RELATIONSHIP52 
  FOREIGN KEY (PENSION_AWARD_TERMINATION_ID1) 
  REFERENCES ADR.PENSION_REASON (PENSION_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PENSION
  DROP CONSTRAINT RELATIONSHIP53;


ALTER TABLE ADR.PENSION ADD (
  CONSTRAINT RELATIONSHIP53 
  FOREIGN KEY (PENSION_AWARD_TERMINATION_ID2) 
  REFERENCES ADR.PENSION_REASON (PENSION_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PENSION
  DROP CONSTRAINT RELATIONSHIP54;


ALTER TABLE ADR.PENSION ADD (
  CONSTRAINT RELATIONSHIP54 
  FOREIGN KEY (PENSION_AWARD_TERMINATION_ID3) 
  REFERENCES ADR.PENSION_REASON (PENSION_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PENSION
  DROP CONSTRAINT RELATIONSHIP55;


ALTER TABLE ADR.PENSION ADD (
  CONSTRAINT RELATIONSHIP55 
  FOREIGN KEY (PENSION_AWARD_TERMINATION_ID4) 
  REFERENCES ADR.PENSION_REASON (PENSION_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BROKER_SERVICE_LOG
  DROP CONSTRAINT BRSL_TRANSTYP_FK;


ALTER TABLE ADR.BROKER_SERVICE_LOG ADD (
  CONSTRAINT BRSL_TRANSTYP_FK 
  FOREIGN KEY (TRANSMISSION_TYPE_ID) 
  REFERENCES ADR.TRANSMISSION_TYPE (TRANSMISSION_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_SERVICE_LOG
  DROP CONSTRAINT CCNSERVLOG_TRANSTYPE_ID_FK;


ALTER TABLE ADR.CCN_SERVICE_LOG ADD (
  CONSTRAINT CCNSERVLOG_TRANSTYPE_ID_FK 
  FOREIGN KEY (TRANSMISSION_TYPE_ID) 
  REFERENCES ADR.TRANSMISSION_TYPE (TRANSMISSION_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_FILETRANSFER
  DROP CONSTRAINT CCNFITRANSFER_TRNSTYPEID_FK;


ALTER TABLE ADR.CCN_FILETRANSFER ADD (
  CONSTRAINT CCNFITRANSFER_TRNSTYPEID_FK 
  FOREIGN KEY (TRANSMISSION_TYPE_ID) 
  REFERENCES ADR.TRANSMISSION_TYPE (TRANSMISSION_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BROKER_SERVICE_LOG
  DROP CONSTRAINT BRSL_BRSE_FK;


ALTER TABLE ADR.BROKER_SERVICE_LOG ADD (
  CONSTRAINT BRSL_BRSE_FK 
  FOREIGN KEY (BROKER_SERVICE_ERROR_ID) 
  REFERENCES ADR.BROKER_SERVICE_ERROR (BROKER_SERVICE_ERROR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLE_PERMISSIONS
  DROP CONSTRAINT ROLEPERMS_STD_PERM_FK;


ALTER TABLE ADR.ROLE_PERMISSIONS ADD (
  CONSTRAINT ROLEPERMS_STD_PERM_FK 
  FOREIGN KEY (PERMISSION_TYPE_ID) 
  REFERENCES ADRREF.STD_PERMISSIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS
  DROP CONSTRAINT PSETPRM_STD_PERM_FK;


ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS ADD (
  CONSTRAINT PSETPRM_STD_PERM_FK 
  FOREIGN KEY (PERMISSION_TYPE_ID) 
  REFERENCES ADRREF.STD_PERMISSIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_PERMISSIONS
  DROP CONSTRAINT RPTPERM_STD_PERM_FK;


ALTER TABLE ADR.RPT_PERMISSIONS ADD (
  CONSTRAINT RPTPERM_STD_PERM_FK 
  FOREIGN KEY (PERMISSION_TYPE_ID) 
  REFERENCES ADRREF.STD_PERMISSIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_PERMISSIONS
  DROP CONSTRAINT USERPERM_STD_PERM_FK;


ALTER TABLE ADR.USER_PERMISSIONS ADD (
  CONSTRAINT USERPERM_STD_PERM_FK 
  FOREIGN KEY (PERMISSION_TYPE_ID) 
  REFERENCES ADRREF.STD_PERMISSIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT ADDR_STD_NCOADELTYP_FK;


ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT ADDR_STD_NCOADELTYP_FK 
  FOREIGN KEY (NCOA_DELIVERY_TYPE_ID) 
  REFERENCES ADRREF.STD_NCOADELIVERYTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT ADDR_STD_NCOASTATYP_FK;


ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT ADDR_STD_NCOASTATYP_FK 
  FOREIGN KEY (NCOA_STATUS_TYPE_ID) 
  REFERENCES ADRREF.STD_NCOASTATUSTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT ADDR_STD_NCOAZIPMCH_FK;


ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT ADDR_STD_NCOAZIPMCH_FK 
  FOREIGN KEY (NCOA_ZIP_MATCH_TYPE_ID) 
  REFERENCES ADRREF.STD_NCOAZIPMATCHTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT ADDR_STD_NCOAZIPNOMTCH_FK;


ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT ADDR_STD_NCOAZIPNOMTCH_FK 
  FOREIGN KEY (NCOA_ZIP_NO_MATCH_TYPE_ID) 
  REFERENCES ADRREF.STD_NCOAZIPNOMATCHTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_AAC_ERROR_DETAIL
  DROP CONSTRAINT COMAACERR_STD_COMERRTYP_FK;


ALTER TABLE ADR.COM_AAC_ERROR_DETAIL ADD (
  CONSTRAINT COMAACERR_STD_COMERRTYP_FK 
  FOREIGN KEY (COM_AAC_ERROR_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMERRORTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_COM_ERROR
  DROP CONSTRAINT RPTCOMERR_COMERRTYP_FK;


ALTER TABLE ADR.RPT_COM_ERROR ADD (
  CONSTRAINT RPTCOMERR_COMERRTYP_FK 
  FOREIGN KEY (COM_AAC_ERROR_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMERRORTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_LETTER_TEMPLATE
  DROP CONSTRAINT COMLTRTPL_STD_COMLTRGTYPE_FK;


ALTER TABLE ADR.COM_LETTER_TEMPLATE ADD (
  CONSTRAINT COMLTRTPL_STD_COMLTRGTYPE_FK 
  FOREIGN KEY (COM_LETTER_GENERATED_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMLETTERGENTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_LETTER_TEMPLATE
  DROP CONSTRAINT COMLTRTPL_STD_COMLTRTYPE_FK;


ALTER TABLE ADR.COM_LETTER_TEMPLATE ADD (
  CONSTRAINT COMLTRTPL_STD_COMLTRTYPE_FK 
  FOREIGN KEY (COM_LETTER_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMLETTERTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT COMMAIL_COMLETTYPE_FK;


ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT COMMAIL_COMLETTYPE_FK 
  FOREIGN KEY (COM_LETTER_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMLETTERTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL
  DROP CONSTRAINT COMMLSTAT_STD_COMAILSTAT_FK;


ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL ADD (
  CONSTRAINT COMMLSTAT_STD_COMAILSTAT_FK 
  FOREIGN KEY (COM_MAILING_STATUS_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMMAILINGSTTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT COMMAIL_STD_COMMLTRG_FK;


ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT COMMAIL_STD_COMMLTRG_FK 
  FOREIGN KEY (COM_MAILING_TRIGGER_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMMLTRIGGERTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_COM_REJECT_REASON
  DROP CONSTRAINT RPTCOMRJCT_COMAACRJCT_FK;


ALTER TABLE ADR.RPT_COM_REJECT_REASON ADD (
  CONSTRAINT RPTCOMRJCT_COMAACRJCT_FK 
  FOREIGN KEY (COM_AAC_REJECT_REASON_TYPE_ID) 
  REFERENCES ADRREF.STD_COMREJECTREASONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS
  DROP CONSTRAINT R_1058;


ALTER TABLE ADR.HANDBOOK_MAIL_STATUS ADD (
  CONSTRAINT R_1058 
  FOREIGN KEY (STD_COMREJECTREASONTYPE_ID) 
  REFERENCES ADRREF.STD_COMREJECTREASONTYPE (ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT COMMAIL_STD_COMRJCTRSN_FK;


ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT COMMAIL_STD_COMRJCTRSN_FK 
  FOREIGN KEY (COM_AAC_REJECT_REASON_TYPE_ID) 
  REFERENCES ADRREF.STD_COMREJECTREASONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE
  DROP CONSTRAINT WKFCASE_WKFISUTYPE_FK;


ALTER TABLE ADR.WKF_CASE ADD (
  CONSTRAINT WKFCASE_WKFISUTYPE_FK 
  FOREIGN KEY (WKF_CASE_ISSUE_TYPE_ID) 
  REFERENCES ADRREF.STD_WKFISSUETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL
  DROP CONSTRAINT WKFCSESTAT_STD_WKFACTVTY_FK;


ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL ADD (
  CONSTRAINT WKFCSESTAT_STD_WKFACTVTY_FK 
  FOREIGN KEY (WKF_CASE_ACTIVITY_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASEACTIVITY (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL
  DROP CONSTRAINT WKFCSESTAT_STD_WKFRQST_FK;


ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL ADD (
  CONSTRAINT WKFCSESTAT_STD_WKFRQST_FK 
  FOREIGN KEY (WKF_CASE_REQUEST_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASEREQUEST (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE
  DROP CONSTRAINT WKFCASE_STD_WKFRQST_FK;


ALTER TABLE ADR.WKF_CASE ADD (
  CONSTRAINT WKFCASE_STD_WKFRQST_FK 
  FOREIGN KEY (WKF_CASE_REQUEST_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASEREQUEST (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL
  DROP CONSTRAINT WKFCSESTAT_STD_WKFCSST_FK;


ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL ADD (
  CONSTRAINT WKFCSESTAT_STD_WKFCSST_FK 
  FOREIGN KEY (WKF_CASE_STATUS_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASESTATUS (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_WKF_CASE
  DROP CONSTRAINT RPTWKFCASE_WKFCASETYP_FK;


ALTER TABLE ADR.RPT_WKF_CASE ADD (
  CONSTRAINT RPTWKFCASE_WKFCASETYP_FK 
  FOREIGN KEY (WKF_CASE_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE
  DROP CONSTRAINT WKFCASE_STD_WKFCSTYPE_FK;


ALTER TABLE ADR.WKF_CASE ADD (
  CONSTRAINT WKFCASE_STD_WKFCSTYPE_FK 
  FOREIGN KEY (WKF_CASE_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR
  DROP CONSTRAINT RPTELGFCTR_STDRPTELGF_FK;


ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR ADD (
  CONSTRAINT RPTELGFCTR_STDRPTELGF_FK 
  FOREIGN KEY (STD_REPORTELIGFACTOR_ID) 
  REFERENCES ADRREF.STD_REPORTELIGFACTOR (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTENRLPRSTAT_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTENRLPRSTAT_FK 
  FOREIGN KEY (RPT_ENROLLPRSTAT_ID) 
  REFERENCES ADRREF.STD_REPORTENROLLPRSTAT (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_PERMISSIONS
  DROP CONSTRAINT RPTPERM_STD_RPTTYPE_FK;


ALTER TABLE ADR.RPT_PERMISSIONS ADD (
  CONSTRAINT RPTPERM_STD_RPTTYPE_FK 
  FOREIGN KEY (RPT_TYPE_ID) 
  REFERENCES ADRREF.STD_REPORTTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTMNTHDAY_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTMNTHDAY_FK 
  FOREIGN KEY (RPT_DAY_OF_MONTH_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDAYOFMONTHTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTDAYQRTR_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTDAYQRTR_FK 
  FOREIGN KEY (RPT_DAY_OF_QUARTER_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDAYOFQUARTERTYP (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTDYWKTYP_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTDYWKTYP_FK 
  FOREIGN KEY (RPT_DAY_OF_WEEK_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDAYOFWEEKTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_DAY_OF_WEEK
  DROP CONSTRAINT RPTDOWK_STD_RPTDYWKTYP_FK;


ALTER TABLE ADR.RPT_DAY_OF_WEEK ADD (
  CONSTRAINT RPTDOWK_STD_RPTDYWKTYP_FK 
  FOREIGN KEY (RPT_DAY_OF_WEEK_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDAYOFWEEKTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTDTLBY_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTDTLBY_FK 
  FOREIGN KEY (RPT_DETAIL_BY_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDETAILBYTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTDTLFOR_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTDTLFOR_FK 
  FOREIGN KEY (RPT_DETAIL_FOR_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDETAILFORTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SCHEDRPT_RPTDIVTYPE_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SCHEDRPT_RPTDIVTYPE_FK 
  FOREIGN KEY (RPT_DIVISION_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDIVISIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_EED_WEEKLY
  DROP CONSTRAINT RPTEWK_STD_EEDWKLYTYP_FK;


ALTER TABLE ADR.RPT_EED_WEEKLY ADD (
  CONSTRAINT RPTEWK_STD_EEDWKLYTYP_FK 
  FOREIGN KEY (RPT_EED_WEEKLY_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTEEDWEEKLYTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION
  DROP CONSTRAINT RGSTRLODX_STD_RPTEXCPT_FK;


ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION ADD (
  CONSTRAINT RGSTRLODX_STD_RPTEXCPT_FK 
  FOREIGN KEY (RPT_EXCEPTION_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTEXCEPTIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTEXCPT_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTEXCPT_FK 
  FOREIGN KEY (RPT_EXCEPTION_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTEXCEPTIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.APP_PARAMETER
  DROP CONSTRAINT APARAM_STD_APARAMTYP_FK;


ALTER TABLE ADR.APP_PARAMETER ADD (
  CONSTRAINT APARAM_STD_APARAMTYP_FK 
  FOREIGN KEY (APP_PARAMETER_TYPE_ID) 
  REFERENCES ADRREF.STD_APPPARAMETERTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.APP_PARAMETER
  DROP CONSTRAINT APARAM_STD_APARAMU_FK;


ALTER TABLE ADR.APP_PARAMETER ADD (
  CONSTRAINT APARAM_STD_APARAMU_FK 
  FOREIGN KEY (APP_PARAMETER_UNIT_ID) 
  REFERENCES ADRREF.STD_APPPARAMETERUNIT (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_LETTER_FILE
  DROP CONSTRAINT RPTLTRFLTP_RPTLTRFILE_FK;


ALTER TABLE ADR.RPT_LETTER_FILE ADD (
  CONSTRAINT RPTLTRFLTP_RPTLTRFILE_FK 
  FOREIGN KEY (RPT_LETTER_FILE_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTLETTERFILETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTMTHLST_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTMTHLST_FK 
  FOREIGN KEY (RPT_MONTH_LIST_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTMONTHLIST (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTOUTFILE_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTOUTFILE_FK 
  FOREIGN KEY (RPT_OUTPUT_FILE_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTOUTPUTFILETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_COMPLETED_REPORTS
  DROP CONSTRAINT CMRPT_STD_RPTOUTFILE_FK;


ALTER TABLE ADR.RPT_COMPLETED_REPORTS ADD (
  CONSTRAINT CMRPT_STD_RPTOUTFILE_FK 
  FOREIGN KEY (RPT_OUTPUT_FILE_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTOUTPUTFILETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTFORMAT_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTFORMAT_FK 
  FOREIGN KEY (RPT_OUTPUT_FORMAT_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTOUTFORMATTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTPERIOD_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTPERIOD_FK 
  FOREIGN KEY (RPT_PERIOD_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTPERIODTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTQRTRLST_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTQRTRLST_FK 
  FOREIGN KEY (RPT_QUARTER_LIST_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTQUARTERLIST (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTFREQTYP_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTFREQTYP_FK 
  FOREIGN KEY (RPT_RUN_FREQUENCY_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTRUNFREQUENCYTYP (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTSCHED_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTSCHED_FK 
  FOREIGN KEY (RPT_SCHEDULE_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTSCHEDULETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTSITEDSP_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTSITEDSP_FK 
  FOREIGN KEY (RPT_SITE_DISPLAY_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTSITEDISPLAYTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTSTDRPT_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTSTDRPT_FK 
  FOREIGN KEY (RPT_STANDARD_REPORT_ID) 
  REFERENCES ADRREF.STD_RPTSTANDARDREPORTS (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_COMPLETED_REPORTS
  DROP CONSTRAINT CMRPT_STD_RPTSTDRPT_FK;


ALTER TABLE ADR.RPT_COMPLETED_REPORTS ADD (
  CONSTRAINT CMRPT_STD_RPTSTDRPT_FK 
  FOREIGN KEY (RPT_STANDARD_REPORT_ID) 
  REFERENCES ADRREF.STD_RPTSTANDARDREPORTS (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_STATUS_COMPONENT
  DROP CONSTRAINT RPTSTATCMP_STDRPTSTCM_FK;


ALTER TABLE ADR.RPT_STATUS_COMPONENT ADD (
  CONSTRAINT RPTSTATCMP_STDRPTSTCM_FK 
  FOREIGN KEY (STD_RPTSTATUSCOMPONENT_ID) 
  REFERENCES ADRREF.STD_RPTSTATUSCOMPONENT (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SRPT_STD_RPTWKMNTH_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SRPT_STD_RPTWKMNTH_FK 
  FOREIGN KEY (RPT_WEEK_OF_MONTH_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTWEEKOFMONTHTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SCHEDRPT_RPTWRKITM_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SCHEDRPT_RPTWRKITM_FK 
  FOREIGN KEY (RPT_WORK_ITEM_STATUS_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTWORKITEMSTTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT
  DROP CONSTRAINT RELATIONSHIP59;


ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT ADD (
  CONSTRAINT RELATIONSHIP59 
  FOREIGN KEY (HEALTH_CARE_PROVIDER_ID) 
  REFERENCES ADR.HEALTH_CARE_PROVIDER (HEALTH_CARE_PROVIDER_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BATCH_REQUEST_FACILITY
  DROP CONSTRAINT R_1061;


ALTER TABLE ADR.BATCH_REQUEST_FACILITY ADD (
  CONSTRAINT R_1061 
  FOREIGN KEY (HANDBOOK_BATCH_REQUEST_ID) 
  REFERENCES ADR.HANDBOOK_BATCH_REQUEST (HANDBOOK_BATCH_REQUEST_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP
  DROP CONSTRAINT R_1062;


ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP ADD (
  CONSTRAINT R_1062 
  FOREIGN KEY (HANDBOOK_BATCH_REQUEST_ID) 
  REFERENCES ADR.HANDBOOK_BATCH_REQUEST (HANDBOOK_BATCH_REQUEST_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN
  DROP CONSTRAINT R_1063;


ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN ADD (
  CONSTRAINT R_1063 
  FOREIGN KEY (HANDBOOK_BATCH_REQUEST_ID) 
  REFERENCES ADR.HANDBOOK_BATCH_REQUEST (HANDBOOK_BATCH_REQUEST_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE
  DROP CONSTRAINT R_1065;


ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE ADD (
  CONSTRAINT R_1065 
  FOREIGN KEY (HANDBOOK_BATCH_REQUEST_ID) 
  REFERENCES ADR.HANDBOOK_BATCH_REQUEST (HANDBOOK_BATCH_REQUEST_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST
  DROP CONSTRAINT R_1064;


ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST ADD (
  CONSTRAINT R_1064 
  FOREIGN KEY (STD_HANDBOOKBATCHREQUESTSTA_ID) 
  REFERENCES ADRREF.STD_HANDBOOKBATCHREQUESTSTATUS (ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS
  DROP CONSTRAINT R_1060;


ALTER TABLE ADR.HANDBOOK_MAIL_STATUS ADD (
  CONSTRAINT R_1060 
  FOREIGN KEY (STD_HANDBOOKMAILSTATTYPE_ID) 
  REFERENCES ADRREF.STD_HANDBOOKMAILSTATTYPE (ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST
  DROP CONSTRAINT R_1051;


ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST ADD (
  CONSTRAINT R_1051 
  FOREIGN KEY (STD_HANDBOOKRELEASECNTL_ID) 
  REFERENCES ADRREF.STD_HANDBOOKRELEASECONTROL (ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE
  DROP CONSTRAINT R_1050;


ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE ADD (
  CONSTRAINT R_1050 
  FOREIGN KEY (STD_HANDBOOKRELEASECNTL_ID) 
  REFERENCES ADRREF.STD_HANDBOOKRELEASECONTROL (ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL
  DROP CONSTRAINT DLVPRFEM_DLVPRF_FK;


ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL ADD (
  CONSTRAINT DLVPRFEM_DLVPRF_FK 
  FOREIGN KEY (DELIVERY_PREFERENCE_ID) 
  REFERENCES ADR.DELIVERY_PREFERENCE (DELIVERY_PREFERENCE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EMPLOYMENT
  DROP CONSTRAINT EMPLOY_PRSNREL_FK;


ALTER TABLE ADR.EMPLOYMENT ADD (
  CONSTRAINT EMPLOY_PRSNREL_FK 
  FOREIGN KEY (PERSON_RELATION_ID) 
  REFERENCES ADR.PERSON_RELATION (PERSON_RELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT ADDR_PRSNREL_FK;


ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT ADDR_PRSNREL_FK 
  FOREIGN KEY (PERSON_RELATION_ID) 
  REFERENCES ADR.PERSON_RELATION (PERSON_RELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN
  DROP CONSTRAINT SSN_PRSNREL_FK;


ALTER TABLE ADR.SSN ADD (
  CONSTRAINT SSN_PRSNREL_FK 
  FOREIGN KEY (PERSON_RELATION_ID) 
  REFERENCES ADR.PERSON_RELATION (PERSON_RELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.PHONE
  DROP CONSTRAINT PHONE_PRSNREL_FK;


ALTER TABLE ADR.PHONE ADD (
  CONSTRAINT PHONE_PRSNREL_FK 
  FOREIGN KEY (PERSON_RELATION_ID) 
  REFERENCES ADR.PERSON_RELATION (PERSON_RELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT
  DROP CONSTRAINT FINSTATE_PRSNREL_FK;


ALTER TABLE ADR.FINANCIAL_STATEMENT ADD (
  CONSTRAINT FINSTATE_PRSNREL_FK 
  FOREIGN KEY (PERSON_RELATION_ID) 
  REFERENCES ADR.PERSON_RELATION (PERSON_RELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL
  DROP CONSTRAINT RATEDISDET_SVCCON_FK;


ALTER TABLE ADR.RATED_DISABILITY_DETAIL ADD (
  CONSTRAINT RATEDISDET_SVCCON_FK 
  FOREIGN KEY (SERVICE_CONNECTED_ID) 
  REFERENCES ADR.SERVICE_CONNECTED (SERVICE_CONNECTED_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR
  DROP CONSTRAINT RPTELGFCTR_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR ADD (
  CONSTRAINT RPTELGFCTR_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_PH_REJECT_REASON
  DROP CONSTRAINT RPTPHRJCT_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_PH_REJECT_REASON ADD (
  CONSTRAINT RPTPHRJCT_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_LETTER_FILE
  DROP CONSTRAINT RPTLTRFLTP_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_LETTER_FILE ADD (
  CONSTRAINT RPTLTRFLTP_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_PRIORITY_GROUP
  DROP CONSTRAINT RPTPRIOGRP_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_PRIORITY_GROUP ADD (
  CONSTRAINT RPTPRIOGRP_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_EED_WEEKLY
  DROP CONSTRAINT RPTEWK_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_EED_WEEKLY ADD (
  CONSTRAINT RPTEWK_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_COM_REJECT_REASON
  DROP CONSTRAINT RPTCOMRJCT_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_COM_REJECT_REASON ADD (
  CONSTRAINT RPTCOMRJCT_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_STATUS_COMPONENT
  DROP CONSTRAINT RPTSTATCMP_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_STATUS_COMPONENT ADD (
  CONSTRAINT RPTSTATCMP_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS
  DROP CONSTRAINT RPTPRSNMRG_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS ADD (
  CONSTRAINT RPTPRSNMRG_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_USERS
  DROP CONSTRAINT RPTUSERS_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_USERS ADD (
  CONSTRAINT RPTUSERS_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_COM_ERROR
  DROP CONSTRAINT RPTCOMERR_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_COM_ERROR ADD (
  CONSTRAINT RPTCOMERR_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY
  DROP CONSTRAINT RPTENRLCAT_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY ADD (
  CONSTRAINT RPTENRLCAT_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON
  DROP CONSTRAINT RPTINVADDR_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON ADD (
  CONSTRAINT RPTINVADDR_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_WKF_CASE
  DROP CONSTRAINT RPTWKFCASE_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_WKF_CASE ADD (
  CONSTRAINT RPTWKFCASE_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_REGISTRY
  DROP CONSTRAINT RPTRGSTRY_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_REGISTRY ADD (
  CONSTRAINT RPTRGSTRY_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_ENROLLMENT_STATUS
  DROP CONSTRAINT RPTENRSTAT_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_ENROLLMENT_STATUS ADD (
  CONSTRAINT RPTENRSTAT_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON
  DROP CONSTRAINT RPTCANDECL_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON ADD (
  CONSTRAINT RPTCANDECL_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE
  DROP CONSTRAINT RPTENROVER_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE ADD (
  CONSTRAINT RPTENROVER_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_MESSAGE
  DROP CONSTRAINT RPTMSG_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_MESSAGE ADD (
  CONSTRAINT RPTMSG_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_USER_GROUP
  DROP CONSTRAINT RPTUSRGRP_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_USER_GROUP ADD (
  CONSTRAINT RPTUSRGRP_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_MESSAGE_ERROR
  DROP CONSTRAINT RPTMSGERR_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_MESSAGE_ERROR ADD (
  CONSTRAINT RPTMSGERR_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_VBA_QUERY_STATUS
  DROP CONSTRAINT RPTVBAQRY_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_VBA_QUERY_STATUS ADD (
  CONSTRAINT RPTVBAQRY_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_DAY_OF_WEEK
  DROP CONSTRAINT RPTDAYOFWK_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_DAY_OF_WEEK ADD (
  CONSTRAINT RPTDAYOFWK_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SITE
  DROP CONSTRAINT RPTSITE_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_SITE ADD (
  CONSTRAINT RPTSITE_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_QUERY_SITE
  DROP CONSTRAINT RPTQRYSITE_SCHEDRPT_FK;


ALTER TABLE ADR.RPT_QUERY_SITE ADD (
  CONSTRAINT RPTQRYSITE_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_FORM_TYPE
  DROP CONSTRAINT RPT_SCHED_REP_RPT_FORM_TYP;


ALTER TABLE ADR.RPT_FORM_TYPE ADD (
  CONSTRAINT RPT_SCHED_REP_RPT_FORM_TYP 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLE_PERMISSION_SETS
  DROP CONSTRAINT ROLEPERMST_PERMSET_FK;


ALTER TABLE ADR.ROLE_PERMISSION_SETS ADD (
  CONSTRAINT ROLEPERMST_PERMSET_FK 
  FOREIGN KEY (PERMISSION_SET_ID) 
  REFERENCES ADR.PERMISSION_SET (PERMISSION_SET_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_PERMISSION_SETS
  DROP CONSTRAINT USERPERMST_PERMSET_FK;


ALTER TABLE ADR.USER_PERMISSION_SETS ADD (
  CONSTRAINT USERPERMST_PERMSET_FK 
  FOREIGN KEY (PERMISSION_SET_ID) 
  REFERENCES ADR.PERMISSION_SET (PERMISSION_SET_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS
  DROP CONSTRAINT PSETPRM_PERMSET_FK;


ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS ADD (
  CONSTRAINT PSETPRM_PERMSET_FK 
  FOREIGN KEY (PERMISSION_SET_ID) 
  REFERENCES ADR.PERMISSION_SET (PERMISSION_SET_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_ROLES
  DROP CONSTRAINT USERROLE_USER_1_FK;


ALTER TABLE ADR.USER_ROLES ADD (
  CONSTRAINT USERROLE_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_USERS
  DROP CONSTRAINT RPTUSERS_USER_1_FK;


ALTER TABLE ADR.RPT_USERS ADD (
  CONSTRAINT RPTUSERS_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SCHEDRPT_USER_1_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SCHEDRPT_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_PERMISSION_SETS
  DROP CONSTRAINT USERPERMST_USER_1_FK;


ALTER TABLE ADR.USER_PERMISSION_SETS ADD (
  CONSTRAINT USERPERMST_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_COMPLETED_REPORTS
  DROP CONSTRAINT CMPRPT_USER_1_FK;


ALTER TABLE ADR.RPT_COMPLETED_REPORTS ADD (
  CONSTRAINT CMPRPT_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_LOGIN
  DROP CONSTRAINT USERLOGIN_USER_1_FK;


ALTER TABLE ADR.USER_LOGIN ADD (
  CONSTRAINT USERLOGIN_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_PERMISSIONS
  DROP CONSTRAINT USERPERM_USER_1_FK;


ALTER TABLE ADR.USER_PERMISSIONS ADD (
  CONSTRAINT USERPERM_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.POW_REGISTRY_DETAIL
  DROP CONSTRAINT POWREGDTL_POW_FK;


ALTER TABLE ADR.POW_REGISTRY_DETAIL ADD (
  CONSTRAINT POWREGDTL_POW_FK 
  FOREIGN KEY (PRISONER_OF_WAR_REGISTRY_ID) 
  REFERENCES ADR.PRISONER_OF_WAR_REGISTRY (PRISONER_OF_WAR_REGISTRY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL
  DROP CONSTRAINT SHADREGDTL_SHADRGSTRY_FK;


ALTER TABLE ADR.SHAD_REGISTRY_DETAIL ADD (
  CONSTRAINT SHADREGDTL_SHADRGSTRY_FK 
  FOREIGN KEY (SHAD_REGISTRY_ID) 
  REFERENCES ADR.SHAD_REGISTRY (SHAD_REGISTRY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_ROLES
  DROP CONSTRAINT USERROLE_ROLE_FK;


ALTER TABLE ADR.USER_ROLES ADD (
  CONSTRAINT USERROLE_ROLE_FK 
  FOREIGN KEY (ROLE_ID) 
  REFERENCES ADR.ROLES (ROLE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLE_PERMISSION_SETS
  DROP CONSTRAINT ROLEPERMST_ROLE_FK;


ALTER TABLE ADR.ROLE_PERMISSION_SETS ADD (
  CONSTRAINT ROLEPERMST_ROLE_FK 
  FOREIGN KEY (ROLE_ID) 
  REFERENCES ADR.ROLES (ROLE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLE_PERMISSIONS
  DROP CONSTRAINT ROLEPERMS_ROLE_FK;


ALTER TABLE ADR.ROLE_PERMISSIONS ADD (
  CONSTRAINT ROLEPERMS_ROLE_FK 
  FOREIGN KEY (ROLE_ID) 
  REFERENCES ADR.ROLES (ROLE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_SETTING
  DROP CONSTRAINT EGTSETTING_EGTSETTING_FK;


ALTER TABLE ADR.EGT_SETTING ADD (
  CONSTRAINT EGTSETTING_EGTSETTING_FK 
  FOREIGN KEY (REFERENCE_EGT_SETTING_ID) 
  REFERENCES ADR.EGT_SETTING (EGT_SETTING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_STATISTICS
  DROP CONSTRAINT EGTSTAT_EGTSETTING_FK;


ALTER TABLE ADR.EGT_STATISTICS ADD (
  CONSTRAINT EGTSTAT_EGTSETTING_FK 
  FOREIGN KEY (EGT_SETTING_ID) 
  REFERENCES ADR.EGT_SETTING (EGT_SETTING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
  DROP CONSTRAINT ENRLMNTDET_EGTSETTING_FK;


ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT ENRLMNTDET_EGTSETTING_FK 
  FOREIGN KEY (EGT_SETTING_ID) 
  REFERENCES ADR.EGT_SETTING (EGT_SETTING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_SITE_STATISTICS
  DROP CONSTRAINT EGTSTSTIC_EGTSTAT_FK;


ALTER TABLE ADR.EGT_SITE_STATISTICS ADD (
  CONSTRAINT EGTSTSTIC_EGTSTAT_FK 
  FOREIGN KEY (EGT_STATISTICS_ID) 
  REFERENCES ADR.EGT_STATISTICS (EGT_STATISTICS_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.CORRESPONDENCE
  DROP CONSTRAINT CORRESPONDENCE_COM_LTR_TEMP_FK;


ALTER TABLE ADR.CORRESPONDENCE ADD (
  CONSTRAINT CORRESPONDENCE_COM_LTR_TEMP_FK 
  FOREIGN KEY (COM_LETTER_TEMPLATE_ID) 
  REFERENCES ADR.COM_LETTER_TEMPLATE (COM_LETTER_TEMPLATE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT COMMAIL_COMLTRTPL_FK;


ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT COMMAIL_COMLTRTPL_FK 
  FOREIGN KEY (COM_LETTER_TEMPLATE_ID) 
  REFERENCES ADR.COM_LETTER_TEMPLATE (COM_LETTER_TEMPLATE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_PRINT_CHECK
  DROP CONSTRAINT COMPRTCHK_COMCNLPR_FK;


ALTER TABLE ADR.COM_PRINT_CHECK ADD (
  CONSTRAINT COMPRTCHK_COMCNLPR_FK 
  FOREIGN KEY (COM_CANCELED_REQUEST_ID) 
  REFERENCES ADR.COM_CANCELED_REQUEST (COM_CANCELED_REQUEST_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL
  DROP CONSTRAINT IVMMGEXDTL_IVMMGEX_FK;


ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL ADD (
  CONSTRAINT IVMMGEXDTL_IVMMGEX_FK 
  FOREIGN KEY (IVM_MIGRATE_EXTRACT_ID) 
  REFERENCES ADR.IVM_MIGRATE_EXTRACT (IVM_MIGRATE_EXTRACT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE
  DROP CONSTRAINT CATDSBLPRC_CATDSBLTY_FK;


ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE ADD (
  CONSTRAINT CATDSBLPRC_CATDSBLTY_FK 
  FOREIGN KEY (CATASTROPHIC_DISABILITY_ID) 
  REFERENCES ADR.CATASTROPHIC_DISABILITY (CATASTROPHIC_DISABILITY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS
  DROP CONSTRAINT CATDSDIAG_CATDSBLTY_FK;


ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS ADD (
  CONSTRAINT CATDSDIAG_CATDSBLTY_FK 
  FOREIGN KEY (CATASTROPHIC_DISABILITY_ID) 
  REFERENCES ADR.CATASTROPHIC_DISABILITY (CATASTROPHIC_DISABILITY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_CONDITION
  DROP CONSTRAINT CATDSCOND_CATDSBLTY_FK;


ALTER TABLE ADR.CAT_DSBLTY_CONDITION ADD (
  CONSTRAINT CATDSCOND_CATDSBLTY_FK 
  FOREIGN KEY (CATASTROPHIC_DISABILITY_ID) 
  REFERENCES ADR.CATASTROPHIC_DISABILITY (CATASTROPHIC_DISABILITY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR
  DROP CONSTRAINT CAT_DSBLTY_CAT_DSBLTY_DESC_FK;


ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR ADD (
  CONSTRAINT CAT_DSBLTY_CAT_DSBLTY_DESC_FK 
  FOREIGN KEY (CATASTROPHIC_DISABILITY_ID) 
  REFERENCES ADR.CATASTROPHIC_DISABILITY (CATASTROPHIC_DISABILITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_FORM_STATISTICS
  DROP CONSTRAINT COMFRMSTAT_COMTRANLOG_FK;


ALTER TABLE ADR.COM_FORM_STATISTICS ADD (
  CONSTRAINT COMFRMSTAT_COMTRANLOG_FK 
  FOREIGN KEY (COM_TRANSMISSION_LOG_ID) 
  REFERENCES ADR.COM_TRANSMISSION_LOG (COM_TRANSMISSION_LOG_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL
  DROP CONSTRAINT WKFCSESTAT_WKFCASE_FK;


ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL ADD (
  CONSTRAINT WKFCSESTAT_WKFCASE_FK 
  FOREIGN KEY (WKF_CASE_ID) 
  REFERENCES ADR.WKF_CASE (WKF_CASE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_COMMENTS
  DROP CONSTRAINT WKFCMTS_WKFCASE_FK;


ALTER TABLE ADR.WKF_CASE_COMMENTS ADD (
  CONSTRAINT WKFCMTS_WKFCASE_FK 
  FOREIGN KEY (WKF_CASE_ID) 
  REFERENCES ADR.WKF_CASE (WKF_CASE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_MESSAGING_CASE
  DROP CONSTRAINT WKFMSGCS_WKFCASE_FK;


ALTER TABLE ADR.WKF_MESSAGING_CASE ADD (
  CONSTRAINT WKFMSGCS_WKFCASE_FK 
  FOREIGN KEY (WKF_CASE_ID) 
  REFERENCES ADR.WKF_CASE (WKF_CASE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT
  DROP CONSTRAINT WKFCSASGMT_WKFCASE_FK;


ALTER TABLE ADR.WKF_CASE_ASSIGNMENT ADD (
  CONSTRAINT WKFCSASGMT_WKFCASE_FK 
  FOREIGN KEY (WKF_CASE_ID) 
  REFERENCES ADR.WKF_CASE (WKF_CASE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT COMMAIL_WKFCASE_FK;


ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT COMMAIL_WKFCASE_FK 
  FOREIGN KEY (WKF_CASE_ID) 
  REFERENCES ADR.WKF_CASE (WKF_CASE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.SSN_VERIFICATION_DETAIL
  DROP CONSTRAINT SSNVERFYDT_SSNVERIFY_FK;


ALTER TABLE ADR.SSN_VERIFICATION_DETAIL ADD (
  CONSTRAINT SSNVERFYDT_SSNVERIFY_FK 
  FOREIGN KEY (SSN_VERIFICATION_ID) 
  REFERENCES ADR.SSN_VERIFICATION (SSN_VERIFICATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_FORM_TYPE
  DROP CONSTRAINT ENRL_FORM_TYP_RPT_FORM_TYP_FK;


ALTER TABLE ADR.RPT_FORM_TYPE ADD (
  CONSTRAINT ENRL_FORM_TYP_RPT_FORM_TYP_FK 
  FOREIGN KEY (ENROLLMENT_FORM_TYPE_ID) 
  REFERENCES VOA.ENROLLMENT_FORM_TYPE (ENROLLMENT_FORM_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL
  DROP CONSTRAINT ADDRCONF_ADDR_FK;


ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL ADD (
  CONSTRAINT ADDRCONF_ADDR_FK 
  FOREIGN KEY (ADDRESS_ID) 
  REFERENCES ADR.ADDRESS (ADDRESS_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS
  DROP CONSTRAINT R_1057;


ALTER TABLE ADR.HANDBOOK_MAIL_STATUS ADD (
  CONSTRAINT R_1057 
  FOREIGN KEY (HANDBOOK_MAIL_QUEUE_ID) 
  REFERENCES ADR.HANDBOOK_MAIL_QUEUE (HANDBOOK_MAIL_QUEUE_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_DOCUMENT
  DROP CONSTRAINT R_1059;


ALTER TABLE ADR.HANDBOOK_DOCUMENT ADD (
  CONSTRAINT R_1059 
  FOREIGN KEY (HANDBOOK_MAIL_STATUS_ID) 
  REFERENCES ADR.HANDBOOK_MAIL_STATUS (HANDBOOK_MAIL_STATUS_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN
  DROP CONSTRAINT HLTBNFPLN_HLTBNFPRF_FK;


ALTER TABLE ADR.HEALTH_BENEFIT_PLAN ADD (
  CONSTRAINT HLTBNFPLN_HLTBNFPRF_FK 
  FOREIGN KEY (HEALTH_BENEFIT_PROFILE_ID) 
  REFERENCES ADR.HEALTH_BENEFIT_PROFILE (HEALTH_BENEFIT_PROFILE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.CL_VERIFICATION_METHOD
  DROP CONSTRAINT STD_CLVERIFTYP_CLVERMETH_FK;


ALTER TABLE ADR.CL_VERIFICATION_METHOD ADD (
  CONSTRAINT STD_CLVERIFTYP_CLVERMETH_FK 
  FOREIGN KEY (CL_VERIFICATION_METHOD_CODE) 
  REFERENCES ADRREF.STD_CLVERIFICATIONTYPE (ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR
  DROP CONSTRAINT SP_FAC_STD_CLVERIFTYP_FK;


ALTER TABLE ADR.SPECIAL_FACTOR ADD (
  CONSTRAINT SP_FAC_STD_CLVERIFTYP_FK 
  FOREIGN KEY (CL_VERIFICATION_METHOD_CODE) 
  REFERENCES ADRREF.STD_CLVERIFICATIONTYPE (ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR
  DROP CONSTRAINT SP_FAC_STD_CLSRCOFCHNG_FK;


ALTER TABLE ADR.SPECIAL_FACTOR ADD (
  CONSTRAINT SP_FAC_STD_CLSRCOFCHNG_FK 
  FOREIGN KEY (CL_SOURCE_OF_CHANGE) 
  REFERENCES ADRREF.STD_CLSOURCEOFCHANGE (ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE
  DROP CONSTRAINT STDLNGCD_PRSNPREFLNG_FK;


ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE ADD (
  CONSTRAINT STDLNGCD_PRSNPREFLNG_FK 
  FOREIGN KEY (STD_LANGUAGECODE_ID) 
  REFERENCES ADRREF.STD_LANGUAGECODE (ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME
  DROP CONSTRAINT STD_HLTHBENEFITPLANTYPEID_FK;


ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME ADD (
  CONSTRAINT STD_HLTHBENEFITPLANTYPEID_FK 
  FOREIGN KEY (STD_HLTHBENEFITPLANTYPE_ID) 
  REFERENCES ADRREF.STD_HLTHBENEFITPLANTYPE (ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL
  DROP CONSTRAINT HLTHBENPLNDTL_HLTHPLNNAMEID_FK;


ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL ADD (
  CONSTRAINT HLTHBENPLNDTL_HLTHPLNNAMEID_FK 
  FOREIGN KEY (HLTH_BEN_PLAN_NAME_ID) 
  REFERENCES ADR.HEALTH_BENEFIT_PLAN_NAME (HLTH_BEN_PLAN_NAME_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC
  DROP CONSTRAINT HLTHBENPLANDESC_FK;


ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC ADD (
  CONSTRAINT HLTHBENPLANDESC_FK 
  FOREIGN KEY (HEALTH_BENEFIT_PLAN_DETAIL_ID) 
  REFERENCES ADR.HEALTH_BENEFIT_PLAN_DETAIL (HEALTH_BENEFIT_PLAN_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION
  DROP CONSTRAINT ELGBTYVERIFI_REASONID_FK;


ALTER TABLE ADR.ELIGIBILITY_VERIFICATION ADD (
  CONSTRAINT ELGBTYVERIFI_REASONID_FK 
  FOREIGN KEY (ELGBTY_STATUS_REASON_ID) 
  REFERENCES ADR.ELIGIBILITY_STATUS_REASON (ELIGIBILITY_STATUS_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL
  DROP CONSTRAINT IRSTRNSLOG_IRSTRNSLGDET_FK;


ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL ADD (
  CONSTRAINT IRSTRNSLOG_IRSTRNSLGDET_FK 
  FOREIGN KEY (IRS_TRANSMISSION_LOG_ID) 
  REFERENCES ADR.IRS_TRANSMISSION_LOG (IRS_TRANSMISSION_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_DATA
  DROP CONSTRAINT IRSTRNSLOG_IRSTRNSDATA_FK;


ALTER TABLE ADR.IRS_TRANSMISSION_DATA ADD (
  CONSTRAINT IRSTRNSLOG_IRSTRNSDATA_FK 
  FOREIGN KEY (IRS_TRANSMISSION_LOG_ID) 
  REFERENCES ADR.IRS_TRANSMISSION_LOG (IRS_TRANSMISSION_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_LOG
  DROP CONSTRAINT TRNSSTAT_IRSTRNSLOG_FK;


ALTER TABLE ADR.IRS_TRANSMISSION_LOG ADD (
  CONSTRAINT TRNSSTAT_IRSTRNSLOG_FK 
  FOREIGN KEY (TRANSMISSION_STATUS_ID) 
  REFERENCES ADR.TRANSMISSION_STATUS (TRANSMISSION_STATUS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CORRESPONDENCE
  DROP CONSTRAINT CORRPNDNC_CORRPNDNC_TYPE_FK;


ALTER TABLE ADR.CORRESPONDENCE ADD (
  CONSTRAINT CORRPNDNC_CORRPNDNC_TYPE_FK 
  FOREIGN KEY (CORRESPONDENCE_TYPE_ID) 
  REFERENCES ADR.CORRESPONDENCE_TYPE (CORRESPONDENCE_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CORRESPONDENCE
  DROP CONSTRAINT CORRPNDNC_CORRPNDNC_STATUS_FK;


ALTER TABLE ADR.CORRESPONDENCE ADD (
  CONSTRAINT CORRPNDNC_CORRPNDNC_STATUS_FK 
  FOREIGN KEY (CORRESPONDENCE_STATUS_ID) 
  REFERENCES ADR.CORRESPONDENCE_STATUS (CORRESPONDENCE_STATUS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CORRESPONDENCE
  DROP CONSTRAINT CORRPNDNC_CORRPNDNC_DOC_FK;


ALTER TABLE ADR.CORRESPONDENCE ADD (
  CONSTRAINT CORRPNDNC_CORRPNDNC_DOC_FK 
  FOREIGN KEY (CORRESPONDENCE_DOCUMENT_ID) 
  REFERENCES ADR.CORRESPONDENCE_DOCUMENT (CORRESPONDENCE_DOCUMENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.VCELIGIBILITY
  DROP CONSTRAINT VCEELGB_VCESTATS_FK;


ALTER TABLE ADR.VCELIGIBILITY ADD (
  CONSTRAINT VCEELGB_VCESTATS_FK 
  FOREIGN KEY (VCESTATUSTYPE_ID) 
  REFERENCES ADR.VCESTATUSTYPE (VCESTATUSTYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WAITTIME_STAGE
  DROP CONSTRAINT WAITTIME_STAGE_WAITTYPE_FK;


ALTER TABLE ADR.WAITTIME_STAGE ADD (
  CONSTRAINT WAITTIME_STAGE_WAITTYPE_FK 
  FOREIGN KEY (WAITTYPE_ID) 
  REFERENCES ADR.WAITTYPE (WAITTYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WAITTIME
  DROP CONSTRAINT WAITTIME_WAITTYPE_FK;


ALTER TABLE ADR.WAITTIME ADD (
  CONSTRAINT WAITTIME_WAITTYPE_FK 
  FOREIGN KEY (WAITTYPE_ID) 
  REFERENCES ADR.WAITTYPE (WAITTYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.WAITTIME_ARCHIVE
  DROP CONSTRAINT WAITTIME_ARCHIVE_WAITTYPE_FK;


ALTER TABLE ADR.WAITTIME_ARCHIVE ADD (
  CONSTRAINT WAITTIME_ARCHIVE_WAITTYPE_FK 
  FOREIGN KEY (WAITTYPE_ID) 
  REFERENCES ADR.WAITTYPE (WAITTYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT ADDR_CASSCERTIFIEDTY_FK;


ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT ADDR_CASSCERTIFIEDTY_FK 
  FOREIGN KEY (CASSCERTIFIEDTYPE_ID) 
  REFERENCES ADR.CASSCERTIFIEDTYPE (CASSCERTIFIEDTYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS_H
  DROP CONSTRAINT ADDR_H_CASSCERTIFIEDTY_FK;


ALTER TABLE ADR.ADDRESS_H ADD (
  CONSTRAINT ADDR_H_CASSCERTIFIEDTY_FK 
  FOREIGN KEY (CASSCERTIFIEDTYPE_ID) 
  REFERENCES ADR.CASSCERTIFIEDTYPE (CASSCERTIFIEDTYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.VCADMIN
  DROP CONSTRAINT VCADMIN_VCEADMINSTATS_FK;


ALTER TABLE ADR.VCADMIN ADD (
  CONSTRAINT VCADMIN_VCEADMINSTATS_FK 
  FOREIGN KEY (VCADMISTATUS_TYPE_ID) 
  REFERENCES ADR.VCADMISTATUS_TYPE (VCADMISTATUS_TYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_SERVICE_LOG
  DROP CONSTRAINT CCNSERVLOG_TRANSTASTTYPEID_FK;


ALTER TABLE ADR.CCN_SERVICE_LOG ADD (
  CONSTRAINT CCNSERVLOG_TRANSTASTTYPEID_FK 
  FOREIGN KEY (TRANSMISSION_STTYPE_ID) 
  REFERENCES ADR.VCADMISTATUS_TYPE (VCADMISTATUS_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_FILETRANSFER
  DROP CONSTRAINT CCNFITRANSF_VCADSTPIDD_FK_I;


ALTER TABLE ADR.CCN_FILETRANSFER ADD (
  CONSTRAINT CCNFITRANSF_VCADSTPIDD_FK_I 
  FOREIGN KEY (VCADMISTATUS_TYPE_ID) 
  REFERENCES ADR.VCADMISTATUS_TYPE (VCADMISTATUS_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG
  DROP CONSTRAINT CCNRSERVLOG_VCADMNSTATPID_FK;


ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG ADD (
  CONSTRAINT CCNRSERVLOG_VCADMNSTATPID_FK 
  FOREIGN KEY (VCADMINSTATUS_TYPE_ID) 
  REFERENCES ADR.VCADMISTATUS_TYPE (VCADMISTATUS_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WAITTIME_STAGE
  DROP CONSTRAINT WT_STAGE_FK;


ALTER TABLE ADR.WAITTIME_STAGE ADD (
  CONSTRAINT WT_STAGE_FK 
  FOREIGN KEY (VCELIGIBILITY_ID) 
  REFERENCES ADR.VCELIGIBILITY (VCELIGIBILITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WAITTIME
  DROP CONSTRAINT VCELIG_WAITTME_FK;


ALTER TABLE ADR.WAITTIME ADD (
  CONSTRAINT VCELIG_WAITTME_FK 
  FOREIGN KEY (VCELIGIBILITY_ID) 
  REFERENCES ADR.VCELIGIBILITY (VCELIGIBILITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_TRANSMIT
  DROP CONSTRAINT GEOCODETRANS_VCELIG_FK;


ALTER TABLE ADR.GEOCODE_TRANSMIT ADD (
  CONSTRAINT GEOCODETRANS_VCELIG_FK 
  FOREIGN KEY (VCELIGIBILITY_ID) 
  REFERENCES ADR.VCELIGIBILITY (VCELIGIBILITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WAITTIME_ARCHIVE
  DROP CONSTRAINT WTARCH_VCELIG_FK;


ALTER TABLE ADR.WAITTIME_ARCHIVE ADD (
  CONSTRAINT WTARCH_VCELIG_FK 
  FOREIGN KEY (VCELIGIBILITY_ID) 
  REFERENCES ADR.VCELIGIBILITY (VCELIGIBILITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE
  DROP CONSTRAINT GEOCDTRANSARCH_VCELIG_FK;


ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE ADD (
  CONSTRAINT GEOCDTRANSARCH_VCELIG_FK 
  FOREIGN KEY (VCELIGIBILITY_ID) 
  REFERENCES ADR.VCELIGIBILITY (VCELIGIBILITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_SERVICE_LOG
  DROP CONSTRAINT CCNSERVLOG_VCELIGBTY_H_ID_FK;


ALTER TABLE ADR.CCN_SERVICE_LOG ADD (
  CONSTRAINT CCNSERVLOG_VCELIGBTY_H_ID_FK 
  FOREIGN KEY (VCELIGIBILITY_H_ID) 
  REFERENCES ADR.VCELIGIBILITY_H (VCELIGIBILITY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_STAGE
  DROP CONSTRAINT GEOCODE_STG_STATION_FK;


ALTER TABLE ADR.GEOCODE_STAGE ADD (
  CONSTRAINT GEOCODE_STG_STATION_FK 
  FOREIGN KEY (GEOCODE_STATION_ID) 
  REFERENCES ADR.GEOCODE_STATION (GEOCODE_STATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_TRANSMIT
  DROP CONSTRAINT GEOCODE_STATION_FK;


ALTER TABLE ADR.GEOCODE_TRANSMIT ADD (
  CONSTRAINT GEOCODE_STATION_FK 
  FOREIGN KEY (GEOCODE_STATION_ID) 
  REFERENCES ADR.GEOCODE_STATION (GEOCODE_STATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE
  DROP CONSTRAINT GTA_GEOCODE_STATION_FK;


ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE ADD (
  CONSTRAINT GTA_GEOCODE_STATION_FK 
  FOREIGN KEY (GEOCODE_STATION_ID) 
  REFERENCES ADR.GEOCODE_STATION (GEOCODE_STATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.CORRESPONDENCE
  DROP CONSTRAINT CORRESPONDENCE_EMAIL_H_FK;


ALTER TABLE ADR.CORRESPONDENCE ADD (
  CONSTRAINT CORRESPONDENCE_EMAIL_H_FK 
  FOREIGN KEY (EMAIL_H_ID) 
  REFERENCES ADR.EMAIL_H (EMAIL_H_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT
  DROP CONSTRAINT FINSTATE_FINSTATE_FK;


ALTER TABLE ADR.FINANCIAL_STATEMENT ADD (
  CONSTRAINT FINSTATE_FINSTATE_FK 
  FOREIGN KEY (REF_FINANCIAL_STATEMENT_ID) 
  REFERENCES ADR.FINANCIAL_STATEMENT (FINANCIAL_STATEMENT_ID)
  DEFERRABLE INITIALLY DEFERRED
  DISABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL
  DROP CONSTRAINT FINDBTDTL_FINSTATE_FK;


ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL ADD (
  CONSTRAINT FINDBTDTL_FINSTATE_FK 
  FOREIGN KEY (FINANCIAL_STATEMENT_ID) 
  REFERENCES ADR.FINANCIAL_STATEMENT (FINANCIAL_STATEMENT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL
  DROP CONSTRAINT FINASTDTL_FINSTATE_FK;


ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL ADD (
  CONSTRAINT FINASTDTL_FINSTATE_FK 
  FOREIGN KEY (FINANCIAL_STATEMENT_ID) 
  REFERENCES ADR.FINANCIAL_STATEMENT (FINANCIAL_STATEMENT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL
  DROP CONSTRAINT FININCMDTL_FINSTATE_FK;


ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL ADD (
  CONSTRAINT FININCMDTL_FINSTATE_FK 
  FOREIGN KEY (FINANCIAL_STATEMENT_ID) 
  REFERENCES ADR.FINANCIAL_STATEMENT (FINANCIAL_STATEMENT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL
  DROP CONSTRAINT FINEXPDTL_FINSTATE_FK;


ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL ADD (
  CONSTRAINT FINEXPDTL_FINSTATE_FK 
  FOREIGN KEY (FINANCIAL_STATEMENT_ID) 
  REFERENCES ADR.FINANCIAL_STATEMENT (FINANCIAL_STATEMENT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CONFLICT_DETAIL
  DROP CONSTRAINT CONFLDTL_MILSRVC_FK;


ALTER TABLE ADR.CONFLICT_DETAIL ADD (
  CONSTRAINT CONFLDTL_MILSRVC_FK 
  FOREIGN KEY (MILITARY_SERVICE_ID) 
  REFERENCES ADR.MILITARY_SERVICE (MILITARY_SERVICE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE
  DROP CONSTRAINT MILSRVCEPS_MILSRVC_FK;


ALTER TABLE ADR.MILITARY_SERVICE_EPISODE ADD (
  CONSTRAINT MILSRVCEPS_MILSRVC_FK 
  FOREIGN KEY (MILITARY_SERVICE_ID) 
  REFERENCES ADR.MILITARY_SERVICE (MILITARY_SERVICE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE
  DROP CONSTRAINT MILITARY_SERVICE_ID_FK;


ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE ADD (
  CONSTRAINT MILITARY_SERVICE_ID_FK 
  FOREIGN KEY (MILITARY_SERVICE_ID) 
  REFERENCES ADR.MILITARY_SERVICE (MILITARY_SERVICE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EMAIL
  DROP CONSTRAINT EMAIL_INSURANCE_FK;


ALTER TABLE ADR.EMAIL ADD (
  CONSTRAINT EMAIL_INSURANCE_FK 
  FOREIGN KEY (INSURANCE_ID) 
  REFERENCES ADR.INSURANCE (INSURANCE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT ADDR_INSURANCE_FK;


ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT ADDR_INSURANCE_FK 
  FOREIGN KEY (INSURANCE_ID) 
  REFERENCES ADR.INSURANCE (INSURANCE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE
  DROP CONSTRAINT PHONE_INSURANCE_FK;


ALTER TABLE ADR.PHONE ADD (
  CONSTRAINT PHONE_INSURANCE_FK 
  FOREIGN KEY (INSURANCE_ID) 
  REFERENCES ADR.INSURANCE (INSURANCE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL
  DROP CONSTRAINT INCMTSTDTL_INCMTST_FK;


ALTER TABLE ADR.INCOME_TEST_DETAIL ADD (
  CONSTRAINT INCMTSTDTL_INCMTST_FK 
  FOREIGN KEY (INCOME_TEST_ID) 
  REFERENCES ADR.INCOME_TEST (INCOME_TEST_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CCN_SERVICE_LOG
  DROP CONSTRAINT CCNSERVLOG_PFFACHID_FK;


ALTER TABLE ADR.CCN_SERVICE_LOG ADD (
  CONSTRAINT CCNSERVLOG_PFFACHID_FK 
  FOREIGN KEY (PREFERRED_FACILITY_H_ID) 
  REFERENCES ADR.PREFERRED_FACILITY_H (PREFERRED_FACILITY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_AAC_ERROR_DETAIL
  DROP CONSTRAINT COMAACERR_COMMAIL_FK;


ALTER TABLE ADR.COM_AAC_ERROR_DETAIL ADD (
  CONSTRAINT COMAACERR_COMMAIL_FK 
  FOREIGN KEY (COM_MAILING_ID) 
  REFERENCES ADR.COM_MAILING (COM_MAILING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_HEC_REJECT_DETAIL
  DROP CONSTRAINT COMRJCTDTL_COMMAIL_FK;


ALTER TABLE ADR.COM_HEC_REJECT_DETAIL ADD (
  CONSTRAINT COMRJCTDTL_COMMAIL_FK 
  FOREIGN KEY (COM_MAILING_ID) 
  REFERENCES ADR.COM_MAILING (COM_MAILING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_PRINT_CHECK
  DROP CONSTRAINT COMPRTCHK_COMMAIL_FK;


ALTER TABLE ADR.COM_PRINT_CHECK ADD (
  CONSTRAINT COMPRTCHK_COMMAIL_FK 
  FOREIGN KEY (COM_MAILING_ID) 
  REFERENCES ADR.COM_MAILING (COM_MAILING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_CANCELED_REQUEST
  DROP CONSTRAINT COMCNLPR_COMMAIL_FK;


ALTER TABLE ADR.COM_CANCELED_REQUEST ADD (
  CONSTRAINT COMCNLPR_COMMAIL_FK 
  FOREIGN KEY (COM_MAILING_ID) 
  REFERENCES ADR.COM_MAILING (COM_MAILING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL
  DROP CONSTRAINT COMMLSTAT_COMMAIL_FK;


ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL ADD (
  CONSTRAINT COMMLSTAT_COMMAIL_FK 
  FOREIGN KEY (COM_MAILING_ID) 
  REFERENCES ADR.COM_MAILING (COM_MAILING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_PRINT_REQUEST
  DROP CONSTRAINT COMPRTREQ_COMMAIL_FK;


ALTER TABLE ADR.COM_PRINT_REQUEST ADD (
  CONSTRAINT COMPRTREQ_COMMAIL_FK 
  FOREIGN KEY (COM_MAILING_ID) 
  REFERENCES ADR.COM_MAILING (COM_MAILING_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CORRESPONDENCE
  DROP CONSTRAINT CORRESPONDENCE_ADDR_H_FK;


ALTER TABLE ADR.CORRESPONDENCE ADD (
  CONSTRAINT CORRESPONDENCE_ADDR_H_FK 
  FOREIGN KEY (ADDRESS_H_ID) 
  REFERENCES ADR.ADDRESS_H (ADDRESS_H_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.GEOCODE_STAGE
  DROP CONSTRAINT GEOCD_STAGE_ADDR_D_FK;


ALTER TABLE ADR.GEOCODE_STAGE ADD (
  CONSTRAINT GEOCD_STAGE_ADDR_D_FK 
  FOREIGN KEY (ADDRESS_H_ID) 
  REFERENCES ADR.ADDRESS_H (ADDRESS_H_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.GEOCODE_TRANSMIT
  DROP CONSTRAINT GEOCD_TRNSMIT_ADDR_D_FK;


ALTER TABLE ADR.GEOCODE_TRANSMIT ADD (
  CONSTRAINT GEOCD_TRNSMIT_ADDR_D_FK 
  FOREIGN KEY (ADDRESS_H_ID) 
  REFERENCES ADR.ADDRESS_H (ADDRESS_H_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE
  DROP CONSTRAINT GEOCD_TRNSMIT_ARCH_ADDR_D_FK;


ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE ADD (
  CONSTRAINT GEOCD_TRNSMIT_ARCH_ADDR_D_FK 
  FOREIGN KEY (ADDRESS_H_ID) 
  REFERENCES ADR.ADDRESS_H (ADDRESS_H_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CCN_SERVICE_LOG
  DROP CONSTRAINT CCNSERVLOG_MAILADDRHID_FK;


ALTER TABLE ADR.CCN_SERVICE_LOG ADD (
  CONSTRAINT CCNSERVLOG_MAILADDRHID_FK 
  FOREIGN KEY (MAILING_ADDRESS_H_ID) 
  REFERENCES ADR.ADDRESS_H (ADDRESS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_SERVICE_LOG
  DROP CONSTRAINT CCNSERVLOG_RESADRHID_FK;


ALTER TABLE ADR.CCN_SERVICE_LOG ADD (
  CONSTRAINT CCNSERVLOG_RESADRHID_FK 
  FOREIGN KEY (RESI_ADDRESS_H_ID) 
  REFERENCES ADR.ADDRESS_H (ADDRESS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL
  DROP CONSTRAINT REGTRAITDT_REGTRAIT_FK;


ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL ADD (
  CONSTRAINT REGTRAITDT_REGTRAIT_FK 
  FOREIGN KEY (REGISTRY_TRAIT_ID) 
  REFERENCES ADR.REGISTRY_TRAIT (REGISTRY_TRAIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PURPLE_HEART_REGISTRY
  DROP CONSTRAINT PRPLHRTREG_REGTRAIT_FK;


ALTER TABLE ADR.PURPLE_HEART_REGISTRY ADD (
  CONSTRAINT PRPLHRTREG_REGTRAIT_FK 
  FOREIGN KEY (REGISTRY_TRAIT_ID) 
  REFERENCES ADR.REGISTRY_TRAIT (REGISTRY_TRAIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY
  DROP CONSTRAINT POW_REGTRAIT_FK;


ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY ADD (
  CONSTRAINT POW_REGTRAIT_FK 
  FOREIGN KEY (REGISTRY_TRAIT_ID) 
  REFERENCES ADR.REGISTRY_TRAIT (REGISTRY_TRAIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SHAD_REGISTRY
  DROP CONSTRAINT SHADRGSTRY_REGTRAIT_FK;


ALTER TABLE ADR.SHAD_REGISTRY ADD (
  CONSTRAINT SHADRGSTRY_REGTRAIT_FK 
  FOREIGN KEY (REGISTRY_TRAIT_ID) 
  REFERENCES ADR.REGISTRY_TRAIT (REGISTRY_TRAIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BROKER_SERVICE_LOG
  DROP CONSTRAINT BRSL_PER_FK;


ALTER TABLE ADR.BROKER_SERVICE_LOG ADD (
  CONSTRAINT BRSL_PER_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DISABLE NOVALIDATE);
ALTER TABLE ADR.CANCEL_DECLINE
  DROP CONSTRAINT CANDEC_PRSN_FK;


ALTER TABLE ADR.CANCEL_DECLINE ADD (
  CONSTRAINT CANDEC_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT
  DROP CONSTRAINT SITERECENR_PRSN_FK;


ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT ADD (
  CONSTRAINT SITERECENR_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PURPLE_HEART_REGISTRY
  DROP CONSTRAINT PRPLHRTREG_PRSN_FK;


ALTER TABLE ADR.PURPLE_HEART_REGISTRY ADD (
  CONSTRAINT PRPLHRTREG_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT
  DROP CONSTRAINT MONEYBEN_PRSN_FK;


ALTER TABLE ADR.MONETARY_BENEFIT ADD (
  CONSTRAINT MONEYBEN_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MEDICAID_FACTOR
  DROP CONSTRAINT MEDICAID_PRSN_FK;


ALTER TABLE ADR.MEDICAID_FACTOR ADD (
  CONSTRAINT MEDICAID_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL
  DROP CONSTRAINT VAPERDVSN_PRSN_FK;


ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL ADD (
  CONSTRAINT VAPERDVSN_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IN_PROCESS_FINANCIALS
  DROP CONSTRAINT INPROCFNCL_PRSN_FK;


ALTER TABLE ADR.IN_PROCESS_FINANCIALS ADD (
  CONSTRAINT INPROCFNCL_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_OVERRIDE
  DROP CONSTRAINT ENROLOVER_PRSN_FK;


ALTER TABLE ADR.ENROLLMENT_OVERRIDE ADD (
  CONSTRAINT ENROLOVER_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HL7_TRANSACTION_LOG
  DROP CONSTRAINT HL7_PERSONID_FK;


ALTER TABLE ADR.HL7_TRANSACTION_LOG ADD (
  CONSTRAINT HL7_PERSONID_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_SCI
  DROP CONSTRAINT BNFYSCI_PRSN_FK;


ALTER TABLE ADR.BENEFICIARY_SCI ADD (
  CONSTRAINT BNFYSCI_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ACTIVATION
  DROP CONSTRAINT RELATIONSHIP43;


ALTER TABLE ADR.ACTIVATION ADD (
  CONSTRAINT RELATIONSHIP43 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MEDAL_OF_HONOR
  DROP CONSTRAINT RELATIONSHIP25;


ALTER TABLE ADR.MEDAL_OF_HONOR ADD (
  CONSTRAINT RELATIONSHIP25 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SEEDING
  DROP CONSTRAINT RELATIONSHIP39;


ALTER TABLE ADR.SEEDING ADD (
  CONSTRAINT RELATIONSHIP39 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN
  DROP CONSTRAINT RELATIONSHIP69;


ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN ADD (
  CONSTRAINT RELATIONSHIP69 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ON DELETE SET NULL
  ENABLE NOVALIDATE);
ALTER TABLE ADR.DELIVERY_PREFERENCE
  DROP CONSTRAINT DLVPRF_PRS_FK;


ALTER TABLE ADR.DELIVERY_PREFERENCE ADD (
  CONSTRAINT DLVPRF_PRS_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COMBAT_EPISODE
  DROP CONSTRAINT CMBTEPSD_PRSN_FK;


ALTER TABLE ADR.COMBAT_EPISODE ADD (
  CONSTRAINT CMBTEPSD_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMERGENCY_RESPONSE
  DROP CONSTRAINT EMERGRESP_PRSN_FK;


ALTER TABLE ADR.EMERGENCY_RESPONSE ADD (
  CONSTRAINT EMERGRESP_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_RELATION
  DROP CONSTRAINT PRSNREL_PRSN_FK;


ALTER TABLE ADR.PERSON_RELATION ADD (
  CONSTRAINT PRSNREL_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SERVICE_CONNECTED
  DROP CONSTRAINT SVCCON_PRSN_FK;


ALTER TABLE ADR.SERVICE_CONNECTED ADD (
  CONSTRAINT SVCCON_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FEE_BASIS
  DROP CONSTRAINT FEEBASIS_PRSN_FK;


ALTER TABLE ADR.FEE_BASIS ADD (
  CONSTRAINT FEEBASIS_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_ETHNICITY
  DROP CONSTRAINT PRSNETNCTY_PRSN_FK;


ALTER TABLE ADR.PERSON_ETHNICITY ADD (
  CONSTRAINT PRSNETNCTY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SIGNATURE_IMAGE
  DROP CONSTRAINT SIGNATURE_PRSN_FK;


ALTER TABLE ADR.SIGNATURE_IMAGE ADD (
  CONSTRAINT SIGNATURE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_NTR
  DROP CONSTRAINT BNFYNTR_PRSN_FK;


ALTER TABLE ADR.BENEFICIARY_NTR ADD (
  CONSTRAINT BNFYNTR_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY
  DROP CONSTRAINT CNFADDR_PRSN_FK;


ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY ADD (
  CONSTRAINT CNFADDR_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOMPETENT_RULING
  DROP CONSTRAINT INCOMPRULE_PRSN_FK;


ALTER TABLE ADR.INCOMPETENT_RULING ADD (
  CONSTRAINT INCOMPRULE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INELIGIBLE_RULING
  DROP CONSTRAINT INELIGBRLG_PRSN_FK;


ALTER TABLE ADR.INELIGIBLE_RULING ADD (
  CONSTRAINT INELIGBRLG_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL
  DROP CONSTRAINT VAPRSNCLAS_PRSN_FK;


ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL ADD (
  CONSTRAINT VAPRSNCLAS_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_MST
  DROP CONSTRAINT BNFYMST_PRSN_FK;


ALTER TABLE ADR.BENEFICIARY_MST ADD (
  CONSTRAINT BNFYMST_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY
  DROP CONSTRAINT POW_PRSN_FK;


ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY ADD (
  CONSTRAINT POW_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SHAD_REGISTRY
  DROP CONSTRAINT SHADRGSTRY_PRSN_FK;


ALTER TABLE ADR.SHAD_REGISTRY ADD (
  CONSTRAINT SHADRGSTRY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COMBAT_PAY
  DROP CONSTRAINT CMBTPAY_PRSN_FK;


ALTER TABLE ADR.COMBAT_PAY ADD (
  CONSTRAINT CMBTPAY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMAIL
  DROP CONSTRAINT EMAIL_PRSN_FK;


ALTER TABLE ADR.EMAIL ADD (
  CONSTRAINT EMAIL_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION
  DROP CONSTRAINT HEALTHAPP_PRSN_FK;


ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION ADD (
  CONSTRAINT HEALTHAPP_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_RACE
  DROP CONSTRAINT PRSNRACE_PRSN_FK;


ALTER TABLE ADR.PERSON_RACE ADD (
  CONSTRAINT PRSNRACE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CATASTROPHIC_DISABILITY
  DROP CONSTRAINT CATDSBLTY_PRSN_FK;


ALTER TABLE ADR.CATASTROPHIC_DISABILITY ADD (
  CONSTRAINT CATDSBLTY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.WKF_CASE
  DROP CONSTRAINT WKFCASE_PRSN_FK;


ALTER TABLE ADR.WKF_CASE ADD (
  CONSTRAINT WKFCASE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_RELATION_MERGE
  DROP CONSTRAINT PRSNRELMRG_PRSN_FK;


ALTER TABLE ADR.PERSON_RELATION_MERGE ADD (
  CONSTRAINT PRSNRELMRG_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_TRAVEL
  DROP CONSTRAINT BENTRVL_PRSN_FK;


ALTER TABLE ADR.BENEFICIARY_TRAVEL ADD (
  CONSTRAINT BENTRVL_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMPLOYMENT
  DROP CONSTRAINT EMPLOY_PRSN_FK;


ALTER TABLE ADR.EMPLOYMENT ADD (
  CONSTRAINT EMPLOY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT ADDR_PRSN_FK;


ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT ADDR_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN
  DROP CONSTRAINT SSN_PRSN_FK;


ALTER TABLE ADR.SSN ADD (
  CONSTRAINT SSN_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE
  DROP CONSTRAINT PHONE_PRSN_FK;


ALTER TABLE ADR.PHONE ADD (
  CONSTRAINT PHONE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE
  DROP CONSTRAINT R_1053;


ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE ADD (
  CONSTRAINT R_1053 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL
  DROP CONSTRAINT PERSN_IRSTRNSLGDET_PRSN_ID_FK;


ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL ADD (
  CONSTRAINT PERSN_IRSTRNSLGDET_PRSN_ID_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY
  DROP CONSTRAINT RELATIONSHIP60;


ALTER TABLE ADR.PREFERRED_FACILITY ADD (
  CONSTRAINT RELATIONSHIP60 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY
  DROP CONSTRAINT BENVISSUM_PRSN_FK;


ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY ADD (
  CONSTRAINT BENVISSUM_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE
  DROP CONSTRAINT HLTBNFPRF_PRSN_FK;


ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE ADD (
  CONSTRAINT HLTBNFPRF_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE
  DROP CONSTRAINT PRSNPRSNPREFLANG_FK;


ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE ADD (
  CONSTRAINT PRSNPRSNPREFLANG_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CORRESPONDENCE
  DROP CONSTRAINT CORRESPONDENCE_PERSON_FK;


ALTER TABLE ADR.CORRESPONDENCE ADD (
  CONSTRAINT CORRESPONDENCE_PERSON_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.VCADMIN
  DROP CONSTRAINT VCADMIN_PRSON_FK;


ALTER TABLE ADR.VCADMIN ADD (
  CONSTRAINT VCADMIN_PRSON_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.VCELIGIBILITY
  DROP CONSTRAINT VCEELGB_PRSN_FK;


ALTER TABLE ADR.VCELIGIBILITY ADD (
  CONSTRAINT VCEELGB_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.WAITTIME_STAGE
  DROP CONSTRAINT WAITTIME_STAGE_PERSON_FK;


ALTER TABLE ADR.WAITTIME_STAGE ADD (
  CONSTRAINT WAITTIME_STAGE_PERSON_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.GEOCODE_STAGE
  DROP CONSTRAINT GS_TRNSMT_PRSN_FK;


ALTER TABLE ADR.GEOCODE_STAGE ADD (
  CONSTRAINT GS_TRNSMT_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MEC_PERIOD_NEW
  DROP CONSTRAINT MEC_PERIOD_NEW_PERSON_FK;


ALTER TABLE ADR.MEC_PERIOD_NEW ADD (
  CONSTRAINT MEC_PERIOD_NEW_PERSON_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.WAITTIME
  DROP CONSTRAINT WAITTIME_PERSON_FK;


ALTER TABLE ADR.WAITTIME ADD (
  CONSTRAINT WAITTIME_PERSON_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.GEOCODE_TRANSMIT
  DROP CONSTRAINT TRNSMT_PRSN_FK;


ALTER TABLE ADR.GEOCODE_TRANSMIT ADD (
  CONSTRAINT TRNSMT_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.WAITTIME_ARCHIVE
  DROP CONSTRAINT WAITTIME_ARCHIVE_PERSON_FK;


ALTER TABLE ADR.WAITTIME_ARCHIVE ADD (
  CONSTRAINT WAITTIME_ARCHIVE_PERSON_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE
  DROP CONSTRAINT GTA_TRNSMT_PRSN_FK;


ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE ADD (
  CONSTRAINT GTA_TRNSMT_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT
  DROP CONSTRAINT FINSTATE_PRSN_FK;


ALTER TABLE ADR.FINANCIAL_STATEMENT ADD (
  CONSTRAINT FINSTATE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE
  DROP CONSTRAINT MILSRVC_PRSN_FK;


ALTER TABLE ADR.MILITARY_SERVICE ADD (
  CONSTRAINT MILSRVC_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INSURANCE
  DROP CONSTRAINT INSURANCE_PRSN_FK;


ALTER TABLE ADR.INSURANCE ADD (
  CONSTRAINT INSURANCE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST
  DROP CONSTRAINT INCMTST_PRSN_FK;


ALTER TABLE ADR.INCOME_TEST ADD (
  CONSTRAINT INCMTST_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT COMMAIL_PRSN_FK;


ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT COMMAIL_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT
  DROP CONSTRAINT RELATIONSHIP65;


ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT ADD (
  CONSTRAINT RELATIONSHIP65 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY
  DROP CONSTRAINT SITERCVELG_PRSN_FK;


ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY ADD (
  CONSTRAINT SITERCVELG_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CONTACT
  DROP CONSTRAINT PRSNCTAC_PRSN_FK;


ALTER TABLE ADR.PERSON_CONTACT ADD (
  CONSTRAINT PRSNCTAC_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CHANGE_LOG
  DROP CONSTRAINT PRSNCHGLOG_PRSN_FK;


ALTER TABLE ADR.PERSON_CHANGE_LOG ADD (
  CONSTRAINT PRSNCHGLOG_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN_VERIFICATION_DETAIL
  DROP CONSTRAINT SSNVERFYDT_PRSN_FK;


ALTER TABLE ADR.SSN_VERIFICATION_DETAIL ADD (
  CONSTRAINT SSNVERFYDT_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION
  DROP CONSTRAINT ELGBTYVRFY_PRSN_FK;


ALTER TABLE ADR.ELIGIBILITY_VERIFICATION ADD (
  CONSTRAINT ELGBTYVRFY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IVM_MIGRATE
  DROP CONSTRAINT IVMMGRT_PRSN_FK;


ALTER TABLE ADR.IVM_MIGRATE ADD (
  CONSTRAINT IVMMGRT_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
  DROP CONSTRAINT ENRLMNTDET_PRSN_FK;


ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT ENRLMNTDET_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR
  DROP CONSTRAINT SPECFACT_PRSN_FK;


ALTER TABLE ADR.SPECIAL_FACTOR ADD (
  CONSTRAINT SPECFACT_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MANUAL_OVERRIDE
  DROP CONSTRAINT PERSON_ID_FK;


ALTER TABLE ADR.MANUAL_OVERRIDE ADD (
  CONSTRAINT PERSON_ID_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_SERVICE_LOG
  DROP CONSTRAINT CCNSERVLOG_PERSON_ID_FK;


ALTER TABLE ADR.CCN_SERVICE_LOG ADD (
  CONSTRAINT CCNSERVLOG_PERSON_ID_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PCP_STAGE
  DROP CONSTRAINT PCPSTAGE_PERSONID_FK;


ALTER TABLE ADR.PCP_STAGE ADD (
  CONSTRAINT PCPSTAGE_PERSONID_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG
  DROP CONSTRAINT CCNRSERVLOG_PERSONID_FK;


ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG ADD (
  CONSTRAINT CCNRSERVLOG_PERSONID_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.TPA_TRANSMISSION_LOG
  DROP CONSTRAINT TPA_TRANSLOG_PERSON_ID_FK;


ALTER TABLE ADR.TPA_TRANSMISSION_LOG ADD (
  CONSTRAINT TPA_TRANSLOG_PERSON_ID_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_PRINT_CHECK
  DROP CONSTRAINT COMPRTCHK_COMPRTREQ_FK;


ALTER TABLE ADR.COM_PRINT_CHECK ADD (
  CONSTRAINT COMPRTCHK_COMPRTREQ_FK 
  FOREIGN KEY (COM_PRINT_REQUEST_ID) 
  REFERENCES ADR.COM_PRINT_REQUEST (COM_PRINT_REQUEST_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION
  DROP CONSTRAINT ELGBDETER_ENRLMNTDET_FK;


ALTER TABLE ADR.ELIGIBILITY_DETERMINATION ADD (
  CONSTRAINT ELGBDETER_ENRLMNTDET_FK 
  FOREIGN KEY (ENROLLMENT_DETERMINATION_ID) 
  REFERENCES ADR.ENROLLMENT_DETERMINATION (ENROLLMENT_DETERMINATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CL_VERIFICATION_METHOD
  DROP CONSTRAINT SPC_FAC_CL_VER_METH_FK;


ALTER TABLE ADR.CL_VERIFICATION_METHOD ADD (
  CONSTRAINT SPC_FAC_CL_VER_METH_FK 
  FOREIGN KEY (SPECIAL_FACTOR_ID) 
  REFERENCES ADR.SPECIAL_FACTOR (SPECIAL_FACTOR_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE
  DROP CONSTRAINT FUTURE_DIS_ID_FK;


ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE ADD (
  CONSTRAINT FUTURE_DIS_ID_FK 
  FOREIGN KEY (FUTURE_DISCHARGE_SRC_TYPE_ID) 
  REFERENCES ADR.FUTURE_DISCHARGE_SRC_TYPE (FUTURE_DISCHARGE_SRC_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT PURPOSE_OF_USE_FK;


ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT PURPOSE_OF_USE_FK 
  FOREIGN KEY (PURPOSE_OF_USE_TYPE_ID) 
  REFERENCES ADR.PURPOSE_OF_USE_TYPE (PURPOSE_OF_USE_TYPE_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON
  DROP CONSTRAINT STOP_COM_RSN_TYPE_ID_FK;


ALTER TABLE ADR.PERSON ADD (
  CONSTRAINT STOP_COM_RSN_TYPE_ID_FK 
  FOREIGN KEY (STOP_COM_RSN_TYPE_ID) 
  REFERENCES ADR.STOP_COM_RSN_TYPE (STOP_COM_RSN_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
  DROP CONSTRAINT CLOSE_APL_RSN_TYPE_ID_FK;


ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT CLOSE_APL_RSN_TYPE_ID_FK 
  FOREIGN KEY (CLOSE_APL_RSN_TYPE_ID) 
  REFERENCES ADR.CLOSE_APL_RSN_TYPE (CLOSE_APL_RSN_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT RPT_SORTBY_TYPE_ID_FK;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT RPT_SORTBY_TYPE_ID_FK 
  FOREIGN KEY (RPT_SORTBY_TYPE_ID) 
  REFERENCES ADR.RPT_SORTBY_TYPE (RPT_SORTBY_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MANUAL_OVERRIDE
  DROP CONSTRAINT MANUAL_OVERRIDE_RSN_TYPE_ID_FK;


ALTER TABLE ADR.MANUAL_OVERRIDE ADD (
  CONSTRAINT MANUAL_OVERRIDE_RSN_TYPE_ID_FK 
  FOREIGN KEY (MANUAL_OVERRIDE_RSN_TYPE_ID) 
  REFERENCES ADR.MANUAL_OVERRIDE_RSN_TYPE (MANUAL_OVERRIDE_RSN_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG
  DROP CONSTRAINT RCVDSRVLOG_SRVLOGID_FK;


ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG ADD (
  CONSTRAINT RCVDSRVLOG_SRVLOGID_FK 
  FOREIGN KEY (CCN_SERVICE_LOG_ID) 
  REFERENCES ADR.CCN_SERVICE_LOG (CCN_SERVICE_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_CONTRACTOR_REGION
  DROP CONSTRAINT CCN_CONTRACTOR_ID_FK;


ALTER TABLE ADR.CCN_CONTRACTOR_REGION ADD (
  CONSTRAINT CCN_CONTRACTOR_ID_FK 
  FOREIGN KEY (CCN_CONTRACTOR_ID) 
  REFERENCES ADR.CCN_CONTRACTOR (CCN_CONTRACTOR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG
  DROP CONSTRAINT CCNRSERVLOG_CONTRACTORID_FK;


ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG ADD (
  CONSTRAINT CCNRSERVLOG_CONTRACTORID_FK 
  FOREIGN KEY (CCN_CONTRACTOR_ID) 
  REFERENCES ADR.CCN_CONTRACTOR (CCN_CONTRACTOR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_CONTRACTOR_REGION
  DROP CONSTRAINT CCN_REGION_ID_FK;


ALTER TABLE ADR.CCN_CONTRACTOR_REGION ADD (
  CONSTRAINT CCN_REGION_ID_FK 
  FOREIGN KEY (CCN_REGION_ID) 
  REFERENCES ADR.CCN_REGION (CCN_REGION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_REGION_STATE
  DROP CONSTRAINT CCNRSNSTA_REGION_ID_FK;


ALTER TABLE ADR.CCN_REGION_STATE ADD (
  CONSTRAINT CCNRSNSTA_REGION_ID_FK 
  FOREIGN KEY (CCN_REGION_ID) 
  REFERENCES ADR.CCN_REGION (CCN_REGION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_SERVICE_LOG
  DROP CONSTRAINT CCNSERVLOG_GEOCODE_STATION_FK;


ALTER TABLE ADR.CCN_SERVICE_LOG ADD (
  CONSTRAINT CCNSERVLOG_GEOCODE_STATION_FK 
  FOREIGN KEY (GEOCODE_STATION_H_ID) 
  REFERENCES ADR.GEOCODE_STATION_H (GEOCODE_STATION_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_SERVICE_LOG
  DROP CONSTRAINT CCNSVCLOG_CCNFLTR_ID_FK;


ALTER TABLE ADR.CCN_SERVICE_LOG ADD (
  CONSTRAINT CCNSVCLOG_CCNFLTR_ID_FK 
  FOREIGN KEY (CCN_FILETRANSFER_ID) 
  REFERENCES ADR.CCN_FILETRANSFER (CCN_FILETRANSFER_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EMAIL
  DROP CONSTRAINT EML_SITE_OF_CNG_FK;


ALTER TABLE ADR.EMAIL ADD (
  CONSTRAINT EML_SITE_OF_CNG_FK 
  FOREIGN KEY (SITE_OF_CHANGE_ID) 
  REFERENCES ADR.LOOKUP_TYPE (LOOKUP_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT ADR_SITE_OF_CNG_FK;


ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT ADR_SITE_OF_CNG_FK 
  FOREIGN KEY (SITE_OF_CHANGE_ID) 
  REFERENCES ADR.LOOKUP_TYPE (LOOKUP_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PHONE
  DROP CONSTRAINT PHN_SITE_OF_CNG_FK;


ALTER TABLE ADR.PHONE ADD (
  CONSTRAINT PHN_SITE_OF_CNG_FK 
  FOREIGN KEY (SITE_OF_CHANGE_ID) 
  REFERENCES ADR.LOOKUP_TYPE (LOOKUP_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BROKER_SERVICE_LOG
  DROP CONSTRAINT BRSRVPL_DSBLTY_FK;


ALTER TABLE ADR.BROKER_SERVICE_LOG ADD (
  CONSTRAINT BRSRVPL_DSBLTY_FK 
  FOREIGN KEY (DISBLTY_RES_STAT_TYPE_ID) 
  REFERENCES ADR.LOOKUP_TYPE (LOOKUP_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BROKER_SERVICE_LOG
  DROP CONSTRAINT BRSRVPL_RETMNT_FK;


ALTER TABLE ADR.BROKER_SERVICE_LOG ADD (
  CONSTRAINT BRSRVPL_RETMNT_FK 
  FOREIGN KEY (RETIREMNT_RES_STAT_TYPE_ID) 
  REFERENCES ADR.LOOKUP_TYPE (LOOKUP_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BROKER_SERVICE_LOG
  DROP CONSTRAINT BRSRVPL_ELGBTY_FK;


ALTER TABLE ADR.BROKER_SERVICE_LOG ADD (
  CONSTRAINT BRSRVPL_ELGBTY_FK 
  FOREIGN KEY (ELGBTY_RES_STAT_TYPE_ID) 
  REFERENCES ADR.LOOKUP_TYPE (LOOKUP_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BROKER_SERVICE_LOG
  DROP CONSTRAINT BRSRVPL_RES_FK;


ALTER TABLE ADR.BROKER_SERVICE_LOG ADD (
  CONSTRAINT BRSRVPL_RES_FK 
  FOREIGN KEY (DEPLOY_RES_STAT_TYPE_ID) 
  REFERENCES ADR.LOOKUP_TYPE (LOOKUP_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE
  DROP CONSTRAINT MSE_PAY_PLAN_TYPE_FK;


ALTER TABLE ADR.MILITARY_SERVICE_EPISODE ADD (
  CONSTRAINT MSE_PAY_PLAN_TYPE_FK 
  FOREIGN KEY (PAY_PLAN_TYPE_ID) 
  REFERENCES ADR.LOOKUP_TYPE (LOOKUP_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON
  DROP CONSTRAINT PER_SUPDOCLKUP_TYPE_FK;


ALTER TABLE ADR.PERSON ADD (
  CONSTRAINT PER_SUPDOCLKUP_TYPE_FK 
  FOREIGN KEY (SUP_DOC_LOOKUP_TYPE_ID) 
  REFERENCES ADR.LOOKUP_TYPE (LOOKUP_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE
  DROP CONSTRAINT MSE_NARLKUP_TYPE_FK;


ALTER TABLE ADR.MILITARY_SERVICE_EPISODE ADD (
  CONSTRAINT MSE_NARLKUP_TYPE_FK 
  FOREIGN KEY (NARRATIVE_REASON_TYPE_ID) 
  REFERENCES ADR.NARRATIVE_REASON_TYPE (NARRATIVE_REASON_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ADR_DB_VER
  DROP CONSTRAINT ADR_DBVER_PK;

ALTER TABLE ADR.ADR_DB_VER ADD (
  CONSTRAINT ADR_DBVER_PK
  PRIMARY KEY
  (ADR_DB_VER_ID)
  DISABLE NOVALIDATE);
ALTER TABLE ADR.APP_PARAMETER_H
  DROP CONSTRAINT APP_PARAMETER_H_PK;

ALTER TABLE ADR.APP_PARAMETER_H ADD (
  CONSTRAINT APP_PARAMETER_H_PK
  PRIMARY KEY
  (APP_PARAMETER_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_TRAITS
  DROP CONSTRAINT PRSN_U_VPIDVAL_UN;

ALTER TABLE ADR.PERSON_TRAITS ADD (
  CONSTRAINT PRSN_U_VPIDVAL_UN
  UNIQUE (VPID_VALUE)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.TPA_TRANSMISSION_LOG
  DROP CONSTRAINT TPA_TRANSMISSION_LOG_PK;

ALTER TABLE ADR.TPA_TRANSMISSION_LOG ADD (
  CONSTRAINT TPA_TRANSMISSION_LOG_PK
  PRIMARY KEY
  (TPA_TRANSMISSION_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_TRAITS
  DROP CONSTRAINT PERSONTRAITSID_PK_I;

ALTER TABLE ADR.PERSON_TRAITS ADD (
  CONSTRAINT PERSONTRAITSID_PK_I
  PRIMARY KEY
  (PERSON_TRAITS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_TRAITS_BKP
  DROP CONSTRAINT PERSONTRAITSID_PK_I_BKP;

ALTER TABLE ADR.PERSON_TRAITS_BKP ADD (
  CONSTRAINT PERSONTRAITSID_PK_I_BKP
  PRIMARY KEY
  (PERSON_TRAITS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CI_TRANSACTION_LOG
  DROP CONSTRAINT CI_TRANSACTION_LOG_PK;

ALTER TABLE ADR.CI_TRANSACTION_LOG ADD (
  CONSTRAINT CI_TRANSACTION_LOG_PK
  PRIMARY KEY
  (CI_TRANSACTION_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.NARRATIVE_REASON_TYPE
  DROP CONSTRAINT NARRATIVE_REASON_TYPE_PK;

ALTER TABLE ADR.NARRATIVE_REASON_TYPE ADD (
  CONSTRAINT NARRATIVE_REASON_TYPE_PK
  PRIMARY KEY
  (NARRATIVE_REASON_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.LOOKUP_TYPE
  DROP CONSTRAINT LOOKUP_TYPE_PK;

ALTER TABLE ADR.LOOKUP_TYPE ADD (
  CONSTRAINT LOOKUP_TYPE_PK
  PRIMARY KEY
  (LOOKUP_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG
  DROP CONSTRAINT CCN_RECEIVED_SERVICE_LOG_PK;

ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG ADD (
  CONSTRAINT CCN_RECEIVED_SERVICE_LOG_PK
  PRIMARY KEY
  (CCN_RECEIVED_SERVICE_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PCP_STAGE
  DROP CONSTRAINT PCP_STAGE_PK;

ALTER TABLE ADR.PCP_STAGE ADD (
  CONSTRAINT PCP_STAGE_PK
  PRIMARY KEY
  (PCP_STAGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_FILETRANSFER_H
  DROP CONSTRAINT CCNFILETRANSHID_PK;

ALTER TABLE ADR.CCN_FILETRANSFER_H ADD (
  CONSTRAINT CCNFILETRANSHID_PK
  PRIMARY KEY
  (CCN_FILETRANSFER_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_FILETRANSFER
  DROP CONSTRAINT CCN_FILETRANS_ID_PK;

ALTER TABLE ADR.CCN_FILETRANSFER ADD (
  CONSTRAINT CCN_FILETRANS_ID_PK
  PRIMARY KEY
  (CCN_FILETRANSFER_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_STATION_H
  DROP CONSTRAINT GEOCODE_STATION_H_PK;

ALTER TABLE ADR.GEOCODE_STATION_H ADD (
  CONSTRAINT GEOCODE_STATION_H_PK
  PRIMARY KEY
  (GEOCODE_STATION_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_REGION_STATE
  DROP CONSTRAINT CCN_REGION_STATE_PK;

ALTER TABLE ADR.CCN_REGION_STATE ADD (
  CONSTRAINT CCN_REGION_STATE_PK
  PRIMARY KEY
  (CCN_REGION_STATE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H
  DROP CONSTRAINT CCN_CONTRACTOR_REGION_H_PK;

ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H ADD (
  CONSTRAINT CCN_CONTRACTOR_REGION_H_PK
  PRIMARY KEY
  (CCN_CONTRACTOR_REGION_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_CONTRACTOR_REGION
  DROP CONSTRAINT CCN_CONTRACTOR_REGION_PK;

ALTER TABLE ADR.CCN_CONTRACTOR_REGION ADD (
  CONSTRAINT CCN_CONTRACTOR_REGION_PK
  PRIMARY KEY
  (CCN_CONTRACTOR_REGION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_REGION
  DROP CONSTRAINT CCN_REGION_PK;

ALTER TABLE ADR.CCN_REGION ADD (
  CONSTRAINT CCN_REGION_PK
  PRIMARY KEY
  (CCN_REGION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_CONTRACTOR_H
  DROP CONSTRAINT CCN_CONTRACTOR_H_PK;

ALTER TABLE ADR.CCN_CONTRACTOR_H ADD (
  CONSTRAINT CCN_CONTRACTOR_H_PK
  PRIMARY KEY
  (CCN_CONTRACTOR_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_CONTRACTOR
  DROP CONSTRAINT CCN_CONTRACTOR_PK;

ALTER TABLE ADR.CCN_CONTRACTOR ADD (
  CONSTRAINT CCN_CONTRACTOR_PK
  PRIMARY KEY
  (CCN_CONTRACTOR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_SERVICE_LOG
  DROP CONSTRAINT CCNSERVLOG_CCNSERVLOG_ID_PK;

ALTER TABLE ADR.CCN_SERVICE_LOG ADD (
  CONSTRAINT CCNSERVLOG_CCNSERVLOG_ID_PK
  PRIMARY KEY
  (CCN_SERVICE_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WAITTIME_H
  DROP CONSTRAINT WAITTIME_H_PK;

ALTER TABLE ADR.WAITTIME_H ADD (
  CONSTRAINT WAITTIME_H_PK
  PRIMARY KEY
  (WAITTIME_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_TRANSMIT_H
  DROP CONSTRAINT GEOCODE_TRANSMIT_H_PK;

ALTER TABLE ADR.GEOCODE_TRANSMIT_H ADD (
  CONSTRAINT GEOCODE_TRANSMIT_H_PK
  PRIMARY KEY
  (GEOCODE_TRANSMIT_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_SIMPROP_TRIGGERS
  DROP CONSTRAINT QRTZ_SIMPROP_TRIG_PK;

ALTER TABLE ADR.QRTZ_SIMPROP_TRIGGERS ADD (
  CONSTRAINT QRTZ_SIMPROP_TRIG_PK
  PRIMARY KEY
  (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_SCHEDULER_STATE
  DROP CONSTRAINT QRTZ_SCHEDULER_STATE_PK;

ALTER TABLE ADR.QRTZ_SCHEDULER_STATE ADD (
  CONSTRAINT QRTZ_SCHEDULER_STATE_PK
  PRIMARY KEY
  (SCHED_NAME, INSTANCE_NAME)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_PAUSED_TRIGGER_GRPS
  DROP CONSTRAINT QRTZ_PAUSED_TRIG_GRPS_PK;

ALTER TABLE ADR.QRTZ_PAUSED_TRIGGER_GRPS ADD (
  CONSTRAINT QRTZ_PAUSED_TRIG_GRPS_PK
  PRIMARY KEY
  (SCHED_NAME, TRIGGER_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_LOCKS
  DROP CONSTRAINT QRTZ_LOCKS_PK;

ALTER TABLE ADR.QRTZ_LOCKS ADD (
  CONSTRAINT QRTZ_LOCKS_PK
  PRIMARY KEY
  (SCHED_NAME, LOCK_NAME)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_CALENDARS
  DROP CONSTRAINT QRTZ_CALENDARS_PK;

ALTER TABLE ADR.QRTZ_CALENDARS ADD (
  CONSTRAINT QRTZ_CALENDARS_PK
  PRIMARY KEY
  (SCHED_NAME, CALENDAR_NAME)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS
  DROP CONSTRAINT QRTZ_FIRED_TRIGGER_PK;

ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS ADD (
  CONSTRAINT QRTZ_FIRED_TRIGGER_PK
  PRIMARY KEY
  (SCHED_NAME, ENTRY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS
  DROP CONSTRAINT QRTZ_SIMPLE_TRIG_PK;

ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS ADD (
  CONSTRAINT QRTZ_SIMPLE_TRIG_PK
  PRIMARY KEY
  (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_CRON_TRIGGERS
  DROP CONSTRAINT QRTZ_CRON_TRIG_PK;

ALTER TABLE ADR.QRTZ_CRON_TRIGGERS ADD (
  CONSTRAINT QRTZ_CRON_TRIG_PK
  PRIMARY KEY
  (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_BLOB_TRIGGERS
  DROP CONSTRAINT QRTZ_BLOB_TRIG_PK;

ALTER TABLE ADR.QRTZ_BLOB_TRIGGERS ADD (
  CONSTRAINT QRTZ_BLOB_TRIG_PK
  PRIMARY KEY
  (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_TRIGGERS
  DROP CONSTRAINT QRTZ_TRIGGERS_PK;

ALTER TABLE ADR.QRTZ_TRIGGERS ADD (
  CONSTRAINT QRTZ_TRIGGERS_PK
  PRIMARY KEY
  (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.QRTZ_JOB_DETAILS
  DROP CONSTRAINT QRTZ_JOB_DETAILS_PK;

ALTER TABLE ADR.QRTZ_JOB_DETAILS ADD (
  CONSTRAINT QRTZ_JOB_DETAILS_PK
  PRIMARY KEY
  (SCHED_NAME, JOB_NAME, JOB_GROUP)
  ENABLE VALIDATE);
ALTER TABLE ADR.MANUAL_OVERRIDE_H
  DROP CONSTRAINT MANUAL_OVERRIDE_H_PK;

ALTER TABLE ADR.MANUAL_OVERRIDE_H ADD (
  CONSTRAINT MANUAL_OVERRIDE_H_PK
  PRIMARY KEY
  (MANUAL_OVERRIDE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MANUAL_OVERRIDE
  DROP CONSTRAINT MANUAL_OVERRIDE_PK;

ALTER TABLE ADR.MANUAL_OVERRIDE ADD (
  CONSTRAINT MANUAL_OVERRIDE_PK
  PRIMARY KEY
  (MANUAL_OVERRIDE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MANUAL_OVERRIDE_RSN_TYPE
  DROP CONSTRAINT MANUAL_OVERRIDE_RSN_TYPE_PK;

ALTER TABLE ADR.MANUAL_OVERRIDE_RSN_TYPE ADD (
  CONSTRAINT MANUAL_OVERRIDE_RSN_TYPE_PK
  PRIMARY KEY
  (MANUAL_OVERRIDE_RSN_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SORTBY_TYPE
  DROP CONSTRAINT RPT_SORTBY_TYPE_PK;

ALTER TABLE ADR.RPT_SORTBY_TYPE ADD (
  CONSTRAINT RPT_SORTBY_TYPE_PK
  PRIMARY KEY
  (RPT_SORTBY_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CLOSE_APL_RSN_TYPE
  DROP CONSTRAINT CLOSE_APL_RSN_TYPE_PK;

ALTER TABLE ADR.CLOSE_APL_RSN_TYPE ADD (
  CONSTRAINT CLOSE_APL_RSN_TYPE_PK
  PRIMARY KEY
  (CLOSE_APL_RSN_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.STOP_COM_RSN_TYPE
  DROP CONSTRAINT STOP_COM_RSN_TYPE_PK;

ALTER TABLE ADR.STOP_COM_RSN_TYPE ADD (
  CONSTRAINT STOP_COM_RSN_TYPE_PK
  PRIMARY KEY
  (STOP_COM_RSN_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PURPOSE_OF_USE_TYPE
  DROP CONSTRAINT PURPOSE_OF_USE_TYPE_PK;

ALTER TABLE ADR.PURPOSE_OF_USE_TYPE ADD (
  CONSTRAINT PURPOSE_OF_USE_TYPE_PK
  PRIMARY KEY
  (PURPOSE_OF_USE_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE_H
  DROP CONSTRAINT MILITARY_FUTURE_DIS_H_PK;

ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE_H ADD (
  CONSTRAINT MILITARY_FUTURE_DIS_H_PK
  PRIMARY KEY
  (MILITARY_FUTURE_DISCHARGE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE
  DROP CONSTRAINT MILITARY_FUTURE_DIS_PK;

ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE ADD (
  CONSTRAINT MILITARY_FUTURE_DIS_PK
  PRIMARY KEY
  (MILITARY_FUTURE_DISCHARGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE
  DROP CONSTRAINT FUTURE_DISCHARGE_SRC_TYPE_PK;

ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE ADD (
  CONSTRAINT FUTURE_DISCHARGE_SRC_TYPE_PK
  PRIMARY KEY
  (FUTURE_DISCHARGE_SRC_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
  DROP CONSTRAINT ENRLMNTDET_PK;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT ENRLMNTDET_PK
  PRIMARY KEY
  (ENROLLMENT_DETERMINATION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IVM_MIGRATE
  DROP CONSTRAINT IVMMGRT_PK;

ALTER TABLE ADR.IVM_MIGRATE ADD (
  CONSTRAINT IVMMGRT_PK
  PRIMARY KEY
  (IVM_MIGRATE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION
  DROP CONSTRAINT ELGBTYVRFY_PK;

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION ADD (
  CONSTRAINT ELGBTYVRFY_PK
  PRIMARY KEY
  (ELIGIBILITY_VERIFICATION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.INCOMPETENT_RULING_H
  DROP CONSTRAINT INCOMPRULH_PK;

ALTER TABLE ADR.INCOMPETENT_RULING_H ADD (
  CONSTRAINT INCOMPRULH_PK
  PRIMARY KEY
  (INCOMPETENT_RULING_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H
  DROP CONSTRAINT PRPLHRTREH_PK;

ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H ADD (
  CONSTRAINT PRPLHRTREH_PK
  PRIMARY KEY
  (PURPLE_HEART_REGISTRY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SSN_VERIFICATION_DETAIL
  DROP CONSTRAINT SSNVERFYDT_PK;

ALTER TABLE ADR.SSN_VERIFICATION_DETAIL ADD (
  CONSTRAINT SSNVERFYDT_PK
  PRIMARY KEY
  (SSN_VERIFICATION_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_CHANGE_LOG
  DROP CONSTRAINT PRSNCHGLOG_PK;

ALTER TABLE ADR.PERSON_CHANGE_LOG ADD (
  CONSTRAINT PRSNCHGLOG_PK
  PRIMARY KEY
  (PERSON_CHANGE_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_PRINT_REQUEST
  DROP CONSTRAINT COMPRTREQ_U_PRINT_DUPLICATE_UK;

ALTER TABLE ADR.COM_PRINT_REQUEST ADD (
  CONSTRAINT COMPRTREQ_U_PRINT_DUPLICATE_UK
  UNIQUE (PRINT_REQUEST_UNIQUE_CODE)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_PRINT_REQUEST
  DROP CONSTRAINT COMPRTREQ_PK;

ALTER TABLE ADR.COM_PRINT_REQUEST ADD (
  CONSTRAINT COMPRTREQ_PK
  PRIMARY KEY
  (COM_PRINT_REQUEST_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL
  DROP CONSTRAINT MONEYBNDTL_PK;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL ADD (
  CONSTRAINT MONEYBNDTL_PK
  PRIMARY KEY
  (MONETARY_BENEFIT_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON
  DROP CONSTRAINT PRSN_U_VPID_UK;

ALTER TABLE ADR.PERSON ADD (
  CONSTRAINT PRSN_U_VPID_UK
  UNIQUE (VPID_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON
  DROP CONSTRAINT PRSN_VPIDVALUE_UK;

ALTER TABLE ADR.PERSON ADD (
  CONSTRAINT PRSN_VPIDVALUE_UK
  UNIQUE (VPID_VALUE)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON
  DROP CONSTRAINT PRSN_PK;

ALTER TABLE ADR.PERSON ADD (
  CONSTRAINT PRSN_PK
  PRIMARY KEY
  (PERSON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_CONTACT
  DROP CONSTRAINT PRSNCTAC_PK;

ALTER TABLE ADR.PERSON_CONTACT ADD (
  CONSTRAINT PRSNCTAC_PK
  PRIMARY KEY
  (PERSON_CONTACT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_ETHNICITY_H
  DROP CONSTRAINT PRSNETNCTH_PK;

ALTER TABLE ADR.PERSON_ETHNICITY_H ADD (
  CONSTRAINT PRSNETNCTH_PK
  PRIMARY KEY
  (PERSON_ETHNICITY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_H
  DROP CONSTRAINT PRSNH_PK;

ALTER TABLE ADR.PERSON_H ADD (
  CONSTRAINT PRSNH_PK
  PRIMARY KEY
  (PERSON_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL
  DROP CONSTRAINT RATEDISDET_PK;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL ADD (
  CONSTRAINT RATEDISDET_PK
  PRIMARY KEY
  (RATED_DISABILITY_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H
  DROP CONSTRAINT RATEDISDTH_PK;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H ADD (
  CONSTRAINT RATEDISDTH_PK
  PRIMARY KEY
  (RATED_DISABILITY_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT
  DROP CONSTRAINT REGTRAIT_PK;

ALTER TABLE ADR.REGISTRY_TRAIT ADD (
  CONSTRAINT REGTRAIT_PK
  PRIMARY KEY
  (REGISTRY_TRAIT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT_H
  DROP CONSTRAINT REGTRAITH_PK;

ALTER TABLE ADR.REGISTRY_TRAIT_H ADD (
  CONSTRAINT REGTRAITH_PK
  PRIMARY KEY
  (REGISTRY_TRAIT_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY
  DROP CONSTRAINT SITERCVELG_PK;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY ADD (
  CONSTRAINT SITERCVELG_PK
  PRIMARY KEY
  (SITE_RECEIVED_ELIGIBILITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H
  DROP CONSTRAINT SITERCVELH_PK;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H ADD (
  CONSTRAINT SITERCVELH_PK
  PRIMARY KEY
  (SITE_RECEIVED_ELIGIBILITY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT
  DROP CONSTRAINT PATPRVASGN_PK;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT ADD (
  CONSTRAINT PATPRVASGN_PK
  PRIMARY KEY
  (PATIENT_PROVIDER_ASSIGNMENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H
  DROP CONSTRAINT MILSRVCEPH_PK;

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H ADD (
  CONSTRAINT MILSRVCEPH_PK
  PRIMARY KEY
  (MILITARY_SERVICE_EPISODE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_H
  DROP CONSTRAINT MILSRVCH_PK;

ALTER TABLE ADR.MILITARY_SERVICE_H ADD (
  CONSTRAINT MILSRVCH_PK
  PRIMARY KEY
  (MILITARY_SERVICE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H
  DROP CONSTRAINT FINEXPDTLH_PK;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H ADD (
  CONSTRAINT FINEXPDTLH_PK
  PRIMARY KEY
  (FINANCIAL_EXPENSE_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H
  DROP CONSTRAINT CATDSBLTYH_PK;

ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H ADD (
  CONSTRAINT CATDSBLTYH_PK
  PRIMARY KEY
  (CATASTROPHIC_DISABILITY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FEE_BASIS_H
  DROP CONSTRAINT FEEBASISH_PK;

ALTER TABLE ADR.FEE_BASIS_H ADD (
  CONSTRAINT FEEBASISH_PK
  PRIMARY KEY
  (FEE_BASIS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ADDRESS_H
  DROP CONSTRAINT ADDRH_PK;

ALTER TABLE ADR.ADDRESS_H ADD (
  CONSTRAINT ADDRH_PK
  PRIMARY KEY
  (ADDRESS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CONFLICT_DETAIL_H
  DROP CONSTRAINT CONFLDTLH_PK;

ALTER TABLE ADR.CONFLICT_DETAIL_H ADD (
  CONSTRAINT CONFLDTLH_PK
  PRIMARY KEY
  (CONFLICT_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.INSURANCE_H
  DROP CONSTRAINT INSURANCEH_PK;

ALTER TABLE ADR.INSURANCE_H ADD (
  CONSTRAINT INSURANCEH_PK
  PRIMARY KEY
  (INSURANCE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H
  DROP CONSTRAINT BENVISSUMH_PK;

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H ADD (
  CONSTRAINT BENVISSUMH_PK
  PRIMARY KEY
  (BENEFICIARY_VISIT_SUMMARY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H
  DROP CONSTRAINT MONEYBNDTLH_PK;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H ADD (
  CONSTRAINT MONEYBNDTLH_PK
  PRIMARY KEY
  (MONETARY_BENEFIT_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EMPLOYMENT_H
  DROP CONSTRAINT EMPLOYH_PK;

ALTER TABLE ADR.EMPLOYMENT_H ADD (
  CONSTRAINT EMPLOYH_PK
  PRIMARY KEY
  (EMPLOYMENT_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_SCI_H
  DROP CONSTRAINT BNFYSCIH_PK;

ALTER TABLE ADR.BENEFICIARY_SCI_H ADD (
  CONSTRAINT BNFYSCIH_PK
  PRIMARY KEY
  (BENEFICIARY_SCI_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL_H
  DROP CONSTRAINT INCMTSTDTH_PK;

ALTER TABLE ADR.INCOME_TEST_DETAIL_H ADD (
  CONSTRAINT INCMTSTDTH_PK
  PRIMARY KEY
  (INCOME_TEST_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H
  DROP CONSTRAINT FININCMDTH_PK;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H ADD (
  CONSTRAINT FININCMDTH_PK
  PRIMARY KEY
  (FINANCIAL_INCOME_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT COMMAIL_PK;

ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT COMMAIL_PK
  PRIMARY KEY
  (COM_MAILING_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL
  DROP CONSTRAINT COMMLSTAT_PK;

ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL ADD (
  CONSTRAINT COMMLSTAT_PK
  PRIMARY KEY
  (COM_MAILING_STATUS_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE
  DROP CONSTRAINT MILSRVCEPS_PK;

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE ADD (
  CONSTRAINT MILSRVCEPS_PK
  PRIMARY KEY
  (MILITARY_SERVICE_EPISODE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H
  DROP CONSTRAINT HCPH_PK;

ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H ADD (
  CONSTRAINT HCPH_PK
  PRIMARY KEY
  (HEALTH_CARE_PROVIDER_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SSN_H
  DROP CONSTRAINT SSNH_PK;

ALTER TABLE ADR.SSN_H ADD (
  CONSTRAINT SSNH_PK
  PRIMARY KEY
  (SSN_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR_H
  DROP CONSTRAINT SPECFACTH_PK;

ALTER TABLE ADR.SPECIAL_FACTOR_H ADD (
  CONSTRAINT SPECFACTH_PK
  PRIMARY KEY
  (SPECIAL_FACTOR_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SERVICE_CONNECTED_H
  DROP CONSTRAINT SVCCONH_PK;

ALTER TABLE ADR.SERVICE_CONNECTED_H ADD (
  CONSTRAINT SVCCONH_PK
  PRIMARY KEY
  (SERVICE_CONNECTED_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY_H
  DROP CONSTRAINT PRFFCLH_PK;

ALTER TABLE ADR.PREFERRED_FACILITY_H ADD (
  CONSTRAINT PRFFCLH_PK
  PRIMARY KEY
  (PREFERRED_FACILITY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_CONTACT_H
  DROP CONSTRAINT PRSNCTACH_PK;

ALTER TABLE ADR.PERSON_CONTACT_H ADD (
  CONSTRAINT PRSNCTACH_PK
  PRIMARY KEY
  (PERSON_CONTACT_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MEDICAID_FACTOR_H
  DROP CONSTRAINT MEDICAIDH_PK;

ALTER TABLE ADR.MEDICAID_FACTOR_H ADD (
  CONSTRAINT MEDICAIDH_PK
  PRIMARY KEY
  (MEDICAID_FACTOR_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.INCOME_TEST_H
  DROP CONSTRAINT INCMTSTH_PK;

ALTER TABLE ADR.INCOME_TEST_H ADD (
  CONSTRAINT INCMTSTH_PK
  PRIMARY KEY
  (INCOME_TEST_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.INCOME_TEST
  DROP CONSTRAINT INCMTST_PK;

ALTER TABLE ADR.INCOME_TEST ADD (
  CONSTRAINT INCMTST_PK
  PRIMARY KEY
  (INCOME_TEST_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H
  DROP CONSTRAINT HLTHBENPRFH_PK;

ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H ADD (
  CONSTRAINT HLTHBENPRFH_PK
  PRIMARY KEY
  (HEALTH_BENEFIT_PROFILE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H
  DROP CONSTRAINT HNDMALSTAH_PK;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H ADD (
  CONSTRAINT HNDMALSTAH_PK
  PRIMARY KEY
  (HANDBOOK_MAIL_STATUS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H
  DROP CONSTRAINT HNDMALQUEH_PK;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H ADD (
  CONSTRAINT HNDMALQUEH_PK
  PRIMARY KEY
  (HANDBOOK_MAIL_QUEUE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H
  DROP CONSTRAINT FINASTDTLH_PK;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H ADD (
  CONSTRAINT FINASTDTLH_PK
  PRIMARY KEY
  (FINANCIAL_ASSET_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H
  DROP CONSTRAINT ELGBDETERH_PK;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H ADD (
  CONSTRAINT ELGBDETERH_PK
  PRIMARY KEY
  (ELIGIBILITY_DETERMINATION_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.INSURANCE
  DROP CONSTRAINT INSURANCE_PK;

ALTER TABLE ADR.INSURANCE ADD (
  CONSTRAINT INSURANCE_PK
  PRIMARY KEY
  (INSURANCE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE
  DROP CONSTRAINT MILSRVC_PK;

ALTER TABLE ADR.MILITARY_SERVICE ADD (
  CONSTRAINT MILSRVC_PK
  PRIMARY KEY
  (MILITARY_SERVICE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BROKER_SERVICE_LOG
  DROP CONSTRAINT BRSRVL1_PK;

ALTER TABLE ADR.BROKER_SERVICE_LOG ADD (
  CONSTRAINT BRSRVL1_PK
  PRIMARY KEY
  (BROKER_SERVICE_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT_H
  DROP CONSTRAINT FINSTATEH_PK;

ALTER TABLE ADR.FINANCIAL_STATEMENT_H ADD (
  CONSTRAINT FINSTATEH_PK
  PRIMARY KEY
  (FINANCIAL_STATEMENT_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT
  DROP CONSTRAINT FINSTATE_PK;

ALTER TABLE ADR.FINANCIAL_STATEMENT ADD (
  CONSTRAINT FINSTATE_PK
  PRIMARY KEY
  (FINANCIAL_STATEMENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL
  DROP CONSTRAINT FINEXPDTL_PK;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL ADD (
  CONSTRAINT FINEXPDTL_PK
  PRIMARY KEY
  (FINANCIAL_EXPENSE_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_NTR_H
  DROP CONSTRAINT BNFYNTRH_PK;

ALTER TABLE ADR.BENEFICIARY_NTR_H ADD (
  CONSTRAINT BNFYNTRH_PK
  PRIMARY KEY
  (BENEFICIARY_NTR_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H
  DROP CONSTRAINT ELGBTYVRFH_PK;

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H ADD (
  CONSTRAINT ELGBTYVRFH_PK
  PRIMARY KEY
  (ELIGIBILITY_VERIFICATION_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EMAIL_H
  DROP CONSTRAINT EMAILH_PK;

ALTER TABLE ADR.EMAIL_H ADD (
  CONSTRAINT EMAILH_PK
  PRIMARY KEY
  (EMAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_H
  DROP CONSTRAINT MONEYBENH_PK;

ALTER TABLE ADR.MONETARY_BENEFIT_H ADD (
  CONSTRAINT MONEYBENH_PK
  PRIMARY KEY
  (MONETARY_BENEFIT_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE
  DROP CONSTRAINT GEOCODE_TRANSMIT_ARCHIVE_PK;

ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE ADD (
  CONSTRAINT GEOCODE_TRANSMIT_ARCHIVE_PK
  PRIMARY KEY
  (RECORD_CREATED_DATE, GEOCODE_TRANSMIT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WAITTIME_ARCHIVE
  DROP CONSTRAINT WAITTIME_ARCHIVE_PK;

ALTER TABLE ADR.WAITTIME_ARCHIVE ADD (
  CONSTRAINT WAITTIME_ARCHIVE_PK
  PRIMARY KEY
  (RECORD_CREATED_DATE, WAITTIME_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_TRANSMIT
  DROP CONSTRAINT GEOCODE_TRANSMIT_PK;

ALTER TABLE ADR.GEOCODE_TRANSMIT ADD (
  CONSTRAINT GEOCODE_TRANSMIT_PK
  PRIMARY KEY
  (RECORD_CREATED_DATE, GEOCODE_TRANSMIT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WAITTIME
  DROP CONSTRAINT WAITTIME_PK;

ALTER TABLE ADR.WAITTIME ADD (
  CONSTRAINT WAITTIME_PK
  PRIMARY KEY
  (RECORD_CREATED_DATE, WAITTIME_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SELF_IDENTIFIED_GENDER
  DROP CONSTRAINT SELF_IDENTIFIED_GENDER_PK;

ALTER TABLE ADR.SELF_IDENTIFIED_GENDER ADD (
  CONSTRAINT SELF_IDENTIFIED_GENDER_PK
  PRIMARY KEY
  (SELF_IDENTIFIED_GENDER_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MEC_PERIOD_NEW
  DROP CONSTRAINT MEC_PERIOD_ID_PK;

ALTER TABLE ADR.MEC_PERIOD_NEW ADD (
  CONSTRAINT MEC_PERIOD_ID_PK
  PRIMARY KEY
  (MEC_PERIOD_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MEC_PERIOD_LAST_HIST_NEW
  DROP CONSTRAINT PERSON_ID_MAX_PK;

ALTER TABLE ADR.MEC_PERIOD_LAST_HIST_NEW ADD (
  CONSTRAINT PERSON_ID_MAX_PK
  PRIMARY KEY
  (PERSON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_STAGE
  DROP CONSTRAINT GEOCODE_STAGE_PK;

ALTER TABLE ADR.GEOCODE_STAGE ADD (
  CONSTRAINT GEOCODE_STAGE_PK
  PRIMARY KEY
  (RECORD_CREATED_DATE, GEOCODE_STAGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WAITTIME_STAGE
  DROP CONSTRAINT WAITTIME_STAGE_PK;

ALTER TABLE ADR.WAITTIME_STAGE ADD (
  CONSTRAINT WAITTIME_STAGE_PK
  PRIMARY KEY
  (RECORD_CREATED_DATE, WAITTIME_STAGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.GEOCODE_STATION
  DROP CONSTRAINT GEOCODE_STATION_PK;

ALTER TABLE ADR.GEOCODE_STATION ADD (
  CONSTRAINT GEOCODE_STATION_PK
  PRIMARY KEY
  (GEOCODE_STATION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.VCELIGIBILITY_H
  DROP CONSTRAINT VCELIGIBILITY_H_PK;

ALTER TABLE ADR.VCELIGIBILITY_H ADD (
  CONSTRAINT VCELIGIBILITY_H_PK
  PRIMARY KEY
  (VCELIGIBILITY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.VCELIGIBILITY
  DROP CONSTRAINT VCELIGIBILITY_PK;

ALTER TABLE ADR.VCELIGIBILITY ADD (
  CONSTRAINT VCELIGIBILITY_PK
  PRIMARY KEY
  (VCELIGIBILITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.VCADMIN_H
  DROP CONSTRAINT VCADMIN_H_PK;

ALTER TABLE ADR.VCADMIN_H ADD (
  CONSTRAINT VCADMIN_H_PK
  PRIMARY KEY
  (VCADMIN_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.VCADMIN
  DROP CONSTRAINT VCADMIN_PK;

ALTER TABLE ADR.VCADMIN ADD (
  CONSTRAINT VCADMIN_PK
  PRIMARY KEY
  (VCADMIN_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.VCADMISTATUS_TYPE
  DROP CONSTRAINT VCADMISTATUS_TYPE_PK;

ALTER TABLE ADR.VCADMISTATUS_TYPE ADD (
  CONSTRAINT VCADMISTATUS_TYPE_PK
  PRIMARY KEY
  (VCADMISTATUS_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CASSCERTIFIEDTYPE
  DROP CONSTRAINT CASSCERTIFIEDTYPE_PK;

ALTER TABLE ADR.CASSCERTIFIEDTYPE ADD (
  CONSTRAINT CASSCERTIFIEDTYPE_PK
  PRIMARY KEY
  (CASSCERTIFIEDTYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WAITTYPE
  DROP CONSTRAINT WAITTYPE_PK;

ALTER TABLE ADR.WAITTYPE ADD (
  CONSTRAINT WAITTYPE_PK
  PRIMARY KEY
  (WAITTYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.VCESTATUSTYPE
  DROP CONSTRAINT VCESTATUSTYPE_PK;

ALTER TABLE ADR.VCESTATUSTYPE ADD (
  CONSTRAINT VCESTATUSTYPE_PK
  PRIMARY KEY
  (VCESTATUSTYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CORRESPONDENCE_H
  DROP CONSTRAINT CORRESPONDENCE_H_PK;

ALTER TABLE ADR.CORRESPONDENCE_H ADD (
  CONSTRAINT CORRESPONDENCE_H_PK
  PRIMARY KEY
  (CORRESPONDENCE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CORRESPONDENCE
  DROP CONSTRAINT CORRESPONDENCE_PK;

ALTER TABLE ADR.CORRESPONDENCE ADD (
  CONSTRAINT CORRESPONDENCE_PK
  PRIMARY KEY
  (CORRESPONDENCE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CORRESPONDENCE_DOCUMENT
  DROP CONSTRAINT CORRESPONDENCE_DOCUMENT_PK;

ALTER TABLE ADR.CORRESPONDENCE_DOCUMENT ADD (
  CONSTRAINT CORRESPONDENCE_DOCUMENT_PK
  PRIMARY KEY
  (CORRESPONDENCE_DOCUMENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CORRESPONDENCE_STATUS
  DROP CONSTRAINT CORRESPONDENCE_STATUS_PK;

ALTER TABLE ADR.CORRESPONDENCE_STATUS ADD (
  CONSTRAINT CORRESPONDENCE_STATUS_PK
  PRIMARY KEY
  (CORRESPONDENCE_STATUS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CORRESPONDENCE_TYPE
  DROP CONSTRAINT CORRESPONDENCE_TYPE_PK;

ALTER TABLE ADR.CORRESPONDENCE_TYPE ADD (
  CONSTRAINT CORRESPONDENCE_TYPE_PK
  PRIMARY KEY
  (CORRESPONDENCE_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_DATA
  DROP CONSTRAINT IRS_TRANSMISSION_DATA_ID_PK;

ALTER TABLE ADR.IRS_TRANSMISSION_DATA ADD (
  CONSTRAINT IRS_TRANSMISSION_DATA_ID_PK
  PRIMARY KEY
  (IRS_TRANSMISSION_DATA_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.TRANSMISSION_STATUS
  DROP CONSTRAINT TRANSMISSION_STATUS_ID_PK;

ALTER TABLE ADR.TRANSMISSION_STATUS ADD (
  CONSTRAINT TRANSMISSION_STATUS_ID_PK
  PRIMARY KEY
  (TRANSMISSION_STATUS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_LOG
  DROP CONSTRAINT IRS_TRANSMISSION_LOG_ID_PK;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG ADD (
  CONSTRAINT IRS_TRANSMISSION_LOG_ID_PK
  PRIMARY KEY
  (IRS_TRANSMISSION_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ACTIVEAGG_TRACKER
  DROP CONSTRAINT APP_LOG_PK;

ALTER TABLE ADR.ACTIVEAGG_TRACKER ADD (
  CONSTRAINT APP_LOG_PK
  PRIMARY KEY
  (ACTIVEAGG_TRACKER_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON
  DROP CONSTRAINT ELIGIBILITY_STATUS_REASON_PK;

ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON ADD (
  CONSTRAINT ELIGIBILITY_STATUS_REASON_PK
  PRIMARY KEY
  (ELIGIBILITY_STATUS_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CL_VERIFICATION_METHOD_H
  DROP CONSTRAINT CL_VERIFICATION_METHOD_H_PK;

ALTER TABLE ADR.CL_VERIFICATION_METHOD_H ADD (
  CONSTRAINT CL_VERIFICATION_METHOD_H_PK
  PRIMARY KEY
  (CL_VERIFICATION_METHOD_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CL_VERIFICATION_METHOD
  DROP CONSTRAINT CL_VERIFICATION_METHOD_PK;

ALTER TABLE ADR.CL_VERIFICATION_METHOD ADD (
  CONSTRAINT CL_VERIFICATION_METHOD_PK
  PRIMARY KEY
  (CL_VERIFICATION_METHOD_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H
  DROP CONSTRAINT HEALTH_BEN_PLAN_DETAIL_H_PK;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H ADD (
  CONSTRAINT HEALTH_BEN_PLAN_DETAIL_H_PK
  PRIMARY KEY
  (HEALTH_BENEFIT_PLAN_DET_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL
  DROP CONSTRAINT HLTHBENPLANDET_PK;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL ADD (
  CONSTRAINT HLTHBENPLANDET_PK
  PRIMARY KEY
  (HEALTH_BENEFIT_PLAN_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H
  DROP CONSTRAINT HEALTH_BENEFIT_PLAN_NAME_H_PK;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H ADD (
  CONSTRAINT HEALTH_BENEFIT_PLAN_NAME_H_PK
  PRIMARY KEY
  (HLTH_BEN_PLAN_NAME_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME
  DROP CONSTRAINT HEALTH_BENEFIT_PLAN_NAME_PK;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME ADD (
  CONSTRAINT HEALTH_BENEFIT_PLAN_NAME_PK
  PRIMARY KEY
  (HLTH_BEN_PLAN_NAME_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H
  DROP CONSTRAINT PERSON_PREFERRED_LANGUAGE_H_PK;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H ADD (
  CONSTRAINT PERSON_PREFERRED_LANGUAGE_H_PK
  PRIMARY KEY
  (PERSON_PREFERRED_LANG_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE
  DROP CONSTRAINT PERSON_PREFERRED_LANGUAGE_PK;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE ADD (
  CONSTRAINT PERSON_PREFERRED_LANGUAGE_PK
  PRIMARY KEY
  (PERSON_PREFERRED_LANGUAGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H
  DROP CONSTRAINT CAT_DSBLTY_DESCRIPTOR_H_PK;

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H ADD (
  CONSTRAINT CAT_DSBLTY_DESCRIPTOR_H_PK
  PRIMARY KEY
  (CAT_DSBLTY_DESCRIPTOR_ID_H)
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR
  DROP CONSTRAINT CAT_DSBLTY_DESCRIPTOR_PK;

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR ADD (
  CONSTRAINT CAT_DSBLTY_DESCRIPTOR_PK
  PRIMARY KEY
  (CAT_DSBLTY_DESCRIPTOR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_FORM_TYPE
  DROP CONSTRAINT RPT_FORM_TYPE_ID_PK;

ALTER TABLE ADR.RPT_FORM_TYPE ADD (
  CONSTRAINT RPT_FORM_TYPE_ID_PK
  PRIMARY KEY
  (RPT_FORM_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H
  DROP CONSTRAINT HEALTH_BENEFIT_PLAN_DESC_H_PK;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H ADD (
  CONSTRAINT HEALTH_BENEFIT_PLAN_DESC_H_PK
  PRIMARY KEY
  (HLTH_BEN_PLAN_DESC_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC
  DROP CONSTRAINT HEALTH_BENEFIT_PLAN_DESC_PK;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC ADD (
  CONSTRAINT HEALTH_BENEFIT_PLAN_DESC_PK
  PRIMARY KEY
  (HLTH_BEN_PLAN_DESC_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN
  DROP CONSTRAINT HLTHBENPLN_PK;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN ADD (
  CONSTRAINT HLTHBENPLN_PK
  PRIMARY KEY
  (HEALTH_BENEFIT_PLAN_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H
  DROP CONSTRAINT HLTHBENPLNH_PK;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H ADD (
  CONSTRAINT HLTHBENPLNH_PK
  PRIMARY KEY
  (HEALTH_BENEFIT_PLAN_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE
  DROP CONSTRAINT HLTHBENPRF_PK;

ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE ADD (
  CONSTRAINT HLTHBENPRF_PK
  PRIMARY KEY
  (HEALTH_BENEFIT_PROFILE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL
  DROP CONSTRAINT FININCMDTL_PK;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL ADD (
  CONSTRAINT FININCMDTL_PK
  PRIMARY KEY
  (FINANCIAL_INCOME_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H
  DROP CONSTRAINT ENRLMNTDEH_PK;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H ADD (
  CONSTRAINT ENRLMNTDEH_PK
  PRIMARY KEY
  (ENROLLMENT_DETERMINATION_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_DOCUMENT
  DROP CONSTRAINT HNDDOC_PK;

ALTER TABLE ADR.HANDBOOK_DOCUMENT ADD (
  CONSTRAINT HNDDOC_PK
  PRIMARY KEY
  (HANDBOOK_DOCUMENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY
  DROP CONSTRAINT BENVISSUM_PK;

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY ADD (
  CONSTRAINT BENVISSUM_PK
  PRIMARY KEY
  (BENEFICIARY_VISIT_SUMMARY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_RELATION_H
  DROP CONSTRAINT PRSNRELH_PK;

ALTER TABLE ADR.PERSON_RELATION_H ADD (
  CONSTRAINT PRSNRELH_PK
  PRIMARY KEY
  (PERSON_RELATION_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY
  DROP CONSTRAINT PRFFCL_PK;

ALTER TABLE ADR.PREFERRED_FACILITY ADD (
  CONSTRAINT PRFFCL_PK
  PRIMARY KEY
  (PREFERRED_FACILITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL
  DROP CONSTRAINT FINASTDTL_PK;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL ADD (
  CONSTRAINT FINASTDTL_PK
  PRIMARY KEY
  (FINANCIAL_ASSET_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PHONE_H
  DROP CONSTRAINT PHONEH_PK;

ALTER TABLE ADR.PHONE_H ADD (
  CONSTRAINT PHONEH_PK
  PRIMARY KEY
  (PHONE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL
  DROP CONSTRAINT INCMTSTDTL_PK;

ALTER TABLE ADR.INCOME_TEST_DETAIL ADD (
  CONSTRAINT INCMTSTDTL_PK
  PRIMARY KEY
  (INCOME_TEST_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL
  DROP CONSTRAINT IRS_TRANS_LOG_DET_ID_PK;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL ADD (
  CONSTRAINT IRS_TRANS_LOG_DET_ID_PK
  PRIMARY KEY
  (IRS_TRANSMISSION_LOG_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS
  DROP CONSTRAINT HNDMALSTA_PK;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS ADD (
  CONSTRAINT HNDMALSTA_PK
  PRIMARY KEY
  (HANDBOOK_MAIL_STATUS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PHONE
  DROP CONSTRAINT PHONE_PK;

ALTER TABLE ADR.PHONE ADD (
  CONSTRAINT PHONE_PK
  PRIMARY KEY
  (PHONE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE
  DROP CONSTRAINT COMLOG_PK;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE ADD (
  CONSTRAINT COMLOG_PK
  PRIMARY KEY
  (HANDBOOK_MAIL_QUEUE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SSN
  DROP CONSTRAINT SSN_PK;

ALTER TABLE ADR.SSN ADD (
  CONSTRAINT SSN_PK
  PRIMARY KEY
  (SSN_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT ADDR_PK;

ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT ADDR_PK
  PRIMARY KEY
  (ADDRESS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EMPLOYMENT
  DROP CONSTRAINT EMPLOY_PK;

ALTER TABLE ADR.EMPLOYMENT ADD (
  CONSTRAINT EMPLOY_PK
  PRIMARY KEY
  (EMPLOYMENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
  DROP CONSTRAINT PERSON_ID_UK;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT PERSON_ID_UK
  UNIQUE (PERSON_ID)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR
  DROP CONSTRAINT SPECFACT_PK;

ALTER TABLE ADR.SPECIAL_FACTOR ADD (
  CONSTRAINT SPECFACT_PK
  PRIMARY KEY
  (SPECIAL_FACTOR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HL7_ARCHIVE_TRANSACTION_LOG
  DROP CONSTRAINT HL7_ARCLOG_PK;

ALTER TABLE ADR.HL7_ARCHIVE_TRANSACTION_LOG ADD (
  CONSTRAINT HL7_ARCLOG_PK
  PRIMARY KEY
  (HL7_TRANSACTION_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.DELIVERY_PREFERENCE_H
  DROP CONSTRAINT DLVPRF_H_PK;

ALTER TABLE ADR.DELIVERY_PREFERENCE_H ADD (
  CONSTRAINT DLVPRF_H_PK
  PRIMARY KEY
  (DELIVERY_PREFERENCE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H
  DROP CONSTRAINT DLVPRFEM_H_PK;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H ADD (
  CONSTRAINT DLVPRFEM_H_PK
  PRIMARY KEY
  (DELIVERY_PREFERENCE_EMAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL
  DROP CONSTRAINT DLVPRFEM_PK;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL ADD (
  CONSTRAINT DLVPRFEM_PK
  PRIMARY KEY
  (DELIVERY_PREFERENCE_EMAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.DELIVERY_PREFERENCE
  DROP CONSTRAINT DLVPRF_PK;

ALTER TABLE ADR.DELIVERY_PREFERENCE ADD (
  CONSTRAINT DLVPRF_PK
  PRIMARY KEY
  (DELIVERY_PREFERENCE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H
  DROP CONSTRAINT HNDREQVETH_PK;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H ADD (
  CONSTRAINT HNDREQVETH_PK
  PRIMARY KEY
  (HANDBOOK_REQUEST_VETERAN_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H
  DROP CONSTRAINT BATREQPRRGRPH_PK;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H ADD (
  CONSTRAINT BATREQPRRGRPH_PK
  PRIMARY KEY
  (BATCH_REQUEST_PRI_GRP_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP
  DROP CONSTRAINT BTCREQPRRGRP_PK;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP ADD (
  CONSTRAINT BTCREQPRRGRP_PK
  PRIMARY KEY
  (BATCH_REQUEST_PRIORITY_GRP_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN
  DROP CONSTRAINT BATREQVET_PK;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN ADD (
  CONSTRAINT BATREQVET_PK
  PRIMARY KEY
  (HANDBOOK_REQUEST_VETERAN_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H
  DROP CONSTRAINT BATREQFACH_PK;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H ADD (
  CONSTRAINT BATREQFACH_PK
  PRIMARY KEY
  (BATCH_REQUEST_FACILITY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BATCH_REQUEST_FACILITY
  DROP CONSTRAINT BATREQFAC_PK;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY ADD (
  CONSTRAINT BATREQFAC_PK
  PRIMARY KEY
  (BATCH_REQUEST_FACILITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H
  DROP CONSTRAINT HNDBATREQH_PK;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H ADD (
  CONSTRAINT HNDBATREQH_PK
  PRIMARY KEY
  (HANDBOOK_BATCH_REQUEST_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST
  DROP CONSTRAINT HNDBATREQ_PK;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST ADD (
  CONSTRAINT HNDBATREQ_PK
  PRIMARY KEY
  (HANDBOOK_BATCH_REQUEST_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H
  DROP CONSTRAINT PATPRVASGNH_PK;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H ADD (
  CONSTRAINT PATPRVASGNH_PK
  PRIMARY KEY
  (PATIENT_PROVIDER_ASSIGN_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_CARE_PROVIDER
  DROP CONSTRAINT HCP_PK;

ALTER TABLE ADR.HEALTH_CARE_PROVIDER ADD (
  CONSTRAINT HCP_PK
  PRIMARY KEY
  (HEALTH_CARE_PROVIDER_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BROKER_SERVICE_PAYLOAD
  DROP CONSTRAINT BRSRVPL_PK;

ALTER TABLE ADR.BROKER_SERVICE_PAYLOAD ADD (
  CONSTRAINT BRSRVPL_PK
  PRIMARY KEY
  (BROKER_SERVICE_PAYLOAD_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BROKER_SERVICE_ERROR
  DROP CONSTRAINT BRSRVER_PK;

ALTER TABLE ADR.BROKER_SERVICE_ERROR ADD (
  CONSTRAINT BRSRVER_PK
  PRIMARY KEY
  (BROKER_SERVICE_ERROR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.TRANSMISSION_TYPE
  DROP CONSTRAINT NAME_UK;

ALTER TABLE ADR.TRANSMISSION_TYPE ADD (
  CONSTRAINT NAME_UK
  UNIQUE (NAME)
  ENABLE VALIDATE);
ALTER TABLE ADR.TRANSMISSION_TYPE
  DROP CONSTRAINT CODE_UK;

ALTER TABLE ADR.TRANSMISSION_TYPE ADD (
  CONSTRAINT CODE_UK
  UNIQUE (CODE)
  ENABLE VALIDATE);
ALTER TABLE ADR.TRANSMISSION_TYPE
  DROP CONSTRAINT TRNTYP_PK;

ALTER TABLE ADR.TRANSMISSION_TYPE ADD (
  CONSTRAINT TRNTYP_PK
  PRIMARY KEY
  (TRANSMISSION_TYPE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PENSION_REASON
  DROP CONSTRAINT PNSRSN_PK;

ALTER TABLE ADR.PENSION_REASON ADD (
  CONSTRAINT PNSRSN_PK
  PRIMARY KEY
  (PENSION_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PENSION
  DROP CONSTRAINT PNS_PK;

ALTER TABLE ADR.PENSION ADD (
  CONSTRAINT PNS_PK
  PRIMARY KEY
  (PENSION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PENSION_H
  DROP CONSTRAINT PNSH_PK;

ALTER TABLE ADR.PENSION_H ADD (
  CONSTRAINT PNSH_PK
  PRIMARY KEY
  (PENSION_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SEEDING
  DROP CONSTRAINT SEEDING_PK;

ALTER TABLE ADR.SEEDING ADD (
  CONSTRAINT SEEDING_PK
  PRIMARY KEY
  (SEEDING_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MEDAL_OF_HONOR
  DROP CONSTRAINT MOH_PK;

ALTER TABLE ADR.MEDAL_OF_HONOR ADD (
  CONSTRAINT MOH_PK
  PRIMARY KEY
  (MEDAL_OF_HONOR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.DEPLOYMENT
  DROP CONSTRAINT DEP_PK;

ALTER TABLE ADR.DEPLOYMENT ADD (
  CONSTRAINT DEP_PK
  PRIMARY KEY
  (DEPLOYMENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ACTIVATION
  DROP CONSTRAINT ACT_PK;

ALTER TABLE ADR.ACTIVATION ADD (
  CONSTRAINT ACT_PK
  PRIMARY KEY
  (ACTIVATION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MEDAL_OF_HONOR_H
  DROP CONSTRAINT MOH_H_PK;

ALTER TABLE ADR.MEDAL_OF_HONOR_H ADD (
  CONSTRAINT MOH_H_PK
  PRIMARY KEY
  (MEDAL_OF_HONOR_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.DEPLOYMENT_H
  DROP CONSTRAINT DEP_H_PK;

ALTER TABLE ADR.DEPLOYMENT_H ADD (
  CONSTRAINT DEP_H_PK
  PRIMARY KEY
  (DEPLOYMENT_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ACTIVATION_H
  DROP CONSTRAINT ACT_H_PK;

ALTER TABLE ADR.ACTIVATION_H ADD (
  CONSTRAINT ACT_H_PK
  PRIMARY KEY
  (ACTIVATION_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RELAXATION_PERCENTAGE
  DROP CONSTRAINT RLXPCT_PK;

ALTER TABLE ADR.RELAXATION_PERCENTAGE ADD (
  CONSTRAINT RLXPCT_PK
  PRIMARY KEY
  (RELAXATION_PERCENTAGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RELAXATION_PERCENTAGE_H
  DROP CONSTRAINT RLXPCTH_PK;

ALTER TABLE ADR.RELAXATION_PERCENTAGE_H ADD (
  CONSTRAINT RLXPCTH_PK
  PRIMARY KEY
  (RELAXATION_PERCENTAGE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H
  DROP CONSTRAINT ADDRCONFH_PK;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H ADD (
  CONSTRAINT ADDRCONFH_PK
  PRIMARY KEY
  (ADDR_CONFIDENTIAL_DTL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL
  DROP CONSTRAINT ADDRCONF_PK;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL ADD (
  CONSTRAINT ADDRCONF_PK
  PRIMARY KEY
  (ADDR_CONFIDENTIAL_DTL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_SCI
  DROP CONSTRAINT BNFYSCI_PK;

ALTER TABLE ADR.BENEFICIARY_SCI ADD (
  CONSTRAINT BNFYSCI_PK
  PRIMARY KEY
  (BENEFICIARY_SCI_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ADR_DB_VER
  DROP CONSTRAINT ADR_DBVER_VERSION_UK;

ALTER TABLE ADR.ADR_DB_VER ADD (
  CONSTRAINT ADR_DBVER_VERSION_UK
  UNIQUE (DB_VERSION, ADR_CR)
  ENABLE VALIDATE);
ALTER TABLE ADR.ADR_DB_VER
  DROP CONSTRAINT ADR_DBVER_CR_UK;

ALTER TABLE ADR.ADR_DB_VER ADD (
  CONSTRAINT ADR_DBVER_CR_UK
  UNIQUE (ADR_CR)
  ENABLE VALIDATE);
ALTER TABLE ADR.HL7_TRANSACTION_LOG
  DROP CONSTRAINT HL7LOG_PK;

ALTER TABLE ADR.HL7_TRANSACTION_LOG ADD (
  CONSTRAINT HL7LOG_PK
  PRIMARY KEY
  (HL7_TRANSACTION_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.APP_PARAMETER
  DROP CONSTRAINT APPLPARAM_U_CODE_UK;

ALTER TABLE ADR.APP_PARAMETER ADD (
  CONSTRAINT APPLPARAM_U_CODE_UK
  UNIQUE (PARAMETER_NAME)
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLES
  DROP CONSTRAINT ROLE_U_CODE_UK;

ALTER TABLE ADR.ROLES ADD (
  CONSTRAINT ROLE_U_CODE_UK
  UNIQUE (ROLE_NAME)
  ENABLE VALIDATE);
ALTER TABLE ADR.USERS
  DROP CONSTRAINT USER_1_UK2_UK;

ALTER TABLE ADR.USERS ADD (
  CONSTRAINT USER_1_UK2_UK
  UNIQUE (USERNAME)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERMISSION_SET
  DROP CONSTRAINT PERMSET_U_CODE_UK;

ALTER TABLE ADR.PERMISSION_SET ADD (
  CONSTRAINT PERMSET_U_CODE_UK
  UNIQUE (NAME)
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE
  DROP CONSTRAINT CATDSBLPRC_PK;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE ADD (
  CONSTRAINT CATDSBLPRC_PK
  PRIMARY KEY
  (CAT_DSBLTY_PROCEDURE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_STATUS_COMPONENT
  DROP CONSTRAINT RPTSTATCMP_PK;

ALTER TABLE ADR.RPT_STATUS_COMPONENT ADD (
  CONSTRAINT RPTSTATCMP_PK
  PRIMARY KEY
  (RPT_STATUS_COMPONENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.JOB_RESULT
  DROP CONSTRAINT JRESULT_PK;

ALTER TABLE ADR.JOB_RESULT ADD (
  CONSTRAINT JRESULT_PK
  PRIMARY KEY
  (JOB_RESULT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ENROLLMENT_OVERRIDE
  DROP CONSTRAINT ENROLOVER_PK;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE ADD (
  CONSTRAINT ENROLOVER_PK
  PRIMARY KEY
  (ENROLLMENT_OVERRIDE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLE_PERMISSION_SETS
  DROP CONSTRAINT ROLEPERMST_PK;

ALTER TABLE ADR.ROLE_PERMISSION_SETS ADD (
  CONSTRAINT ROLEPERMST_PK
  PRIMARY KEY
  (ROLE_PERMISSION_SET_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H
  DROP CONSTRAINT FINDBTDTLH_PK;

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H ADD (
  CONSTRAINT FINDBTDTLH_PK
  PRIMARY KEY
  (FINANCIAL_DEBT_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_ROLES
  DROP CONSTRAINT USERROLE_PK;

ALTER TABLE ADR.USER_ROLES ADD (
  CONSTRAINT USERROLE_PK
  PRIMARY KEY
  (USER_ROLE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H
  DROP CONSTRAINT REGTRAIDTH_PK;

ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H ADD (
  CONSTRAINT REGTRAIDTH_PK
  PRIMARY KEY
  (REGISTRY_TRAIT_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IN_PROCESS_FINANCIALS
  DROP CONSTRAINT INPROCFNCL_PK;

ALTER TABLE ADR.IN_PROCESS_FINANCIALS ADD (
  CONSTRAINT INPROCFNCL_PK
  PRIMARY KEY
  (IN_PROCESS_FINANCIAL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL
  DROP CONSTRAINT VAPERDVSN_PK;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL ADD (
  CONSTRAINT VAPERDVSN_PK
  PRIMARY KEY
  (VA_PERSON_DIVISION_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SIGNATURE_IMAGE_H
  DROP CONSTRAINT SIGNATUREH_PK;

ALTER TABLE ADR.SIGNATURE_IMAGE_H ADD (
  CONSTRAINT SIGNATUREH_PK
  PRIMARY KEY
  (SIGNATURE_IMAGE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.APP_PARAMETER
  DROP CONSTRAINT APPLPARAM_PK;

ALTER TABLE ADR.APP_PARAMETER ADD (
  CONSTRAINT APPLPARAM_PK
  PRIMARY KEY
  (APP_PARAMETER_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MEDICAID_FACTOR
  DROP CONSTRAINT MEDICAID_PK;

ALTER TABLE ADR.MEDICAID_FACTOR ADD (
  CONSTRAINT MEDICAID_PK
  PRIMARY KEY
  (MEDICAID_FACTOR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.REGISTRY_LOAD_STATISTICS
  DROP CONSTRAINT RGSTRYSTAT_PK;

ALTER TABLE ADR.REGISTRY_LOAD_STATISTICS ADD (
  CONSTRAINT RGSTRYSTAT_PK
  PRIMARY KEY
  (REGISTRY_LOAD_STATISTICS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PH_REGISTRY_DETAIL_H
  DROP CONSTRAINT PHREGDTLH_PK;

ALTER TABLE ADR.PH_REGISTRY_DETAIL_H ADD (
  CONSTRAINT PHREGDTLH_PK
  PRIMARY KEY
  (PH_REGISTRY_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_EMAIL_TEMPLATE
  DROP CONSTRAINT COMEMLTPL_PK;

ALTER TABLE ADR.COM_EMAIL_TEMPLATE ADD (
  CONSTRAINT COMEMLTPL_PK
  PRIMARY KEY
  (COM_EMAIL_TEMPLATE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_COM_REJECT_REASON
  DROP CONSTRAINT RPTCOMRJCT_PK;

ALTER TABLE ADR.RPT_COM_REJECT_REASON ADD (
  CONSTRAINT RPTCOMRJCT_PK
  PRIMARY KEY
  (RPT_COM_REJECT_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT
  DROP CONSTRAINT MONEYBEN_PK;

ALTER TABLE ADR.MONETARY_BENEFIT ADD (
  CONSTRAINT MONEYBEN_PK
  PRIMARY KEY
  (MONETARY_BENEFIT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_H
  DROP CONSTRAINT WKFCASEH_PK;

ALTER TABLE ADR.WKF_CASE_H ADD (
  CONSTRAINT WKFCASEH_PK
  PRIMARY KEY
  (WKF_CASE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_COMMENTS_H
  DROP CONSTRAINT WKFCMTSH_PK;

ALTER TABLE ADR.WKF_CASE_COMMENTS_H ADD (
  CONSTRAINT WKFCMTSH_PK
  PRIMARY KEY
  (WKF_CASE_COMMENT_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_EED_WEEKLY
  DROP CONSTRAINT RPTEEDWKLY_PK;

ALTER TABLE ADR.RPT_EED_WEEKLY ADD (
  CONSTRAINT RPTEEDWKLY_PK
  PRIMARY KEY
  (RPT_EED_WEEKLY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_PRIORITY_GROUP
  DROP CONSTRAINT RPTPRIOGRP_PK;

ALTER TABLE ADR.RPT_PRIORITY_GROUP ADD (
  CONSTRAINT RPTPRIOGRP_PK
  PRIMARY KEY
  (RPT_PRIORITY_GROUP_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PURPLE_HEART_REGISTRY
  DROP CONSTRAINT PRPLHRTREG_PK;

ALTER TABLE ADR.PURPLE_HEART_REGISTRY ADD (
  CONSTRAINT PRPLHRTREG_PK
  PRIMARY KEY
  (PURPLE_HEART_REGISTRY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H
  DROP CONSTRAINT WKFCSESTH_PK;

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H ADD (
  CONSTRAINT WKFCSESTH_PK
  PRIMARY KEY
  (WKF_CASE_STATUS_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H
  DROP CONSTRAINT VAPRSNCLAH_PK;

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H ADD (
  CONSTRAINT VAPRSNCLAH_PK
  PRIMARY KEY
  (VA_PERSON_CLASS_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_AAC_ERROR_DETAIL
  DROP CONSTRAINT COMAACERR_PK;

ALTER TABLE ADR.COM_AAC_ERROR_DETAIL ADD (
  CONSTRAINT COMAACERR_PK
  PRIMARY KEY
  (COM_AAC_ERROR_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_LETTER_FILE
  DROP CONSTRAINT RPTLTRFLTP_PK;

ALTER TABLE ADR.RPT_LETTER_FILE ADD (
  CONSTRAINT RPTLTRFLTP_PK
  PRIMARY KEY
  (RPT_LETTER_FILE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL
  DROP CONSTRAINT REGTRAITDT_PK;

ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL ADD (
  CONSTRAINT REGTRAITDT_PK
  PRIMARY KEY
  (REGISTRY_TRAIT_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_PH_REJECT_REASON
  DROP CONSTRAINT RPTPHRJCT_PK;

ALTER TABLE ADR.RPT_PH_REJECT_REASON ADD (
  CONSTRAINT RPTPHRJCT_PK
  PRIMARY KEY
  (RPT_PH_REJECT_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT
  DROP CONSTRAINT SITERECENR_PK;

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT ADD (
  CONSTRAINT SITERECENR_PK
  PRIMARY KEY
  (SITE_RECEIVED_ENROLLMENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR
  DROP CONSTRAINT RPTELGFCTR_PK;

ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR ADD (
  CONSTRAINT RPTELGFCTR_PK
  PRIMARY KEY
  (RPT_ELIGIBILITY_FACTOR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H
  DROP CONSTRAINT PRMSTPRMH_PK;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H ADD (
  CONSTRAINT PRMSTPRMH_PK
  PRIMARY KEY
  (PERM_SET_PERMISSIONS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CANCEL_DECLINE
  DROP CONSTRAINT CANDEC_PK;

ALTER TABLE ADR.CANCEL_DECLINE ADD (
  CONSTRAINT CANDEC_PK
  PRIMARY KEY
  (CANCEL_DECLINE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL
  DROP CONSTRAINT FINDBTDTL_PK;

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL ADD (
  CONSTRAINT FINDBTDTL_PK
  PRIMARY KEY
  (FINANCIAL_DEBT_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_TRAVEL
  DROP CONSTRAINT BENTRVL_PK;

ALTER TABLE ADR.BENEFICIARY_TRAVEL ADD (
  CONSTRAINT BENTRVL_PK
  PRIMARY KEY
  (BENEFICIARY_TRAVEL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_PERMISSIONS
  DROP CONSTRAINT USERPERM_PK;

ALTER TABLE ADR.USER_PERMISSIONS ADD (
  CONSTRAINT USERPERM_PK
  PRIMARY KEY
  (USER_PERMISSION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_LOGIN
  DROP CONSTRAINT USERLOGIN_PK;

ALTER TABLE ADR.USER_LOGIN ADD (
  CONSTRAINT USERLOGIN_PK
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_QUERY_SITE
  DROP CONSTRAINT RPTQRYSITE_PK;

ALTER TABLE ADR.RPT_QUERY_SITE ADD (
  CONSTRAINT RPTQRYSITE_PK
  PRIMARY KEY
  (REPORT_QUERY_SITE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLE_PERMISSION_SETS_H
  DROP CONSTRAINT ROLEPRMSTH_PK;

ALTER TABLE ADR.ROLE_PERMISSION_SETS_H ADD (
  CONSTRAINT ROLEPRMSTH_PK
  PRIMARY KEY
  (ROLE_PERMISSION_SET_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SITE
  DROP CONSTRAINT RPTSITE_PK;

ALTER TABLE ADR.RPT_SITE ADD (
  CONSTRAINT RPTSITE_PK
  PRIMARY KEY
  (RPT_SITE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_RELATION_MERGE
  DROP CONSTRAINT PRSNRELMRG_PK;

ALTER TABLE ADR.PERSON_RELATION_MERGE ADD (
  CONSTRAINT PRSNRELMRG_PK
  PRIMARY KEY
  (PERSON_RELATION_MERGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SSN_VERIFICATION
  DROP CONSTRAINT SSNVERIFY_PK;

ALTER TABLE ADR.SSN_VERIFICATION ADD (
  CONSTRAINT SSNVERIFY_PK
  PRIMARY KEY
  (SSN_VERIFICATION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_DAY_OF_WEEK
  DROP CONSTRAINT RPTDAYOFWK_PK;

ALTER TABLE ADR.RPT_DAY_OF_WEEK ADD (
  CONSTRAINT RPTDAYOFWK_PK
  PRIMARY KEY
  (RPT_DAY_OF_WEEK_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_COMPLETED_REPORTS
  DROP CONSTRAINT COMPRPT_PK;

ALTER TABLE ADR.RPT_COMPLETED_REPORTS ADD (
  CONSTRAINT COMPRPT_PK
  PRIMARY KEY
  (RPT_COMPLETED_REPORT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_PERMISSIONS
  DROP CONSTRAINT RPTPERM_PK;

ALTER TABLE ADR.RPT_PERMISSIONS ADD (
  CONSTRAINT RPTPERM_PK
  PRIMARY KEY
  (RPT_PERMISSION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_RELATION_UNMERGE
  DROP CONSTRAINT PRSNRELUNM_PK;

ALTER TABLE ADR.PERSON_RELATION_UNMERGE ADD (
  CONSTRAINT PRSNRELUNM_PK
  PRIMARY KEY
  (PERSON_RELATION_UNMERGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE
  DROP CONSTRAINT WKFCASE_PK;

ALTER TABLE ADR.WKF_CASE ADD (
  CONSTRAINT WKFCASE_PK
  PRIMARY KEY
  (WKF_CASE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CANCEL_DECLINE_H
  DROP CONSTRAINT CANDECH_PK;

ALTER TABLE ADR.CANCEL_DECLINE_H ADD (
  CONSTRAINT CANDECH_PK
  PRIMARY KEY
  (CANCEL_DECLINE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SHAD_REGISTRY_H
  DROP CONSTRAINT SHADRGSTRH_PK;

ALTER TABLE ADR.SHAD_REGISTRY_H ADD (
  CONSTRAINT SHADRGSTRH_PK
  PRIMARY KEY
  (SHAD_REGISTRY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_CONDITION
  DROP CONSTRAINT CATDSCOND_PK;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION ADD (
  CONSTRAINT CATDSCOND_PK
  PRIMARY KEY
  (CAT_DSBLTY_CONDITION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IVM_MIGRATE_STATISTICS
  DROP CONSTRAINT IVMMIGSTAT_PK;

ALTER TABLE ADR.IVM_MIGRATE_STATISTICS ADD (
  CONSTRAINT IVMMIGSTAT_PK
  PRIMARY KEY
  (IVM_MIGRATE_STATISTICS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_TRANSMISSION_LOG
  DROP CONSTRAINT COMTRANLOG_PK;

ALTER TABLE ADR.COM_TRANSMISSION_LOG ADD (
  CONSTRAINT COMTRANLOG_PK
  PRIMARY KEY
  (COM_TRANSMISSION_LOG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CATASTROPHIC_DISABILITY
  DROP CONSTRAINT CATDSBLTY_PK;

ALTER TABLE ADR.CATASTROPHIC_DISABILITY ADD (
  CONSTRAINT CATDSBLTY_PK
  PRIMARY KEY
  (CATASTROPHIC_DISABILITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT
  DROP CONSTRAINT WKFCSASGMT_PK;

ALTER TABLE ADR.WKF_CASE_ASSIGNMENT ADD (
  CONSTRAINT WKFCSASGMT_PK
  PRIMARY KEY
  (WKF_CASE_ASSIGNMENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_VBA_QUERY_STATUS
  DROP CONSTRAINT RPTVBAQRY_PK;

ALTER TABLE ADR.RPT_VBA_QUERY_STATUS ADD (
  CONSTRAINT RPTVBAQRY_PK
  PRIMARY KEY
  (RPT_VBA_QUERY_STATUS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_MESSAGE_ERROR
  DROP CONSTRAINT RPTMSGERR_PK;

ALTER TABLE ADR.RPT_MESSAGE_ERROR ADD (
  CONSTRAINT RPTMSGERR_PK
  PRIMARY KEY
  (RPT_MESSAGE_ERROR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H
  DROP CONSTRAINT SITERECENH_PK;

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H ADD (
  CONSTRAINT SITERECENH_PK
  PRIMARY KEY
  (SITE_RECEIVED_ENROLLMENT_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_SITE_STATISTICS_H
  DROP CONSTRAINT EGTSTSTICH_PK;

ALTER TABLE ADR.EGT_SITE_STATISTICS_H ADD (
  CONSTRAINT EGTSTSTICH_PK
  PRIMARY KEY
  (EGT_SITE_STATISTICS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLES_H
  DROP CONSTRAINT ROLESH_PK;

ALTER TABLE ADR.ROLES_H ADD (
  CONSTRAINT ROLESH_PK
  PRIMARY KEY
  (ROLES_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PH_REGISTRY_DETAIL
  DROP CONSTRAINT PHREGDTL_PK;

ALTER TABLE ADR.PH_REGISTRY_DETAIL ADD (
  CONSTRAINT PHREGDTL_PK
  PRIMARY KEY
  (PH_REGISTRY_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_USER_GROUP
  DROP CONSTRAINT RPTUSRGRP_PK;

ALTER TABLE ADR.RPT_USER_GROUP ADD (
  CONSTRAINT RPTUSRGRP_PK
  PRIMARY KEY
  (RPT_USER_GROUP_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_RACE
  DROP CONSTRAINT PRSNRACE_PK;

ALTER TABLE ADR.PERSON_RACE ADD (
  CONSTRAINT PRSNRACE_PK
  PRIMARY KEY
  (PERSON_RACE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL
  DROP CONSTRAINT IVMMGEXDTL_PK;

ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL ADD (
  CONSTRAINT IVMMGEXDTL_PK
  PRIMARY KEY
  (IVM_MIGRATE_EXTRACT_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT
  DROP CONSTRAINT IVMMGEX_PK;

ALTER TABLE ADR.IVM_MIGRATE_EXTRACT ADD (
  CONSTRAINT IVMMGEX_PK
  PRIMARY KEY
  (IVM_MIGRATE_EXTRACT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_CANCELED_REQUEST
  DROP CONSTRAINT COMCNLPR_PK;

ALTER TABLE ADR.COM_CANCELED_REQUEST ADD (
  CONSTRAINT COMCNLPR_PK
  PRIMARY KEY
  (COM_CANCELED_REQUEST_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_FORM_STATISTICS
  DROP CONSTRAINT COMFRMSTAT_PK;

ALTER TABLE ADR.COM_FORM_STATISTICS ADD (
  CONSTRAINT COMFRMSTAT_PK
  PRIMARY KEY
  (COM_FORM_STATISTICS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H
  DROP CONSTRAINT WKFCSASGH_PK;

ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H ADD (
  CONSTRAINT WKFCSASGH_PK
  PRIMARY KEY
  (WKF_CASE_ASSIGNMENT_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLE_PERMISSIONS_H
  DROP CONSTRAINT ROLEPRMSH_PK;

ALTER TABLE ADR.ROLE_PERMISSIONS_H ADD (
  CONSTRAINT ROLEPRMSH_PK
  PRIMARY KEY
  (ROLE_PERMISSIONS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_LETTER_TEMPLATE
  DROP CONSTRAINT COMLTRTPL_PK;

ALTER TABLE ADR.COM_LETTER_TEMPLATE ADD (
  CONSTRAINT COMLTRTPL_PK
  PRIMARY KEY
  (COM_LETTER_TEMPLATE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H
  DROP CONSTRAINT CATDSCONDH_PK;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H ADD (
  CONSTRAINT CATDSCONDH_PK
  PRIMARY KEY
  (CAT_DSBLTY_CONDITION_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CONFLICT_DETAIL
  DROP CONSTRAINT CONFLDTL_PK;

ALTER TABLE ADR.CONFLICT_DETAIL ADD (
  CONSTRAINT CONFLDTL_PK
  PRIMARY KEY
  (CONFLICT_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION
  DROP CONSTRAINT HEALTHAPP_PK;

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION ADD (
  CONSTRAINT HEALTHAPP_PK
  PRIMARY KEY
  (HEALTH_BENEFITS_APPLICATION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_STATISTICS
  DROP CONSTRAINT EGTSTAT_PK;

ALTER TABLE ADR.EGT_STATISTICS ADD (
  CONSTRAINT EGTSTAT_PK
  PRIMARY KEY
  (EGT_STATISTICS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_SETTING_H
  DROP CONSTRAINT EGTSETTINH_PK;

ALTER TABLE ADR.EGT_SETTING_H ADD (
  CONSTRAINT EGTSETTINH_PK
  PRIMARY KEY
  (EGT_SETTING_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_PERMISSIONS_H
  DROP CONSTRAINT USRPERMH_PK;

ALTER TABLE ADR.USER_PERMISSIONS_H ADD (
  CONSTRAINT USRPERMH_PK
  PRIMARY KEY
  (USER_PERMISSIONS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_MESSAGING_CASE
  DROP CONSTRAINT WKFMSGCS_PK;

ALTER TABLE ADR.WKF_MESSAGING_CASE ADD (
  CONSTRAINT WKFMSGCS_PK
  PRIMARY KEY
  (WKF_MESSAGING_CASE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_SETTING
  DROP CONSTRAINT EGTSETTING_PK;

ALTER TABLE ADR.EGT_SETTING ADD (
  CONSTRAINT EGTSETTING_PK
  PRIMARY KEY
  (EGT_SETTING_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_MESSAGE
  DROP CONSTRAINT RPTMSG_PK;

ALTER TABLE ADR.RPT_MESSAGE ADD (
  CONSTRAINT RPTMSG_PK
  PRIMARY KEY
  (RPT_MESSAGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EMAIL
  DROP CONSTRAINT EMAIL_PK;

ALTER TABLE ADR.EMAIL ADD (
  CONSTRAINT EMAIL_PK
  PRIMARY KEY
  (EMAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H
  DROP CONSTRAINT ENROLOVERH_PK;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H ADD (
  CONSTRAINT ENROLOVERH_PK
  PRIMARY KEY
  (ENROLLMENT_OVERRIDE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE
  DROP CONSTRAINT RPTENROVER_PK;

ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE ADD (
  CONSTRAINT RPTENROVER_PK
  PRIMARY KEY
  (RPT_ENROLLMENT_OVERRIDE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLES
  DROP CONSTRAINT ROLE_PK;

ALTER TABLE ADR.ROLES ADD (
  CONSTRAINT ROLE_PK
  PRIMARY KEY
  (ROLE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.INELIGIBLE_RULING_H
  DROP CONSTRAINT INELIGBRLH_PK;

ALTER TABLE ADR.INELIGIBLE_RULING_H ADD (
  CONSTRAINT INELIGBRLH_PK
  PRIMARY KEY
  (INELIGIBLE_RULING_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_PERMISSION_SETS_H
  DROP CONSTRAINT USRPERMSTH_PK;

ALTER TABLE ADR.USER_PERMISSION_SETS_H ADD (
  CONSTRAINT USRPERMSTH_PK
  PRIMARY KEY
  (USER_PERMISSION_SET_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERMISSION_SET_H
  DROP CONSTRAINT PERMSETH_PK;

ALTER TABLE ADR.PERMISSION_SET_H ADD (
  CONSTRAINT PERMSETH_PK
  PRIMARY KEY
  (PERMISSION_SET_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COMBAT_PAY
  DROP CONSTRAINT CMBTPAY_PK;

ALTER TABLE ADR.COMBAT_PAY ADD (
  CONSTRAINT CMBTPAY_PK
  PRIMARY KEY
  (COMBAT_PAY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION
  DROP CONSTRAINT ELGBDETER_PK;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION ADD (
  CONSTRAINT ELGBDETER_PK
  PRIMARY KEY
  (ELIGIBILITY_DETERMINATION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H
  DROP CONSTRAINT CATDSBLPRH_PK;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H ADD (
  CONSTRAINT CATDSBLPRH_PK
  PRIMARY KEY
  (CAT_DSBLTY_PROCEDURE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_RACE_H
  DROP CONSTRAINT PRSNRACEH_PK;

ALTER TABLE ADR.PERSON_RACE_H ADD (
  CONSTRAINT PRSNRACEH_PK
  PRIMARY KEY
  (PERSON_RACE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS
  DROP CONSTRAINT CATDSDIAG_PK;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS ADD (
  CONSTRAINT CATDSDIAG_PK
  PRIMARY KEY
  (CAT_DSBLTY_DIAGNOSIS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS
  DROP CONSTRAINT PRMSTPRM_PK;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS ADD (
  CONSTRAINT PRMSTPRM_PK
  PRIMARY KEY
  (PERM_SET_PERMISSIONS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SHAD_REGISTRY
  DROP CONSTRAINT SHADRGSTRY_PK;

ALTER TABLE ADR.SHAD_REGISTRY ADD (
  CONSTRAINT SHADRGSTRY_PK
  PRIMARY KEY
  (SHAD_REGISTRY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H
  DROP CONSTRAINT VAPERDVSNH_PK;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H ADD (
  CONSTRAINT VAPERDVSNH_PK
  PRIMARY KEY
  (VA_PERSON_DIVISION_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON
  DROP CONSTRAINT RPTCANDECL_PK;

ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON ADD (
  CONSTRAINT RPTCANDECL_PK
  PRIMARY KEY
  (RPT_CANCEL_DECLINE_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY
  DROP CONSTRAINT POW_PK;

ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY ADD (
  CONSTRAINT POW_PK
  PRIMARY KEY
  (PRISONER_OF_WAR_REGISTRY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_MST
  DROP CONSTRAINT BNFYMST_PK;

ALTER TABLE ADR.BENEFICIARY_MST ADD (
  CONSTRAINT BNFYMST_PK
  PRIMARY KEY
  (BENEFICIARY_MST_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL
  DROP CONSTRAINT VAPRSNCLAS_PK;

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL ADD (
  CONSTRAINT VAPRSNCLAS_PK
  PRIMARY KEY
  (VA_PERSON_CLASS_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_MERGE
  DROP CONSTRAINT PRSNMRG_PK;

ALTER TABLE ADR.PERSON_MERGE ADD (
  CONSTRAINT PRSNMRG_PK
  PRIMARY KEY
  (PERSON_MERGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.INELIGIBLE_RULING
  DROP CONSTRAINT INELIGBRLG_PK;

ALTER TABLE ADR.INELIGIBLE_RULING ADD (
  CONSTRAINT INELIGBRLG_PK
  PRIMARY KEY
  (INELIGIBLE_RULING_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.INCOMPETENT_RULING
  DROP CONSTRAINT INCOMPRULE_PK;

ALTER TABLE ADR.INCOMPETENT_RULING ADD (
  CONSTRAINT INCOMPRULE_PK
  PRIMARY KEY
  (INCOMPETENT_RULING_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_PRINT_CHECK
  DROP CONSTRAINT COMPRTCHK_PK;

ALTER TABLE ADR.COM_PRINT_CHECK ADD (
  CONSTRAINT COMPRTCHK_PK
  PRIMARY KEY
  (COM_PRINT_CHECK_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_ENROLLMENT_STATUS
  DROP CONSTRAINT RPTENRSTAT_PK;

ALTER TABLE ADR.RPT_ENROLLMENT_STATUS ADD (
  CONSTRAINT RPTENRSTAT_PK
  PRIMARY KEY
  (RPT_ENROLLMENT_STATUS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.USERS_H
  DROP CONSTRAINT USERH_PK;

ALTER TABLE ADR.USERS_H ADD (
  CONSTRAINT USERH_PK
  PRIMARY KEY
  (USERS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COM_HEC_REJECT_DETAIL
  DROP CONSTRAINT COMRJCTDTL_PK;

ALTER TABLE ADR.COM_HEC_REJECT_DETAIL ADD (
  CONSTRAINT COMRJCTDTL_PK
  PRIMARY KEY
  (COM_HEC_REJECT_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H
  DROP CONSTRAINT SHADREGDH_PK;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H ADD (
  CONSTRAINT SHADREGDH_PK
  PRIMARY KEY
  (SHAD_REGISTRY_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EMERGENCY_RESPONSE_H
  DROP CONSTRAINT EMERGRESH_PK;

ALTER TABLE ADR.EMERGENCY_RESPONSE_H ADD (
  CONSTRAINT EMERGRESH_PK
  PRIMARY KEY
  (EMERGENCY_RESPONSE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_UNMERGE
  DROP CONSTRAINT PRSNUNMRG_PK;

ALTER TABLE ADR.PERSON_UNMERGE ADD (
  CONSTRAINT PRSNUNMRG_PK
  PRIMARY KEY
  (PERSON_UNMERGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY
  DROP CONSTRAINT CNFADDR_PK;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY ADD (
  CONSTRAINT CNFADDR_PK
  PRIMARY KEY
  (CONFIDENTIAL_ADDR_CATGRY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_ROLES_H
  DROP CONSTRAINT USERROLEH_PK;

ALTER TABLE ADR.USER_ROLES_H ADD (
  CONSTRAINT USERROLEH_PK
  PRIMARY KEY
  (USER_ROLES_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.POW_REGISTRY_DETAIL
  DROP CONSTRAINT POWREGDTL_PK;

ALTER TABLE ADR.POW_REGISTRY_DETAIL ADD (
  CONSTRAINT POWREGDTL_PK
  PRIMARY KEY
  (POW_REGISTRY_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COMBAT_PAY_H
  DROP CONSTRAINT CMBTPAYH_PK;

ALTER TABLE ADR.COMBAT_PAY_H ADD (
  CONSTRAINT CMBTPAYH_PK
  PRIMARY KEY
  (COMBAT_PAY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_NTR
  DROP CONSTRAINT BNFYNTR_PK;

ALTER TABLE ADR.BENEFICIARY_NTR ADD (
  CONSTRAINT BNFYNTR_PK
  PRIMARY KEY
  (BENEFICIARY_NTR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.POW_REGISTRY_DETAIL_H
  DROP CONSTRAINT POWREGDTH_PK;

ALTER TABLE ADR.POW_REGISTRY_DETAIL_H ADD (
  CONSTRAINT POWREGDTH_PK
  PRIMARY KEY
  (POW_REGISTRY_DETAIL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_SITE_STATISTICS
  DROP CONSTRAINT EGTSTSTIC_PK;

ALTER TABLE ADR.EGT_SITE_STATISTICS ADD (
  CONSTRAINT EGTSTSTIC_PK
  PRIMARY KEY
  (EGT_SITE_STATISTICS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.USERS
  DROP CONSTRAINT USER_PK;

ALTER TABLE ADR.USERS ADD (
  CONSTRAINT USER_PK
  PRIMARY KEY
  (USERID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_REGISTRY
  DROP CONSTRAINT RPTRGSTRY_PK;

ALTER TABLE ADR.RPT_REGISTRY ADD (
  CONSTRAINT RPTRGSTRY_PK
  PRIMARY KEY
  (RPT_REGISTRY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERMISSION_SET
  DROP CONSTRAINT PERMSET_PK;

ALTER TABLE ADR.PERMISSION_SET ADD (
  CONSTRAINT PERMSET_PK
  PRIMARY KEY
  (PERMISSION_SET_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SIGNATURE_IMAGE
  DROP CONSTRAINT SIGNATURE_PK;

ALTER TABLE ADR.SIGNATURE_IMAGE ADD (
  CONSTRAINT SIGNATURE_PK
  PRIMARY KEY
  (SIGNATURE_IMAGE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H
  DROP CONSTRAINT HEALTHAPPH_PK;

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H ADD (
  CONSTRAINT HEALTHAPPH_PK
  PRIMARY KEY
  (HEALTH_BENEFITS_APPLN_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.JOB_CONFIG
  DROP CONSTRAINT JCONFIG_PK;

ALTER TABLE ADR.JOB_CONFIG ADD (
  CONSTRAINT JCONFIG_PK
  PRIMARY KEY
  (JOB_CONFIG_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_WKF_CASE
  DROP CONSTRAINT RPTWKFCASE_PK;

ALTER TABLE ADR.RPT_WKF_CASE ADD (
  CONSTRAINT RPTWKFCASE_PK
  PRIMARY KEY
  (RPT_WKF_CASE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_PERMISSION_SETS
  DROP CONSTRAINT USERPERMST_PK;

ALTER TABLE ADR.USER_PERMISSION_SETS ADD (
  CONSTRAINT USERPERMST_PK
  PRIMARY KEY
  (USER_PERMISSION_SET_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_LOGIN_H
  DROP CONSTRAINT USERLOGINH_PK;

ALTER TABLE ADR.USER_LOGIN_H ADD (
  CONSTRAINT USERLOGINH_PK
  PRIMARY KEY
  (USER_LOGIN_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT SCHEDRPT_PK;

ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SCHEDRPT_PK
  PRIMARY KEY
  (RPT_SCHEDULED_REPORT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_ETHNICITY
  DROP CONSTRAINT PRSNETNCTY_PK;

ALTER TABLE ADR.PERSON_ETHNICITY ADD (
  CONSTRAINT PRSNETNCTY_PK
  PRIMARY KEY
  (PERSON_ETHNICITY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_STATISTICS_H
  DROP CONSTRAINT EGTSTATH_PK;

ALTER TABLE ADR.EGT_STATISTICS_H ADD (
  CONSTRAINT EGTSTATH_PK
  PRIMARY KEY
  (EGT_STATISTICS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON
  DROP CONSTRAINT RPTINVADDR_PK;

ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON ADD (
  CONSTRAINT RPTINVADDR_PK
  PRIMARY KEY
  (RPT_INVALID_ADDRESS_REASON_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.FEE_BASIS
  DROP CONSTRAINT FEEBASIS_PK;

ALTER TABLE ADR.FEE_BASIS ADD (
  CONSTRAINT FEEBASIS_PK
  PRIMARY KEY
  (FEE_BASIS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H
  DROP CONSTRAINT POWH_PK;

ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H ADD (
  CONSTRAINT POWH_PK
  PRIMARY KEY
  (PRISONER_OF_WAR_REGISTRY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SERVICE_CONNECTED
  DROP CONSTRAINT SVCCON_PK;

ALTER TABLE ADR.SERVICE_CONNECTED ADD (
  CONSTRAINT SVCCON_PK
  PRIMARY KEY
  (SERVICE_CONNECTED_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H
  DROP CONSTRAINT CNFADDRH_PK;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H ADD (
  CONSTRAINT CNFADDRH_PK
  PRIMARY KEY
  (CONFIDENTIAL_ADDR_CATGRY_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_RELATION
  DROP CONSTRAINT PRSNREL_PK;

ALTER TABLE ADR.PERSON_RELATION ADD (
  CONSTRAINT PRSNREL_PK
  PRIMARY KEY
  (PERSON_RELATION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION
  DROP CONSTRAINT RGSTRLODX_PK;

ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION ADD (
  CONSTRAINT RGSTRLODX_PK
  PRIMARY KEY
  (REGISTRY_LOAD_EXCEPTION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY
  DROP CONSTRAINT RPTENRLCAT_PK;

ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY ADD (
  CONSTRAINT RPTENRLCAT_PK
  PRIMARY KEY
  (RPT_ENROLLMENT_CATEGORY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.EMERGENCY_RESPONSE
  DROP CONSTRAINT EMERGRESP_PK;

ALTER TABLE ADR.EMERGENCY_RESPONSE ADD (
  CONSTRAINT EMERGRESP_PK
  PRIMARY KEY
  (EMERGENCY_RESPONSE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_COMMENTS
  DROP CONSTRAINT WKFCMTS_PK;

ALTER TABLE ADR.WKF_CASE_COMMENTS ADD (
  CONSTRAINT WKFCMTS_PK
  PRIMARY KEY
  (WKF_CASE_COMMENT_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLE_PERMISSIONS
  DROP CONSTRAINT ROLEPERMS_PK;

ALTER TABLE ADR.ROLE_PERMISSIONS ADD (
  CONSTRAINT ROLEPERMS_PK
  PRIMARY KEY
  (ROLE_PERMISSION_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_COM_ERROR
  DROP CONSTRAINT RPTCOMERR_PK;

ALTER TABLE ADR.RPT_COM_ERROR ADD (
  CONSTRAINT RPTCOMERR_PK
  PRIMARY KEY
  (RPT_COM_ERROR_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_USERS
  DROP CONSTRAINT RPTUSERS_PK;

ALTER TABLE ADR.RPT_USERS ADD (
  CONSTRAINT RPTUSERS_PK
  PRIMARY KEY
  (RPT_USER_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_TRAVEL_H
  DROP CONSTRAINT BENTRVLH_PK;

ALTER TABLE ADR.BENEFICIARY_TRAVEL_H ADD (
  CONSTRAINT BENTRVLH_PK
  PRIMARY KEY
  (BENEFICIARY_TRAVEL_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY
  DROP CONSTRAINT VERIFYSUM_PK;

ALTER TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY ADD (
  CONSTRAINT VERIFYSUM_PK
  PRIMARY KEY
  (NCOA_ADDRESS_VERIFY_SUMMARY_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL
  DROP CONSTRAINT SHADREGDTL_PK;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL ADD (
  CONSTRAINT SHADREGDTL_PK
  PRIMARY KEY
  (SHAD_REGISTRY_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COMBAT_EPISODE
  DROP CONSTRAINT CMBTEPSD_PK;

ALTER TABLE ADR.COMBAT_EPISODE ADD (
  CONSTRAINT CMBTEPSD_PK
  PRIMARY KEY
  (COMBAT_EPISODE_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL
  DROP CONSTRAINT WKFCSESTAT_PK;

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL ADD (
  CONSTRAINT WKFCSESTAT_PK
  PRIMARY KEY
  (WKF_CASE_STATUS_DETAIL_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H
  DROP CONSTRAINT CATDSDIAGH_PK;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H ADD (
  CONSTRAINT CATDSDIAGH_PK
  PRIMARY KEY
  (CAT_DSBLTY_DIAGNOSIS_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.COMBAT_EPISODE_H
  DROP CONSTRAINT CMBTEPSDH_PK;

ALTER TABLE ADR.COMBAT_EPISODE_H ADD (
  CONSTRAINT CMBTEPSDH_PK
  PRIMARY KEY
  (COMBAT_EPISODE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_MST_H
  DROP CONSTRAINT BNFYMSTH_PK;

ALTER TABLE ADR.BENEFICIARY_MST_H ADD (
  CONSTRAINT BNFYMSTH_PK
  PRIMARY KEY
  (BENEFICIARY_MST_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_MESSAGING_CASE_H
  DROP CONSTRAINT WKFMSGCSH_PK;

ALTER TABLE ADR.WKF_MESSAGING_CASE_H ADD (
  CONSTRAINT WKFMSGCSH_PK
  PRIMARY KEY
  (WKF_MESSAGING_CASE_H_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS
  DROP CONSTRAINT RPTPRSNMRG_PK;

ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS ADD (
  CONSTRAINT RPTPRSNMRG_PK
  PRIMARY KEY
  (RPT_PERSON_MERGE_STATUS_ID)
  ENABLE VALIDATE);
ALTER TABLE ADR.CANCEL_DECLINE MODIFY 
  CANCEL_DECLINE_ID NULL;

ALTER TABLE ADR.CANCEL_DECLINE MODIFY 
  CANCEL_DECLINE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CANCEL_DECLINE MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.CANCEL_DECLINE MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CANCEL_DECLINE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CANCEL_DECLINE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CANCEL_DECLINE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CANCEL_DECLINE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CANCEL_DECLINE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CANCEL_DECLINE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CANCEL_DECLINE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CANCEL_DECLINE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CANCEL_DECLINE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CANCEL_DECLINE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H MODIFY 
  PERM_SET_PERMISSIONS_H_ID NULL;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H MODIFY 
  PERM_SET_PERMISSIONS_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H MODIFY 
  PERM_SET_PERMISSIONS_ID NULL;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H MODIFY 
  PERM_SET_PERMISSIONS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H MODIFY 
  PERMISSION_SET_ID NULL;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H MODIFY 
  PERMISSION_SET_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H MODIFY 
  PERMISSION_TYPE_ID NULL;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H MODIFY 
  PERMISSION_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_063;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_063
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR MODIFY 
  RPT_ELIGIBILITY_FACTOR_ID NULL;

ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR MODIFY 
  RPT_ELIGIBILITY_FACTOR_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR MODIFY 
  STD_REPORTELIGFACTOR_ID NULL;

ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR MODIFY 
  STD_REPORTELIGFACTOR_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT MODIFY 
  SITE_RECEIVED_ENROLLMENT_ID NULL;

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT MODIFY 
  SITE_RECEIVED_ENROLLMENT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PH_REJECT_REASON MODIFY 
  RPT_PH_REJECT_REASON_ID NULL;

ALTER TABLE ADR.RPT_PH_REJECT_REASON MODIFY 
  RPT_PH_REJECT_REASON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PH_REJECT_REASON MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_PH_REJECT_REASON MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PH_REJECT_REASON MODIFY 
  STD_REJECTEDREMARKS_ID NULL;

ALTER TABLE ADR.RPT_PH_REJECT_REASON MODIFY 
  STD_REJECTEDREMARKS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PH_REJECT_REASON MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_PH_REJECT_REASON MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PH_REJECT_REASON MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_PH_REJECT_REASON MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PH_REJECT_REASON MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_PH_REJECT_REASON MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PH_REJECT_REASON MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_PH_REJECT_REASON MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PH_REJECT_REASON MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_PH_REJECT_REASON MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL MODIFY 
  REGISTRY_TRAIT_DETAIL_ID NULL;

ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL MODIFY 
  REGISTRY_TRAIT_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL MODIFY 
  REGISTRY_TRAIT_ID NULL;

ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL MODIFY 
  REGISTRY_TRAIT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_LETTER_FILE MODIFY 
  RPT_LETTER_FILE_ID NULL;

ALTER TABLE ADR.RPT_LETTER_FILE MODIFY 
  RPT_LETTER_FILE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_LETTER_FILE MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_LETTER_FILE MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_LETTER_FILE MODIFY 
  RPT_LETTER_FILE_TYPE_ID NULL;

ALTER TABLE ADR.RPT_LETTER_FILE MODIFY 
  RPT_LETTER_FILE_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_LETTER_FILE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_LETTER_FILE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_LETTER_FILE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_LETTER_FILE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_LETTER_FILE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_LETTER_FILE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_LETTER_FILE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_LETTER_FILE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_LETTER_FILE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_LETTER_FILE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_AAC_ERROR_DETAIL MODIFY 
  COM_AAC_ERROR_DETAIL_ID NULL;

ALTER TABLE ADR.COM_AAC_ERROR_DETAIL MODIFY 
  COM_AAC_ERROR_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_AAC_ERROR_DETAIL MODIFY 
  COM_MAILING_ID NULL;

ALTER TABLE ADR.COM_AAC_ERROR_DETAIL MODIFY 
  COM_MAILING_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_AAC_ERROR_DETAIL MODIFY 
  COM_AAC_ERROR_TYPE_ID NULL;

ALTER TABLE ADR.COM_AAC_ERROR_DETAIL MODIFY 
  COM_AAC_ERROR_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_AAC_ERROR_DETAIL MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.COM_AAC_ERROR_DETAIL MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_AAC_ERROR_DETAIL MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.COM_AAC_ERROR_DETAIL MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_AAC_ERROR_DETAIL MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.COM_AAC_ERROR_DETAIL MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_AAC_ERROR_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.COM_AAC_ERROR_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_AAC_ERROR_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.COM_AAC_ERROR_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H MODIFY 
  VA_PERSON_CLASS_DETAIL_H_ID NULL;

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H MODIFY 
  VA_PERSON_CLASS_DETAIL_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H MODIFY 
  VA_PERSON_CLASS_DETAIL_ID NULL;

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H MODIFY 
  VA_PERSON_CLASS_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_065;

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_065
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H MODIFY 
  WKF_CASE_STATUS_DETAIL_H_ID NULL;

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H MODIFY 
  WKF_CASE_STATUS_DETAIL_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H MODIFY 
  WKF_CASE_STATUS_DETAIL_ID NULL;

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H MODIFY 
  WKF_CASE_STATUS_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H MODIFY 
  WKF_CASE_ID NULL;

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H MODIFY 
  WKF_CASE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_066;

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_066
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.PURPLE_HEART_REGISTRY MODIFY 
  PURPLE_HEART_REGISTRY_ID NULL;

ALTER TABLE ADR.PURPLE_HEART_REGISTRY MODIFY 
  PURPLE_HEART_REGISTRY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PURPLE_HEART_REGISTRY MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PURPLE_HEART_REGISTRY MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PURPLE_HEART_REGISTRY MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PURPLE_HEART_REGISTRY MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PURPLE_HEART_REGISTRY MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PURPLE_HEART_REGISTRY MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PURPLE_HEART_REGISTRY MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PURPLE_HEART_REGISTRY MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PURPLE_HEART_REGISTRY MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PURPLE_HEART_REGISTRY MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PRIORITY_GROUP MODIFY 
  RPT_PRIORITY_GROUP_ID NULL;

ALTER TABLE ADR.RPT_PRIORITY_GROUP MODIFY 
  RPT_PRIORITY_GROUP_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PRIORITY_GROUP MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_PRIORITY_GROUP MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PRIORITY_GROUP MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_PRIORITY_GROUP MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PRIORITY_GROUP MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_PRIORITY_GROUP MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PRIORITY_GROUP MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_PRIORITY_GROUP MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PRIORITY_GROUP MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_PRIORITY_GROUP MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PRIORITY_GROUP MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_PRIORITY_GROUP MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_EED_WEEKLY MODIFY 
  RPT_EED_WEEKLY_ID NULL;

ALTER TABLE ADR.RPT_EED_WEEKLY MODIFY 
  RPT_EED_WEEKLY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_EED_WEEKLY MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_EED_WEEKLY MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_EED_WEEKLY MODIFY 
  RPT_EED_WEEKLY_TYPE_ID NULL;

ALTER TABLE ADR.RPT_EED_WEEKLY MODIFY 
  RPT_EED_WEEKLY_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_EED_WEEKLY MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_EED_WEEKLY MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_EED_WEEKLY MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_EED_WEEKLY MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_EED_WEEKLY MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_EED_WEEKLY MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_EED_WEEKLY MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_EED_WEEKLY MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_EED_WEEKLY MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_EED_WEEKLY MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_COMMENTS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_067;

ALTER TABLE ADR.WKF_CASE_COMMENTS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_067
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_COMMENTS_H MODIFY 
  WKF_CASE_COMMENT_H_ID NULL;

ALTER TABLE ADR.WKF_CASE_COMMENTS_H MODIFY 
  WKF_CASE_COMMENT_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_COMMENTS_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.WKF_CASE_COMMENTS_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_COMMENTS_H MODIFY 
  WKF_CASE_ID NULL;

ALTER TABLE ADR.WKF_CASE_COMMENTS_H MODIFY 
  WKF_CASE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_COMMENTS_H MODIFY 
  WKF_CASE_COMMENT_ID NULL;

ALTER TABLE ADR.WKF_CASE_COMMENTS_H MODIFY 
  WKF_CASE_COMMENT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_COMMENTS_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.WKF_CASE_COMMENTS_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_COMMENTS_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.WKF_CASE_COMMENTS_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_COMMENTS_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.WKF_CASE_COMMENTS_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_COMMENTS_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.WKF_CASE_COMMENTS_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_COMMENTS_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.WKF_CASE_COMMENTS_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_068;

ALTER TABLE ADR.WKF_CASE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_068
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_H MODIFY 
  WKF_CASE_H_ID NULL;

ALTER TABLE ADR.WKF_CASE_H MODIFY 
  WKF_CASE_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.WKF_CASE_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_H MODIFY 
  WKF_CASE_ID NULL;

ALTER TABLE ADR.WKF_CASE_H MODIFY 
  WKF_CASE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.WKF_CASE_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.WKF_CASE_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.WKF_CASE_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.WKF_CASE_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.WKF_CASE_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MONETARY_BENEFIT MODIFY 
  MONETARY_BENEFIT_ID NULL;

ALTER TABLE ADR.MONETARY_BENEFIT MODIFY 
  MONETARY_BENEFIT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MONETARY_BENEFIT MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.MONETARY_BENEFIT MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MONETARY_BENEFIT MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.MONETARY_BENEFIT MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MONETARY_BENEFIT MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.MONETARY_BENEFIT MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MONETARY_BENEFIT MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.MONETARY_BENEFIT MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MONETARY_BENEFIT MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.MONETARY_BENEFIT MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MONETARY_BENEFIT MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.MONETARY_BENEFIT MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COM_REJECT_REASON MODIFY 
  RPT_COM_REJECT_REASON_ID NULL;

ALTER TABLE ADR.RPT_COM_REJECT_REASON MODIFY 
  RPT_COM_REJECT_REASON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COM_REJECT_REASON MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_COM_REJECT_REASON MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COM_REJECT_REASON MODIFY 
  COM_AAC_REJECT_REASON_TYPE_ID NULL;

ALTER TABLE ADR.RPT_COM_REJECT_REASON MODIFY 
  COM_AAC_REJECT_REASON_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COM_REJECT_REASON MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_COM_REJECT_REASON MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COM_REJECT_REASON MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_COM_REJECT_REASON MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COM_REJECT_REASON MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_COM_REJECT_REASON MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COM_REJECT_REASON MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_COM_REJECT_REASON MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COM_REJECT_REASON MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_COM_REJECT_REASON MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_EMAIL_TEMPLATE MODIFY 
  COM_EMAIL_TEMPLATE_ID NULL;

ALTER TABLE ADR.COM_EMAIL_TEMPLATE MODIFY 
  COM_EMAIL_TEMPLATE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_EMAIL_TEMPLATE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.COM_EMAIL_TEMPLATE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_EMAIL_TEMPLATE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.COM_EMAIL_TEMPLATE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_EMAIL_TEMPLATE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.COM_EMAIL_TEMPLATE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_EMAIL_TEMPLATE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.COM_EMAIL_TEMPLATE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_EMAIL_TEMPLATE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.COM_EMAIL_TEMPLATE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PH_REGISTRY_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_071;

ALTER TABLE ADR.PH_REGISTRY_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_071
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.PH_REGISTRY_DETAIL_H MODIFY 
  PH_REGISTRY_DETAIL_H_ID NULL;

ALTER TABLE ADR.PH_REGISTRY_DETAIL_H MODIFY 
  PH_REGISTRY_DETAIL_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PH_REGISTRY_DETAIL_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.PH_REGISTRY_DETAIL_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PH_REGISTRY_DETAIL_H MODIFY 
  PH_REGISTRY_DETAIL_ID NULL;

ALTER TABLE ADR.PH_REGISTRY_DETAIL_H MODIFY 
  PH_REGISTRY_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PH_REGISTRY_DETAIL_H MODIFY 
  PURPLE_HEART_REGISTRY_ID NULL;

ALTER TABLE ADR.PH_REGISTRY_DETAIL_H MODIFY 
  PURPLE_HEART_REGISTRY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PH_REGISTRY_DETAIL_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PH_REGISTRY_DETAIL_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PH_REGISTRY_DETAIL_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PH_REGISTRY_DETAIL_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PH_REGISTRY_DETAIL_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PH_REGISTRY_DETAIL_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PH_REGISTRY_DETAIL_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PH_REGISTRY_DETAIL_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PH_REGISTRY_DETAIL_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PH_REGISTRY_DETAIL_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_LOAD_STATISTICS MODIFY 
  REGISTRY_LOAD_STATISTICS_ID NULL;

ALTER TABLE ADR.REGISTRY_LOAD_STATISTICS MODIFY 
  REGISTRY_LOAD_STATISTICS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_LOAD_STATISTICS MODIFY 
  REGISTRY_TYPE_ID NULL;

ALTER TABLE ADR.REGISTRY_LOAD_STATISTICS MODIFY 
  REGISTRY_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_LOAD_STATISTICS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.REGISTRY_LOAD_STATISTICS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_LOAD_STATISTICS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.REGISTRY_LOAD_STATISTICS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_LOAD_STATISTICS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.REGISTRY_LOAD_STATISTICS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_LOAD_STATISTICS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.REGISTRY_LOAD_STATISTICS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_LOAD_STATISTICS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.REGISTRY_LOAD_STATISTICS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDICAID_FACTOR MODIFY 
  MEDICAID_FACTOR_ID NULL;

ALTER TABLE ADR.MEDICAID_FACTOR MODIFY 
  MEDICAID_FACTOR_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDICAID_FACTOR MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.MEDICAID_FACTOR MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDICAID_FACTOR MODIFY 
  MEDICAID_ELIGIBILITY_IND NULL;

ALTER TABLE ADR.MEDICAID_FACTOR MODIFY 
  MEDICAID_ELIGIBILITY_IND NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDICAID_FACTOR MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.MEDICAID_FACTOR MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDICAID_FACTOR MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.MEDICAID_FACTOR MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDICAID_FACTOR MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.MEDICAID_FACTOR MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDICAID_FACTOR MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.MEDICAID_FACTOR MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDICAID_FACTOR MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.MEDICAID_FACTOR MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER MODIFY 
  APP_PARAMETER_ID NULL;

ALTER TABLE ADR.APP_PARAMETER MODIFY 
  APP_PARAMETER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER MODIFY 
  APP_PARAMETER_TYPE_ID NULL;

ALTER TABLE ADR.APP_PARAMETER MODIFY 
  APP_PARAMETER_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER MODIFY 
  PARAMETER_NAME NULL;

ALTER TABLE ADR.APP_PARAMETER MODIFY 
  PARAMETER_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER MODIFY 
  PARAMETER_DESCRIPTION NULL;

ALTER TABLE ADR.APP_PARAMETER MODIFY 
  PARAMETER_DESCRIPTION NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER MODIFY 
  PARAMETER_VALUE NULL;

ALTER TABLE ADR.APP_PARAMETER MODIFY 
  PARAMETER_VALUE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER MODIFY 
  INACTIVE_FLAG NULL;

ALTER TABLE ADR.APP_PARAMETER MODIFY 
  INACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.APP_PARAMETER MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.APP_PARAMETER MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.APP_PARAMETER MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.APP_PARAMETER MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER
  DROP CONSTRAINT AVCON_1172521913_INACT_114;

ALTER TABLE ADR.APP_PARAMETER ADD (
  CONSTRAINT AVCON_1172521913_INACT_114
  CHECK (INACTIVE_FLAG BETWEEN 0 AND 0 OR INACTIVE_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.SIGNATURE_IMAGE_H MODIFY 
  SIGNATURE_IMAGE_H_ID NULL;

ALTER TABLE ADR.SIGNATURE_IMAGE_H MODIFY 
  SIGNATURE_IMAGE_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SIGNATURE_IMAGE_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.SIGNATURE_IMAGE_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SIGNATURE_IMAGE_H MODIFY 
  SIGNATURE_IMAGE_ID NULL;

ALTER TABLE ADR.SIGNATURE_IMAGE_H MODIFY 
  SIGNATURE_IMAGE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SIGNATURE_IMAGE_H MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.SIGNATURE_IMAGE_H MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SIGNATURE_IMAGE_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.SIGNATURE_IMAGE_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SIGNATURE_IMAGE_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.SIGNATURE_IMAGE_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SIGNATURE_IMAGE_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.SIGNATURE_IMAGE_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SIGNATURE_IMAGE_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.SIGNATURE_IMAGE_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SIGNATURE_IMAGE_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.SIGNATURE_IMAGE_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SIGNATURE_IMAGE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_072;

ALTER TABLE ADR.SIGNATURE_IMAGE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_072
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL MODIFY 
  VA_PERSON_DIVISION_DETAIL_ID NULL;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL MODIFY 
  VA_PERSON_DIVISION_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL MODIFY 
  DEFAULT_DIVISION_FLAG NULL;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL MODIFY 
  DEFAULT_DIVISION_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL
  DROP CONSTRAINT AVCON_1172521913_DEFAU_000;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL ADD (
  CONSTRAINT AVCON_1172521913_DEFAU_000
  CHECK (DEFAULT_DIVISION_FLAG BETWEEN 0
AND 0 OR DEFAULT_DIVISION_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.IN_PROCESS_FINANCIALS MODIFY 
  IN_PROCESS_FINANCIAL_ID NULL;

ALTER TABLE ADR.IN_PROCESS_FINANCIALS MODIFY 
  IN_PROCESS_FINANCIAL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IN_PROCESS_FINANCIALS MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.IN_PROCESS_FINANCIALS MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IN_PROCESS_FINANCIALS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.IN_PROCESS_FINANCIALS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IN_PROCESS_FINANCIALS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.IN_PROCESS_FINANCIALS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IN_PROCESS_FINANCIALS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.IN_PROCESS_FINANCIALS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IN_PROCESS_FINANCIALS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.IN_PROCESS_FINANCIALS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IN_PROCESS_FINANCIALS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.IN_PROCESS_FINANCIALS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H MODIFY 
  REGISTRY_TRAIT_DETAIL_H_ID NULL;

ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H MODIFY 
  REGISTRY_TRAIT_DETAIL_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_073;

ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_073
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_ROLES MODIFY 
  USER_ROLE_ID NULL;

ALTER TABLE ADR.USER_ROLES MODIFY 
  USER_ROLE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_ROLES MODIFY 
  USERID NULL;

ALTER TABLE ADR.USER_ROLES MODIFY 
  USERID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_ROLES MODIFY 
  ROLE_ID NULL;

ALTER TABLE ADR.USER_ROLES MODIFY 
  ROLE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_ROLES MODIFY 
  INACTIVE_FLAG NULL;

ALTER TABLE ADR.USER_ROLES MODIFY 
  INACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_ROLES MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.USER_ROLES MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_ROLES MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.USER_ROLES MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_ROLES MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.USER_ROLES MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_ROLES MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.USER_ROLES MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_ROLES MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.USER_ROLES MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_ROLES
  DROP CONSTRAINT AVCON_1172521913_INACT_116;

ALTER TABLE ADR.USER_ROLES ADD (
  CONSTRAINT AVCON_1172521913_INACT_116
  CHECK (INACTIVE_FLAG BETWEEN 0 AND 0 OR INACTIVE_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H MODIFY 
  FINANCIAL_DEBT_DETAIL_H_ID NULL;

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H MODIFY 
  FINANCIAL_DEBT_DETAIL_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H MODIFY 
  FINANCIAL_DEBT_DETAIL_ID NULL;

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H MODIFY 
  FINANCIAL_DEBT_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H MODIFY 
  FINANCIAL_STATEMENT_ID NULL;

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H MODIFY 
  FINANCIAL_STATEMENT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_074;

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_074
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLE_PERMISSION_SETS MODIFY 
  ROLE_PERMISSION_SET_ID NULL;

ALTER TABLE ADR.ROLE_PERMISSION_SETS MODIFY 
  ROLE_PERMISSION_SET_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSION_SETS MODIFY 
  PERMISSION_SET_ID NULL;

ALTER TABLE ADR.ROLE_PERMISSION_SETS MODIFY 
  PERMISSION_SET_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSION_SETS MODIFY 
  ROLE_ID NULL;

ALTER TABLE ADR.ROLE_PERMISSION_SETS MODIFY 
  ROLE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSION_SETS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.ROLE_PERMISSION_SETS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSION_SETS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.ROLE_PERMISSION_SETS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSION_SETS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.ROLE_PERMISSION_SETS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSION_SETS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.ROLE_PERMISSION_SETS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSION_SETS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.ROLE_PERMISSION_SETS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ENROLLMENT_OVERRIDE MODIFY 
  ENROLLMENT_OVERRIDE_ID NULL;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE MODIFY 
  ENROLLMENT_OVERRIDE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ENROLLMENT_OVERRIDE MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ENROLLMENT_OVERRIDE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ENROLLMENT_OVERRIDE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ENROLLMENT_OVERRIDE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ENROLLMENT_OVERRIDE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ENROLLMENT_OVERRIDE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ENROLLMENT_OVERRIDE
  DROP CONSTRAINT AVCON_1172521913_OVERR_000;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE ADD (
  CONSTRAINT AVCON_1172521913_OVERR_000
  CHECK (OVERRIDE_FLAG BETWEEN 0 AND 0 OR OVERRIDE_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.JOB_RESULT MODIFY 
  JOB_RESULT_ID NULL;

ALTER TABLE ADR.JOB_RESULT MODIFY 
  JOB_RESULT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.JOB_RESULT MODIFY 
  JOB_NAME NULL;

ALTER TABLE ADR.JOB_RESULT MODIFY 
  JOB_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.JOB_RESULT MODIFY 
  JOB_GROUP_NAME NULL;

ALTER TABLE ADR.JOB_RESULT MODIFY 
  JOB_GROUP_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.JOB_RESULT MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.JOB_RESULT MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.JOB_RESULT MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.JOB_RESULT MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.JOB_RESULT MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.JOB_RESULT MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.JOB_RESULT MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.JOB_RESULT MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.JOB_RESULT MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.JOB_RESULT MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_STATUS_COMPONENT MODIFY 
  RPT_STATUS_COMPONENT_ID NULL;

ALTER TABLE ADR.RPT_STATUS_COMPONENT MODIFY 
  RPT_STATUS_COMPONENT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_STATUS_COMPONENT MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_STATUS_COMPONENT MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_STATUS_COMPONENT MODIFY 
  STD_RPTSTATUSCOMPONENT_ID NULL;

ALTER TABLE ADR.RPT_STATUS_COMPONENT MODIFY 
  STD_RPTSTATUSCOMPONENT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_STATUS_COMPONENT MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_STATUS_COMPONENT MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_STATUS_COMPONENT MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_STATUS_COMPONENT MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_STATUS_COMPONENT MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_STATUS_COMPONENT MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_STATUS_COMPONENT MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_STATUS_COMPONENT MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_STATUS_COMPONENT MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_STATUS_COMPONENT MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE MODIFY 
  CAT_DSBLTY_PROCEDURE_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE MODIFY 
  CAT_DSBLTY_PROCEDURE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE MODIFY 
  CATASTROPHIC_DISABILITY_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE MODIFY 
  CATASTROPHIC_DISABILITY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE MODIFY 
  PROCEDURE_TYPE_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE MODIFY 
  PROCEDURE_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_JOB_DETAILS MODIFY 
  JOB_NAME NULL;

ALTER TABLE ADR.QRTZ_JOB_DETAILS MODIFY 
  JOB_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_JOB_DETAILS MODIFY 
  JOB_GROUP NULL;

ALTER TABLE ADR.QRTZ_JOB_DETAILS MODIFY 
  JOB_GROUP NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_JOB_DETAILS MODIFY 
  JOB_CLASS_NAME NULL;

ALTER TABLE ADR.QRTZ_JOB_DETAILS MODIFY 
  JOB_CLASS_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_JOB_DETAILS MODIFY 
  IS_DURABLE NULL;

ALTER TABLE ADR.QRTZ_JOB_DETAILS MODIFY 
  IS_DURABLE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_JOB_DETAILS MODIFY 
  REQUESTS_RECOVERY NULL;

ALTER TABLE ADR.QRTZ_JOB_DETAILS MODIFY 
  REQUESTS_RECOVERY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_JOB_DETAILS MODIFY 
  SCHED_NAME NULL;

ALTER TABLE ADR.QRTZ_JOB_DETAILS MODIFY 
  SCHED_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_TRIGGERS MODIFY 
  SCHED_NAME NULL;

ALTER TABLE ADR.QRTZ_TRIGGERS MODIFY 
  SCHED_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_TRIGGERS MODIFY 
  TRIGGER_NAME NULL;

ALTER TABLE ADR.QRTZ_TRIGGERS MODIFY 
  TRIGGER_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_TRIGGERS MODIFY 
  TRIGGER_GROUP NULL;

ALTER TABLE ADR.QRTZ_TRIGGERS MODIFY 
  TRIGGER_GROUP NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_TRIGGERS MODIFY 
  JOB_NAME NULL;

ALTER TABLE ADR.QRTZ_TRIGGERS MODIFY 
  JOB_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_TRIGGERS MODIFY 
  JOB_GROUP NULL;

ALTER TABLE ADR.QRTZ_TRIGGERS MODIFY 
  JOB_GROUP NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_TRIGGERS MODIFY 
  TRIGGER_STATE NULL;

ALTER TABLE ADR.QRTZ_TRIGGERS MODIFY 
  TRIGGER_STATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_TRIGGERS MODIFY 
  TRIGGER_TYPE NULL;

ALTER TABLE ADR.QRTZ_TRIGGERS MODIFY 
  TRIGGER_TYPE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_TRIGGERS MODIFY 
  START_TIME NULL;

ALTER TABLE ADR.QRTZ_TRIGGERS MODIFY 
  START_TIME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS MODIFY 
  SCHED_NAME NULL;

ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS MODIFY 
  SCHED_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS MODIFY 
  TRIGGER_NAME NULL;

ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS MODIFY 
  TRIGGER_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS MODIFY 
  TRIGGER_GROUP NULL;

ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS MODIFY 
  TRIGGER_GROUP NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS MODIFY 
  REPEAT_COUNT NULL;

ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS MODIFY 
  REPEAT_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS MODIFY 
  REPEAT_INTERVAL NULL;

ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS MODIFY 
  REPEAT_INTERVAL NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS MODIFY 
  TIMES_TRIGGERED NULL;

ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS MODIFY 
  TIMES_TRIGGERED NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_CRON_TRIGGERS MODIFY 
  SCHED_NAME NULL;

ALTER TABLE ADR.QRTZ_CRON_TRIGGERS MODIFY 
  SCHED_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_CRON_TRIGGERS MODIFY 
  TRIGGER_NAME NULL;

ALTER TABLE ADR.QRTZ_CRON_TRIGGERS MODIFY 
  TRIGGER_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_CRON_TRIGGERS MODIFY 
  TRIGGER_GROUP NULL;

ALTER TABLE ADR.QRTZ_CRON_TRIGGERS MODIFY 
  TRIGGER_GROUP NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_CRON_TRIGGERS MODIFY 
  CRON_EXPRESSION NULL;

ALTER TABLE ADR.QRTZ_CRON_TRIGGERS MODIFY 
  CRON_EXPRESSION NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_BLOB_TRIGGERS MODIFY 
  SCHED_NAME NULL;

ALTER TABLE ADR.QRTZ_BLOB_TRIGGERS MODIFY 
  SCHED_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_BLOB_TRIGGERS MODIFY 
  TRIGGER_NAME NULL;

ALTER TABLE ADR.QRTZ_BLOB_TRIGGERS MODIFY 
  TRIGGER_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_BLOB_TRIGGERS MODIFY 
  TRIGGER_GROUP NULL;

ALTER TABLE ADR.QRTZ_BLOB_TRIGGERS MODIFY 
  TRIGGER_GROUP NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_CALENDARS MODIFY 
  SCHED_NAME NULL;

ALTER TABLE ADR.QRTZ_CALENDARS MODIFY 
  SCHED_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_CALENDARS MODIFY 
  CALENDAR_NAME NULL;

ALTER TABLE ADR.QRTZ_CALENDARS MODIFY 
  CALENDAR_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_PAUSED_TRIGGER_GRPS MODIFY 
  SCHED_NAME NULL;

ALTER TABLE ADR.QRTZ_PAUSED_TRIGGER_GRPS MODIFY 
  SCHED_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_PAUSED_TRIGGER_GRPS MODIFY 
  TRIGGER_GROUP NULL;

ALTER TABLE ADR.QRTZ_PAUSED_TRIGGER_GRPS MODIFY 
  TRIGGER_GROUP NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS MODIFY 
  SCHED_NAME NULL;

ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS MODIFY 
  SCHED_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS MODIFY 
  PRIORITY NULL;

ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS MODIFY 
  PRIORITY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS MODIFY 
  SCHED_TIME NULL;

ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS MODIFY 
  SCHED_TIME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS MODIFY 
  ENTRY_ID NULL;

ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS MODIFY 
  ENTRY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS MODIFY 
  TRIGGER_NAME NULL;

ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS MODIFY 
  TRIGGER_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS MODIFY 
  TRIGGER_GROUP NULL;

ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS MODIFY 
  TRIGGER_GROUP NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS MODIFY 
  INSTANCE_NAME NULL;

ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS MODIFY 
  INSTANCE_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS MODIFY 
  FIRED_TIME NULL;

ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS MODIFY 
  FIRED_TIME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS MODIFY 
  STATE NULL;

ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS MODIFY 
  STATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_SCHEDULER_STATE MODIFY 
  SCHED_NAME NULL;

ALTER TABLE ADR.QRTZ_SCHEDULER_STATE MODIFY 
  SCHED_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_SCHEDULER_STATE MODIFY 
  INSTANCE_NAME NULL;

ALTER TABLE ADR.QRTZ_SCHEDULER_STATE MODIFY 
  INSTANCE_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_SCHEDULER_STATE MODIFY 
  LAST_CHECKIN_TIME NULL;

ALTER TABLE ADR.QRTZ_SCHEDULER_STATE MODIFY 
  LAST_CHECKIN_TIME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_SCHEDULER_STATE MODIFY 
  CHECKIN_INTERVAL NULL;

ALTER TABLE ADR.QRTZ_SCHEDULER_STATE MODIFY 
  CHECKIN_INTERVAL NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_LOCKS MODIFY 
  SCHED_NAME NULL;

ALTER TABLE ADR.QRTZ_LOCKS MODIFY 
  SCHED_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_LOCKS MODIFY 
  LOCK_NAME NULL;

ALTER TABLE ADR.QRTZ_LOCKS MODIFY 
  LOCK_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HL7_TRANSACTION_LOG MODIFY 
  HL7_TRANSACTION_LOG_ID NULL;

ALTER TABLE ADR.HL7_TRANSACTION_LOG MODIFY 
  HL7_TRANSACTION_LOG_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HL7_TRANSACTION_LOG MODIFY 
  MESSAGE_TRANSMISSION_TYPE_ID NULL;

ALTER TABLE ADR.HL7_TRANSACTION_LOG MODIFY 
  MESSAGE_TRANSMISSION_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HL7_TRANSACTION_LOG MODIFY 
  MESSAGE_CONTROL_NUMBER NULL;

ALTER TABLE ADR.HL7_TRANSACTION_LOG MODIFY 
  MESSAGE_CONTROL_NUMBER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HL7_TRANSACTION_LOG MODIFY 
  RETRANSMISSION_COUNT NULL;

ALTER TABLE ADR.HL7_TRANSACTION_LOG MODIFY 
  RETRANSMISSION_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HL7_TRANSACTION_LOG MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.HL7_TRANSACTION_LOG MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HL7_TRANSACTION_LOG MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.HL7_TRANSACTION_LOG MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HL7_TRANSACTION_LOG_SAVE MODIFY 
  HL7_TRANSACTION_LOG_ID NULL;

ALTER TABLE ADR.HL7_TRANSACTION_LOG_SAVE MODIFY 
  HL7_TRANSACTION_LOG_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HL7_TRANSACTION_LOG_SAVE MODIFY 
  MESSAGE_CONTROL_NUMBER NULL;

ALTER TABLE ADR.HL7_TRANSACTION_LOG_SAVE MODIFY 
  MESSAGE_CONTROL_NUMBER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_SCI MODIFY 
  BENEFICIARY_SCI_ID NULL;

ALTER TABLE ADR.BENEFICIARY_SCI MODIFY 
  BENEFICIARY_SCI_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_SCI MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.BENEFICIARY_SCI MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_SCI MODIFY 
  STD_SPINALINJURYCODE_ID NULL;

ALTER TABLE ADR.BENEFICIARY_SCI MODIFY 
  STD_SPINALINJURYCODE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_SCI MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.BENEFICIARY_SCI MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_SCI MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.BENEFICIARY_SCI MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_SCI MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.BENEFICIARY_SCI MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_SCI MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.BENEFICIARY_SCI MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_SCI MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.BENEFICIARY_SCI MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL MODIFY 
  ADDR_CONFIDENTIAL_DTL_ID NULL;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL MODIFY 
  ADDR_CONFIDENTIAL_DTL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL MODIFY 
  ADDRESS_ID NULL;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL MODIFY 
  ADDRESS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL MODIFY 
  STD_CONFIDENTIALADDRESSCAT_ID NULL;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL MODIFY 
  STD_CONFIDENTIALADDRESSCAT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H MODIFY 
  ADDR_CONFIDENTIAL_DTL_H_ID NULL;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H MODIFY 
  ADDR_CONFIDENTIAL_DTL_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H MODIFY 
  ADDR_CONFIDENTIAL_DTL_ID NULL;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H MODIFY 
  ADDR_CONFIDENTIAL_DTL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H MODIFY 
  ADDRESS_ID NULL;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H MODIFY 
  ADDRESS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H MODIFY 
  STD_CONFIDENTIALADDRESSCAT_ID NULL;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H MODIFY 
  STD_CONFIDENTIALADDRESSCAT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H
  DROP CONSTRAINT ADDR_CONFIDENTIAL_DTL_H_CHK;

ALTER TABLE ADR.ADDR_CONFIDENTIAL_DTL_H ADD (
  CONSTRAINT ADDR_CONFIDENTIAL_DTL_H_CHK
  CHECK (TRANSACTION_TYPE_CODE IN ('''U''', '''I''', '''D'''))
  ENABLE VALIDATE);
ALTER TABLE ADR.RELAXATION_PERCENTAGE_H MODIFY 
  RELAXATION_PERCENTAGE_H_ID NULL;

ALTER TABLE ADR.RELAXATION_PERCENTAGE_H MODIFY 
  RELAXATION_PERCENTAGE_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RELAXATION_PERCENTAGE_H MODIFY 
  RELAXATION_PERCENTAGE_ID NULL;

ALTER TABLE ADR.RELAXATION_PERCENTAGE_H MODIFY 
  RELAXATION_PERCENTAGE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RELAXATION_PERCENTAGE_H MODIFY 
  RELAXATION_PERCENTAGE NULL;

ALTER TABLE ADR.RELAXATION_PERCENTAGE_H MODIFY 
  RELAXATION_PERCENTAGE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RELAXATION_PERCENTAGE_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RELAXATION_PERCENTAGE_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RELAXATION_PERCENTAGE_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RELAXATION_PERCENTAGE_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RELAXATION_PERCENTAGE_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RELAXATION_PERCENTAGE_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RELAXATION_PERCENTAGE_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RELAXATION_PERCENTAGE_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RELAXATION_PERCENTAGE_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RELAXATION_PERCENTAGE_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RELAXATION_PERCENTAGE_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.RELAXATION_PERCENTAGE_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RELAXATION_PERCENTAGE MODIFY 
  RELAXATION_PERCENTAGE_ID NULL;

ALTER TABLE ADR.RELAXATION_PERCENTAGE MODIFY 
  RELAXATION_PERCENTAGE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RELAXATION_PERCENTAGE MODIFY 
  RELAXATION_PERCENTAGE NULL;

ALTER TABLE ADR.RELAXATION_PERCENTAGE MODIFY 
  RELAXATION_PERCENTAGE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RELAXATION_PERCENTAGE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RELAXATION_PERCENTAGE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RELAXATION_PERCENTAGE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RELAXATION_PERCENTAGE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RELAXATION_PERCENTAGE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RELAXATION_PERCENTAGE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RELAXATION_PERCENTAGE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RELAXATION_PERCENTAGE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RELAXATION_PERCENTAGE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RELAXATION_PERCENTAGE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ACTIVATION_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.ACTIVATION_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ACTIVATION_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.ACTIVATION_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ACTIVATION_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.ACTIVATION_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ACTIVATION_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.ACTIVATION_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ACTIVATION_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.ACTIVATION_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ACTIVATION_H
  DROP CONSTRAINT AVCON_1252960469_TRANS_001;

ALTER TABLE ADR.ACTIVATION_H ADD (
  CONSTRAINT AVCON_1252960469_TRANS_001
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.ACTIVATION_H MODIFY 
  ACTIVATION_H_ID NULL;

ALTER TABLE ADR.ACTIVATION_H MODIFY 
  ACTIVATION_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ACTIVATION_H MODIFY 
  ACTIVATION_ID NULL;

ALTER TABLE ADR.ACTIVATION_H MODIFY 
  ACTIVATION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ACTIVATION_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.ACTIVATION_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DEPLOYMENT_H MODIFY 
  DEPLOYMENT_H_ID NULL;

ALTER TABLE ADR.DEPLOYMENT_H MODIFY 
  DEPLOYMENT_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DEPLOYMENT_H MODIFY 
  DEPLOYMENT_ID NULL;

ALTER TABLE ADR.DEPLOYMENT_H MODIFY 
  DEPLOYMENT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DEPLOYMENT_H MODIFY 
  ACTIVATION_ID NULL;

ALTER TABLE ADR.DEPLOYMENT_H MODIFY 
  ACTIVATION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DEPLOYMENT_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.DEPLOYMENT_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DEPLOYMENT_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.DEPLOYMENT_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DEPLOYMENT_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.DEPLOYMENT_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DEPLOYMENT_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.DEPLOYMENT_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DEPLOYMENT_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.DEPLOYMENT_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DEPLOYMENT_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.DEPLOYMENT_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DEPLOYMENT_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.DEPLOYMENT_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DEPLOYMENT_H
  DROP CONSTRAINT AVCON_1253310191_TRANS_000;

ALTER TABLE ADR.DEPLOYMENT_H ADD (
  CONSTRAINT AVCON_1253310191_TRANS_000
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.MEDAL_OF_HONOR_H MODIFY 
  MEDAL_OF_HONOR_H_ID NULL;

ALTER TABLE ADR.MEDAL_OF_HONOR_H MODIFY 
  MEDAL_OF_HONOR_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDAL_OF_HONOR_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.MEDAL_OF_HONOR_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDAL_OF_HONOR_H MODIFY 
  MEDAL_OF_HONOR_ID NULL;

ALTER TABLE ADR.MEDAL_OF_HONOR_H MODIFY 
  MEDAL_OF_HONOR_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDAL_OF_HONOR_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.MEDAL_OF_HONOR_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDAL_OF_HONOR_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.MEDAL_OF_HONOR_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDAL_OF_HONOR_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.MEDAL_OF_HONOR_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDAL_OF_HONOR_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.MEDAL_OF_HONOR_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDAL_OF_HONOR_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.MEDAL_OF_HONOR_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDAL_OF_HONOR_H
  DROP CONSTRAINT AVCON_1252960469_TRANS_002;

ALTER TABLE ADR.MEDAL_OF_HONOR_H ADD (
  CONSTRAINT AVCON_1252960469_TRANS_002
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.ACTIVATION MODIFY 
  ACTIVATION_ID NULL;

ALTER TABLE ADR.ACTIVATION MODIFY 
  ACTIVATION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ACTIVATION MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.ACTIVATION MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ACTIVATION MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.ACTIVATION MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ACTIVATION MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.ACTIVATION MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ACTIVATION MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.ACTIVATION MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ACTIVATION MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.ACTIVATION MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DEPLOYMENT MODIFY 
  DEPLOYMENT_ID NULL;

ALTER TABLE ADR.DEPLOYMENT MODIFY 
  DEPLOYMENT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DEPLOYMENT MODIFY 
  ACTIVATION_ID NULL;

ALTER TABLE ADR.DEPLOYMENT MODIFY 
  ACTIVATION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DEPLOYMENT MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.DEPLOYMENT MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DEPLOYMENT MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.DEPLOYMENT MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DEPLOYMENT MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.DEPLOYMENT MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DEPLOYMENT MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.DEPLOYMENT MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DEPLOYMENT MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.DEPLOYMENT MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDAL_OF_HONOR MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.MEDAL_OF_HONOR MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDAL_OF_HONOR MODIFY 
  MEDAL_OF_HONOR_ID NULL;

ALTER TABLE ADR.MEDAL_OF_HONOR MODIFY 
  MEDAL_OF_HONOR_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDAL_OF_HONOR MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.MEDAL_OF_HONOR MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDAL_OF_HONOR MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.MEDAL_OF_HONOR MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDAL_OF_HONOR MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.MEDAL_OF_HONOR MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDAL_OF_HONOR MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.MEDAL_OF_HONOR MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEDAL_OF_HONOR MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.MEDAL_OF_HONOR MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SEEDING MODIFY 
  SEEDING_ID NULL;

ALTER TABLE ADR.SEEDING MODIFY 
  SEEDING_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SEEDING MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.SEEDING MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SEEDING MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.SEEDING MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SEEDING MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.SEEDING MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SEEDING MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.SEEDING MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SEEDING MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.SEEDING MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SEEDING MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.SEEDING MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PENSION_H MODIFY 
  PENSION_H_ID NULL;

ALTER TABLE ADR.PENSION_H MODIFY 
  PENSION_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PENSION_H MODIFY 
  PENSION_ID NULL;

ALTER TABLE ADR.PENSION_H MODIFY 
  PENSION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PENSION_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PENSION_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PENSION_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PENSION_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PENSION_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PENSION_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PENSION_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PENSION_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PENSION_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PENSION_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PENSION_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.PENSION_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PENSION MODIFY 
  PENSION_ID NULL;

ALTER TABLE ADR.PENSION MODIFY 
  PENSION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PENSION MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PENSION MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PENSION MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PENSION MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PENSION MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PENSION MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PENSION MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PENSION MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PENSION MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PENSION MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PENSION_REASON MODIFY 
  PENSION_REASON_ID NULL;

ALTER TABLE ADR.PENSION_REASON MODIFY 
  PENSION_REASON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PENSION_REASON MODIFY 
  CODE NULL;

ALTER TABLE ADR.PENSION_REASON MODIFY 
  CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PENSION_REASON MODIFY 
  NAME NULL;

ALTER TABLE ADR.PENSION_REASON MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PENSION_REASON MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PENSION_REASON MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PENSION_REASON MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PENSION_REASON MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PENSION_REASON MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PENSION_REASON MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PENSION_REASON MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PENSION_REASON MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PENSION_REASON MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PENSION_REASON MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TRANSMISSION_TYPE MODIFY 
  TRANSMISSION_TYPE_ID NULL;

ALTER TABLE ADR.TRANSMISSION_TYPE MODIFY 
  TRANSMISSION_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TRANSMISSION_TYPE MODIFY 
  CODE NULL;

ALTER TABLE ADR.TRANSMISSION_TYPE MODIFY 
  CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TRANSMISSION_TYPE MODIFY 
  NAME NULL;

ALTER TABLE ADR.TRANSMISSION_TYPE MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TRANSMISSION_TYPE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.TRANSMISSION_TYPE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TRANSMISSION_TYPE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.TRANSMISSION_TYPE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TRANSMISSION_TYPE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.TRANSMISSION_TYPE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TRANSMISSION_TYPE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.TRANSMISSION_TYPE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TRANSMISSION_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.TRANSMISSION_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BROKER_SERVICE_ERROR MODIFY 
  BROKER_SERVICE_ERROR_ID NULL;

ALTER TABLE ADR.BROKER_SERVICE_ERROR MODIFY 
  BROKER_SERVICE_ERROR_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BROKER_SERVICE_ERROR MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.BROKER_SERVICE_ERROR MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BROKER_SERVICE_ERROR MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.BROKER_SERVICE_ERROR MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BROKER_SERVICE_ERROR MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.BROKER_SERVICE_ERROR MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BROKER_SERVICE_ERROR MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.BROKER_SERVICE_ERROR MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BROKER_SERVICE_ERROR MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.BROKER_SERVICE_ERROR MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BROKER_SERVICE_PAYLOAD MODIFY 
  BROKER_SERVICE_PAYLOAD_ID NULL;

ALTER TABLE ADR.BROKER_SERVICE_PAYLOAD MODIFY 
  BROKER_SERVICE_PAYLOAD_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BROKER_SERVICE_PAYLOAD MODIFY 
  BROKER_SERVICE_LOG_ID NULL;

ALTER TABLE ADR.BROKER_SERVICE_PAYLOAD MODIFY 
  BROKER_SERVICE_LOG_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BROKER_SERVICE_PAYLOAD MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.BROKER_SERVICE_PAYLOAD MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BROKER_SERVICE_PAYLOAD MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.BROKER_SERVICE_PAYLOAD MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BROKER_SERVICE_PAYLOAD MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.BROKER_SERVICE_PAYLOAD MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BROKER_SERVICE_PAYLOAD MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.BROKER_SERVICE_PAYLOAD MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BROKER_SERVICE_PAYLOAD MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.BROKER_SERVICE_PAYLOAD MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_CARE_PROVIDER MODIFY 
  HEALTH_CARE_PROVIDER_ID NULL;

ALTER TABLE ADR.HEALTH_CARE_PROVIDER MODIFY 
  HEALTH_CARE_PROVIDER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_CARE_PROVIDER MODIFY 
  PRACTITIONER_ID NULL;

ALTER TABLE ADR.HEALTH_CARE_PROVIDER MODIFY 
  PRACTITIONER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_CARE_PROVIDER MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.HEALTH_CARE_PROVIDER MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_CARE_PROVIDER MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.HEALTH_CARE_PROVIDER MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_CARE_PROVIDER MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.HEALTH_CARE_PROVIDER MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_CARE_PROVIDER MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.HEALTH_CARE_PROVIDER MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_CARE_PROVIDER MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.HEALTH_CARE_PROVIDER MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  PATIENT_PROVIDER_ASSIGN_H_ID NULL;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  PATIENT_PROVIDER_ASSIGN_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  PATIENT_PROVIDER_ASSIGNMENT_ID NULL;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  PATIENT_PROVIDER_ASSIGNMENT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  HEALTH_CARE_PROVIDER_ID NULL;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  HEALTH_CARE_PROVIDER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  STD_TEAM_PURPOSE_ID NULL;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  STD_TEAM_PURPOSE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  STD_INSTITUTION_ID NULL;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  STD_INSTITUTION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  DATE_ASSIGNED NULL;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  DATE_ASSIGNED NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H
  DROP CONSTRAINT SYS_C00160912;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H ADD (
  CHECK ("HISTORY_CREATED_DATE" IS NOT NULL)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE ADR.BATCH_REQUEST_FACILITY MODIFY 
  BATCH_REQUEST_FACILITY_ID NULL;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY MODIFY 
  BATCH_REQUEST_FACILITY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY MODIFY 
  STD_INSTITUTION_ID NULL;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY MODIFY 
  STD_INSTITUTION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY MODIFY 
  HANDBOOK_BATCH_REQUEST_ID NULL;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY MODIFY 
  HANDBOOK_BATCH_REQUEST_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY MODIFY 
  PARENT_STD_INSTITUTION_ID NULL;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY MODIFY 
  PARENT_STD_INSTITUTION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  BATCH_REQUEST_FACILITY_H_ID NULL;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  BATCH_REQUEST_FACILITY_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  BATCH_REQUEST_FACILITY_ID NULL;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  BATCH_REQUEST_FACILITY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  STD_INSTITUTION_ID NULL;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  STD_INSTITUTION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  HANDBOOK_BATCH_REQUEST_ID NULL;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  HANDBOOK_BATCH_REQUEST_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  PARENT_STD_INSTITUTION_ID NULL;

ALTER TABLE ADR.BATCH_REQUEST_FACILITY_H MODIFY 
  PARENT_STD_INSTITUTION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP MODIFY 
  BATCH_REQUEST_PRIORITY_GRP_ID NULL;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP MODIFY 
  BATCH_REQUEST_PRIORITY_GRP_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP MODIFY 
  STD_ENROLLMENTPRIORGRP_ID NULL;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP MODIFY 
  STD_ENROLLMENTPRIORGRP_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP MODIFY 
  HANDBOOK_BATCH_REQUEST_ID NULL;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP MODIFY 
  HANDBOOK_BATCH_REQUEST_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  BATCH_REQUEST_PRIORITY_GRP_ID NULL;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  BATCH_REQUEST_PRIORITY_GRP_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  STD_ENROLLMENTPRIORGRP_ID NULL;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  STD_ENROLLMENTPRIORGRP_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  HANDBOOK_BATCH_REQUEST_ID NULL;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  HANDBOOK_BATCH_REQUEST_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  BATCH_REQUEST_PRI_GRP_H_ID NULL;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  BATCH_REQUEST_PRI_GRP_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.BATCH_REQUEST_PRIORITY_GROUP_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST MODIFY 
  HANDBOOK_BATCH_REQUEST_ID NULL;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST MODIFY 
  HANDBOOK_BATCH_REQUEST_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST MODIFY 
  BATCH_RELEASE_DATE NULL;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST MODIFY 
  BATCH_RELEASE_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST MODIFY 
  STD_HANDBOOKRELEASECNTL_ID NULL;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST MODIFY 
  STD_HANDBOOKRELEASECNTL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST MODIFY 
  STD_HANDBOOKBATCHREQUESTSTA_ID NULL;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST MODIFY 
  STD_HANDBOOKBATCHREQUESTSTA_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  HANDBOOK_BATCH_REQUEST_ID NULL;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  HANDBOOK_BATCH_REQUEST_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  BATCH_RELEASE_DATE NULL;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  BATCH_RELEASE_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  STD_HANDBOOKRELEASECNTL_ID NULL;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  STD_HANDBOOKRELEASECNTL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  STD_HANDBOOKBATCHREQUESTSTA_ID NULL;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  STD_HANDBOOKBATCHREQUESTSTA_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  HANDBOOK_BATCH_REQUEST_H_ID NULL;

ALTER TABLE ADR.HANDBOOK_BATCH_REQUEST_H MODIFY 
  HANDBOOK_BATCH_REQUEST_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN MODIFY 
  HANDBOOK_REQUEST_VETERAN_ID NULL;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN MODIFY 
  HANDBOOK_REQUEST_VETERAN_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN MODIFY 
  HANDBOOK_BATCH_REQUEST_ID NULL;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN MODIFY 
  HANDBOOK_BATCH_REQUEST_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H MODIFY 
  HANDBOOK_REQUEST_VETERAN_ID NULL;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H MODIFY 
  HANDBOOK_REQUEST_VETERAN_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H MODIFY 
  HANDBOOK_BATCH_REQUEST_ID NULL;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H MODIFY 
  HANDBOOK_BATCH_REQUEST_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H MODIFY 
  HANDBOOK_REQUEST_VETERAN_H_ID NULL;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H MODIFY 
  HANDBOOK_REQUEST_VETERAN_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.HANDBOOK_REQUEST_VETERAN_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE MODIFY 
  DELIVERY_PREFERENCE_ID NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE MODIFY 
  DELIVERY_PREFERENCE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE MODIFY 
  STD_DELIVERYPREFERENCETYPE_ID NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE MODIFY 
  STD_DELIVERYPREFERENCETYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE MODIFY 
  STD_DELIVERYPREFSRCTYPE_ID NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE MODIFY 
  STD_DELIVERYPREFSRCTYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL MODIFY 
  DELIVERY_PREFERENCE_EMAIL_ID NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL MODIFY 
  DELIVERY_PREFERENCE_EMAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL MODIFY 
  STD_EMAILADDRESSTYPE_ID NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL MODIFY 
  STD_EMAILADDRESSTYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL MODIFY 
  DELIVERY_PREFERENCE_ID NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL MODIFY 
  DELIVERY_PREFERENCE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL MODIFY 
  EMAIL_ADDRESS NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL MODIFY 
  EMAIL_ADDRESS NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  DELIVERY_PREFERENCE_EMAIL_ID NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  DELIVERY_PREFERENCE_EMAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  STD_EMAILADDRESSTYPE_ID NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  STD_EMAILADDRESSTYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  DELIVERY_PREFERENCE_ID NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  DELIVERY_PREFERENCE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  EMAIL_ADDRESS NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  EMAIL_ADDRESS NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  DELIVERY_PREFERENCE_EMAIL_H_ID NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_EMAIL_H MODIFY 
  DELIVERY_PREFERENCE_EMAIL_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  DELIVERY_PREFERENCE_ID NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  DELIVERY_PREFERENCE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  DELIVERY_PREFERENCE_H_ID NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  DELIVERY_PREFERENCE_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  STD_DELIVERYPREFERENCETYPE_ID NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  STD_DELIVERYPREFERENCETYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  STD_DELIVERYPREFSRCTYPE_ID NULL;

ALTER TABLE ADR.DELIVERY_PREFERENCE_H MODIFY 
  STD_DELIVERYPREFSRCTYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS MODIFY 
  RPT_PERSON_MERGE_STATUS_ID NULL;

ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS MODIFY 
  RPT_PERSON_MERGE_STATUS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS MODIFY 
  STD_PERSONMERGESTATUS_ID NULL;

ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS MODIFY 
  STD_PERSONMERGESTATUS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_MESSAGING_CASE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_000;

ALTER TABLE ADR.WKF_MESSAGING_CASE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_000
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_MESSAGING_CASE_H MODIFY 
  WKF_MESSAGING_CASE_H_ID NULL;

ALTER TABLE ADR.WKF_MESSAGING_CASE_H MODIFY 
  WKF_MESSAGING_CASE_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_MESSAGING_CASE_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.WKF_MESSAGING_CASE_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_MESSAGING_CASE_H MODIFY 
  WKF_MESSAGING_CASE_ID NULL;

ALTER TABLE ADR.WKF_MESSAGING_CASE_H MODIFY 
  WKF_MESSAGING_CASE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_MESSAGING_CASE_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.WKF_MESSAGING_CASE_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_MESSAGING_CASE_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.WKF_MESSAGING_CASE_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_MESSAGING_CASE_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.WKF_MESSAGING_CASE_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_MESSAGING_CASE_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.WKF_MESSAGING_CASE_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_MESSAGING_CASE_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.WKF_MESSAGING_CASE_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_MST_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_001;

ALTER TABLE ADR.BENEFICIARY_MST_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_001
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.BENEFICIARY_MST_H MODIFY 
  BENEFICIARY_MST_H_ID NULL;

ALTER TABLE ADR.BENEFICIARY_MST_H MODIFY 
  BENEFICIARY_MST_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_MST_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.BENEFICIARY_MST_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_MST_H MODIFY 
  BENEFICIARY_MST_ID NULL;

ALTER TABLE ADR.BENEFICIARY_MST_H MODIFY 
  BENEFICIARY_MST_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_MST_H MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.BENEFICIARY_MST_H MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_MST_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.BENEFICIARY_MST_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_MST_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.BENEFICIARY_MST_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_MST_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.BENEFICIARY_MST_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_MST_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.BENEFICIARY_MST_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_MST_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.BENEFICIARY_MST_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_EPISODE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_002;

ALTER TABLE ADR.COMBAT_EPISODE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_002
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.COMBAT_EPISODE_H MODIFY 
  COMBAT_EPISODE_H_ID NULL;

ALTER TABLE ADR.COMBAT_EPISODE_H MODIFY 
  COMBAT_EPISODE_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_EPISODE_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.COMBAT_EPISODE_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_EPISODE_H MODIFY 
  COMBAT_EPISODE_ID NULL;

ALTER TABLE ADR.COMBAT_EPISODE_H MODIFY 
  COMBAT_EPISODE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_EPISODE_H MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.COMBAT_EPISODE_H MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_EPISODE_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.COMBAT_EPISODE_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_EPISODE_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.COMBAT_EPISODE_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_EPISODE_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.COMBAT_EPISODE_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_EPISODE_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.COMBAT_EPISODE_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_EPISODE_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.COMBAT_EPISODE_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_004;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_004
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H MODIFY 
  CAT_DSBLTY_DIAGNOSIS_H_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H MODIFY 
  CAT_DSBLTY_DIAGNOSIS_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H MODIFY 
  CAT_DSBLTY_DIAGNOSIS_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H MODIFY 
  CAT_DSBLTY_DIAGNOSIS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H MODIFY 
  CATASTROPHIC_DISABILITY_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H MODIFY 
  CATASTROPHIC_DISABILITY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H MODIFY 
  DIAGNOSIS_TYPE_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H MODIFY 
  DIAGNOSIS_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL MODIFY 
  WKF_CASE_STATUS_DETAIL_ID NULL;

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL MODIFY 
  WKF_CASE_STATUS_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_EPISODE MODIFY 
  COMBAT_EPISODE_ID NULL;

ALTER TABLE ADR.COMBAT_EPISODE MODIFY 
  COMBAT_EPISODE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_EPISODE MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.COMBAT_EPISODE MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_EPISODE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.COMBAT_EPISODE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_EPISODE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.COMBAT_EPISODE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_EPISODE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.COMBAT_EPISODE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_EPISODE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.COMBAT_EPISODE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_EPISODE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.COMBAT_EPISODE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL MODIFY 
  SHAD_REGISTRY_DETAIL_ID NULL;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL MODIFY 
  SHAD_REGISTRY_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL MODIFY 
  SHAD_REGISTRY_ID NULL;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL MODIFY 
  SHAD_REGISTRY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL MODIFY 
  SHAD_DOCUMENT_TYPE_ID NULL;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL MODIFY 
  SHAD_DOCUMENT_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY MODIFY 
  NCOA_ADDRESS_VERIFY_SUMMARY_ID NULL;

ALTER TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY MODIFY 
  NCOA_ADDRESS_VERIFY_SUMMARY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_TRAVEL_H MODIFY 
  BENEFICIARY_TRAVEL_H_ID NULL;

ALTER TABLE ADR.BENEFICIARY_TRAVEL_H MODIFY 
  BENEFICIARY_TRAVEL_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_TRAVEL_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.BENEFICIARY_TRAVEL_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_TRAVEL_H MODIFY 
  BENEFICIARY_TRAVEL_ID NULL;

ALTER TABLE ADR.BENEFICIARY_TRAVEL_H MODIFY 
  BENEFICIARY_TRAVEL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_TRAVEL_H MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.BENEFICIARY_TRAVEL_H MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_TRAVEL_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.BENEFICIARY_TRAVEL_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_TRAVEL_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.BENEFICIARY_TRAVEL_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_TRAVEL_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.BENEFICIARY_TRAVEL_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_TRAVEL_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.BENEFICIARY_TRAVEL_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_TRAVEL_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.BENEFICIARY_TRAVEL_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_TRAVEL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_006;

ALTER TABLE ADR.BENEFICIARY_TRAVEL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_006
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_USERS MODIFY 
  RPT_USER_ID NULL;

ALTER TABLE ADR.RPT_USERS MODIFY 
  RPT_USER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_USERS MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_USERS MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_USERS MODIFY 
  USERID NULL;

ALTER TABLE ADR.RPT_USERS MODIFY 
  USERID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_USERS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_USERS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_USERS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_USERS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_USERS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_USERS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_USERS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_USERS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_USERS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_USERS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COM_ERROR MODIFY 
  RPT_COM_ERROR_ID NULL;

ALTER TABLE ADR.RPT_COM_ERROR MODIFY 
  RPT_COM_ERROR_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COM_ERROR MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_COM_ERROR MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COM_ERROR MODIFY 
  COM_AAC_ERROR_TYPE_ID NULL;

ALTER TABLE ADR.RPT_COM_ERROR MODIFY 
  COM_AAC_ERROR_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COM_ERROR MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_COM_ERROR MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COM_ERROR MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_COM_ERROR MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COM_ERROR MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_COM_ERROR MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COM_ERROR MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_COM_ERROR MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COM_ERROR MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_COM_ERROR MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSIONS MODIFY 
  ROLE_PERMISSION_ID NULL;

ALTER TABLE ADR.ROLE_PERMISSIONS MODIFY 
  ROLE_PERMISSION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSIONS MODIFY 
  PERMISSION_TYPE_ID NULL;

ALTER TABLE ADR.ROLE_PERMISSIONS MODIFY 
  PERMISSION_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSIONS MODIFY 
  ROLE_ID NULL;

ALTER TABLE ADR.ROLE_PERMISSIONS MODIFY 
  ROLE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSIONS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.ROLE_PERMISSIONS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSIONS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.ROLE_PERMISSIONS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSIONS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.ROLE_PERMISSIONS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSIONS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.ROLE_PERMISSIONS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSIONS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.ROLE_PERMISSIONS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_COMMENTS MODIFY 
  WKF_CASE_COMMENT_ID NULL;

ALTER TABLE ADR.WKF_CASE_COMMENTS MODIFY 
  WKF_CASE_COMMENT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_COMMENTS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.WKF_CASE_COMMENTS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_COMMENTS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.WKF_CASE_COMMENTS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_COMMENTS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.WKF_CASE_COMMENTS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_COMMENTS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.WKF_CASE_COMMENTS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_COMMENTS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.WKF_CASE_COMMENTS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMERGENCY_RESPONSE MODIFY 
  EMERGENCY_RESPONSE_ID NULL;

ALTER TABLE ADR.EMERGENCY_RESPONSE MODIFY 
  EMERGENCY_RESPONSE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMERGENCY_RESPONSE MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.EMERGENCY_RESPONSE MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMERGENCY_RESPONSE MODIFY 
  STD_EMERGENCYRESPONSE_ID NULL;

ALTER TABLE ADR.EMERGENCY_RESPONSE MODIFY 
  STD_EMERGENCYRESPONSE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMERGENCY_RESPONSE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.EMERGENCY_RESPONSE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMERGENCY_RESPONSE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.EMERGENCY_RESPONSE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMERGENCY_RESPONSE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.EMERGENCY_RESPONSE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMERGENCY_RESPONSE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.EMERGENCY_RESPONSE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMERGENCY_RESPONSE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.EMERGENCY_RESPONSE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY MODIFY 
  RPT_ENROLLMENT_CATEGORY_ID NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY MODIFY 
  RPT_ENROLLMENT_CATEGORY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY MODIFY 
  STD_ENROLLMENTCATTYPE_ID NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY MODIFY 
  STD_ENROLLMENTCATTYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION MODIFY 
  REGISTRY_LOAD_EXCEPTION_ID NULL;

ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION MODIFY 
  REGISTRY_LOAD_EXCEPTION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RELATION MODIFY 
  PERSON_RELATION_ID NULL;

ALTER TABLE ADR.PERSON_RELATION MODIFY 
  PERSON_RELATION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RELATION MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.PERSON_RELATION MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RELATION MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PERSON_RELATION MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RELATION MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PERSON_RELATION MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RELATION MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PERSON_RELATION MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RELATION MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PERSON_RELATION MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RELATION MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PERSON_RELATION MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_010;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_010
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H MODIFY 
  CONFIDENTIAL_ADDR_CATGRY_H_ID NULL;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H MODIFY 
  CONFIDENTIAL_ADDR_CATGRY_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H MODIFY 
  CONFIDENTIAL_ADDR_CATGRY_ID NULL;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H MODIFY 
  CONFIDENTIAL_ADDR_CATGRY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H MODIFY 
  CONFIDENTIAL_ADDR_TYPE_ID NULL;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H MODIFY 
  CONFIDENTIAL_ADDR_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H MODIFY 
  INACTIVE_FLAG NULL;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H MODIFY 
  INACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SERVICE_CONNECTED MODIFY 
  SERVICE_CONNECTED_ID NULL;

ALTER TABLE ADR.SERVICE_CONNECTED MODIFY 
  SERVICE_CONNECTED_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SERVICE_CONNECTED MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.SERVICE_CONNECTED MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SERVICE_CONNECTED MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.SERVICE_CONNECTED MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SERVICE_CONNECTED MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.SERVICE_CONNECTED MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SERVICE_CONNECTED MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.SERVICE_CONNECTED MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SERVICE_CONNECTED MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.SERVICE_CONNECTED MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SERVICE_CONNECTED MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.SERVICE_CONNECTED MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H MODIFY 
  PRISONER_OF_WAR_REGISTRY_H_ID NULL;

ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H MODIFY 
  PRISONER_OF_WAR_REGISTRY_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H MODIFY 
  PRISONER_OF_WAR_REGISTRY_ID NULL;

ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H MODIFY 
  PRISONER_OF_WAR_REGISTRY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_011;

ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_011
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.FEE_BASIS MODIFY 
  FEE_BASIS_ID NULL;

ALTER TABLE ADR.FEE_BASIS MODIFY 
  FEE_BASIS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FEE_BASIS MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.FEE_BASIS MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FEE_BASIS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.FEE_BASIS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FEE_BASIS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.FEE_BASIS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FEE_BASIS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.FEE_BASIS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FEE_BASIS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.FEE_BASIS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FEE_BASIS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.FEE_BASIS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON MODIFY 
  RPT_INVALID_ADDRESS_REASON_ID NULL;

ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON MODIFY 
  RPT_INVALID_ADDRESS_REASON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON MODIFY 
  ADDRESS_INVALID_TYPE_ID NULL;

ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON MODIFY 
  ADDRESS_INVALID_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_STATISTICS_H MODIFY 
  EGT_STATISTICS_H_ID NULL;

ALTER TABLE ADR.EGT_STATISTICS_H MODIFY 
  EGT_STATISTICS_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_STATISTICS_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.EGT_STATISTICS_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_STATISTICS_H MODIFY 
  EGT_STATISTICS_ID NULL;

ALTER TABLE ADR.EGT_STATISTICS_H MODIFY 
  EGT_STATISTICS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_STATISTICS_H MODIFY 
  EGT_SETTING_ID NULL;

ALTER TABLE ADR.EGT_STATISTICS_H MODIFY 
  EGT_SETTING_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_STATISTICS_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.EGT_STATISTICS_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_STATISTICS_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.EGT_STATISTICS_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_STATISTICS_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.EGT_STATISTICS_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_STATISTICS_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.EGT_STATISTICS_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_STATISTICS_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.EGT_STATISTICS_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_STATISTICS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_013;

ALTER TABLE ADR.EGT_STATISTICS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_013
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_ETHNICITY MODIFY 
  PERSON_ETHNICITY_ID NULL;

ALTER TABLE ADR.PERSON_ETHNICITY MODIFY 
  PERSON_ETHNICITY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_ETHNICITY MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.PERSON_ETHNICITY MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_ETHNICITY MODIFY 
  STD_ETHNICITY_ID NULL;

ALTER TABLE ADR.PERSON_ETHNICITY MODIFY 
  STD_ETHNICITY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_ETHNICITY MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PERSON_ETHNICITY MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_ETHNICITY MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PERSON_ETHNICITY MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_ETHNICITY MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PERSON_ETHNICITY MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_ETHNICITY MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PERSON_ETHNICITY MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_ETHNICITY MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PERSON_ETHNICITY MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_SCHEDULED_REPORTS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_SCHEDULED_REPORTS MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS MODIFY 
  RPT_STANDARD_REPORT_ID NULL;

ALTER TABLE ADR.RPT_SCHEDULED_REPORTS MODIFY 
  RPT_STANDARD_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS MODIFY 
  INCLUDE_USERS_FLAG NULL;

ALTER TABLE ADR.RPT_SCHEDULED_REPORTS MODIFY 
  INCLUDE_USERS_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS MODIFY 
  RUN_REPORT_BY_USER_FLAG NULL;

ALTER TABLE ADR.RPT_SCHEDULED_REPORTS MODIFY 
  RUN_REPORT_BY_USER_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_SCHEDULED_REPORTS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_SCHEDULED_REPORTS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_SCHEDULED_REPORTS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_SCHEDULED_REPORTS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT AVCON_1172521913_INCLU_000;

ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT AVCON_1172521913_INCLU_000
  CHECK (INCLUDE_USERS_FLAG BETWEEN 0
AND 0 OR INCLUDE_USERS_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT AVCON_1172521913_RUN_R_000;

ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT AVCON_1172521913_RUN_R_000
  CHECK (RUN_REPORT_BY_USER_FLAG BETWEEN 0
AND 0 OR RUN_REPORT_BY_USER_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
  DROP CONSTRAINT PRIOR_ENROLLMENT_CK;

ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT PRIOR_ENROLLMENT_CK
  CHECK (PRIOR_ENROLLMENT IN ('all', 'yes', 'no'))
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_LOGIN_H MODIFY 
  USER_LOGIN_H_ID NULL;

ALTER TABLE ADR.USER_LOGIN_H MODIFY 
  USER_LOGIN_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_LOGIN_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.USER_LOGIN_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_LOGIN_H MODIFY 
  ID NULL;

ALTER TABLE ADR.USER_LOGIN_H MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_LOGIN_H MODIFY 
  USERID NULL;

ALTER TABLE ADR.USER_LOGIN_H MODIFY 
  USERID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_LOGIN_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.USER_LOGIN_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_LOGIN_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.USER_LOGIN_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_LOGIN_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.USER_LOGIN_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_LOGIN_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.USER_LOGIN_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_LOGIN_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.USER_LOGIN_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_LOGIN_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_015;

ALTER TABLE ADR.USER_LOGIN_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_015
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_PERMISSION_SETS MODIFY 
  USER_PERMISSION_SET_ID NULL;

ALTER TABLE ADR.USER_PERMISSION_SETS MODIFY 
  USER_PERMISSION_SET_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSION_SETS MODIFY 
  PERMISSION_SET_ID NULL;

ALTER TABLE ADR.USER_PERMISSION_SETS MODIFY 
  PERMISSION_SET_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSION_SETS MODIFY 
  USERID NULL;

ALTER TABLE ADR.USER_PERMISSION_SETS MODIFY 
  USERID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSION_SETS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.USER_PERMISSION_SETS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSION_SETS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.USER_PERMISSION_SETS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSION_SETS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.USER_PERMISSION_SETS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSION_SETS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.USER_PERMISSION_SETS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSION_SETS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.USER_PERMISSION_SETS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_WKF_CASE MODIFY 
  RPT_WKF_CASE_ID NULL;

ALTER TABLE ADR.RPT_WKF_CASE MODIFY 
  RPT_WKF_CASE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_WKF_CASE MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_WKF_CASE MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_WKF_CASE MODIFY 
  WKF_CASE_TYPE_ID NULL;

ALTER TABLE ADR.RPT_WKF_CASE MODIFY 
  WKF_CASE_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_WKF_CASE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_WKF_CASE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_WKF_CASE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_WKF_CASE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_WKF_CASE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_WKF_CASE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_WKF_CASE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_WKF_CASE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_WKF_CASE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_WKF_CASE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.JOB_CONFIG MODIFY 
  JOB_CONFIG_ID NULL;

ALTER TABLE ADR.JOB_CONFIG MODIFY 
  JOB_CONFIG_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.JOB_CONFIG MODIFY 
  JOB_NAME NULL;

ALTER TABLE ADR.JOB_CONFIG MODIFY 
  JOB_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.JOB_CONFIG MODIFY 
  JOB_GROUP_NAME NULL;

ALTER TABLE ADR.JOB_CONFIG MODIFY 
  JOB_GROUP_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.JOB_CONFIG MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.JOB_CONFIG MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.JOB_CONFIG MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.JOB_CONFIG MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.JOB_CONFIG MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.JOB_CONFIG MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.JOB_CONFIG MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.JOB_CONFIG MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.JOB_CONFIG MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.JOB_CONFIG MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H MODIFY 
  HEALTH_BENEFITS_APPLN_H_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H MODIFY 
  HEALTH_BENEFITS_APPLN_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H MODIFY 
  HEALTH_BENEFITS_APPLICATION_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H MODIFY 
  HEALTH_BENEFITS_APPLICATION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_018;

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_018
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.SIGNATURE_IMAGE MODIFY 
  SIGNATURE_IMAGE_ID NULL;

ALTER TABLE ADR.SIGNATURE_IMAGE MODIFY 
  SIGNATURE_IMAGE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SIGNATURE_IMAGE MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.SIGNATURE_IMAGE MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SIGNATURE_IMAGE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.SIGNATURE_IMAGE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SIGNATURE_IMAGE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.SIGNATURE_IMAGE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SIGNATURE_IMAGE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.SIGNATURE_IMAGE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SIGNATURE_IMAGE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.SIGNATURE_IMAGE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SIGNATURE_IMAGE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.SIGNATURE_IMAGE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET MODIFY 
  PERMISSION_SET_ID NULL;

ALTER TABLE ADR.PERMISSION_SET MODIFY 
  PERMISSION_SET_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET MODIFY 
  NAME NULL;

ALTER TABLE ADR.PERMISSION_SET MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PERMISSION_SET MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PERMISSION_SET MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PERMISSION_SET MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PERMISSION_SET MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PERMISSION_SET MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_REGISTRY MODIFY 
  RPT_REGISTRY_ID NULL;

ALTER TABLE ADR.RPT_REGISTRY MODIFY 
  RPT_REGISTRY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_REGISTRY MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_REGISTRY MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_REGISTRY MODIFY 
  REGISTRY_TYPE_ID NULL;

ALTER TABLE ADR.RPT_REGISTRY MODIFY 
  REGISTRY_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_REGISTRY MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_REGISTRY MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_REGISTRY MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_REGISTRY MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_REGISTRY MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_REGISTRY MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_REGISTRY MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_REGISTRY MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_REGISTRY MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_REGISTRY MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USERS
  DROP CONSTRAINT AVCON_1172521913_INACT_042;

ALTER TABLE ADR.USERS ADD (
  CONSTRAINT AVCON_1172521913_INACT_042
  CHECK (INACTIVE_FLAG BETWEEN 0 AND 0 OR INACTIVE_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.USERS MODIFY 
  USERID NULL;

ALTER TABLE ADR.USERS MODIFY 
  USERID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USERS MODIFY 
  USERNAME NULL;

ALTER TABLE ADR.USERS MODIFY 
  USERNAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USERS MODIFY 
  PASSWORD_CHANGE_DATE NULL;

ALTER TABLE ADR.USERS MODIFY 
  PASSWORD_CHANGE_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USERS MODIFY 
  INACTIVE_FLAG NULL;

ALTER TABLE ADR.USERS MODIFY 
  INACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USERS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.USERS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USERS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.USERS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USERS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.USERS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USERS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.USERS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USERS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.USERS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SITE_STATISTICS MODIFY 
  EGT_SITE_STATISTICS_ID NULL;

ALTER TABLE ADR.EGT_SITE_STATISTICS MODIFY 
  EGT_SITE_STATISTICS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SITE_STATISTICS MODIFY 
  EGT_STATISTICS_ID NULL;

ALTER TABLE ADR.EGT_SITE_STATISTICS MODIFY 
  EGT_STATISTICS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SITE_STATISTICS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.EGT_SITE_STATISTICS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SITE_STATISTICS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.EGT_SITE_STATISTICS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SITE_STATISTICS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.EGT_SITE_STATISTICS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SITE_STATISTICS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.EGT_SITE_STATISTICS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SITE_STATISTICS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.EGT_SITE_STATISTICS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.POW_REGISTRY_DETAIL_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.POW_REGISTRY_DETAIL_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.POW_REGISTRY_DETAIL_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.POW_REGISTRY_DETAIL_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.POW_REGISTRY_DETAIL_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.POW_REGISTRY_DETAIL_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.POW_REGISTRY_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_022;

ALTER TABLE ADR.POW_REGISTRY_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_022
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.POW_REGISTRY_DETAIL_H MODIFY 
  POW_REGISTRY_DETAIL_H_ID NULL;

ALTER TABLE ADR.POW_REGISTRY_DETAIL_H MODIFY 
  POW_REGISTRY_DETAIL_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.POW_REGISTRY_DETAIL_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.POW_REGISTRY_DETAIL_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.POW_REGISTRY_DETAIL_H MODIFY 
  POW_REGISTRY_DETAIL_ID NULL;

ALTER TABLE ADR.POW_REGISTRY_DETAIL_H MODIFY 
  POW_REGISTRY_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.POW_REGISTRY_DETAIL_H MODIFY 
  PRISONER_OF_WAR_REGISTRY_ID NULL;

ALTER TABLE ADR.POW_REGISTRY_DETAIL_H MODIFY 
  PRISONER_OF_WAR_REGISTRY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.POW_REGISTRY_DETAIL_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.POW_REGISTRY_DETAIL_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.POW_REGISTRY_DETAIL_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.POW_REGISTRY_DETAIL_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_NTR MODIFY 
  BENEFICIARY_NTR_ID NULL;

ALTER TABLE ADR.BENEFICIARY_NTR MODIFY 
  BENEFICIARY_NTR_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_NTR MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.BENEFICIARY_NTR MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_NTR MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.BENEFICIARY_NTR MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_NTR MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.BENEFICIARY_NTR MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_NTR MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.BENEFICIARY_NTR MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_NTR MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.BENEFICIARY_NTR MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_NTR MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.BENEFICIARY_NTR MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_PAY_H MODIFY 
  COMBAT_PAY_H_ID NULL;

ALTER TABLE ADR.COMBAT_PAY_H MODIFY 
  COMBAT_PAY_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_PAY_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.COMBAT_PAY_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_PAY_H MODIFY 
  COMBAT_PAY_ID NULL;

ALTER TABLE ADR.COMBAT_PAY_H MODIFY 
  COMBAT_PAY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_PAY_H MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.COMBAT_PAY_H MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_PAY_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.COMBAT_PAY_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_PAY_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.COMBAT_PAY_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_PAY_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.COMBAT_PAY_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_PAY_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.COMBAT_PAY_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_PAY_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.COMBAT_PAY_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_PAY_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_023;

ALTER TABLE ADR.COMBAT_PAY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_023
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.POW_REGISTRY_DETAIL MODIFY 
  POW_REGISTRY_DETAIL_ID NULL;

ALTER TABLE ADR.POW_REGISTRY_DETAIL MODIFY 
  POW_REGISTRY_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.POW_REGISTRY_DETAIL MODIFY 
  PRISONER_OF_WAR_REGISTRY_ID NULL;

ALTER TABLE ADR.POW_REGISTRY_DETAIL MODIFY 
  PRISONER_OF_WAR_REGISTRY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.POW_REGISTRY_DETAIL MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.POW_REGISTRY_DETAIL MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.POW_REGISTRY_DETAIL MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.POW_REGISTRY_DETAIL MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.POW_REGISTRY_DETAIL MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.POW_REGISTRY_DETAIL MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.POW_REGISTRY_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.POW_REGISTRY_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.POW_REGISTRY_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.POW_REGISTRY_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_ROLES_H MODIFY 
  USER_ROLES_H_ID NULL;

ALTER TABLE ADR.USER_ROLES_H MODIFY 
  USER_ROLES_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_ROLES_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.USER_ROLES_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_ROLES_H MODIFY 
  USER_ROLE_ID NULL;

ALTER TABLE ADR.USER_ROLES_H MODIFY 
  USER_ROLE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_ROLES_H MODIFY 
  USERID NULL;

ALTER TABLE ADR.USER_ROLES_H MODIFY 
  USERID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_ROLES_H MODIFY 
  ROLE_ID NULL;

ALTER TABLE ADR.USER_ROLES_H MODIFY 
  ROLE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_ROLES_H MODIFY 
  INACTIVE_FLAG NULL;

ALTER TABLE ADR.USER_ROLES_H MODIFY 
  INACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_ROLES_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.USER_ROLES_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_ROLES_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.USER_ROLES_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_ROLES_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.USER_ROLES_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_ROLES_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.USER_ROLES_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_ROLES_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.USER_ROLES_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_ROLES_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_024;

ALTER TABLE ADR.USER_ROLES_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_024
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY MODIFY 
  CONFIDENTIAL_ADDR_CATGRY_ID NULL;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY MODIFY 
  CONFIDENTIAL_ADDR_CATGRY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY MODIFY 
  CONFIDENTIAL_ADDR_TYPE_ID NULL;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY MODIFY 
  CONFIDENTIAL_ADDR_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY MODIFY 
  INACTIVE_FLAG NULL;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY MODIFY 
  INACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY
  DROP CONSTRAINT AVCON_1172521913_INACT_046;

ALTER TABLE ADR.CONFIDENTIAL_ADDR_CATGRY ADD (
  CONSTRAINT AVCON_1172521913_INACT_046
  CHECK (INACTIVE_FLAG BETWEEN 0 AND 0 OR INACTIVE_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_UNMERGE MODIFY 
  PERSON_UNMERGE_ID NULL;

ALTER TABLE ADR.PERSON_UNMERGE MODIFY 
  PERSON_UNMERGE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_UNMERGE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PERSON_UNMERGE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_UNMERGE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PERSON_UNMERGE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_UNMERGE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PERSON_UNMERGE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_UNMERGE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PERSON_UNMERGE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_UNMERGE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PERSON_UNMERGE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMERGENCY_RESPONSE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_025;

ALTER TABLE ADR.EMERGENCY_RESPONSE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_025
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.EMERGENCY_RESPONSE_H MODIFY 
  EMERGENCY_RESPONSE_H_ID NULL;

ALTER TABLE ADR.EMERGENCY_RESPONSE_H MODIFY 
  EMERGENCY_RESPONSE_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMERGENCY_RESPONSE_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.EMERGENCY_RESPONSE_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMERGENCY_RESPONSE_H MODIFY 
  EMERGENCY_RESPONSE_ID NULL;

ALTER TABLE ADR.EMERGENCY_RESPONSE_H MODIFY 
  EMERGENCY_RESPONSE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMERGENCY_RESPONSE_H MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.EMERGENCY_RESPONSE_H MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMERGENCY_RESPONSE_H MODIFY 
  STD_EMERGENCYRESPONSE_ID NULL;

ALTER TABLE ADR.EMERGENCY_RESPONSE_H MODIFY 
  STD_EMERGENCYRESPONSE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMERGENCY_RESPONSE_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.EMERGENCY_RESPONSE_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMERGENCY_RESPONSE_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.EMERGENCY_RESPONSE_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMERGENCY_RESPONSE_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.EMERGENCY_RESPONSE_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMERGENCY_RESPONSE_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.EMERGENCY_RESPONSE_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMERGENCY_RESPONSE_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.EMERGENCY_RESPONSE_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_026;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_026
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H MODIFY 
  SHAD_REGISTRY_DETAIL_H_ID NULL;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H MODIFY 
  SHAD_REGISTRY_DETAIL_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H MODIFY 
  SHAD_REGISTRY_DETAIL_ID NULL;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H MODIFY 
  SHAD_REGISTRY_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H MODIFY 
  SHAD_REGISTRY_ID NULL;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H MODIFY 
  SHAD_REGISTRY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_HEC_REJECT_DETAIL MODIFY 
  COM_HEC_REJECT_DETAIL_ID NULL;

ALTER TABLE ADR.COM_HEC_REJECT_DETAIL MODIFY 
  COM_HEC_REJECT_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_HEC_REJECT_DETAIL MODIFY 
  COM_MAILING_ID NULL;

ALTER TABLE ADR.COM_HEC_REJECT_DETAIL MODIFY 
  COM_MAILING_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_HEC_REJECT_DETAIL MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.COM_HEC_REJECT_DETAIL MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_HEC_REJECT_DETAIL MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.COM_HEC_REJECT_DETAIL MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_HEC_REJECT_DETAIL MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.COM_HEC_REJECT_DETAIL MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_HEC_REJECT_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.COM_HEC_REJECT_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_HEC_REJECT_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.COM_HEC_REJECT_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USERS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_028;

ALTER TABLE ADR.USERS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_028
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.USERS_H MODIFY 
  USERS_H_ID NULL;

ALTER TABLE ADR.USERS_H MODIFY 
  USERS_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USERS_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.USERS_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USERS_H MODIFY 
  USERID NULL;

ALTER TABLE ADR.USERS_H MODIFY 
  USERID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USERS_H MODIFY 
  USERNAME NULL;

ALTER TABLE ADR.USERS_H MODIFY 
  USERNAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USERS_H MODIFY 
  INACTIVE_FLAG NULL;

ALTER TABLE ADR.USERS_H MODIFY 
  INACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USERS_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.USERS_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USERS_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.USERS_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USERS_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.USERS_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USERS_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.USERS_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USERS_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.USERS_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_STATUS MODIFY 
  RPT_ENROLLMENT_STATUS_ID NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_STATUS MODIFY 
  RPT_ENROLLMENT_STATUS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_STATUS MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_STATUS MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_STATUS MODIFY 
  STD_ENROLLMENTSTATUS_ID NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_STATUS MODIFY 
  STD_ENROLLMENTSTATUS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_STATUS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_STATUS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_STATUS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_STATUS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_STATUS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_STATUS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_STATUS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_STATUS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_STATUS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_STATUS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_PRINT_CHECK MODIFY 
  COM_PRINT_CHECK_ID NULL;

ALTER TABLE ADR.COM_PRINT_CHECK MODIFY 
  COM_PRINT_CHECK_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_PRINT_CHECK MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.COM_PRINT_CHECK MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_PRINT_CHECK MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.COM_PRINT_CHECK MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_PRINT_CHECK MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.COM_PRINT_CHECK MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_PRINT_CHECK MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.COM_PRINT_CHECK MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_PRINT_CHECK MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.COM_PRINT_CHECK MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INCOMPETENT_RULING MODIFY 
  INCOMPETENT_RULING_ID NULL;

ALTER TABLE ADR.INCOMPETENT_RULING MODIFY 
  INCOMPETENT_RULING_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INCOMPETENT_RULING MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.INCOMPETENT_RULING MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INCOMPETENT_RULING MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.INCOMPETENT_RULING MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INCOMPETENT_RULING MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.INCOMPETENT_RULING MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INCOMPETENT_RULING MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.INCOMPETENT_RULING MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INCOMPETENT_RULING MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.INCOMPETENT_RULING MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INCOMPETENT_RULING MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.INCOMPETENT_RULING MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INELIGIBLE_RULING MODIFY 
  INELIGIBLE_RULING_ID NULL;

ALTER TABLE ADR.INELIGIBLE_RULING MODIFY 
  INELIGIBLE_RULING_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INELIGIBLE_RULING MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.INELIGIBLE_RULING MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INELIGIBLE_RULING MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.INELIGIBLE_RULING MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INELIGIBLE_RULING MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.INELIGIBLE_RULING MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INELIGIBLE_RULING MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.INELIGIBLE_RULING MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INELIGIBLE_RULING MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.INELIGIBLE_RULING MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INELIGIBLE_RULING MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.INELIGIBLE_RULING MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_MERGE MODIFY 
  PERSON_MERGE_ID NULL;

ALTER TABLE ADR.PERSON_MERGE MODIFY 
  PERSON_MERGE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_MERGE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PERSON_MERGE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_MERGE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PERSON_MERGE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_MERGE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PERSON_MERGE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_MERGE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PERSON_MERGE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_MERGE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PERSON_MERGE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_MERGE
  DROP CONSTRAINT AVCON_1172521913_MERGE_000;

ALTER TABLE ADR.PERSON_MERGE ADD (
  CONSTRAINT AVCON_1172521913_MERGE_000
  CHECK (MERGE_RECORD_LOCKED_FLAG BETWEEN 0
AND 0 OR MERGE_RECORD_LOCKED_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL MODIFY 
  VA_PERSON_CLASS_DETAIL_ID NULL;

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL MODIFY 
  VA_PERSON_CLASS_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_MST MODIFY 
  BENEFICIARY_MST_ID NULL;

ALTER TABLE ADR.BENEFICIARY_MST MODIFY 
  BENEFICIARY_MST_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_MST MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.BENEFICIARY_MST MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_MST MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.BENEFICIARY_MST MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_MST MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.BENEFICIARY_MST MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_MST MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.BENEFICIARY_MST MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_MST MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.BENEFICIARY_MST MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_MST MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.BENEFICIARY_MST MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY MODIFY 
  PRISONER_OF_WAR_REGISTRY_ID NULL;

ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY MODIFY 
  PRISONER_OF_WAR_REGISTRY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON MODIFY 
  RPT_CANCEL_DECLINE_REASON_ID NULL;

ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON MODIFY 
  RPT_CANCEL_DECLINE_REASON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON MODIFY 
  CANCEL_DECLINE_REASON_TYPE_ID NULL;

ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON MODIFY 
  CANCEL_DECLINE_REASON_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H MODIFY 
  VA_PERSON_DIVISION_DETAIL_H_ID NULL;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H MODIFY 
  VA_PERSON_DIVISION_DETAIL_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H MODIFY 
  VA_PERSON_DIVISION_DETAIL_ID NULL;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H MODIFY 
  VA_PERSON_DIVISION_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H MODIFY 
  DEFAULT_DIVISION_FLAG NULL;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H MODIFY 
  DEFAULT_DIVISION_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_032;

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_032
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.SHAD_REGISTRY MODIFY 
  SHAD_REGISTRY_ID NULL;

ALTER TABLE ADR.SHAD_REGISTRY MODIFY 
  SHAD_REGISTRY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.SHAD_REGISTRY MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.SHAD_REGISTRY MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.SHAD_REGISTRY MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.SHAD_REGISTRY MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.SHAD_REGISTRY MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS MODIFY 
  PERM_SET_PERMISSIONS_ID NULL;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS MODIFY 
  PERM_SET_PERMISSIONS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS MODIFY 
  PERMISSION_TYPE_ID NULL;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS MODIFY 
  PERMISSION_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS MODIFY 
  PERMISSION_SET_ID NULL;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS MODIFY 
  PERMISSION_SET_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS MODIFY 
  CAT_DSBLTY_DIAGNOSIS_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS MODIFY 
  CAT_DSBLTY_DIAGNOSIS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS MODIFY 
  CATASTROPHIC_DISABILITY_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS MODIFY 
  CATASTROPHIC_DISABILITY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS MODIFY 
  DIAGNOSIS_TYPE_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS MODIFY 
  DIAGNOSIS_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CAT_DSBLTY_DIAGNOSIS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RACE_H MODIFY 
  PERSON_RACE_H_ID NULL;

ALTER TABLE ADR.PERSON_RACE_H MODIFY 
  PERSON_RACE_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RACE_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.PERSON_RACE_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RACE_H MODIFY 
  PERSON_RACE_ID NULL;

ALTER TABLE ADR.PERSON_RACE_H MODIFY 
  PERSON_RACE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RACE_H MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.PERSON_RACE_H MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RACE_H MODIFY 
  STD_RACE_ID NULL;

ALTER TABLE ADR.PERSON_RACE_H MODIFY 
  STD_RACE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RACE_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PERSON_RACE_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RACE_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PERSON_RACE_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RACE_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PERSON_RACE_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RACE_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PERSON_RACE_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RACE_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PERSON_RACE_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RACE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_034;

ALTER TABLE ADR.PERSON_RACE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_034
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H MODIFY 
  CAT_DSBLTY_PROCEDURE_H_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H MODIFY 
  CAT_DSBLTY_PROCEDURE_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H MODIFY 
  CAT_DSBLTY_PROCEDURE_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H MODIFY 
  CAT_DSBLTY_PROCEDURE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H MODIFY 
  CATASTROPHIC_DISABILITY_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H MODIFY 
  CATASTROPHIC_DISABILITY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H MODIFY 
  PROCEDURE_TYPE_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H MODIFY 
  PROCEDURE_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_035;

ALTER TABLE ADR.CAT_DSBLTY_PROCEDURE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_035
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION MODIFY 
  ELIGIBILITY_DETERMINATION_ID NULL;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION MODIFY 
  ELIGIBILITY_DETERMINATION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION MODIFY 
  ENROLLMENT_DETERMINATION_ID NULL;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION MODIFY 
  ENROLLMENT_DETERMINATION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION
  DROP CONSTRAINT AVCON_1172521913_PRIMA_001;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION ADD (
  CONSTRAINT AVCON_1172521913_PRIMA_001
  CHECK (PRIMARY_SECONDARY_OR_OTHER IN ('P', 'S', 'O'))
  ENABLE VALIDATE);
ALTER TABLE ADR.COMBAT_PAY MODIFY 
  COMBAT_PAY_ID NULL;

ALTER TABLE ADR.COMBAT_PAY MODIFY 
  COMBAT_PAY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_PAY MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.COMBAT_PAY MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_PAY MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.COMBAT_PAY MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_PAY MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.COMBAT_PAY MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_PAY MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.COMBAT_PAY MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_PAY MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.COMBAT_PAY MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COMBAT_PAY MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.COMBAT_PAY MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_H MODIFY 
  PERMISSION_SET_H_ID NULL;

ALTER TABLE ADR.PERMISSION_SET_H MODIFY 
  PERMISSION_SET_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.PERMISSION_SET_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_H MODIFY 
  PERMISSION_SET_ID NULL;

ALTER TABLE ADR.PERMISSION_SET_H MODIFY 
  PERMISSION_SET_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_H MODIFY 
  NAME NULL;

ALTER TABLE ADR.PERMISSION_SET_H MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PERMISSION_SET_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PERMISSION_SET_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PERMISSION_SET_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PERMISSION_SET_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PERMISSION_SET_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERMISSION_SET_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_036;

ALTER TABLE ADR.PERMISSION_SET_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_036
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_PERMISSION_SETS_H MODIFY 
  USER_PERMISSION_SET_H_ID NULL;

ALTER TABLE ADR.USER_PERMISSION_SETS_H MODIFY 
  USER_PERMISSION_SET_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSION_SETS_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.USER_PERMISSION_SETS_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSION_SETS_H MODIFY 
  USER_PERMISSION_SET_ID NULL;

ALTER TABLE ADR.USER_PERMISSION_SETS_H MODIFY 
  USER_PERMISSION_SET_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSION_SETS_H MODIFY 
  USERID NULL;

ALTER TABLE ADR.USER_PERMISSION_SETS_H MODIFY 
  USERID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSION_SETS_H MODIFY 
  PERMISSION_SET_ID NULL;

ALTER TABLE ADR.USER_PERMISSION_SETS_H MODIFY 
  PERMISSION_SET_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSION_SETS_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.USER_PERMISSION_SETS_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSION_SETS_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.USER_PERMISSION_SETS_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSION_SETS_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.USER_PERMISSION_SETS_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSION_SETS_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.USER_PERMISSION_SETS_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSION_SETS_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.USER_PERMISSION_SETS_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSION_SETS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_037;

ALTER TABLE ADR.USER_PERMISSION_SETS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_037
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.INELIGIBLE_RULING_H MODIFY 
  INELIGIBLE_RULING_H_ID NULL;

ALTER TABLE ADR.INELIGIBLE_RULING_H MODIFY 
  INELIGIBLE_RULING_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INELIGIBLE_RULING_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.INELIGIBLE_RULING_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INELIGIBLE_RULING_H MODIFY 
  INELIGIBLE_RULING_ID NULL;

ALTER TABLE ADR.INELIGIBLE_RULING_H MODIFY 
  INELIGIBLE_RULING_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INELIGIBLE_RULING_H MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.INELIGIBLE_RULING_H MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INELIGIBLE_RULING_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.INELIGIBLE_RULING_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INELIGIBLE_RULING_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.INELIGIBLE_RULING_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INELIGIBLE_RULING_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.INELIGIBLE_RULING_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INELIGIBLE_RULING_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.INELIGIBLE_RULING_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INELIGIBLE_RULING_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.INELIGIBLE_RULING_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.INELIGIBLE_RULING_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_038;

ALTER TABLE ADR.INELIGIBLE_RULING_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_038
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLES MODIFY 
  ROLE_ID NULL;

ALTER TABLE ADR.ROLES MODIFY 
  ROLE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLES MODIFY 
  ROLE_NAME NULL;

ALTER TABLE ADR.ROLES MODIFY 
  ROLE_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLES MODIFY 
  INACTIVE_FLAG NULL;

ALTER TABLE ADR.ROLES MODIFY 
  INACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLES MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.ROLES MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLES MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.ROLES MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLES MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.ROLES MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLES MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.ROLES MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLES MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.ROLES MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLES
  DROP CONSTRAINT AVCON_1172521913_INACT_063;

ALTER TABLE ADR.ROLES ADD (
  CONSTRAINT AVCON_1172521913_INACT_063
  CHECK (INACTIVE_FLAG BETWEEN 0 AND 0 OR INACTIVE_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE MODIFY 
  RPT_ENROLLMENT_OVERRIDE_ID NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE MODIFY 
  RPT_ENROLLMENT_OVERRIDE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE MODIFY 
  STD_ENRLOVERRIDEREASON_ID NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE MODIFY 
  STD_ENRLOVERRIDEREASON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H MODIFY 
  ENROLLMENT_OVERRIDE_H_ID NULL;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H MODIFY 
  ENROLLMENT_OVERRIDE_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H MODIFY 
  ENROLLMENT_OVERRIDE_ID NULL;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H MODIFY 
  ENROLLMENT_OVERRIDE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_039;

ALTER TABLE ADR.ENROLLMENT_OVERRIDE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_039
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.EMAIL MODIFY 
  EMAIL_ID NULL;

ALTER TABLE ADR.EMAIL MODIFY 
  EMAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMAIL MODIFY 
  EMAIL_ADDRESS NULL;

ALTER TABLE ADR.EMAIL MODIFY 
  EMAIL_ADDRESS NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMAIL MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.EMAIL MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMAIL MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.EMAIL MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMAIL MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.EMAIL MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMAIL MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.EMAIL MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMAIL MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.EMAIL MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_MESSAGE MODIFY 
  RPT_MESSAGE_ID NULL;

ALTER TABLE ADR.RPT_MESSAGE MODIFY 
  RPT_MESSAGE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_MESSAGE MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_MESSAGE MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_MESSAGE MODIFY 
  MESSAGE_TRANSMISSION_TYPE_ID NULL;

ALTER TABLE ADR.RPT_MESSAGE MODIFY 
  MESSAGE_TRANSMISSION_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_MESSAGE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_MESSAGE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_MESSAGE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_MESSAGE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_MESSAGE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_MESSAGE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_MESSAGE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_MESSAGE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_MESSAGE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_MESSAGE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SETTING
  DROP CONSTRAINT AVCON_1172521913_CURRE_000;

ALTER TABLE ADR.EGT_SETTING ADD (
  CONSTRAINT AVCON_1172521913_CURRE_000
  CHECK (CURRENT_EGT_FLAG BETWEEN 0 AND 0 OR CURRENT_EGT_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_SETTING
  DROP CONSTRAINT AVCON_1172521913_DISAB_000;

ALTER TABLE ADR.EGT_SETTING ADD (
  CONSTRAINT AVCON_1172521913_DISAB_000
  CHECK (DISABLED_EGT_FLAG BETWEEN 0
AND 0 OR DISABLED_EGT_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_SETTING MODIFY 
  EGT_SETTING_ID NULL;

ALTER TABLE ADR.EGT_SETTING MODIFY 
  EGT_SETTING_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SETTING MODIFY 
  EGT_TYPE_ID NULL;

ALTER TABLE ADR.EGT_SETTING MODIFY 
  EGT_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SETTING MODIFY 
  CURRENT_EGT_FLAG NULL;

ALTER TABLE ADR.EGT_SETTING MODIFY 
  CURRENT_EGT_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SETTING MODIFY 
  DISABLED_EGT_FLAG NULL;

ALTER TABLE ADR.EGT_SETTING MODIFY 
  DISABLED_EGT_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SETTING MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.EGT_SETTING MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SETTING MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.EGT_SETTING MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SETTING MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.EGT_SETTING MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SETTING MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.EGT_SETTING MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SETTING MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.EGT_SETTING MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_MESSAGING_CASE MODIFY 
  WKF_MESSAGING_CASE_ID NULL;

ALTER TABLE ADR.WKF_MESSAGING_CASE MODIFY 
  WKF_MESSAGING_CASE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_MESSAGING_CASE MODIFY 
  WKF_CASE_ID NULL;

ALTER TABLE ADR.WKF_MESSAGING_CASE MODIFY 
  WKF_CASE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_MESSAGING_CASE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.WKF_MESSAGING_CASE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_MESSAGING_CASE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.WKF_MESSAGING_CASE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_MESSAGING_CASE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.WKF_MESSAGING_CASE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_MESSAGING_CASE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.WKF_MESSAGING_CASE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_MESSAGING_CASE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.WKF_MESSAGING_CASE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSIONS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_044;

ALTER TABLE ADR.USER_PERMISSIONS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_044
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.USER_PERMISSIONS_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.USER_PERMISSIONS_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSIONS_H MODIFY 
  USER_PERMISSIONS_H_ID NULL;

ALTER TABLE ADR.USER_PERMISSIONS_H MODIFY 
  USER_PERMISSIONS_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSIONS_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.USER_PERMISSIONS_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSIONS_H MODIFY 
  USER_PERMISSION_ID NULL;

ALTER TABLE ADR.USER_PERMISSIONS_H MODIFY 
  USER_PERMISSION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSIONS_H MODIFY 
  USERID NULL;

ALTER TABLE ADR.USER_PERMISSIONS_H MODIFY 
  USERID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSIONS_H MODIFY 
  PERMISSION_TYPE_ID NULL;

ALTER TABLE ADR.USER_PERMISSIONS_H MODIFY 
  PERMISSION_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSIONS_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.USER_PERMISSIONS_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSIONS_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.USER_PERMISSIONS_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSIONS_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.USER_PERMISSIONS_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSIONS_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.USER_PERMISSIONS_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SETTING_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_045;

ALTER TABLE ADR.EGT_SETTING_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_045
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_SETTING_H
  DROP CONSTRAINT AVCON_1172521913_CURRE_001;

ALTER TABLE ADR.EGT_SETTING_H ADD (
  CONSTRAINT AVCON_1172521913_CURRE_001
  CHECK (CURRENT_EGT_FLAG BETWEEN 0 AND 0 OR CURRENT_EGT_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_SETTING_H MODIFY 
  EGT_SETTING_H_ID NULL;

ALTER TABLE ADR.EGT_SETTING_H MODIFY 
  EGT_SETTING_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SETTING_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.EGT_SETTING_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SETTING_H MODIFY 
  EGT_SETTING_ID NULL;

ALTER TABLE ADR.EGT_SETTING_H MODIFY 
  EGT_SETTING_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SETTING_H MODIFY 
  EGT_TYPE_ID NULL;

ALTER TABLE ADR.EGT_SETTING_H MODIFY 
  EGT_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SETTING_H MODIFY 
  CURRENT_EGT_FLAG NULL;

ALTER TABLE ADR.EGT_SETTING_H MODIFY 
  CURRENT_EGT_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SETTING_H MODIFY 
  DISABLED_EGT_FLAG NULL;

ALTER TABLE ADR.EGT_SETTING_H MODIFY 
  DISABLED_EGT_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SETTING_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.EGT_SETTING_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SETTING_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.EGT_SETTING_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SETTING_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.EGT_SETTING_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SETTING_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.EGT_SETTING_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SETTING_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.EGT_SETTING_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_STATISTICS MODIFY 
  EGT_STATISTICS_ID NULL;

ALTER TABLE ADR.EGT_STATISTICS MODIFY 
  EGT_STATISTICS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_STATISTICS MODIFY 
  EGT_SETTING_ID NULL;

ALTER TABLE ADR.EGT_STATISTICS MODIFY 
  EGT_SETTING_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_STATISTICS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.EGT_STATISTICS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_STATISTICS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.EGT_STATISTICS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_STATISTICS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.EGT_STATISTICS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_STATISTICS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.EGT_STATISTICS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_STATISTICS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.EGT_STATISTICS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION MODIFY 
  HEALTH_BENEFITS_APPLICATION_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION MODIFY 
  HEALTH_BENEFITS_APPLICATION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.HEALTH_BENEFITS_APPLICATION MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFLICT_DETAIL MODIFY 
  CONFLICT_DETAIL_ID NULL;

ALTER TABLE ADR.CONFLICT_DETAIL MODIFY 
  CONFLICT_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFLICT_DETAIL MODIFY 
  MILITARY_SERVICE_ID NULL;

ALTER TABLE ADR.CONFLICT_DETAIL MODIFY 
  MILITARY_SERVICE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFLICT_DETAIL MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CONFLICT_DETAIL MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFLICT_DETAIL MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CONFLICT_DETAIL MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFLICT_DETAIL MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CONFLICT_DETAIL MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFLICT_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CONFLICT_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CONFLICT_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CONFLICT_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ADR_DB_VER MODIFY 
  ADR_DB_VER_ID NULL;

ALTER TABLE ADR.ADR_DB_VER MODIFY 
  ADR_DB_VER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ADR_DB_VER MODIFY 
  DB_CREATE_DATE NULL;

ALTER TABLE ADR.ADR_DB_VER MODIFY 
  DB_CREATE_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_047;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_047
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H MODIFY 
  CAT_DSBLTY_CONDITION_H_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H MODIFY 
  CAT_DSBLTY_CONDITION_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H MODIFY 
  CAT_DSBLTY_CONDITION_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H MODIFY 
  CAT_DSBLTY_CONDITION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H MODIFY 
  CATASTROPHIC_DISABILITY_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H MODIFY 
  CATASTROPHIC_DISABILITY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H MODIFY 
  CONDITION_TYPE_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H MODIFY 
  CONDITION_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_LETTER_TEMPLATE MODIFY 
  COM_LETTER_TEMPLATE_ID NULL;

ALTER TABLE ADR.COM_LETTER_TEMPLATE MODIFY 
  COM_LETTER_TEMPLATE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_LETTER_TEMPLATE MODIFY 
  COM_LETTER_TYPE_ID NULL;

ALTER TABLE ADR.COM_LETTER_TEMPLATE MODIFY 
  COM_LETTER_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_LETTER_TEMPLATE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.COM_LETTER_TEMPLATE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_LETTER_TEMPLATE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.COM_LETTER_TEMPLATE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_LETTER_TEMPLATE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.COM_LETTER_TEMPLATE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_LETTER_TEMPLATE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.COM_LETTER_TEMPLATE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_LETTER_TEMPLATE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.COM_LETTER_TEMPLATE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSIONS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_048;

ALTER TABLE ADR.ROLE_PERMISSIONS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_048
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.ROLE_PERMISSIONS_H MODIFY 
  ROLE_PERMISSIONS_H_ID NULL;

ALTER TABLE ADR.ROLE_PERMISSIONS_H MODIFY 
  ROLE_PERMISSIONS_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSIONS_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.ROLE_PERMISSIONS_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSIONS_H MODIFY 
  ROLE_PERMISSION_ID NULL;

ALTER TABLE ADR.ROLE_PERMISSIONS_H MODIFY 
  ROLE_PERMISSION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSIONS_H MODIFY 
  ROLE_ID NULL;

ALTER TABLE ADR.ROLE_PERMISSIONS_H MODIFY 
  ROLE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSIONS_H MODIFY 
  PERMISSION_TYPE_ID NULL;

ALTER TABLE ADR.ROLE_PERMISSIONS_H MODIFY 
  PERMISSION_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSIONS_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.ROLE_PERMISSIONS_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSIONS_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.ROLE_PERMISSIONS_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSIONS_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.ROLE_PERMISSIONS_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSIONS_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.ROLE_PERMISSIONS_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSIONS_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.ROLE_PERMISSIONS_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_049;

ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_049
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H MODIFY 
  WKF_CASE_ASSIGNMENT_H_ID NULL;

ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H MODIFY 
  WKF_CASE_ASSIGNMENT_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H MODIFY 
  WKF_CASE_ASSIGNMENT_ID NULL;

ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H MODIFY 
  WKF_CASE_ASSIGNMENT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_FORM_STATISTICS MODIFY 
  COM_FORM_STATISTICS_ID NULL;

ALTER TABLE ADR.COM_FORM_STATISTICS MODIFY 
  COM_FORM_STATISTICS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_FORM_STATISTICS MODIFY 
  COM_TRANSMISSION_LOG_ID NULL;

ALTER TABLE ADR.COM_FORM_STATISTICS MODIFY 
  COM_TRANSMISSION_LOG_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_FORM_STATISTICS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.COM_FORM_STATISTICS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_FORM_STATISTICS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.COM_FORM_STATISTICS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_FORM_STATISTICS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.COM_FORM_STATISTICS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_FORM_STATISTICS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.COM_FORM_STATISTICS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_FORM_STATISTICS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.COM_FORM_STATISTICS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_CANCELED_REQUEST MODIFY 
  COM_CANCELED_REQUEST_ID NULL;

ALTER TABLE ADR.COM_CANCELED_REQUEST MODIFY 
  COM_CANCELED_REQUEST_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_CANCELED_REQUEST MODIFY 
  COM_MAILING_ID NULL;

ALTER TABLE ADR.COM_CANCELED_REQUEST MODIFY 
  COM_MAILING_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_CANCELED_REQUEST MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.COM_CANCELED_REQUEST MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_CANCELED_REQUEST MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.COM_CANCELED_REQUEST MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_CANCELED_REQUEST MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.COM_CANCELED_REQUEST MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_CANCELED_REQUEST MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.COM_CANCELED_REQUEST MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_CANCELED_REQUEST MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.COM_CANCELED_REQUEST MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT MODIFY 
  IVM_MIGRATE_EXTRACT_ID NULL;

ALTER TABLE ADR.IVM_MIGRATE_EXTRACT MODIFY 
  IVM_MIGRATE_EXTRACT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT MODIFY 
  IVM_MIGRATE_TYPE_ID NULL;

ALTER TABLE ADR.IVM_MIGRATE_EXTRACT MODIFY 
  IVM_MIGRATE_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.IVM_MIGRATE_EXTRACT MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.IVM_MIGRATE_EXTRACT MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.IVM_MIGRATE_EXTRACT MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.IVM_MIGRATE_EXTRACT MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.IVM_MIGRATE_EXTRACT MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL MODIFY 
  IVM_MIGRATE_EXTRACT_DETAIL_ID NULL;

ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL MODIFY 
  IVM_MIGRATE_EXTRACT_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL MODIFY 
  IVM_MIGRATE_EXTRACT_ID NULL;

ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL MODIFY 
  IVM_MIGRATE_EXTRACT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RACE MODIFY 
  PERSON_RACE_ID NULL;

ALTER TABLE ADR.PERSON_RACE MODIFY 
  PERSON_RACE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RACE MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.PERSON_RACE MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RACE MODIFY 
  STD_RACE_ID NULL;

ALTER TABLE ADR.PERSON_RACE MODIFY 
  STD_RACE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RACE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PERSON_RACE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RACE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PERSON_RACE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RACE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PERSON_RACE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RACE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PERSON_RACE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RACE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PERSON_RACE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_USER_GROUP MODIFY 
  RPT_USER_GROUP_ID NULL;

ALTER TABLE ADR.RPT_USER_GROUP MODIFY 
  RPT_USER_GROUP_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_USER_GROUP MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_USER_GROUP MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_USER_GROUP MODIFY 
  USER_GROUP_TYPE_ID NULL;

ALTER TABLE ADR.RPT_USER_GROUP MODIFY 
  USER_GROUP_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_USER_GROUP MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_USER_GROUP MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_USER_GROUP MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_USER_GROUP MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_USER_GROUP MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_USER_GROUP MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_USER_GROUP MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_USER_GROUP MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_USER_GROUP MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_USER_GROUP MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PH_REGISTRY_DETAIL MODIFY 
  PH_REGISTRY_DETAIL_ID NULL;

ALTER TABLE ADR.PH_REGISTRY_DETAIL MODIFY 
  PH_REGISTRY_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PH_REGISTRY_DETAIL MODIFY 
  PURPLE_HEART_REGISTRY_ID NULL;

ALTER TABLE ADR.PH_REGISTRY_DETAIL MODIFY 
  PURPLE_HEART_REGISTRY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PH_REGISTRY_DETAIL MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PH_REGISTRY_DETAIL MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PH_REGISTRY_DETAIL MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PH_REGISTRY_DETAIL MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PH_REGISTRY_DETAIL MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PH_REGISTRY_DETAIL MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PH_REGISTRY_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PH_REGISTRY_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PH_REGISTRY_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PH_REGISTRY_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLES_H MODIFY 
  ROLES_H_ID NULL;

ALTER TABLE ADR.ROLES_H MODIFY 
  ROLES_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLES_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.ROLES_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLES_H MODIFY 
  ROLE_ID NULL;

ALTER TABLE ADR.ROLES_H MODIFY 
  ROLE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLES_H MODIFY 
  ROLE_NAME NULL;

ALTER TABLE ADR.ROLES_H MODIFY 
  ROLE_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLES_H MODIFY 
  INACTIVE_FLAG NULL;

ALTER TABLE ADR.ROLES_H MODIFY 
  INACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLES_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.ROLES_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLES_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.ROLES_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLES_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.ROLES_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLES_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.ROLES_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLES_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.ROLES_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLES_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_050;

ALTER TABLE ADR.ROLES_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_050
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_SITE_STATISTICS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_051;

ALTER TABLE ADR.EGT_SITE_STATISTICS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_051
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.EGT_SITE_STATISTICS_H MODIFY 
  EGT_SITE_STATISTICS_H_ID NULL;

ALTER TABLE ADR.EGT_SITE_STATISTICS_H MODIFY 
  EGT_SITE_STATISTICS_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SITE_STATISTICS_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.EGT_SITE_STATISTICS_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SITE_STATISTICS_H MODIFY 
  EGT_SITE_STATISTICS_ID NULL;

ALTER TABLE ADR.EGT_SITE_STATISTICS_H MODIFY 
  EGT_SITE_STATISTICS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SITE_STATISTICS_H MODIFY 
  EGT_STATISTICS_ID NULL;

ALTER TABLE ADR.EGT_SITE_STATISTICS_H MODIFY 
  EGT_STATISTICS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SITE_STATISTICS_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.EGT_SITE_STATISTICS_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SITE_STATISTICS_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.EGT_SITE_STATISTICS_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SITE_STATISTICS_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.EGT_SITE_STATISTICS_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SITE_STATISTICS_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.EGT_SITE_STATISTICS_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EGT_SITE_STATISTICS_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.EGT_SITE_STATISTICS_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_052;

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_052
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H MODIFY 
  SITE_RECEIVED_ENROLLMENT_H_ID NULL;

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H MODIFY 
  SITE_RECEIVED_ENROLLMENT_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H MODIFY 
  SITE_RECEIVED_ENROLLMENT_ID NULL;

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H MODIFY 
  SITE_RECEIVED_ENROLLMENT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_MESSAGE_ERROR MODIFY 
  RPT_MESSAGE_ERROR_ID NULL;

ALTER TABLE ADR.RPT_MESSAGE_ERROR MODIFY 
  RPT_MESSAGE_ERROR_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_MESSAGE_ERROR MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_MESSAGE_ERROR MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_MESSAGE_ERROR MODIFY 
  ACK_TYPE_ID NULL;

ALTER TABLE ADR.RPT_MESSAGE_ERROR MODIFY 
  ACK_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_MESSAGE_ERROR MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_MESSAGE_ERROR MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_MESSAGE_ERROR MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_MESSAGE_ERROR MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_MESSAGE_ERROR MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_MESSAGE_ERROR MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_MESSAGE_ERROR MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_MESSAGE_ERROR MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_MESSAGE_ERROR MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_MESSAGE_ERROR MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_VBA_QUERY_STATUS MODIFY 
  RPT_VBA_QUERY_STATUS_ID NULL;

ALTER TABLE ADR.RPT_VBA_QUERY_STATUS MODIFY 
  RPT_VBA_QUERY_STATUS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_VBA_QUERY_STATUS MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_VBA_QUERY_STATUS MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_VBA_QUERY_STATUS MODIFY 
  VBA_QUERY_STATUS_TYPE_ID NULL;

ALTER TABLE ADR.RPT_VBA_QUERY_STATUS MODIFY 
  VBA_QUERY_STATUS_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_VBA_QUERY_STATUS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_VBA_QUERY_STATUS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_VBA_QUERY_STATUS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_VBA_QUERY_STATUS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_VBA_QUERY_STATUS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_VBA_QUERY_STATUS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_VBA_QUERY_STATUS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_VBA_QUERY_STATUS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_VBA_QUERY_STATUS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_VBA_QUERY_STATUS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT MODIFY 
  WKF_CASE_ASSIGNMENT_ID NULL;

ALTER TABLE ADR.WKF_CASE_ASSIGNMENT MODIFY 
  WKF_CASE_ASSIGNMENT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.WKF_CASE_ASSIGNMENT MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.WKF_CASE_ASSIGNMENT MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.WKF_CASE_ASSIGNMENT MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.WKF_CASE_ASSIGNMENT MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.WKF_CASE_ASSIGNMENT MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CATASTROPHIC_DISABILITY MODIFY 
  CATASTROPHIC_DISABILITY_ID NULL;

ALTER TABLE ADR.CATASTROPHIC_DISABILITY MODIFY 
  CATASTROPHIC_DISABILITY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CATASTROPHIC_DISABILITY MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.CATASTROPHIC_DISABILITY MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CATASTROPHIC_DISABILITY MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CATASTROPHIC_DISABILITY MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CATASTROPHIC_DISABILITY MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CATASTROPHIC_DISABILITY MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CATASTROPHIC_DISABILITY MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CATASTROPHIC_DISABILITY MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CATASTROPHIC_DISABILITY MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CATASTROPHIC_DISABILITY MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CATASTROPHIC_DISABILITY MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CATASTROPHIC_DISABILITY MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_TRANSMISSION_LOG MODIFY 
  COM_TRANSMISSION_LOG_ID NULL;

ALTER TABLE ADR.COM_TRANSMISSION_LOG MODIFY 
  COM_TRANSMISSION_LOG_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_TRANSMISSION_LOG MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.COM_TRANSMISSION_LOG MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_TRANSMISSION_LOG MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.COM_TRANSMISSION_LOG MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_TRANSMISSION_LOG MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.COM_TRANSMISSION_LOG MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_TRANSMISSION_LOG MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.COM_TRANSMISSION_LOG MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.COM_TRANSMISSION_LOG MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.COM_TRANSMISSION_LOG MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_STATISTICS MODIFY 
  IVM_MIGRATE_STATISTICS_ID NULL;

ALTER TABLE ADR.IVM_MIGRATE_STATISTICS MODIFY 
  IVM_MIGRATE_STATISTICS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_STATISTICS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.IVM_MIGRATE_STATISTICS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_STATISTICS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.IVM_MIGRATE_STATISTICS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_STATISTICS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.IVM_MIGRATE_STATISTICS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_STATISTICS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.IVM_MIGRATE_STATISTICS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_STATISTICS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.IVM_MIGRATE_STATISTICS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_CONDITION MODIFY 
  CAT_DSBLTY_CONDITION_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION MODIFY 
  CAT_DSBLTY_CONDITION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_CONDITION MODIFY 
  CATASTROPHIC_DISABILITY_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION MODIFY 
  CATASTROPHIC_DISABILITY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_CONDITION MODIFY 
  CONDITION_TYPE_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION MODIFY 
  CONDITION_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_CONDITION MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_CONDITION MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_CONDITION MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_CONDITION MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_CONDITION MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CAT_DSBLTY_CONDITION MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_H MODIFY 
  SHAD_REGISTRY_H_ID NULL;

ALTER TABLE ADR.SHAD_REGISTRY_H MODIFY 
  SHAD_REGISTRY_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.SHAD_REGISTRY_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_H MODIFY 
  SHAD_REGISTRY_ID NULL;

ALTER TABLE ADR.SHAD_REGISTRY_H MODIFY 
  SHAD_REGISTRY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.SHAD_REGISTRY_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.SHAD_REGISTRY_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.SHAD_REGISTRY_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.SHAD_REGISTRY_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.SHAD_REGISTRY_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SHAD_REGISTRY_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_056;

ALTER TABLE ADR.SHAD_REGISTRY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_056
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.CANCEL_DECLINE_H MODIFY 
  CANCEL_DECLINE_H_ID NULL;

ALTER TABLE ADR.CANCEL_DECLINE_H MODIFY 
  CANCEL_DECLINE_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CANCEL_DECLINE_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.CANCEL_DECLINE_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CANCEL_DECLINE_H MODIFY 
  CANCEL_DECLINE_ID NULL;

ALTER TABLE ADR.CANCEL_DECLINE_H MODIFY 
  CANCEL_DECLINE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CANCEL_DECLINE_H MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.CANCEL_DECLINE_H MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CANCEL_DECLINE_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CANCEL_DECLINE_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CANCEL_DECLINE_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CANCEL_DECLINE_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CANCEL_DECLINE_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CANCEL_DECLINE_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CANCEL_DECLINE_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CANCEL_DECLINE_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CANCEL_DECLINE_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CANCEL_DECLINE_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CANCEL_DECLINE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_057;

ALTER TABLE ADR.CANCEL_DECLINE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_057
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.WKF_CASE MODIFY 
  WKF_CASE_ID NULL;

ALTER TABLE ADR.WKF_CASE MODIFY 
  WKF_CASE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE MODIFY 
  WKF_CASE_TYPE_ID NULL;

ALTER TABLE ADR.WKF_CASE MODIFY 
  WKF_CASE_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.WKF_CASE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.WKF_CASE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.WKF_CASE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.WKF_CASE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WKF_CASE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.WKF_CASE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RELATION_UNMERGE MODIFY 
  PERSON_RELATION_UNMERGE_ID NULL;

ALTER TABLE ADR.PERSON_RELATION_UNMERGE MODIFY 
  PERSON_RELATION_UNMERGE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RELATION_UNMERGE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PERSON_RELATION_UNMERGE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RELATION_UNMERGE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PERSON_RELATION_UNMERGE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RELATION_UNMERGE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PERSON_RELATION_UNMERGE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RELATION_UNMERGE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PERSON_RELATION_UNMERGE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RELATION_UNMERGE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PERSON_RELATION_UNMERGE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PERMISSIONS MODIFY 
  RPT_PERMISSION_ID NULL;

ALTER TABLE ADR.RPT_PERMISSIONS MODIFY 
  RPT_PERMISSION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PERMISSIONS MODIFY 
  RPT_TYPE_ID NULL;

ALTER TABLE ADR.RPT_PERMISSIONS MODIFY 
  RPT_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PERMISSIONS MODIFY 
  PERMISSION_TYPE_ID NULL;

ALTER TABLE ADR.RPT_PERMISSIONS MODIFY 
  PERMISSION_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PERMISSIONS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_PERMISSIONS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PERMISSIONS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_PERMISSIONS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PERMISSIONS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_PERMISSIONS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PERMISSIONS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_PERMISSIONS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_PERMISSIONS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_PERMISSIONS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COMPLETED_REPORTS MODIFY 
  RPT_COMPLETED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_COMPLETED_REPORTS MODIFY 
  RPT_COMPLETED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COMPLETED_REPORTS MODIFY 
  RPT_OUTPUT_FILE_TYPE_ID NULL;

ALTER TABLE ADR.RPT_COMPLETED_REPORTS MODIFY 
  RPT_OUTPUT_FILE_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COMPLETED_REPORTS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_COMPLETED_REPORTS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COMPLETED_REPORTS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_COMPLETED_REPORTS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COMPLETED_REPORTS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_COMPLETED_REPORTS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COMPLETED_REPORTS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_COMPLETED_REPORTS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_COMPLETED_REPORTS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_COMPLETED_REPORTS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_DAY_OF_WEEK MODIFY 
  RPT_DAY_OF_WEEK_ID NULL;

ALTER TABLE ADR.RPT_DAY_OF_WEEK MODIFY 
  RPT_DAY_OF_WEEK_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_DAY_OF_WEEK MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_DAY_OF_WEEK MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_DAY_OF_WEEK MODIFY 
  RPT_DAY_OF_WEEK_TYPE_ID NULL;

ALTER TABLE ADR.RPT_DAY_OF_WEEK MODIFY 
  RPT_DAY_OF_WEEK_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_DAY_OF_WEEK MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_DAY_OF_WEEK MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_DAY_OF_WEEK MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_DAY_OF_WEEK MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_DAY_OF_WEEK MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_DAY_OF_WEEK MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_DAY_OF_WEEK MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_DAY_OF_WEEK MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_DAY_OF_WEEK MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_DAY_OF_WEEK MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SSN_VERIFICATION MODIFY 
  SSN_VERIFICATION_ID NULL;

ALTER TABLE ADR.SSN_VERIFICATION MODIFY 
  SSN_VERIFICATION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SSN_VERIFICATION MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.SSN_VERIFICATION MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SSN_VERIFICATION MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.SSN_VERIFICATION MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SSN_VERIFICATION MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.SSN_VERIFICATION MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SSN_VERIFICATION MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.SSN_VERIFICATION MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SSN_VERIFICATION MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.SSN_VERIFICATION MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RELATION_MERGE
  DROP CONSTRAINT AVCON_1172521913_MERGE_001;

ALTER TABLE ADR.PERSON_RELATION_MERGE ADD (
  CONSTRAINT AVCON_1172521913_MERGE_001
  CHECK (MERGE_IN_PROGRESS_FLAG BETWEEN 0
AND 0 OR MERGE_IN_PROGRESS_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_RELATION_MERGE
  DROP CONSTRAINT AVCON_1172521913_MERGE_002;

ALTER TABLE ADR.PERSON_RELATION_MERGE ADD (
  CONSTRAINT AVCON_1172521913_MERGE_002
  CHECK (MERGE_RECORD_LOCKED_FLAG BETWEEN 0
AND 0 OR MERGE_RECORD_LOCKED_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_RELATION_MERGE MODIFY 
  PERSON_RELATION_MERGE_ID NULL;

ALTER TABLE ADR.PERSON_RELATION_MERGE MODIFY 
  PERSON_RELATION_MERGE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RELATION_MERGE MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.PERSON_RELATION_MERGE MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RELATION_MERGE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PERSON_RELATION_MERGE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RELATION_MERGE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PERSON_RELATION_MERGE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RELATION_MERGE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PERSON_RELATION_MERGE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RELATION_MERGE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PERSON_RELATION_MERGE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_RELATION_MERGE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PERSON_RELATION_MERGE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SITE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_SITE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SITE MODIFY 
  RPT_SITE_ID NULL;

ALTER TABLE ADR.RPT_SITE MODIFY 
  RPT_SITE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SITE MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_SITE MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SITE MODIFY 
  STD_INSTITUTION_ID NULL;

ALTER TABLE ADR.RPT_SITE MODIFY 
  STD_INSTITUTION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SITE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_SITE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SITE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_SITE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SITE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_SITE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SITE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_SITE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSION_SETS_H MODIFY 
  ROLE_PERMISSION_SET_H_ID NULL;

ALTER TABLE ADR.ROLE_PERMISSION_SETS_H MODIFY 
  ROLE_PERMISSION_SET_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSION_SETS_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.ROLE_PERMISSION_SETS_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSION_SETS_H MODIFY 
  ROLE_PERMISSION_SET_ID NULL;

ALTER TABLE ADR.ROLE_PERMISSION_SETS_H MODIFY 
  ROLE_PERMISSION_SET_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSION_SETS_H MODIFY 
  ROLE_ID NULL;

ALTER TABLE ADR.ROLE_PERMISSION_SETS_H MODIFY 
  ROLE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSION_SETS_H MODIFY 
  PERMISSION_SET_ID NULL;

ALTER TABLE ADR.ROLE_PERMISSION_SETS_H MODIFY 
  PERMISSION_SET_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSION_SETS_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.ROLE_PERMISSION_SETS_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSION_SETS_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.ROLE_PERMISSION_SETS_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSION_SETS_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.ROLE_PERMISSION_SETS_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSION_SETS_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.ROLE_PERMISSION_SETS_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSION_SETS_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.ROLE_PERMISSION_SETS_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ROLE_PERMISSION_SETS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_060;

ALTER TABLE ADR.ROLE_PERMISSION_SETS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_060
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE);
ALTER TABLE ADR.RPT_QUERY_SITE MODIFY 
  REPORT_QUERY_SITE_ID NULL;

ALTER TABLE ADR.RPT_QUERY_SITE MODIFY 
  REPORT_QUERY_SITE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_QUERY_SITE MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_QUERY_SITE MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_QUERY_SITE MODIFY 
  ID NULL;

ALTER TABLE ADR.RPT_QUERY_SITE MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_QUERY_SITE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_QUERY_SITE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_QUERY_SITE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_QUERY_SITE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_QUERY_SITE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_QUERY_SITE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_QUERY_SITE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_QUERY_SITE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_QUERY_SITE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_QUERY_SITE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_LOGIN MODIFY 
  ID NULL;

ALTER TABLE ADR.USER_LOGIN MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_LOGIN MODIFY 
  USERID NULL;

ALTER TABLE ADR.USER_LOGIN MODIFY 
  USERID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_LOGIN MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.USER_LOGIN MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_LOGIN MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.USER_LOGIN MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_LOGIN MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.USER_LOGIN MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_LOGIN MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.USER_LOGIN MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSIONS MODIFY 
  USER_PERMISSION_ID NULL;

ALTER TABLE ADR.USER_PERMISSIONS MODIFY 
  USER_PERMISSION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSIONS MODIFY 
  PERMISSION_TYPE_ID NULL;

ALTER TABLE ADR.USER_PERMISSIONS MODIFY 
  PERMISSION_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSIONS MODIFY 
  USERID NULL;

ALTER TABLE ADR.USER_PERMISSIONS MODIFY 
  USERID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSIONS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.USER_PERMISSIONS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSIONS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.USER_PERMISSIONS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSIONS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.USER_PERMISSIONS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSIONS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.USER_PERMISSIONS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.USER_PERMISSIONS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.USER_PERMISSIONS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_TRAVEL MODIFY 
  BENEFICIARY_TRAVEL_ID NULL;

ALTER TABLE ADR.BENEFICIARY_TRAVEL MODIFY 
  BENEFICIARY_TRAVEL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_TRAVEL MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.BENEFICIARY_TRAVEL MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_TRAVEL MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.BENEFICIARY_TRAVEL MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_TRAVEL MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.BENEFICIARY_TRAVEL MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_TRAVEL MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.BENEFICIARY_TRAVEL MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_TRAVEL MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.BENEFICIARY_TRAVEL MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BENEFICIARY_TRAVEL MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.BENEFICIARY_TRAVEL MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL MODIFY 
  FINANCIAL_DEBT_DETAIL_ID NULL;

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL MODIFY 
  FINANCIAL_DEBT_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL MODIFY 
  FINANCIAL_STATEMENT_ID NULL;

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL MODIFY 
  FINANCIAL_STATEMENT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.FINANCIAL_DEBT_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HL7_ARCHIVE_TRANSACTION_LOG MODIFY 
  HL7_TRANSACTION_LOG_ID NULL;

ALTER TABLE ADR.HL7_ARCHIVE_TRANSACTION_LOG MODIFY 
  HL7_TRANSACTION_LOG_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HL7_ARCHIVE_TRANSACTION_LOG MODIFY 
  MESSAGE_TRANSMISSION_TYPE_ID NULL;

ALTER TABLE ADR.HL7_ARCHIVE_TRANSACTION_LOG MODIFY 
  MESSAGE_TRANSMISSION_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HL7_ARCHIVE_TRANSACTION_LOG MODIFY 
  MESSAGE_CONTROL_NUMBER NULL;

ALTER TABLE ADR.HL7_ARCHIVE_TRANSACTION_LOG MODIFY 
  MESSAGE_CONTROL_NUMBER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HL7_ARCHIVE_TRANSACTION_LOG MODIFY 
  RETRANSMISSION_COUNT NULL;

ALTER TABLE ADR.HL7_ARCHIVE_TRANSACTION_LOG MODIFY 
  RETRANSMISSION_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HL7_ARCHIVE_TRANSACTION_LOG MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.HL7_ARCHIVE_TRANSACTION_LOG MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HL7_ARCHIVE_TRANSACTION_LOG MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.HL7_ARCHIVE_TRANSACTION_LOG MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.EMPLOYMENT
  DROP CONSTRAINT SYS_C00106534;

ALTER TABLE ADR.EMPLOYMENT ADD (
  CONSTRAINT SYS_C00106534
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMPLOYMENT
  DROP CONSTRAINT SYS_C00106537;

ALTER TABLE ADR.EMPLOYMENT ADD (
  CONSTRAINT SYS_C00106537
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMPLOYMENT
  DROP CONSTRAINT SYS_C00106536;

ALTER TABLE ADR.EMPLOYMENT ADD (
  CONSTRAINT SYS_C00106536
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMPLOYMENT
  DROP CONSTRAINT SYS_C00106532;

ALTER TABLE ADR.EMPLOYMENT ADD (
  CONSTRAINT SYS_C00106532
  CHECK ("EMPLOYMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMPLOYMENT
  DROP CONSTRAINT SYS_C00106538;

ALTER TABLE ADR.EMPLOYMENT ADD (
  CONSTRAINT SYS_C00106538
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMPLOYMENT
  DROP CONSTRAINT SYS_C00106535;

ALTER TABLE ADR.EMPLOYMENT ADD (
  CONSTRAINT SYS_C00106535
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT SYS_C0067426;

ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT SYS_C0067426
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT SYS_C0067425;

ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT SYS_C0067425
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT SYS_C0067424;

ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT SYS_C0067424
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT SYS_C0067423;

ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT SYS_C0067423
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT SYS_C0067422;

ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT SYS_C0067422
  CHECK ("ADDRESS_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS
  DROP CONSTRAINT SYS_C0067427;

ALTER TABLE ADR.ADDRESS ADD (
  CONSTRAINT SYS_C0067427
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN
  DROP CONSTRAINT SYS_C0066931;

ALTER TABLE ADR.SSN ADD (
  CONSTRAINT SYS_C0066931
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN
  DROP CONSTRAINT SYS_C0066934;

ALTER TABLE ADR.SSN ADD (
  CONSTRAINT SYS_C0066934
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN
  DROP CONSTRAINT SYS_C0066933;

ALTER TABLE ADR.SSN ADD (
  CONSTRAINT SYS_C0066933
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN
  DROP CONSTRAINT SYS_C0066930;

ALTER TABLE ADR.SSN ADD (
  CONSTRAINT SYS_C0066930
  CHECK ("SSN_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN
  DROP CONSTRAINT SYS_C0066935;

ALTER TABLE ADR.SSN ADD (
  CONSTRAINT SYS_C0066935
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN
  DROP CONSTRAINT SYS_C0066932;

ALTER TABLE ADR.SSN ADD (
  CONSTRAINT SYS_C0066932
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE
  DROP CONSTRAINT SYS_C0066893;

ALTER TABLE ADR.PHONE ADD (
  CONSTRAINT SYS_C0066893
  CHECK ("PHONE_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE
  DROP CONSTRAINT SYS_C0066898;

ALTER TABLE ADR.PHONE ADD (
  CONSTRAINT SYS_C0066898
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE
  DROP CONSTRAINT SYS_C0066897;

ALTER TABLE ADR.PHONE ADD (
  CONSTRAINT SYS_C0066897
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE
  DROP CONSTRAINT SYS_C0066896;

ALTER TABLE ADR.PHONE ADD (
  CONSTRAINT SYS_C0066896
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE
  DROP CONSTRAINT SYS_C0066892;

ALTER TABLE ADR.PHONE ADD (
  CONSTRAINT SYS_C0066892
  CHECK ("PHONE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE
  DROP CONSTRAINT SYS_C0066899;

ALTER TABLE ADR.PHONE ADD (
  CONSTRAINT SYS_C0066899
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE
  DROP CONSTRAINT SYS_C0066894;

ALTER TABLE ADR.PHONE ADD (
  CONSTRAINT SYS_C0066894
  CHECK ("PHONE_NUMBER" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE
  DROP CONSTRAINT SYS_C0066895;

ALTER TABLE ADR.PHONE ADD (
  CONSTRAINT SYS_C0066895
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE
  DROP CONSTRAINT SYS_C00186906;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE ADD (
  CONSTRAINT SYS_C00186906
  CHECK ("STD_HANDBOOKRELEASECNTL_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE
  DROP CONSTRAINT SYS_C00186912;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE ADD (
  CONSTRAINT SYS_C00186912
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE
  DROP CONSTRAINT SYS_C00186911;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE ADD (
  CONSTRAINT SYS_C00186911
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE
  DROP CONSTRAINT SYS_C00186910;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE ADD (
  CONSTRAINT SYS_C00186910
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE
  DROP CONSTRAINT SYS_C00186909;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE ADD (
  CONSTRAINT SYS_C00186909
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE
  DROP CONSTRAINT SYS_C00186904;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE ADD (
  CONSTRAINT SYS_C00186904
  CHECK ("HANDBOOK_MAIL_QUEUE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE
  DROP CONSTRAINT SYS_C00186905;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE ADD (
  CONSTRAINT SYS_C00186905
  CHECK ("COM_LETTER_TEMPLATE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE
  DROP CONSTRAINT SYS_C00186907;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE ADD (
  CONSTRAINT SYS_C00186907
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE
  DROP CONSTRAINT SYS_C00186908;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE ADD (
  CONSTRAINT SYS_C00186908
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS
  DROP CONSTRAINT SYS_C00186927;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS ADD (
  CONSTRAINT SYS_C00186927
  CHECK ("STD_HANDBOOKMAILSTATTYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS
  DROP CONSTRAINT SYS_C00186932;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS ADD (
  CONSTRAINT SYS_C00186932
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS
  DROP CONSTRAINT SYS_C00186931;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS ADD (
  CONSTRAINT SYS_C00186931
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS
  DROP CONSTRAINT SYS_C00186930;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS ADD (
  CONSTRAINT SYS_C00186930
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS
  DROP CONSTRAINT SYS_C00186929;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS ADD (
  CONSTRAINT SYS_C00186929
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS
  DROP CONSTRAINT SYS_C00186925;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS ADD (
  CONSTRAINT SYS_C00186925
  CHECK ("HANDBOOK_MAIL_STATUS_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS
  DROP CONSTRAINT SYS_C00186926;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS ADD (
  CONSTRAINT SYS_C00186926
  CHECK ("HANDBOOK_MAIL_QUEUE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS
  DROP CONSTRAINT SYS_C00186928;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS ADD (
  CONSTRAINT SYS_C00186928
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL
  DROP CONSTRAINT SYS_C0067036;

ALTER TABLE ADR.INCOME_TEST_DETAIL ADD (
  CONSTRAINT SYS_C0067036
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL
  DROP CONSTRAINT SYS_C0067033;

ALTER TABLE ADR.INCOME_TEST_DETAIL ADD (
  CONSTRAINT SYS_C0067033
  CHECK ("INCOME_TEST_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL
  DROP CONSTRAINT SYS_C0067037;

ALTER TABLE ADR.INCOME_TEST_DETAIL ADD (
  CONSTRAINT SYS_C0067037
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL
  DROP CONSTRAINT SYS_C0067031;

ALTER TABLE ADR.INCOME_TEST_DETAIL ADD (
  CONSTRAINT SYS_C0067031
  CHECK ("INCOME_TEST_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL
  DROP CONSTRAINT SYS_C0067032;

ALTER TABLE ADR.INCOME_TEST_DETAIL ADD (
  CONSTRAINT SYS_C0067032
  CHECK ("INCOME_TEST_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL
  DROP CONSTRAINT SYS_C0067038;

ALTER TABLE ADR.INCOME_TEST_DETAIL ADD (
  CONSTRAINT SYS_C0067038
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL
  DROP CONSTRAINT SYS_C0067034;

ALTER TABLE ADR.INCOME_TEST_DETAIL ADD (
  CONSTRAINT SYS_C0067034
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL
  DROP CONSTRAINT SYS_C0067035;

ALTER TABLE ADR.INCOME_TEST_DETAIL ADD (
  CONSTRAINT SYS_C0067035
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL
  DROP CONSTRAINT SYS_C00392903;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL ADD (
  CONSTRAINT SYS_C00392903
  CHECK ("RECORD_SEQUENCE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL
  DROP CONSTRAINT SYS_C00392907;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL ADD (
  CONSTRAINT SYS_C00392907
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL
  DROP CONSTRAINT SYS_C00392906;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL ADD (
  CONSTRAINT SYS_C00392906
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL
  DROP CONSTRAINT SYS_C00392901;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL ADD (
  CONSTRAINT SYS_C00392901
  CHECK ("IRS_TRANSMISSION_LOG_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL
  DROP CONSTRAINT SYS_C00392902;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL ADD (
  CONSTRAINT SYS_C00392902
  CHECK ("IRS_TRANSMISSION_LOG_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL
  DROP CONSTRAINT SYS_C00392908;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL ADD (
  CONSTRAINT SYS_C00392908
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL
  DROP CONSTRAINT SYS_C00392904;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL ADD (
  CONSTRAINT SYS_C00392904
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL
  DROP CONSTRAINT SYS_C00392905;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL ADD (
  CONSTRAINT SYS_C00392905
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_064;

ALTER TABLE ADR.PHONE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_064
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE_H
  DROP CONSTRAINT SYS_C0067290;

ALTER TABLE ADR.PHONE_H ADD (
  CONSTRAINT SYS_C0067290
  CHECK ("PHONE_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE_H
  DROP CONSTRAINT SYS_C0067287;

ALTER TABLE ADR.PHONE_H ADD (
  CONSTRAINT SYS_C0067287
  CHECK ("PHONE_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE_H
  DROP CONSTRAINT SYS_C0067288;

ALTER TABLE ADR.PHONE_H ADD (
  CONSTRAINT SYS_C0067288
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE_H
  DROP CONSTRAINT SYS_C0067289;

ALTER TABLE ADR.PHONE_H ADD (
  CONSTRAINT SYS_C0067289
  CHECK ("PHONE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE_H
  DROP CONSTRAINT SYS_C0067296;

ALTER TABLE ADR.PHONE_H ADD (
  CONSTRAINT SYS_C0067296
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE_H
  DROP CONSTRAINT SYS_C0067291;

ALTER TABLE ADR.PHONE_H ADD (
  CONSTRAINT SYS_C0067291
  CHECK ("PHONE_NUMBER" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE_H
  DROP CONSTRAINT SYS_C0067292;

ALTER TABLE ADR.PHONE_H ADD (
  CONSTRAINT SYS_C0067292
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE_H
  DROP CONSTRAINT SYS_C0067293;

ALTER TABLE ADR.PHONE_H ADD (
  CONSTRAINT SYS_C0067293
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE_H
  DROP CONSTRAINT SYS_C0067294;

ALTER TABLE ADR.PHONE_H ADD (
  CONSTRAINT SYS_C0067294
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PHONE_H
  DROP CONSTRAINT SYS_C0067295;

ALTER TABLE ADR.PHONE_H ADD (
  CONSTRAINT SYS_C0067295
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL
  DROP CONSTRAINT SYS_C0067153;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL ADD (
  CONSTRAINT SYS_C0067153
  CHECK ("FINANCIAL_ASSET_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL
  DROP CONSTRAINT SYS_C0067157;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL ADD (
  CONSTRAINT SYS_C0067157
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL
  DROP CONSTRAINT SYS_C0067151;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL ADD (
  CONSTRAINT SYS_C0067151
  CHECK ("FINANCIAL_ASSET_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL
  DROP CONSTRAINT SYS_C0067152;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL ADD (
  CONSTRAINT SYS_C0067152
  CHECK ("FINANCIAL_STATEMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL
  DROP CONSTRAINT SYS_C0067158;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL ADD (
  CONSTRAINT SYS_C0067158
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL
  DROP CONSTRAINT SYS_C0067154;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL ADD (
  CONSTRAINT SYS_C0067154
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL
  DROP CONSTRAINT SYS_C0067155;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL ADD (
  CONSTRAINT SYS_C0067155
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL
  DROP CONSTRAINT SYS_C0067156;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL ADD (
  CONSTRAINT SYS_C0067156
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY
  DROP CONSTRAINT SYS_C00160854;

ALTER TABLE ADR.PREFERRED_FACILITY ADD (
  CONSTRAINT SYS_C00160854
  CHECK ("STD_INSTITUTION_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY
  DROP CONSTRAINT SYS_C00160859;

ALTER TABLE ADR.PREFERRED_FACILITY ADD (
  CONSTRAINT SYS_C00160859
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY
  DROP CONSTRAINT SYS_C00160851;

ALTER TABLE ADR.PREFERRED_FACILITY ADD (
  CONSTRAINT SYS_C00160851
  CHECK ("PREFERRED_FACILITY_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY
  DROP CONSTRAINT SYS_C00160852;

ALTER TABLE ADR.PREFERRED_FACILITY ADD (
  CONSTRAINT SYS_C00160852
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY
  DROP CONSTRAINT SYS_C00160853;

ALTER TABLE ADR.PREFERRED_FACILITY ADD (
  CONSTRAINT SYS_C00160853
  CHECK ("STD_PREFERRED_FACILITY_SRC_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY
  DROP CONSTRAINT SYS_C00160860;

ALTER TABLE ADR.PREFERRED_FACILITY ADD (
  CONSTRAINT SYS_C00160860
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY
  DROP CONSTRAINT SYS_C00160855;

ALTER TABLE ADR.PREFERRED_FACILITY ADD (
  CONSTRAINT SYS_C00160855
  CHECK ("ASSIGNMENT_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY
  DROP CONSTRAINT SYS_C00160856;

ALTER TABLE ADR.PREFERRED_FACILITY ADD (
  CONSTRAINT SYS_C00160856
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY
  DROP CONSTRAINT SYS_C00160857;

ALTER TABLE ADR.PREFERRED_FACILITY ADD (
  CONSTRAINT SYS_C00160857
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY
  DROP CONSTRAINT SYS_C00160858;

ALTER TABLE ADR.PREFERRED_FACILITY ADD (
  CONSTRAINT SYS_C00160858
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_RELATION_H
  DROP CONSTRAINT SYS_C0066454;

ALTER TABLE ADR.PERSON_RELATION_H ADD (
  CONSTRAINT SYS_C0066454
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_RELATION_H
  DROP CONSTRAINT SYS_C0066451;

ALTER TABLE ADR.PERSON_RELATION_H ADD (
  CONSTRAINT SYS_C0066451
  CHECK ("PERSON_RELATION_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_RELATION_H
  DROP CONSTRAINT SYS_C0066452;

ALTER TABLE ADR.PERSON_RELATION_H ADD (
  CONSTRAINT SYS_C0066452
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_RELATION_H
  DROP CONSTRAINT SYS_C0066453;

ALTER TABLE ADR.PERSON_RELATION_H ADD (
  CONSTRAINT SYS_C0066453
  CHECK ("PERSON_RELATION_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_RELATION_H
  DROP CONSTRAINT SYS_C0066459;

ALTER TABLE ADR.PERSON_RELATION_H ADD (
  CONSTRAINT SYS_C0066459
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_RELATION_H
  DROP CONSTRAINT SYS_C0066455;

ALTER TABLE ADR.PERSON_RELATION_H ADD (
  CONSTRAINT SYS_C0066455
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_RELATION_H
  DROP CONSTRAINT SYS_C0066456;

ALTER TABLE ADR.PERSON_RELATION_H ADD (
  CONSTRAINT SYS_C0066456
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_RELATION_H
  DROP CONSTRAINT SYS_C0066457;

ALTER TABLE ADR.PERSON_RELATION_H ADD (
  CONSTRAINT SYS_C0066457
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_RELATION_H
  DROP CONSTRAINT SYS_C0066458;

ALTER TABLE ADR.PERSON_RELATION_H ADD (
  CONSTRAINT SYS_C0066458
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_RELATION_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_027;

ALTER TABLE ADR.PERSON_RELATION_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_027
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY
  DROP CONSTRAINT SYS_C0067054;

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY ADD (
  CONSTRAINT SYS_C0067054
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY
  DROP CONSTRAINT SYS_C0067057;

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY ADD (
  CONSTRAINT SYS_C0067057
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY
  DROP CONSTRAINT SYS_C0067052;

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY ADD (
  CONSTRAINT SYS_C0067052
  CHECK ("BENEFICIARY_VISIT_SUMMARY_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY
  DROP CONSTRAINT SYS_C0067053;

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY ADD (
  CONSTRAINT SYS_C0067053
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY
  DROP CONSTRAINT SYS_C0067058;

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY ADD (
  CONSTRAINT SYS_C0067058
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY
  DROP CONSTRAINT SYS_C0067056;

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY ADD (
  CONSTRAINT SYS_C0067056
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY
  DROP CONSTRAINT SYS_C0067055;

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY ADD (
  CONSTRAINT SYS_C0067055
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_DOCUMENT
  DROP CONSTRAINT SYS_C00186899;

ALTER TABLE ADR.HANDBOOK_DOCUMENT ADD (
  CONSTRAINT SYS_C00186899
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_DOCUMENT
  DROP CONSTRAINT SYS_C00186902;

ALTER TABLE ADR.HANDBOOK_DOCUMENT ADD (
  CONSTRAINT SYS_C00186902
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_DOCUMENT
  DROP CONSTRAINT SYS_C00186897;

ALTER TABLE ADR.HANDBOOK_DOCUMENT ADD (
  CONSTRAINT SYS_C00186897
  CHECK ("HANDBOOK_DOCUMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_DOCUMENT
  DROP CONSTRAINT SYS_C00186898;

ALTER TABLE ADR.HANDBOOK_DOCUMENT ADD (
  CONSTRAINT SYS_C00186898
  CHECK ("HANDBOOK_MAIL_STATUS_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_DOCUMENT
  DROP CONSTRAINT SYS_C00186903;

ALTER TABLE ADR.HANDBOOK_DOCUMENT ADD (
  CONSTRAINT SYS_C00186903
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_DOCUMENT
  DROP CONSTRAINT SYS_C00186900;

ALTER TABLE ADR.HANDBOOK_DOCUMENT ADD (
  CONSTRAINT SYS_C00186900
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_DOCUMENT
  DROP CONSTRAINT SYS_C00186901;

ALTER TABLE ADR.HANDBOOK_DOCUMENT ADD (
  CONSTRAINT SYS_C00186901
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL
  DROP CONSTRAINT SYS_C0067439;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL ADD (
  CONSTRAINT SYS_C0067439
  CHECK ("FINANCIAL_INCOME_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL
  DROP CONSTRAINT SYS_C0067443;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL ADD (
  CONSTRAINT SYS_C0067443
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL
  DROP CONSTRAINT SYS_C0067437;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL ADD (
  CONSTRAINT SYS_C0067437
  CHECK ("FINANCIAL_INCOME_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL
  DROP CONSTRAINT SYS_C0067438;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL ADD (
  CONSTRAINT SYS_C0067438
  CHECK ("FINANCIAL_STATEMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL
  DROP CONSTRAINT SYS_C0067444;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL ADD (
  CONSTRAINT SYS_C0067444
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL
  DROP CONSTRAINT SYS_C0067440;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL ADD (
  CONSTRAINT SYS_C0067440
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL
  DROP CONSTRAINT SYS_C0067441;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL ADD (
  CONSTRAINT SYS_C0067441
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL
  DROP CONSTRAINT SYS_C0067442;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL ADD (
  CONSTRAINT SYS_C0067442
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_054;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_054
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H
  DROP CONSTRAINT SYS_C0066985;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H ADD (
  CONSTRAINT SYS_C0066985
  CHECK ("EGT_SETTING_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H
  DROP CONSTRAINT SYS_C0066981;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H ADD (
  CONSTRAINT SYS_C0066981
  CHECK ("ENROLLMENT_DETERMINATION_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H
  DROP CONSTRAINT SYS_C0066982;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H ADD (
  CONSTRAINT SYS_C0066982
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H
  DROP CONSTRAINT SYS_C0066983;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H ADD (
  CONSTRAINT SYS_C0066983
  CHECK ("ENROLLMENT_DETERMINATION_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H
  DROP CONSTRAINT SYS_C0066984;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H ADD (
  CONSTRAINT SYS_C0066984
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H
  DROP CONSTRAINT SYS_C0066991;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H ADD (
  CONSTRAINT SYS_C0066991
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H
  DROP CONSTRAINT SYS_C0066986;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H ADD (
  CONSTRAINT SYS_C0066986
  CHECK ("ENROLLMENT_OVERRIDDEN_FLAG" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H
  DROP CONSTRAINT SYS_C0066987;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H ADD (
  CONSTRAINT SYS_C0066987
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H
  DROP CONSTRAINT SYS_C0066988;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H ADD (
  CONSTRAINT SYS_C0066988
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H
  DROP CONSTRAINT SYS_C0066989;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H ADD (
  CONSTRAINT SYS_C0066989
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H
  DROP CONSTRAINT SYS_C0066990;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION_H ADD (
  CONSTRAINT SYS_C0066990
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE MODIFY 
  HEALTH_BENEFIT_PROFILE_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE MODIFY 
  HEALTH_BENEFIT_PROFILE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H MODIFY 
  HEALTH_BENEFIT_PLAN_H_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H MODIFY 
  HEALTH_BENEFIT_PLAN_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H MODIFY 
  HEALTH_BENEFIT_PLAN_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H MODIFY 
  HEALTH_BENEFIT_PLAN_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN MODIFY 
  HEALTH_BENEFIT_PLAN_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN MODIFY 
  HEALTH_BENEFIT_PLAN_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN MODIFY 
  HEALTH_BENEFIT_PROFILE_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN MODIFY 
  HEALTH_BENEFIT_PROFILE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN MODIFY 
  STD_HEALTHBENEFITPLAN_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN MODIFY 
  STD_HEALTHBENEFITPLAN_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN MODIFY 
  STD_DATACHANGESOURCE_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN MODIFY 
  STD_DATACHANGESOURCE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_ARCHIVE MODIFY 
  IVM_MIGRATE_ID NULL;

ALTER TABLE ADR.IVM_MIGRATE_ARCHIVE MODIFY 
  IVM_MIGRATE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_ARCHIVE MODIFY 
  IVM_MIGRATE_ARCHIVE_ID NULL;

ALTER TABLE ADR.IVM_MIGRATE_ARCHIVE MODIFY 
  IVM_MIGRATE_ARCHIVE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_ARCHIVE MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.IVM_MIGRATE_ARCHIVE MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_ARCHIVE MODIFY 
  MARKED_FLAG NULL;

ALTER TABLE ADR.IVM_MIGRATE_ARCHIVE MODIFY 
  MARKED_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_ARCHIVE MODIFY 
  REMIGRATE_FLAG NULL;

ALTER TABLE ADR.IVM_MIGRATE_ARCHIVE MODIFY 
  REMIGRATE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_ARCHIVE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.IVM_MIGRATE_ARCHIVE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_ARCHIVE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.IVM_MIGRATE_ARCHIVE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_ARCHIVE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.IVM_MIGRATE_ARCHIVE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_ARCHIVE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.IVM_MIGRATE_ARCHIVE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IVM_MIGRATE_ARCHIVE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.IVM_MIGRATE_ARCHIVE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC MODIFY 
  HEALTH_BENEFIT_PLAN_DETAIL_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC MODIFY 
  HEALTH_BENEFIT_PLAN_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC MODIFY 
  HLTH_BEN_PLAN_DESC_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC MODIFY 
  HLTH_BEN_PLAN_DESC_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC MODIFY 
  HLTH_BEN_PLAN_DESCRIPTION NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC MODIFY 
  HLTH_BEN_PLAN_DESCRIPTION NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H MODIFY 
  HEALTH_BENEFIT_PLAN_DETAIL_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H MODIFY 
  HEALTH_BENEFIT_PLAN_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H MODIFY 
  HLTH_BEN_PLAN_DESC_H_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H MODIFY 
  HLTH_BEN_PLAN_DESC_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H MODIFY 
  HLTH_BEN_PLAN_DESC_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H MODIFY 
  HLTH_BEN_PLAN_DESC_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DESC_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_FORM_TYPE MODIFY 
  RPT_FORM_TYPE_ID NULL;

ALTER TABLE ADR.RPT_FORM_TYPE MODIFY 
  RPT_FORM_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_FORM_TYPE MODIFY 
  RPT_SCHEDULED_REPORT_ID NULL;

ALTER TABLE ADR.RPT_FORM_TYPE MODIFY 
  RPT_SCHEDULED_REPORT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_FORM_TYPE MODIFY 
  ENROLLMENT_FORM_TYPE_ID NULL;

ALTER TABLE ADR.RPT_FORM_TYPE MODIFY 
  ENROLLMENT_FORM_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_FORM_TYPE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_FORM_TYPE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_FORM_TYPE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_FORM_TYPE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_FORM_TYPE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_FORM_TYPE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_FORM_TYPE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_FORM_TYPE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_FORM_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_FORM_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR MODIFY 
  CAT_DSBLTY_DESCRIPTOR_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR MODIFY 
  CAT_DSBLTY_DESCRIPTOR_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR MODIFY 
  CATASTROPHIC_DISABILITY_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR MODIFY 
  CATASTROPHIC_DISABILITY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR MODIFY 
  DESCRIPTOR_TYPE_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR MODIFY 
  DESCRIPTOR_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H MODIFY 
  CAT_DSBLTY_DESCRIPTOR_ID_H NULL;

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H MODIFY 
  CAT_DSBLTY_DESCRIPTOR_ID_H NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H MODIFY 
  CAT_DSBLTY_DESCRIPTOR_ID NULL;

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H MODIFY 
  CAT_DSBLTY_DESCRIPTOR_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.CAT_DSBLTY_DESCRIPTOR_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE MODIFY 
  PERSON_PREFERRED_LANGUAGE_ID NULL;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE MODIFY 
  PERSON_PREFERRED_LANGUAGE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE MODIFY 
  STD_LANGUAGECODE_ID NULL;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE MODIFY 
  STD_LANGUAGECODE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE MODIFY 
  LANGUAGE_ENTRY_DATE NULL;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE MODIFY 
  LANGUAGE_ENTRY_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  PERSON_PREFERRED_LANG_H_ID NULL;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  PERSON_PREFERRED_LANG_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  PERSON_PREFERRED_LANGUAGE_ID NULL;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  PERSON_PREFERRED_LANGUAGE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  STD_LANGUAGECODE_ID NULL;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  STD_LANGUAGECODE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  LANGUAGE_ENTRY_DATE NULL;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  LANGUAGE_ENTRY_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME MODIFY 
  HLTH_BEN_PLAN_NAME_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME MODIFY 
  HLTH_BEN_PLAN_NAME_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME MODIFY 
  HLTH_BEN_PLAN_NAME NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME MODIFY 
  HLTH_BEN_PLAN_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME MODIFY 
  STD_HLTHBENEFITPLANTYPE_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME MODIFY 
  STD_HLTHBENEFITPLANTYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H MODIFY 
  HLTH_BEN_PLAN_NAME_H_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H MODIFY 
  HLTH_BEN_PLAN_NAME_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H MODIFY 
  HLTH_BEN_PLAN_NAME_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H MODIFY 
  HLTH_BEN_PLAN_NAME_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H MODIFY 
  HLTH_BEN_PLAN_NAME NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H MODIFY 
  HLTH_BEN_PLAN_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H MODIFY 
  STD_HLTHBENEFITPLANTYPE_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H MODIFY 
  STD_HLTHBENEFITPLANTYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_NAME_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL MODIFY 
  HEALTH_BENEFIT_PLAN_DETAIL_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL MODIFY 
  HEALTH_BENEFIT_PLAN_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL MODIFY 
  HLTH_BEN_PLAN_NAME_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL MODIFY 
  HLTH_BEN_PLAN_NAME_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL MODIFY 
  HLTH_BEN_PLAN_EFF_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL MODIFY 
  HLTH_BEN_PLAN_EFF_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL MODIFY 
  HLTH_BEN_PLAN_AUTO_IND NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL MODIFY 
  HLTH_BEN_PLAN_AUTO_IND NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  HEALTH_BENEFIT_PLAN_DET_H_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  HEALTH_BENEFIT_PLAN_DET_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  HEALTH_BENEFIT_PLAN_DETAIL_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  HEALTH_BENEFIT_PLAN_DETAIL_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  HLTH_BEN_PLAN_NAME_ID NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  HLTH_BEN_PLAN_NAME_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  HLTH_BEN_PLAN_EFF_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  HLTH_BEN_PLAN_EFF_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  HLTH_BEN_PLAN_AUTO_IND NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  HLTH_BEN_PLAN_AUTO_IND NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.HEALTH_BENEFIT_PLAN_DETAIL_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CL_VERIFICATION_METHOD MODIFY 
  CL_VERIFICATION_METHOD_ID NULL;

ALTER TABLE ADR.CL_VERIFICATION_METHOD MODIFY 
  CL_VERIFICATION_METHOD_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CL_VERIFICATION_METHOD MODIFY 
  SPECIAL_FACTOR_ID NULL;

ALTER TABLE ADR.CL_VERIFICATION_METHOD MODIFY 
  SPECIAL_FACTOR_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CL_VERIFICATION_METHOD MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CL_VERIFICATION_METHOD MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CL_VERIFICATION_METHOD MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CL_VERIFICATION_METHOD MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CL_VERIFICATION_METHOD MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CL_VERIFICATION_METHOD MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CL_VERIFICATION_METHOD MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CL_VERIFICATION_METHOD MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CL_VERIFICATION_METHOD MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CL_VERIFICATION_METHOD MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CL_VERIFICATION_METHOD_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CL_VERIFICATION_METHOD_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CL_VERIFICATION_METHOD_H MODIFY 
  CL_VERIFICATION_METHOD_H_ID NULL;

ALTER TABLE ADR.CL_VERIFICATION_METHOD_H MODIFY 
  CL_VERIFICATION_METHOD_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CL_VERIFICATION_METHOD_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.CL_VERIFICATION_METHOD_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CL_VERIFICATION_METHOD_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.CL_VERIFICATION_METHOD_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON MODIFY 
  ELIGIBILITY_STATUS_REASON_ID NULL;

ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON MODIFY 
  ELIGIBILITY_STATUS_REASON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON MODIFY 
  CODE NULL;

ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON MODIFY 
  CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON MODIFY 
  NAME NULL;

ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON MODIFY 
  ISACTIVE NULL;

ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON MODIFY 
  ISACTIVE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.ELIGIBILITY_STATUS_REASON MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ACTIVEAGG MODIFY 
  RECORD_CREATED_TS NULL;

ALTER TABLE ADR.ACTIVEAGG MODIFY 
  RECORD_CREATED_TS NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ACTIVEAGG_TRACKER MODIFY 
  ACTIVEAGG_TRACKER_ID NULL;

ALTER TABLE ADR.ACTIVEAGG_TRACKER MODIFY 
  ACTIVEAGG_TRACKER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ACTIVEAGG_TRACKER MODIFY 
  PREVIOUS_ACTIVE_DATE NULL;

ALTER TABLE ADR.ACTIVEAGG_TRACKER MODIFY 
  PREVIOUS_ACTIVE_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ACTIVEAGG_TRACKER MODIFY 
  CURRENT_ACTIVE_DATE NULL;

ALTER TABLE ADR.ACTIVEAGG_TRACKER MODIFY 
  CURRENT_ACTIVE_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ACTIVEAGG_TRACKER MODIFY 
  RECORD_CREATED_TS NULL;

ALTER TABLE ADR.ACTIVEAGG_TRACKER MODIFY 
  RECORD_CREATED_TS NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ACTIVEAGG_TRACKER MODIFY 
  RECORD_MODIFIED_TS NULL;

ALTER TABLE ADR.ACTIVEAGG_TRACKER MODIFY 
  RECORD_MODIFIED_TS NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.ACTIVEAGG_TRACKER
  DROP CONSTRAINT LOADING_STATUS_CHK;

ALTER TABLE ADR.ACTIVEAGG_TRACKER ADD (
  CONSTRAINT LOADING_STATUS_CHK
  CHECK (LOADING_STATUS IN ('YES','FAIL'))
  ENABLE VALIDATE);
ALTER TABLE ADR.IRS_TRANSMISSION_LOG MODIFY 
  IRS_TRANSMISSION_LOG_ID NULL;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG MODIFY 
  IRS_TRANSMISSION_LOG_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IRS_TRANSMISSION_LOG MODIFY 
  TRANSMISSION_STATUS_ID NULL;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG MODIFY 
  TRANSMISSION_STATUS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IRS_TRANSMISSION_LOG MODIFY 
  TRANSMISSION_DATE NULL;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG MODIFY 
  TRANSMISSION_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IRS_TRANSMISSION_LOG MODIFY 
  BATCH_TYPE_IND NULL;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG MODIFY 
  BATCH_TYPE_IND NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IRS_TRANSMISSION_LOG MODIFY 
  YEAR NULL;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG MODIFY 
  YEAR NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IRS_TRANSMISSION_LOG MODIFY 
  CORRECTION_IND NULL;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG MODIFY 
  CORRECTION_IND NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IRS_TRANSMISSION_LOG MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IRS_TRANSMISSION_LOG MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IRS_TRANSMISSION_LOG MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IRS_TRANSMISSION_LOG MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IRS_TRANSMISSION_LOG MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.IRS_TRANSMISSION_LOG MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TRANSMISSION_STATUS MODIFY 
  TRANSMISSION_STATUS_ID NULL;

ALTER TABLE ADR.TRANSMISSION_STATUS MODIFY 
  TRANSMISSION_STATUS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TRANSMISSION_STATUS MODIFY 
  CODE NULL;

ALTER TABLE ADR.TRANSMISSION_STATUS MODIFY 
  CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TRANSMISSION_STATUS MODIFY 
  NAME NULL;

ALTER TABLE ADR.TRANSMISSION_STATUS MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TRANSMISSION_STATUS MODIFY 
  DESCRIPTION NULL;

ALTER TABLE ADR.TRANSMISSION_STATUS MODIFY 
  DESCRIPTION NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TRANSMISSION_STATUS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.TRANSMISSION_STATUS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TRANSMISSION_STATUS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.TRANSMISSION_STATUS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TRANSMISSION_STATUS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.TRANSMISSION_STATUS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TRANSMISSION_STATUS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.TRANSMISSION_STATUS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TRANSMISSION_STATUS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.TRANSMISSION_STATUS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IRS_TRANSMISSION_DATA MODIFY 
  IRS_TRANSMISSION_DATA_ID NULL;

ALTER TABLE ADR.IRS_TRANSMISSION_DATA MODIFY 
  IRS_TRANSMISSION_DATA_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IRS_TRANSMISSION_DATA MODIFY 
  IRS_TRANSMISSION_LOG_ID NULL;

ALTER TABLE ADR.IRS_TRANSMISSION_DATA MODIFY 
  IRS_TRANSMISSION_LOG_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IRS_TRANSMISSION_DATA MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.IRS_TRANSMISSION_DATA MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IRS_TRANSMISSION_DATA MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.IRS_TRANSMISSION_DATA MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IRS_TRANSMISSION_DATA MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.IRS_TRANSMISSION_DATA MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IRS_TRANSMISSION_DATA MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.IRS_TRANSMISSION_DATA MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.IRS_TRANSMISSION_DATA MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.IRS_TRANSMISSION_DATA MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_TYPE MODIFY 
  CODE NULL;

ALTER TABLE ADR.CORRESPONDENCE_TYPE MODIFY 
  CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_TYPE MODIFY 
  NAME NULL;

ALTER TABLE ADR.CORRESPONDENCE_TYPE MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_TYPE MODIFY 
  DESCRIPTION NULL;

ALTER TABLE ADR.CORRESPONDENCE_TYPE MODIFY 
  DESCRIPTION NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_TYPE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CORRESPONDENCE_TYPE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_TYPE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CORRESPONDENCE_TYPE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_TYPE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CORRESPONDENCE_TYPE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_TYPE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CORRESPONDENCE_TYPE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CORRESPONDENCE_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_STATUS MODIFY 
  CODE NULL;

ALTER TABLE ADR.CORRESPONDENCE_STATUS MODIFY 
  CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_STATUS MODIFY 
  NAME NULL;

ALTER TABLE ADR.CORRESPONDENCE_STATUS MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_STATUS MODIFY 
  DESCRIPTION NULL;

ALTER TABLE ADR.CORRESPONDENCE_STATUS MODIFY 
  DESCRIPTION NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_STATUS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CORRESPONDENCE_STATUS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_STATUS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CORRESPONDENCE_STATUS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_STATUS MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CORRESPONDENCE_STATUS MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_STATUS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CORRESPONDENCE_STATUS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_STATUS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CORRESPONDENCE_STATUS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_DOCUMENT MODIFY 
  CORRESPONDENCE_DOCUMENT_ID NULL;

ALTER TABLE ADR.CORRESPONDENCE_DOCUMENT MODIFY 
  CORRESPONDENCE_DOCUMENT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_DOCUMENT MODIFY 
  DOCUMENT_FILENAME NULL;

ALTER TABLE ADR.CORRESPONDENCE_DOCUMENT MODIFY 
  DOCUMENT_FILENAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_DOCUMENT MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CORRESPONDENCE_DOCUMENT MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_DOCUMENT MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CORRESPONDENCE_DOCUMENT MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_DOCUMENT MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CORRESPONDENCE_DOCUMENT MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_DOCUMENT MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CORRESPONDENCE_DOCUMENT MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_DOCUMENT MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CORRESPONDENCE_DOCUMENT MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE MODIFY 
  CORRESPONDENCE_TYPE_ID NULL;

ALTER TABLE ADR.CORRESPONDENCE MODIFY 
  CORRESPONDENCE_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE MODIFY 
  CORRESPONDENCE_STATUS_ID NULL;

ALTER TABLE ADR.CORRESPONDENCE MODIFY 
  CORRESPONDENCE_STATUS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.CORRESPONDENCE MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CORRESPONDENCE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CORRESPONDENCE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CORRESPONDENCE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CORRESPONDENCE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CORRESPONDENCE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_H MODIFY 
  CORRESPONDENCE_H_ID NULL;

ALTER TABLE ADR.CORRESPONDENCE_H MODIFY 
  CORRESPONDENCE_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_H MODIFY 
  CORRESPONDENCE_ID NULL;

ALTER TABLE ADR.CORRESPONDENCE_H MODIFY 
  CORRESPONDENCE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CORRESPONDENCE_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CORRESPONDENCE_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CORRESPONDENCE_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CORRESPONDENCE_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CORRESPONDENCE_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.CORRESPONDENCE_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CORRESPONDENCE_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.CORRESPONDENCE_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCESTATUSTYPE MODIFY 
  VCESTATUSTYPE_ID NULL;

ALTER TABLE ADR.VCESTATUSTYPE MODIFY 
  VCESTATUSTYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCESTATUSTYPE MODIFY 
  CODE NULL;

ALTER TABLE ADR.VCESTATUSTYPE MODIFY 
  CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCESTATUSTYPE MODIFY 
  NAME NULL;

ALTER TABLE ADR.VCESTATUSTYPE MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCESTATUSTYPE MODIFY 
  CREATED NULL;

ALTER TABLE ADR.VCESTATUSTYPE MODIFY 
  CREATED NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCESTATUSTYPE MODIFY 
  CREATEDBY NULL;

ALTER TABLE ADR.VCESTATUSTYPE MODIFY 
  CREATEDBY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTYPE MODIFY 
  WAITTYPE_ID NULL;

ALTER TABLE ADR.WAITTYPE MODIFY 
  WAITTYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTYPE MODIFY 
  CODE NULL;

ALTER TABLE ADR.WAITTYPE MODIFY 
  CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTYPE MODIFY 
  NAME NULL;

ALTER TABLE ADR.WAITTYPE MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTYPE MODIFY 
  CREATED NULL;

ALTER TABLE ADR.WAITTYPE MODIFY 
  CREATED NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTYPE MODIFY 
  CREATEDBY NULL;

ALTER TABLE ADR.WAITTYPE MODIFY 
  CREATEDBY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CASSCERTIFIEDTYPE MODIFY 
  CASSCERTIFIEDTYPE_ID NULL;

ALTER TABLE ADR.CASSCERTIFIEDTYPE MODIFY 
  CASSCERTIFIEDTYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CASSCERTIFIEDTYPE MODIFY 
  CODE NULL;

ALTER TABLE ADR.CASSCERTIFIEDTYPE MODIFY 
  CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CASSCERTIFIEDTYPE MODIFY 
  NAME NULL;

ALTER TABLE ADR.CASSCERTIFIEDTYPE MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CASSCERTIFIEDTYPE MODIFY 
  CREATED NULL;

ALTER TABLE ADR.CASSCERTIFIEDTYPE MODIFY 
  CREATED NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CASSCERTIFIEDTYPE MODIFY 
  CREATEDBY NULL;

ALTER TABLE ADR.CASSCERTIFIEDTYPE MODIFY 
  CREATEDBY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCADMISTATUS_TYPE MODIFY 
  VCADMISTATUS_TYPE_ID NULL;

ALTER TABLE ADR.VCADMISTATUS_TYPE MODIFY 
  VCADMISTATUS_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCADMISTATUS_TYPE MODIFY 
  CODE NULL;

ALTER TABLE ADR.VCADMISTATUS_TYPE MODIFY 
  CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCADMISTATUS_TYPE MODIFY 
  NAME NULL;

ALTER TABLE ADR.VCADMISTATUS_TYPE MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCADMISTATUS_TYPE MODIFY 
  CREATED NULL;

ALTER TABLE ADR.VCADMISTATUS_TYPE MODIFY 
  CREATED NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCADMISTATUS_TYPE MODIFY 
  CREATEDBY NULL;

ALTER TABLE ADR.VCADMISTATUS_TYPE MODIFY 
  CREATEDBY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCADMIN MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.VCADMIN MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCADMIN MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.VCADMIN MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCADMIN MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.VCADMIN MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCADMIN MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.VCADMIN MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCADMIN MODIFY 
  VCADMISTATUS_TYPE_ID NULL;

ALTER TABLE ADR.VCADMIN MODIFY 
  VCADMISTATUS_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCADMIN MODIFY 
  VCADMIN_ID NULL;

ALTER TABLE ADR.VCADMIN MODIFY 
  VCADMIN_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCADMIN MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.VCADMIN MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCADMIN MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.VCADMIN MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCADMIN_H MODIFY 
  VCADMIN_H_ID NULL;

ALTER TABLE ADR.VCADMIN_H MODIFY 
  VCADMIN_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCADMIN_H MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.VCADMIN_H MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCADMIN_H MODIFY 
  VCADMISTATUS_TYPE_ID NULL;

ALTER TABLE ADR.VCADMIN_H MODIFY 
  VCADMISTATUS_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCADMIN_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.VCADMIN_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCADMIN_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.VCADMIN_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCADMIN_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.VCADMIN_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCADMIN_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.VCADMIN_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCADMIN_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.VCADMIN_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCADMIN_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.VCADMIN_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCELIGIBILITY MODIFY 
  VCELIGIBILITY_ID NULL;

ALTER TABLE ADR.VCELIGIBILITY MODIFY 
  VCELIGIBILITY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCELIGIBILITY MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.VCELIGIBILITY MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCELIGIBILITY MODIFY 
  VCESTATUSTYPE_ID NULL;

ALTER TABLE ADR.VCELIGIBILITY MODIFY 
  VCESTATUSTYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCELIGIBILITY MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.VCELIGIBILITY MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCELIGIBILITY MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.VCELIGIBILITY MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCELIGIBILITY MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.VCELIGIBILITY MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCELIGIBILITY MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.VCELIGIBILITY MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCELIGIBILITY MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.VCELIGIBILITY MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCELIGIBILITY_H MODIFY 
  VCELIGIBILITY_H_ID NULL;

ALTER TABLE ADR.VCELIGIBILITY_H MODIFY 
  VCELIGIBILITY_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCELIGIBILITY_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.VCELIGIBILITY_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCELIGIBILITY_H MODIFY 
  VCELIGIBILITY_ID NULL;

ALTER TABLE ADR.VCELIGIBILITY_H MODIFY 
  VCELIGIBILITY_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCELIGIBILITY_H MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.VCELIGIBILITY_H MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCELIGIBILITY_H MODIFY 
  VCESTATUSTYPE_ID NULL;

ALTER TABLE ADR.VCELIGIBILITY_H MODIFY 
  VCESTATUSTYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCELIGIBILITY_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.VCELIGIBILITY_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCELIGIBILITY_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.VCELIGIBILITY_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCELIGIBILITY_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.VCELIGIBILITY_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCELIGIBILITY_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.VCELIGIBILITY_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.VCELIGIBILITY_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.VCELIGIBILITY_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_STATION MODIFY 
  GEOCODE_STATION_ID NULL;

ALTER TABLE ADR.GEOCODE_STATION MODIFY 
  GEOCODE_STATION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_STATION MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.GEOCODE_STATION MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_STATION MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.GEOCODE_STATION MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_STATION MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.GEOCODE_STATION MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_STATION MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.GEOCODE_STATION MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_STATION MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.GEOCODE_STATION MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_STAGE MODIFY 
  WAITTIME_STAGE_ID NULL;

ALTER TABLE ADR.WAITTIME_STAGE MODIFY 
  WAITTIME_STAGE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_STAGE MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.WAITTIME_STAGE MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_STAGE MODIFY 
  WAITTYPE_ID NULL;

ALTER TABLE ADR.WAITTIME_STAGE MODIFY 
  WAITTYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_STAGE MODIFY 
  STD_INSTITUTION_ID NULL;

ALTER TABLE ADR.WAITTIME_STAGE MODIFY 
  STD_INSTITUTION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_STAGE MODIFY 
  WAITLIST_START_DATE NULL;

ALTER TABLE ADR.WAITTIME_STAGE MODIFY 
  WAITLIST_START_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_STAGE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.WAITTIME_STAGE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_STAGE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.WAITTIME_STAGE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_STAGE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.WAITTIME_STAGE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_STAGE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.WAITTIME_STAGE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_STAGE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.WAITTIME_STAGE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_STAGE MODIFY 
  GEOCODE_STAGE_ID NULL;

ALTER TABLE ADR.GEOCODE_STAGE MODIFY 
  GEOCODE_STAGE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_STAGE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.GEOCODE_STAGE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_STAGE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.GEOCODE_STAGE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_STAGE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.GEOCODE_STAGE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_STAGE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.GEOCODE_STAGE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_STAGE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.GEOCODE_STAGE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEC_PERIOD_NEW MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.MEC_PERIOD_NEW MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEC_PERIOD_NEW MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.MEC_PERIOD_NEW MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEC_PERIOD_NEW MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.MEC_PERIOD_NEW MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEC_PERIOD_NEW MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.MEC_PERIOD_NEW MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEC_PERIOD_NEW MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.MEC_PERIOD_NEW MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MEC_PERIOD_NEW MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.MEC_PERIOD_NEW MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SELF_IDENTIFIED_GENDER MODIFY 
  SELF_IDENTIFIED_GENDER_ID NULL;

ALTER TABLE ADR.SELF_IDENTIFIED_GENDER MODIFY 
  SELF_IDENTIFIED_GENDER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SELF_IDENTIFIED_GENDER MODIFY 
  CODE NULL;

ALTER TABLE ADR.SELF_IDENTIFIED_GENDER MODIFY 
  CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SELF_IDENTIFIED_GENDER MODIFY 
  NAME NULL;

ALTER TABLE ADR.SELF_IDENTIFIED_GENDER MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SELF_IDENTIFIED_GENDER MODIFY 
  DESCRIPTION NULL;

ALTER TABLE ADR.SELF_IDENTIFIED_GENDER MODIFY 
  DESCRIPTION NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SELF_IDENTIFIED_GENDER MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.SELF_IDENTIFIED_GENDER MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SELF_IDENTIFIED_GENDER MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.SELF_IDENTIFIED_GENDER MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SELF_IDENTIFIED_GENDER MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.SELF_IDENTIFIED_GENDER MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SELF_IDENTIFIED_GENDER MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.SELF_IDENTIFIED_GENDER MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.SELF_IDENTIFIED_GENDER MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.SELF_IDENTIFIED_GENDER MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME MODIFY 
  WAITTIME_ID NULL;

ALTER TABLE ADR.WAITTIME MODIFY 
  WAITTIME_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.WAITTIME MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME MODIFY 
  WAITTYPE_ID NULL;

ALTER TABLE ADR.WAITTIME MODIFY 
  WAITTYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME MODIFY 
  STD_INSTITUTION_ID NULL;

ALTER TABLE ADR.WAITTIME MODIFY 
  STD_INSTITUTION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME MODIFY 
  WAITLIST_START_DATE NULL;

ALTER TABLE ADR.WAITTIME MODIFY 
  WAITLIST_START_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.WAITTIME MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.WAITTIME MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.WAITTIME MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.WAITTIME MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.WAITTIME MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_TRANSMIT MODIFY 
  GEOCODE_TRANSMIT_ID NULL;

ALTER TABLE ADR.GEOCODE_TRANSMIT MODIFY 
  GEOCODE_TRANSMIT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_TRANSMIT MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.GEOCODE_TRANSMIT MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_TRANSMIT MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.GEOCODE_TRANSMIT MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_TRANSMIT MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.GEOCODE_TRANSMIT MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_TRANSMIT MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.GEOCODE_TRANSMIT MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_TRANSMIT MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.GEOCODE_TRANSMIT MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_ARCHIVE MODIFY 
  WAITTIME_ID NULL;

ALTER TABLE ADR.WAITTIME_ARCHIVE MODIFY 
  WAITTIME_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_ARCHIVE MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.WAITTIME_ARCHIVE MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_ARCHIVE MODIFY 
  WAITTYPE_ID NULL;

ALTER TABLE ADR.WAITTIME_ARCHIVE MODIFY 
  WAITTYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_ARCHIVE MODIFY 
  STD_INSTITUTION_ID NULL;

ALTER TABLE ADR.WAITTIME_ARCHIVE MODIFY 
  STD_INSTITUTION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_ARCHIVE MODIFY 
  WAITLIST_START_DATE NULL;

ALTER TABLE ADR.WAITTIME_ARCHIVE MODIFY 
  WAITLIST_START_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_ARCHIVE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.WAITTIME_ARCHIVE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_ARCHIVE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.WAITTIME_ARCHIVE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_ARCHIVE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.WAITTIME_ARCHIVE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_ARCHIVE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.WAITTIME_ARCHIVE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_ARCHIVE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.WAITTIME_ARCHIVE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE MODIFY 
  GEOCODE_TRANSMIT_ID NULL;

ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE MODIFY 
  GEOCODE_TRANSMIT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.GEOCODE_TRANSMIT_ARCHIVE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MONETARY_BENEFIT_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_046;

ALTER TABLE ADR.MONETARY_BENEFIT_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_046
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_H
  DROP CONSTRAINT SYS_C0066814;

ALTER TABLE ADR.MONETARY_BENEFIT_H ADD (
  CONSTRAINT SYS_C0066814
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_H
  DROP CONSTRAINT SYS_C0066811;

ALTER TABLE ADR.MONETARY_BENEFIT_H ADD (
  CONSTRAINT SYS_C0066811
  CHECK ("MONETARY_BENEFIT_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_H
  DROP CONSTRAINT SYS_C0066812;

ALTER TABLE ADR.MONETARY_BENEFIT_H ADD (
  CONSTRAINT SYS_C0066812
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_H
  DROP CONSTRAINT SYS_C0066813;

ALTER TABLE ADR.MONETARY_BENEFIT_H ADD (
  CONSTRAINT SYS_C0066813
  CHECK ("MONETARY_BENEFIT_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_H
  DROP CONSTRAINT SYS_C0066819;

ALTER TABLE ADR.MONETARY_BENEFIT_H ADD (
  CONSTRAINT SYS_C0066819
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_H
  DROP CONSTRAINT SYS_C0066815;

ALTER TABLE ADR.MONETARY_BENEFIT_H ADD (
  CONSTRAINT SYS_C0066815
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_H
  DROP CONSTRAINT SYS_C0066816;

ALTER TABLE ADR.MONETARY_BENEFIT_H ADD (
  CONSTRAINT SYS_C0066816
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_H
  DROP CONSTRAINT SYS_C0066817;

ALTER TABLE ADR.MONETARY_BENEFIT_H ADD (
  CONSTRAINT SYS_C0066817
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_H
  DROP CONSTRAINT SYS_C0066818;

ALTER TABLE ADR.MONETARY_BENEFIT_H ADD (
  CONSTRAINT SYS_C0066818
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_076;

ALTER TABLE ADR.EMAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_076
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMAIL_H
  DROP CONSTRAINT SYS_C0067586;

ALTER TABLE ADR.EMAIL_H ADD (
  CONSTRAINT SYS_C0067586
  CHECK ("EMAIL_ADDRESS" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMAIL_H
  DROP CONSTRAINT SYS_C0067591;

ALTER TABLE ADR.EMAIL_H ADD (
  CONSTRAINT SYS_C0067591
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMAIL_H
  DROP CONSTRAINT SYS_C0067583;

ALTER TABLE ADR.EMAIL_H ADD (
  CONSTRAINT SYS_C0067583
  CHECK ("EMAIL_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMAIL_H
  DROP CONSTRAINT SYS_C0067584;

ALTER TABLE ADR.EMAIL_H ADD (
  CONSTRAINT SYS_C0067584
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMAIL_H
  DROP CONSTRAINT SYS_C0067585;

ALTER TABLE ADR.EMAIL_H ADD (
  CONSTRAINT SYS_C0067585
  CHECK ("EMAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMAIL_H
  DROP CONSTRAINT SYS_C0067587;

ALTER TABLE ADR.EMAIL_H ADD (
  CONSTRAINT SYS_C0067587
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMAIL_H
  DROP CONSTRAINT SYS_C0067588;

ALTER TABLE ADR.EMAIL_H ADD (
  CONSTRAINT SYS_C0067588
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMAIL_H
  DROP CONSTRAINT SYS_C0067589;

ALTER TABLE ADR.EMAIL_H ADD (
  CONSTRAINT SYS_C0067589
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMAIL_H
  DROP CONSTRAINT SYS_C0067590;

ALTER TABLE ADR.EMAIL_H ADD (
  CONSTRAINT SYS_C0067590
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_031;

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_031
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H
  DROP CONSTRAINT SYS_C0066540;

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H ADD (
  CONSTRAINT SYS_C0066540
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H
  DROP CONSTRAINT SYS_C0066537;

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H ADD (
  CONSTRAINT SYS_C0066537
  CHECK ("ELIGIBILITY_VERIFICATION_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H
  DROP CONSTRAINT SYS_C0066538;

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H ADD (
  CONSTRAINT SYS_C0066538
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H
  DROP CONSTRAINT SYS_C0066539;

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H ADD (
  CONSTRAINT SYS_C0066539
  CHECK ("ELIGIBILITY_VERIFICATION_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H
  DROP CONSTRAINT SYS_C0066545;

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H ADD (
  CONSTRAINT SYS_C0066545
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H
  DROP CONSTRAINT SYS_C0066541;

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H ADD (
  CONSTRAINT SYS_C0066541
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H
  DROP CONSTRAINT SYS_C0066542;

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H ADD (
  CONSTRAINT SYS_C0066542
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H
  DROP CONSTRAINT SYS_C0066543;

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H ADD (
  CONSTRAINT SYS_C0066543
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H
  DROP CONSTRAINT SYS_C0066544;

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION_H ADD (
  CONSTRAINT SYS_C0066544
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_NTR_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_069;

ALTER TABLE ADR.BENEFICIARY_NTR_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_069
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_NTR_H
  DROP CONSTRAINT SYS_C0067431;

ALTER TABLE ADR.BENEFICIARY_NTR_H ADD (
  CONSTRAINT SYS_C0067431
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_NTR_H
  DROP CONSTRAINT SYS_C0067428;

ALTER TABLE ADR.BENEFICIARY_NTR_H ADD (
  CONSTRAINT SYS_C0067428
  CHECK ("BENEFICIARY_NTR_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_NTR_H
  DROP CONSTRAINT SYS_C0067429;

ALTER TABLE ADR.BENEFICIARY_NTR_H ADD (
  CONSTRAINT SYS_C0067429
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_NTR_H
  DROP CONSTRAINT SYS_C0067430;

ALTER TABLE ADR.BENEFICIARY_NTR_H ADD (
  CONSTRAINT SYS_C0067430
  CHECK ("BENEFICIARY_NTR_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_NTR_H
  DROP CONSTRAINT SYS_C0067436;

ALTER TABLE ADR.BENEFICIARY_NTR_H ADD (
  CONSTRAINT SYS_C0067436
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_NTR_H
  DROP CONSTRAINT SYS_C0067432;

ALTER TABLE ADR.BENEFICIARY_NTR_H ADD (
  CONSTRAINT SYS_C0067432
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_NTR_H
  DROP CONSTRAINT SYS_C0067433;

ALTER TABLE ADR.BENEFICIARY_NTR_H ADD (
  CONSTRAINT SYS_C0067433
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_NTR_H
  DROP CONSTRAINT SYS_C0067434;

ALTER TABLE ADR.BENEFICIARY_NTR_H ADD (
  CONSTRAINT SYS_C0067434
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_NTR_H
  DROP CONSTRAINT SYS_C0067435;

ALTER TABLE ADR.BENEFICIARY_NTR_H ADD (
  CONSTRAINT SYS_C0067435
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL
  DROP CONSTRAINT SYS_C0066412;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL ADD (
  CONSTRAINT SYS_C0066412
  CHECK ("FINANCIAL_EXPENSE_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL
  DROP CONSTRAINT SYS_C0066416;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL ADD (
  CONSTRAINT SYS_C0066416
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL
  DROP CONSTRAINT SYS_C0066410;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL ADD (
  CONSTRAINT SYS_C0066410
  CHECK ("FINANCIAL_EXPENSE_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL
  DROP CONSTRAINT SYS_C0066411;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL ADD (
  CONSTRAINT SYS_C0066411
  CHECK ("FINANCIAL_STATEMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL
  DROP CONSTRAINT SYS_C0066417;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL ADD (
  CONSTRAINT SYS_C0066417
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL
  DROP CONSTRAINT SYS_C0066413;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL ADD (
  CONSTRAINT SYS_C0066413
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL
  DROP CONSTRAINT SYS_C0066414;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL ADD (
  CONSTRAINT SYS_C0066414
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL
  DROP CONSTRAINT SYS_C0066415;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL ADD (
  CONSTRAINT SYS_C0066415
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT
  DROP CONSTRAINT SYS_C0066084;

ALTER TABLE ADR.FINANCIAL_STATEMENT ADD (
  CONSTRAINT SYS_C0066084
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT
  DROP CONSTRAINT SYS_C0066083;

ALTER TABLE ADR.FINANCIAL_STATEMENT ADD (
  CONSTRAINT SYS_C0066083
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT
  DROP CONSTRAINT SYS_C0066085;

ALTER TABLE ADR.FINANCIAL_STATEMENT ADD (
  CONSTRAINT SYS_C0066085
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT
  DROP CONSTRAINT AVCON_1172521913_POST__000;

ALTER TABLE ADR.FINANCIAL_STATEMENT ADD (
  CONSTRAINT AVCON_1172521913_POST__000
  CHECK (POST_2005_DISPLAY_FORMAT_FLAG BETWEEN 0
AND 0 OR POST_2005_DISPLAY_FORMAT_FLAG BETWEEN 1 AND 1)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT
  DROP CONSTRAINT SYS_C0066082;

ALTER TABLE ADR.FINANCIAL_STATEMENT ADD (
  CONSTRAINT SYS_C0066082
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT
  DROP CONSTRAINT SYS_C0066079;

ALTER TABLE ADR.FINANCIAL_STATEMENT ADD (
  CONSTRAINT SYS_C0066079
  CHECK ("FINANCIAL_STATEMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT
  DROP CONSTRAINT SYS_C0066080;

ALTER TABLE ADR.FINANCIAL_STATEMENT ADD (
  CONSTRAINT SYS_C0066080
  CHECK ("POST_2005_DISPLAY_FORMAT_FLAG" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT
  DROP CONSTRAINT SYS_C0066081;

ALTER TABLE ADR.FINANCIAL_STATEMENT ADD (
  CONSTRAINT SYS_C0066081
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_070;

ALTER TABLE ADR.FINANCIAL_STATEMENT_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_070
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT_H
  DROP CONSTRAINT SYS_C0067448;

ALTER TABLE ADR.FINANCIAL_STATEMENT_H ADD (
  CONSTRAINT SYS_C0067448
  CHECK ("POST_2005_DISPLAY_FORMAT_FLAG" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT_H
  DROP CONSTRAINT SYS_C0067445;

ALTER TABLE ADR.FINANCIAL_STATEMENT_H ADD (
  CONSTRAINT SYS_C0067445
  CHECK ("FINANCIAL_STATEMENT_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT_H
  DROP CONSTRAINT SYS_C0067446;

ALTER TABLE ADR.FINANCIAL_STATEMENT_H ADD (
  CONSTRAINT SYS_C0067446
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT_H
  DROP CONSTRAINT SYS_C0067447;

ALTER TABLE ADR.FINANCIAL_STATEMENT_H ADD (
  CONSTRAINT SYS_C0067447
  CHECK ("FINANCIAL_STATEMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT_H
  DROP CONSTRAINT SYS_C0067453;

ALTER TABLE ADR.FINANCIAL_STATEMENT_H ADD (
  CONSTRAINT SYS_C0067453
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT_H
  DROP CONSTRAINT SYS_C0067449;

ALTER TABLE ADR.FINANCIAL_STATEMENT_H ADD (
  CONSTRAINT SYS_C0067449
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT_H
  DROP CONSTRAINT SYS_C0067450;

ALTER TABLE ADR.FINANCIAL_STATEMENT_H ADD (
  CONSTRAINT SYS_C0067450
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT_H
  DROP CONSTRAINT SYS_C0067451;

ALTER TABLE ADR.FINANCIAL_STATEMENT_H ADD (
  CONSTRAINT SYS_C0067451
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_STATEMENT_H
  DROP CONSTRAINT SYS_C0067452;

ALTER TABLE ADR.FINANCIAL_STATEMENT_H ADD (
  CONSTRAINT SYS_C0067452
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BROKER_SERVICE_LOG MODIFY 
  BROKER_SERVICE_LOG_ID NULL;

ALTER TABLE ADR.BROKER_SERVICE_LOG MODIFY 
  BROKER_SERVICE_LOG_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BROKER_SERVICE_LOG MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.BROKER_SERVICE_LOG MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BROKER_SERVICE_LOG MODIFY 
  TRANSMISSION_ID NULL;

ALTER TABLE ADR.BROKER_SERVICE_LOG MODIFY 
  TRANSMISSION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BROKER_SERVICE_LOG MODIFY 
  TRANSMISSION_DATE NULL;

ALTER TABLE ADR.BROKER_SERVICE_LOG MODIFY 
  TRANSMISSION_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BROKER_SERVICE_LOG MODIFY 
  RETRANSMISSION_COUNT NULL;

ALTER TABLE ADR.BROKER_SERVICE_LOG MODIFY 
  RETRANSMISSION_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BROKER_SERVICE_LOG MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.BROKER_SERVICE_LOG MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BROKER_SERVICE_LOG MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.BROKER_SERVICE_LOG MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BROKER_SERVICE_LOG MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.BROKER_SERVICE_LOG MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BROKER_SERVICE_LOG MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.BROKER_SERVICE_LOG MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.BROKER_SERVICE_LOG MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.BROKER_SERVICE_LOG MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MILITARY_SERVICE
  DROP CONSTRAINT SYS_C0067205;

ALTER TABLE ADR.MILITARY_SERVICE ADD (
  CONSTRAINT SYS_C0067205
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE
  DROP CONSTRAINT SYS_C0067209;

ALTER TABLE ADR.MILITARY_SERVICE ADD (
  CONSTRAINT SYS_C0067209
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE
  DROP CONSTRAINT SYS_C0067208;

ALTER TABLE ADR.MILITARY_SERVICE ADD (
  CONSTRAINT SYS_C0067208
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE
  DROP CONSTRAINT SYS_C0067207;

ALTER TABLE ADR.MILITARY_SERVICE ADD (
  CONSTRAINT SYS_C0067207
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE
  DROP CONSTRAINT SYS_C0067202;

ALTER TABLE ADR.MILITARY_SERVICE ADD (
  CONSTRAINT SYS_C0067202
  CHECK ("MILITARY_SERVICE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE
  DROP CONSTRAINT SYS_C0067203;

ALTER TABLE ADR.MILITARY_SERVICE ADD (
  CONSTRAINT SYS_C0067203
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE
  DROP CONSTRAINT SYS_C0067204;

ALTER TABLE ADR.MILITARY_SERVICE ADD (
  CONSTRAINT SYS_C0067204
  CHECK ("STD_INSTITUTION_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE
  DROP CONSTRAINT SYS_C0067206;

ALTER TABLE ADR.MILITARY_SERVICE ADD (
  CONSTRAINT SYS_C0067206
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INSURANCE
  DROP CONSTRAINT SYS_C0066179;

ALTER TABLE ADR.INSURANCE ADD (
  CONSTRAINT SYS_C0066179
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INSURANCE
  DROP CONSTRAINT SYS_C0066182;

ALTER TABLE ADR.INSURANCE ADD (
  CONSTRAINT SYS_C0066182
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INSURANCE
  DROP CONSTRAINT SYS_C0066181;

ALTER TABLE ADR.INSURANCE ADD (
  CONSTRAINT SYS_C0066181
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INSURANCE
  DROP CONSTRAINT SYS_C0066180;

ALTER TABLE ADR.INSURANCE ADD (
  CONSTRAINT SYS_C0066180
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INSURANCE
  DROP CONSTRAINT SYS_C0066178;

ALTER TABLE ADR.INSURANCE ADD (
  CONSTRAINT SYS_C0066178
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INSURANCE
  DROP CONSTRAINT SYS_C0066176;

ALTER TABLE ADR.INSURANCE ADD (
  CONSTRAINT SYS_C0066176
  CHECK ("INSURANCE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INSURANCE
  DROP CONSTRAINT SYS_C0066177;

ALTER TABLE ADR.INSURANCE ADD (
  CONSTRAINT SYS_C0066177
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_075;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_075
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H
  DROP CONSTRAINT SYS_C0067562;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H ADD (
  CONSTRAINT SYS_C0067562
  CHECK ("ENROLLMENT_DETERMINATION_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H
  DROP CONSTRAINT SYS_C0067559;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H ADD (
  CONSTRAINT SYS_C0067559
  CHECK ("ELIGIBILITY_DETERMINATION_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H
  DROP CONSTRAINT SYS_C0067560;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H ADD (
  CONSTRAINT SYS_C0067560
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H
  DROP CONSTRAINT SYS_C0067561;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H ADD (
  CONSTRAINT SYS_C0067561
  CHECK ("ELIGIBILITY_DETERMINATION_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H
  DROP CONSTRAINT SYS_C0067567;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H ADD (
  CONSTRAINT SYS_C0067567
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H
  DROP CONSTRAINT SYS_C0067563;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H ADD (
  CONSTRAINT SYS_C0067563
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H
  DROP CONSTRAINT SYS_C0067564;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H ADD (
  CONSTRAINT SYS_C0067564
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H
  DROP CONSTRAINT SYS_C0067565;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H ADD (
  CONSTRAINT SYS_C0067565
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H
  DROP CONSTRAINT SYS_C0067566;

ALTER TABLE ADR.ELIGIBILITY_DETERMINATION_H ADD (
  CONSTRAINT SYS_C0067566
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_061;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_061
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H
  DROP CONSTRAINT SYS_C0067195;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H ADD (
  CONSTRAINT SYS_C0067195
  CHECK ("FINANCIAL_STATEMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H
  DROP CONSTRAINT SYS_C0067192;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H ADD (
  CONSTRAINT SYS_C0067192
  CHECK ("FINANCIAL_ASSET_DETAIL_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H
  DROP CONSTRAINT SYS_C0067193;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H ADD (
  CONSTRAINT SYS_C0067193
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H
  DROP CONSTRAINT SYS_C0067194;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H ADD (
  CONSTRAINT SYS_C0067194
  CHECK ("FINANCIAL_ASSET_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H
  DROP CONSTRAINT SYS_C0067201;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H ADD (
  CONSTRAINT SYS_C0067201
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H
  DROP CONSTRAINT SYS_C0067196;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H ADD (
  CONSTRAINT SYS_C0067196
  CHECK ("FINANCIAL_ASSET_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H
  DROP CONSTRAINT SYS_C0067197;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H ADD (
  CONSTRAINT SYS_C0067197
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H
  DROP CONSTRAINT SYS_C0067198;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H ADD (
  CONSTRAINT SYS_C0067198
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H
  DROP CONSTRAINT SYS_C0067199;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H ADD (
  CONSTRAINT SYS_C0067199
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H
  DROP CONSTRAINT SYS_C0067200;

ALTER TABLE ADR.FINANCIAL_ASSET_DETAIL_H ADD (
  CONSTRAINT SYS_C0067200
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H
  DROP CONSTRAINT SYS_C00186918;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H ADD (
  CONSTRAINT SYS_C00186918
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H
  DROP CONSTRAINT SYS_C00186913;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H ADD (
  CONSTRAINT SYS_C00186913
  CHECK ("HANDBOOK_MAIL_QUEUE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H
  DROP CONSTRAINT SYS_C00186914;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H ADD (
  CONSTRAINT SYS_C00186914
  CHECK ("COM_LETTER_TEMPLATE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H
  DROP CONSTRAINT SYS_C00186915;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H ADD (
  CONSTRAINT SYS_C00186915
  CHECK ("STD_HANDBOOKRELEASECNTL_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H
  DROP CONSTRAINT SYS_C00186916;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H ADD (
  CONSTRAINT SYS_C00186916
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H
  DROP CONSTRAINT SYS_C00186917;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H ADD (
  CONSTRAINT SYS_C00186917
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H
  DROP CONSTRAINT SYS_C00186924;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H ADD (
  CONSTRAINT SYS_C00186924
  CHECK ("HANDBOOK_MAIL_QUEUE_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H
  DROP CONSTRAINT SYS_C00186919;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H ADD (
  CONSTRAINT SYS_C00186919
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H
  DROP CONSTRAINT SYS_C00186920;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H ADD (
  CONSTRAINT SYS_C00186920
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H
  DROP CONSTRAINT SYS_C00186921;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H ADD (
  CONSTRAINT SYS_C00186921
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H
  DROP CONSTRAINT SYS_C00186922;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H ADD (
  CONSTRAINT SYS_C00186922
  CHECK ("HISTORY_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H
  DROP CONSTRAINT SYS_C00186923;

ALTER TABLE ADR.HANDBOOK_MAIL_QUEUE_H ADD (
  CONSTRAINT SYS_C00186923
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H
  DROP CONSTRAINT SYS_C00186937;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H ADD (
  CONSTRAINT SYS_C00186937
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H
  DROP CONSTRAINT SYS_C00186933;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H ADD (
  CONSTRAINT SYS_C00186933
  CHECK ("HANDBOOK_MAIL_STATUS_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H
  DROP CONSTRAINT SYS_C00186934;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H ADD (
  CONSTRAINT SYS_C00186934
  CHECK ("HANDBOOK_MAIL_QUEUE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H
  DROP CONSTRAINT SYS_C00186935;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H ADD (
  CONSTRAINT SYS_C00186935
  CHECK ("STD_HANDBOOKMAILSTATTYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H
  DROP CONSTRAINT SYS_C00186936;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H ADD (
  CONSTRAINT SYS_C00186936
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H
  DROP CONSTRAINT SYS_C00186943;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H ADD (
  CONSTRAINT SYS_C00186943
  CHECK ("HANDBOOK_MAIL_STATUS_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H
  DROP CONSTRAINT SYS_C00186938;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H ADD (
  CONSTRAINT SYS_C00186938
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H
  DROP CONSTRAINT SYS_C00186939;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H ADD (
  CONSTRAINT SYS_C00186939
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H
  DROP CONSTRAINT SYS_C00186940;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H ADD (
  CONSTRAINT SYS_C00186940
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H
  DROP CONSTRAINT SYS_C00186941;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H ADD (
  CONSTRAINT SYS_C00186941
  CHECK ("HISTORY_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H
  DROP CONSTRAINT SYS_C00186942;

ALTER TABLE ADR.HANDBOOK_MAIL_STATUS_H ADD (
  CONSTRAINT SYS_C00186942
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H
  DROP CONSTRAINT SYS_C00297525;

ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H ADD (
  CONSTRAINT SYS_C00297525
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H
  DROP CONSTRAINT SYS_C00297522;

ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H ADD (
  CONSTRAINT SYS_C00297522
  CHECK ("HEALTH_BENEFIT_PROFILE_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H
  DROP CONSTRAINT SYS_C00297523;

ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H ADD (
  CONSTRAINT SYS_C00297523
  CHECK ("HEALTH_BENEFIT_PROFILE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H
  DROP CONSTRAINT SYS_C00297524;

ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H ADD (
  CONSTRAINT SYS_C00297524
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H
  DROP CONSTRAINT SYS_C00297530;

ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H ADD (
  CONSTRAINT SYS_C00297530
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H
  DROP CONSTRAINT SYS_C00297526;

ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H ADD (
  CONSTRAINT SYS_C00297526
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H
  DROP CONSTRAINT SYS_C00297527;

ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H ADD (
  CONSTRAINT SYS_C00297527
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H
  DROP CONSTRAINT SYS_C00297528;

ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H ADD (
  CONSTRAINT SYS_C00297528
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H
  DROP CONSTRAINT SYS_C00297529;

ALTER TABLE ADR.HEALTH_BENEFIT_PROFILE_H ADD (
  CONSTRAINT SYS_C00297529
  CHECK ("HISTORY_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST
  DROP CONSTRAINT AVCON_1172521913_FUTUR_001;

ALTER TABLE ADR.INCOME_TEST ADD (
  CONSTRAINT AVCON_1172521913_FUTUR_001
  CHECK (FUTURE_TEST_FLAG BETWEEN 0 AND 0 OR FUTURE_TEST_FLAG BETWEEN 1 AND 1)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST
  DROP CONSTRAINT SYS_C0067025;

ALTER TABLE ADR.INCOME_TEST ADD (
  CONSTRAINT SYS_C0067025
  CHECK ("INCOME_TEST_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST
  DROP CONSTRAINT SYS_C0067030;

ALTER TABLE ADR.INCOME_TEST ADD (
  CONSTRAINT SYS_C0067030
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST
  DROP CONSTRAINT SYS_C0067029;

ALTER TABLE ADR.INCOME_TEST ADD (
  CONSTRAINT SYS_C0067029
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST
  DROP CONSTRAINT SYS_C0067023;

ALTER TABLE ADR.INCOME_TEST ADD (
  CONSTRAINT SYS_C0067023
  CHECK ("INCOME_TEST_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST
  DROP CONSTRAINT SYS_C0067024;

ALTER TABLE ADR.INCOME_TEST ADD (
  CONSTRAINT SYS_C0067024
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST
  DROP CONSTRAINT SYS_C0067026;

ALTER TABLE ADR.INCOME_TEST ADD (
  CONSTRAINT SYS_C0067026
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST
  DROP CONSTRAINT SYS_C0067027;

ALTER TABLE ADR.INCOME_TEST ADD (
  CONSTRAINT SYS_C0067027
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST
  DROP CONSTRAINT SYS_C0067028;

ALTER TABLE ADR.INCOME_TEST ADD (
  CONSTRAINT SYS_C0067028
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_H
  DROP CONSTRAINT AVCON_1172521913_FUTUR_000;

ALTER TABLE ADR.INCOME_TEST_H ADD (
  CONSTRAINT AVCON_1172521913_FUTUR_000
  CHECK (FUTURE_TEST_FLAG BETWEEN 0 AND 0 OR FUTURE_TEST_FLAG BETWEEN 1 AND 1)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_053;

ALTER TABLE ADR.INCOME_TEST_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_053
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_H
  DROP CONSTRAINT SYS_C0066974;

ALTER TABLE ADR.INCOME_TEST_H ADD (
  CONSTRAINT SYS_C0066974
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_H
  DROP CONSTRAINT SYS_C0066971;

ALTER TABLE ADR.INCOME_TEST_H ADD (
  CONSTRAINT SYS_C0066971
  CHECK ("INCOME_TEST_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_H
  DROP CONSTRAINT SYS_C0066972;

ALTER TABLE ADR.INCOME_TEST_H ADD (
  CONSTRAINT SYS_C0066972
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_H
  DROP CONSTRAINT SYS_C0066973;

ALTER TABLE ADR.INCOME_TEST_H ADD (
  CONSTRAINT SYS_C0066973
  CHECK ("INCOME_TEST_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_H
  DROP CONSTRAINT SYS_C0066980;

ALTER TABLE ADR.INCOME_TEST_H ADD (
  CONSTRAINT SYS_C0066980
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_H
  DROP CONSTRAINT SYS_C0066975;

ALTER TABLE ADR.INCOME_TEST_H ADD (
  CONSTRAINT SYS_C0066975
  CHECK ("INCOME_TEST_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_H
  DROP CONSTRAINT SYS_C0066976;

ALTER TABLE ADR.INCOME_TEST_H ADD (
  CONSTRAINT SYS_C0066976
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_H
  DROP CONSTRAINT SYS_C0066977;

ALTER TABLE ADR.INCOME_TEST_H ADD (
  CONSTRAINT SYS_C0066977
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_H
  DROP CONSTRAINT SYS_C0066978;

ALTER TABLE ADR.INCOME_TEST_H ADD (
  CONSTRAINT SYS_C0066978
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_H
  DROP CONSTRAINT SYS_C0066979;

ALTER TABLE ADR.INCOME_TEST_H ADD (
  CONSTRAINT SYS_C0066979
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MEDICAID_FACTOR_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_059;

ALTER TABLE ADR.MEDICAID_FACTOR_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_059
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MEDICAID_FACTOR_H
  DROP CONSTRAINT SYS_C0067144;

ALTER TABLE ADR.MEDICAID_FACTOR_H ADD (
  CONSTRAINT SYS_C0067144
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MEDICAID_FACTOR_H
  DROP CONSTRAINT SYS_C0067141;

ALTER TABLE ADR.MEDICAID_FACTOR_H ADD (
  CONSTRAINT SYS_C0067141
  CHECK ("MEDICAID_FACTOR_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MEDICAID_FACTOR_H
  DROP CONSTRAINT SYS_C0067142;

ALTER TABLE ADR.MEDICAID_FACTOR_H ADD (
  CONSTRAINT SYS_C0067142
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MEDICAID_FACTOR_H
  DROP CONSTRAINT SYS_C0067143;

ALTER TABLE ADR.MEDICAID_FACTOR_H ADD (
  CONSTRAINT SYS_C0067143
  CHECK ("MEDICAID_FACTOR_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MEDICAID_FACTOR_H
  DROP CONSTRAINT SYS_C0067150;

ALTER TABLE ADR.MEDICAID_FACTOR_H ADD (
  CONSTRAINT SYS_C0067150
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MEDICAID_FACTOR_H
  DROP CONSTRAINT SYS_C0067145;

ALTER TABLE ADR.MEDICAID_FACTOR_H ADD (
  CONSTRAINT SYS_C0067145
  CHECK ("MEDICAID_ELIGIBILITY_IND" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MEDICAID_FACTOR_H
  DROP CONSTRAINT SYS_C0067146;

ALTER TABLE ADR.MEDICAID_FACTOR_H ADD (
  CONSTRAINT SYS_C0067146
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MEDICAID_FACTOR_H
  DROP CONSTRAINT SYS_C0067147;

ALTER TABLE ADR.MEDICAID_FACTOR_H ADD (
  CONSTRAINT SYS_C0067147
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MEDICAID_FACTOR_H
  DROP CONSTRAINT SYS_C0067148;

ALTER TABLE ADR.MEDICAID_FACTOR_H ADD (
  CONSTRAINT SYS_C0067148
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MEDICAID_FACTOR_H
  DROP CONSTRAINT SYS_C0067149;

ALTER TABLE ADR.MEDICAID_FACTOR_H ADD (
  CONSTRAINT SYS_C0067149
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CONTACT_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_020;

ALTER TABLE ADR.PERSON_CONTACT_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_020
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CONTACT_H
  DROP CONSTRAINT SYS_C0066294;

ALTER TABLE ADR.PERSON_CONTACT_H ADD (
  CONSTRAINT SYS_C0066294
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CONTACT_H
  DROP CONSTRAINT SYS_C0066291;

ALTER TABLE ADR.PERSON_CONTACT_H ADD (
  CONSTRAINT SYS_C0066291
  CHECK ("PERSON_CONTACT_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CONTACT_H
  DROP CONSTRAINT SYS_C0066292;

ALTER TABLE ADR.PERSON_CONTACT_H ADD (
  CONSTRAINT SYS_C0066292
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CONTACT_H
  DROP CONSTRAINT SYS_C0066293;

ALTER TABLE ADR.PERSON_CONTACT_H ADD (
  CONSTRAINT SYS_C0066293
  CHECK ("PERSON_CONTACT_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CONTACT_H
  DROP CONSTRAINT SYS_C0066300;

ALTER TABLE ADR.PERSON_CONTACT_H ADD (
  CONSTRAINT SYS_C0066300
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CONTACT_H
  DROP CONSTRAINT SYS_C0066295;

ALTER TABLE ADR.PERSON_CONTACT_H ADD (
  CONSTRAINT SYS_C0066295
  CHECK ("PERSON_CONTACT_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CONTACT_H
  DROP CONSTRAINT SYS_C0066296;

ALTER TABLE ADR.PERSON_CONTACT_H ADD (
  CONSTRAINT SYS_C0066296
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CONTACT_H
  DROP CONSTRAINT SYS_C0066297;

ALTER TABLE ADR.PERSON_CONTACT_H ADD (
  CONSTRAINT SYS_C0066297
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CONTACT_H
  DROP CONSTRAINT SYS_C0066298;

ALTER TABLE ADR.PERSON_CONTACT_H ADD (
  CONSTRAINT SYS_C0066298
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CONTACT_H
  DROP CONSTRAINT SYS_C0066299;

ALTER TABLE ADR.PERSON_CONTACT_H ADD (
  CONSTRAINT SYS_C0066299
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY_H
  DROP CONSTRAINT SYS_C00160866;

ALTER TABLE ADR.PREFERRED_FACILITY_H ADD (
  CONSTRAINT SYS_C00160866
  CHECK ("ASSIGNMENT_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY_H
  DROP CONSTRAINT SYS_C00160861;

ALTER TABLE ADR.PREFERRED_FACILITY_H ADD (
  CONSTRAINT SYS_C00160861
  CHECK ("PREFERRED_FACILITY_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY_H
  DROP CONSTRAINT SYS_C00160862;

ALTER TABLE ADR.PREFERRED_FACILITY_H ADD (
  CONSTRAINT SYS_C00160862
  CHECK ("PREFERRED_FACILITY_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY_H
  DROP CONSTRAINT SYS_C00160863;

ALTER TABLE ADR.PREFERRED_FACILITY_H ADD (
  CONSTRAINT SYS_C00160863
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY_H
  DROP CONSTRAINT SYS_C00160864;

ALTER TABLE ADR.PREFERRED_FACILITY_H ADD (
  CONSTRAINT SYS_C00160864
  CHECK ("STD_PREFERRED_FACILITY_SRC_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY_H
  DROP CONSTRAINT SYS_C00160865;

ALTER TABLE ADR.PREFERRED_FACILITY_H ADD (
  CONSTRAINT SYS_C00160865
  CHECK ("STD_INSTITUTION_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY_H
  DROP CONSTRAINT SYS_C00160873;

ALTER TABLE ADR.PREFERRED_FACILITY_H ADD (
  CONSTRAINT SYS_C00160873
  CHECK ("HISTORY_CREATED_DATE" IS NOT NULL)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY_H
  DROP CONSTRAINT SYS_C00160867;

ALTER TABLE ADR.PREFERRED_FACILITY_H ADD (
  CONSTRAINT SYS_C00160867
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY_H
  DROP CONSTRAINT SYS_C00160868;

ALTER TABLE ADR.PREFERRED_FACILITY_H ADD (
  CONSTRAINT SYS_C00160868
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY_H
  DROP CONSTRAINT SYS_C00160869;

ALTER TABLE ADR.PREFERRED_FACILITY_H ADD (
  CONSTRAINT SYS_C00160869
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY_H
  DROP CONSTRAINT SYS_C00160870;

ALTER TABLE ADR.PREFERRED_FACILITY_H ADD (
  CONSTRAINT SYS_C00160870
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY_H
  DROP CONSTRAINT SYS_C00160871;

ALTER TABLE ADR.PREFERRED_FACILITY_H ADD (
  CONSTRAINT SYS_C00160871
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PREFERRED_FACILITY_H
  DROP CONSTRAINT SYS_C00160872;

ALTER TABLE ADR.PREFERRED_FACILITY_H ADD (
  CONSTRAINT SYS_C00160872
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SERVICE_CONNECTED_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_077;

ALTER TABLE ADR.SERVICE_CONNECTED_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_077
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SERVICE_CONNECTED_H
  DROP CONSTRAINT SYS_C0067611;

ALTER TABLE ADR.SERVICE_CONNECTED_H ADD (
  CONSTRAINT SYS_C0067611
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SERVICE_CONNECTED_H
  DROP CONSTRAINT SYS_C0067608;

ALTER TABLE ADR.SERVICE_CONNECTED_H ADD (
  CONSTRAINT SYS_C0067608
  CHECK ("SERVICE_CONNECTED_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SERVICE_CONNECTED_H
  DROP CONSTRAINT SYS_C0067609;

ALTER TABLE ADR.SERVICE_CONNECTED_H ADD (
  CONSTRAINT SYS_C0067609
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SERVICE_CONNECTED_H
  DROP CONSTRAINT SYS_C0067610;

ALTER TABLE ADR.SERVICE_CONNECTED_H ADD (
  CONSTRAINT SYS_C0067610
  CHECK ("SERVICE_CONNECTED_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SERVICE_CONNECTED_H
  DROP CONSTRAINT SYS_C0067616;

ALTER TABLE ADR.SERVICE_CONNECTED_H ADD (
  CONSTRAINT SYS_C0067616
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SERVICE_CONNECTED_H
  DROP CONSTRAINT SYS_C0067612;

ALTER TABLE ADR.SERVICE_CONNECTED_H ADD (
  CONSTRAINT SYS_C0067612
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SERVICE_CONNECTED_H
  DROP CONSTRAINT SYS_C0067613;

ALTER TABLE ADR.SERVICE_CONNECTED_H ADD (
  CONSTRAINT SYS_C0067613
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SERVICE_CONNECTED_H
  DROP CONSTRAINT SYS_C0067614;

ALTER TABLE ADR.SERVICE_CONNECTED_H ADD (
  CONSTRAINT SYS_C0067614
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SERVICE_CONNECTED_H
  DROP CONSTRAINT SYS_C0067615;

ALTER TABLE ADR.SERVICE_CONNECTED_H ADD (
  CONSTRAINT SYS_C0067615
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_019;

ALTER TABLE ADR.SPECIAL_FACTOR_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_019
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR_H
  DROP CONSTRAINT SYS_C0066278;

ALTER TABLE ADR.SPECIAL_FACTOR_H ADD (
  CONSTRAINT SYS_C0066278
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR_H
  DROP CONSTRAINT SYS_C0066275;

ALTER TABLE ADR.SPECIAL_FACTOR_H ADD (
  CONSTRAINT SYS_C0066275
  CHECK ("SPECIAL_FACTOR_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR_H
  DROP CONSTRAINT SYS_C0066276;

ALTER TABLE ADR.SPECIAL_FACTOR_H ADD (
  CONSTRAINT SYS_C0066276
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR_H
  DROP CONSTRAINT SYS_C0066277;

ALTER TABLE ADR.SPECIAL_FACTOR_H ADD (
  CONSTRAINT SYS_C0066277
  CHECK ("SPECIAL_FACTOR_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR_H
  DROP CONSTRAINT SYS_C0066283;

ALTER TABLE ADR.SPECIAL_FACTOR_H ADD (
  CONSTRAINT SYS_C0066283
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR_H
  DROP CONSTRAINT SYS_C0066279;

ALTER TABLE ADR.SPECIAL_FACTOR_H ADD (
  CONSTRAINT SYS_C0066279
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR_H
  DROP CONSTRAINT SYS_C0066280;

ALTER TABLE ADR.SPECIAL_FACTOR_H ADD (
  CONSTRAINT SYS_C0066280
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR_H
  DROP CONSTRAINT SYS_C0066281;

ALTER TABLE ADR.SPECIAL_FACTOR_H ADD (
  CONSTRAINT SYS_C0066281
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR_H
  DROP CONSTRAINT SYS_C0066282;

ALTER TABLE ADR.SPECIAL_FACTOR_H ADD (
  CONSTRAINT SYS_C0066282
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_016;

ALTER TABLE ADR.SSN_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_016
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN_H
  DROP CONSTRAINT SYS_C0066235;

ALTER TABLE ADR.SSN_H ADD (
  CONSTRAINT SYS_C0066235
  CHECK ("SSN_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN_H
  DROP CONSTRAINT SYS_C0066233;

ALTER TABLE ADR.SSN_H ADD (
  CONSTRAINT SYS_C0066233
  CHECK ("SSN_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN_H
  DROP CONSTRAINT SYS_C0066234;

ALTER TABLE ADR.SSN_H ADD (
  CONSTRAINT SYS_C0066234
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN_H
  DROP CONSTRAINT SYS_C0066240;

ALTER TABLE ADR.SSN_H ADD (
  CONSTRAINT SYS_C0066240
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN_H
  DROP CONSTRAINT SYS_C0066236;

ALTER TABLE ADR.SSN_H ADD (
  CONSTRAINT SYS_C0066236
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN_H
  DROP CONSTRAINT SYS_C0066237;

ALTER TABLE ADR.SSN_H ADD (
  CONSTRAINT SYS_C0066237
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN_H
  DROP CONSTRAINT SYS_C0066238;

ALTER TABLE ADR.SSN_H ADD (
  CONSTRAINT SYS_C0066238
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN_H
  DROP CONSTRAINT SYS_C0066239;

ALTER TABLE ADR.SSN_H ADD (
  CONSTRAINT SYS_C0066239
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H
  DROP CONSTRAINT SYS_C00160885;

ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H ADD (
  CONSTRAINT SYS_C00160885
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H
  DROP CONSTRAINT SYS_C00160881;

ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H ADD (
  CONSTRAINT SYS_C00160881
  CHECK ("HEALTH_CARE_PROVIDER_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H
  DROP CONSTRAINT SYS_C00160882;

ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H ADD (
  CONSTRAINT SYS_C00160882
  CHECK ("HEALTH_CARE_PROVIDER_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H
  DROP CONSTRAINT SYS_C00160883;

ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H ADD (
  CONSTRAINT SYS_C00160883
  CHECK ("PRACTITIONER_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H
  DROP CONSTRAINT SYS_C00160884;

ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H ADD (
  CONSTRAINT SYS_C00160884
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H
  DROP CONSTRAINT SYS_C00160890;

ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H ADD (
  CONSTRAINT SYS_C00160890
  CHECK ("HISTORY_CREATED_DATE" IS NOT NULL)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H
  DROP CONSTRAINT SYS_C00160886;

ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H ADD (
  CONSTRAINT SYS_C00160886
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H
  DROP CONSTRAINT SYS_C00160887;

ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H ADD (
  CONSTRAINT SYS_C00160887
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H
  DROP CONSTRAINT SYS_C00160888;

ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H ADD (
  CONSTRAINT SYS_C00160888
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H
  DROP CONSTRAINT SYS_C00160889;

ALTER TABLE ADR.HEALTH_CARE_PROVIDER_H ADD (
  CONSTRAINT SYS_C00160889
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE
  DROP CONSTRAINT SYS_C0066736;

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE ADD (
  CONSTRAINT SYS_C0066736
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE
  DROP CONSTRAINT SYS_C0066739;

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE ADD (
  CONSTRAINT SYS_C0066739
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE
  DROP CONSTRAINT SYS_C0066734;

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE ADD (
  CONSTRAINT SYS_C0066734
  CHECK ("MILITARY_SERVICE_EPISODE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE
  DROP CONSTRAINT SYS_C0066735;

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE ADD (
  CONSTRAINT SYS_C0066735
  CHECK ("MILITARY_SERVICE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE
  DROP CONSTRAINT SYS_C0066740;

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE ADD (
  CONSTRAINT SYS_C0066740
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE
  DROP CONSTRAINT SYS_C0066737;

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE ADD (
  CONSTRAINT SYS_C0066737
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE
  DROP CONSTRAINT SYS_C0066738;

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE ADD (
  CONSTRAINT SYS_C0066738
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL
  DROP CONSTRAINT SYS_C0066321;

ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL ADD (
  CONSTRAINT SYS_C0066321
  CHECK ("COM_MAILING_STATUS_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL
  DROP CONSTRAINT SYS_C0066325;

ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL ADD (
  CONSTRAINT SYS_C0066325
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL
  DROP CONSTRAINT SYS_C0066324;

ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL ADD (
  CONSTRAINT SYS_C0066324
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL
  DROP CONSTRAINT SYS_C0066319;

ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL ADD (
  CONSTRAINT SYS_C0066319
  CHECK ("COM_MAILING_STATUS_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL
  DROP CONSTRAINT SYS_C0066320;

ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL ADD (
  CONSTRAINT SYS_C0066320
  CHECK ("COM_MAILING_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL
  DROP CONSTRAINT SYS_C0066326;

ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL ADD (
  CONSTRAINT SYS_C0066326
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL
  DROP CONSTRAINT SYS_C0066322;

ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL ADD (
  CONSTRAINT SYS_C0066322
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL
  DROP CONSTRAINT SYS_C0066323;

ALTER TABLE ADR.COM_MAILING_STATUS_DETAIL ADD (
  CONSTRAINT SYS_C0066323
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT SYS_C0067238;

ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT SYS_C0067238
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT SYS_C0067237;

ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT SYS_C0067237
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT SYS_C0067236;

ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT SYS_C0067236
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT SYS_C0067235;

ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT SYS_C0067235
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT SYS_C0067234;

ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT SYS_C0067234
  CHECK ("COM_LETTER_TEMPLATE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT SYS_C0067233;

ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT SYS_C0067233
  CHECK ("COM_LETTER_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT AVCON_1172521913_REMAI_000;

ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT AVCON_1172521913_REMAI_000
  CHECK (REMAIL_STATUS_CODE IN ('REMAILED', 'RESEND'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT SYS_C0067239;

ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT SYS_C0067239
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT SYS_C0067231;

ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT SYS_C0067231
  CHECK ("COM_MAILING_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_MAILING
  DROP CONSTRAINT SYS_C0067232;

ALTER TABLE ADR.COM_MAILING ADD (
  CONSTRAINT SYS_C0067232
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_005;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_005
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H
  DROP CONSTRAINT SYS_C0065954;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H ADD (
  CONSTRAINT SYS_C0065954
  CHECK ("FINANCIAL_STATEMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H
  DROP CONSTRAINT SYS_C0065951;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H ADD (
  CONSTRAINT SYS_C0065951
  CHECK ("FINANCIAL_INCOME_DETAIL_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H
  DROP CONSTRAINT SYS_C0065952;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H ADD (
  CONSTRAINT SYS_C0065952
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H
  DROP CONSTRAINT SYS_C0065953;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H ADD (
  CONSTRAINT SYS_C0065953
  CHECK ("FINANCIAL_INCOME_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H
  DROP CONSTRAINT SYS_C0065960;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H ADD (
  CONSTRAINT SYS_C0065960
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H
  DROP CONSTRAINT SYS_C0065955;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H ADD (
  CONSTRAINT SYS_C0065955
  CHECK ("FINANCIAL_INCOME_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H
  DROP CONSTRAINT SYS_C0065956;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H ADD (
  CONSTRAINT SYS_C0065956
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H
  DROP CONSTRAINT SYS_C0065957;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H ADD (
  CONSTRAINT SYS_C0065957
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H
  DROP CONSTRAINT SYS_C0065958;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H ADD (
  CONSTRAINT SYS_C0065958
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H
  DROP CONSTRAINT SYS_C0065959;

ALTER TABLE ADR.FINANCIAL_INCOME_DETAIL_H ADD (
  CONSTRAINT SYS_C0065959
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_012;

ALTER TABLE ADR.INCOME_TEST_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_012
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL_H
  DROP CONSTRAINT SYS_C0066128;

ALTER TABLE ADR.INCOME_TEST_DETAIL_H ADD (
  CONSTRAINT SYS_C0066128
  CHECK ("INCOME_TEST_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL_H
  DROP CONSTRAINT SYS_C0066125;

ALTER TABLE ADR.INCOME_TEST_DETAIL_H ADD (
  CONSTRAINT SYS_C0066125
  CHECK ("INCOME_TEST_DETAIL_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL_H
  DROP CONSTRAINT SYS_C0066126;

ALTER TABLE ADR.INCOME_TEST_DETAIL_H ADD (
  CONSTRAINT SYS_C0066126
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL_H
  DROP CONSTRAINT SYS_C0066127;

ALTER TABLE ADR.INCOME_TEST_DETAIL_H ADD (
  CONSTRAINT SYS_C0066127
  CHECK ("INCOME_TEST_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL_H
  DROP CONSTRAINT SYS_C0066134;

ALTER TABLE ADR.INCOME_TEST_DETAIL_H ADD (
  CONSTRAINT SYS_C0066134
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL_H
  DROP CONSTRAINT SYS_C0066129;

ALTER TABLE ADR.INCOME_TEST_DETAIL_H ADD (
  CONSTRAINT SYS_C0066129
  CHECK ("INCOME_TEST_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL_H
  DROP CONSTRAINT SYS_C0066130;

ALTER TABLE ADR.INCOME_TEST_DETAIL_H ADD (
  CONSTRAINT SYS_C0066130
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL_H
  DROP CONSTRAINT SYS_C0066131;

ALTER TABLE ADR.INCOME_TEST_DETAIL_H ADD (
  CONSTRAINT SYS_C0066131
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL_H
  DROP CONSTRAINT SYS_C0066132;

ALTER TABLE ADR.INCOME_TEST_DETAIL_H ADD (
  CONSTRAINT SYS_C0066132
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOME_TEST_DETAIL_H
  DROP CONSTRAINT SYS_C0066133;

ALTER TABLE ADR.INCOME_TEST_DETAIL_H ADD (
  CONSTRAINT SYS_C0066133
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_SCI_H
  DROP CONSTRAINT BENEFICIARY_SCI_H_CHK;

ALTER TABLE ADR.BENEFICIARY_SCI_H ADD (
  CONSTRAINT BENEFICIARY_SCI_H_CHK
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_SCI_H
  DROP CONSTRAINT SYS_C00106525;

ALTER TABLE ADR.BENEFICIARY_SCI_H ADD (
  CONSTRAINT SYS_C00106525
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_SCI_H
  DROP CONSTRAINT SYS_C00106522;

ALTER TABLE ADR.BENEFICIARY_SCI_H ADD (
  CONSTRAINT SYS_C00106522
  CHECK ("BENEFICIARY_SCI_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_SCI_H
  DROP CONSTRAINT SYS_C00106523;

ALTER TABLE ADR.BENEFICIARY_SCI_H ADD (
  CONSTRAINT SYS_C00106523
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_SCI_H
  DROP CONSTRAINT SYS_C00106524;

ALTER TABLE ADR.BENEFICIARY_SCI_H ADD (
  CONSTRAINT SYS_C00106524
  CHECK ("BENEFICIARY_SCI_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_SCI_H
  DROP CONSTRAINT SYS_C00106531;

ALTER TABLE ADR.BENEFICIARY_SCI_H ADD (
  CONSTRAINT SYS_C00106531
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_SCI_H
  DROP CONSTRAINT SYS_C00106526;

ALTER TABLE ADR.BENEFICIARY_SCI_H ADD (
  CONSTRAINT SYS_C00106526
  CHECK ("STD_SPINALINJURYCODE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_SCI_H
  DROP CONSTRAINT SYS_C00106527;

ALTER TABLE ADR.BENEFICIARY_SCI_H ADD (
  CONSTRAINT SYS_C00106527
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_SCI_H
  DROP CONSTRAINT SYS_C00106528;

ALTER TABLE ADR.BENEFICIARY_SCI_H ADD (
  CONSTRAINT SYS_C00106528
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_SCI_H
  DROP CONSTRAINT SYS_C00106529;

ALTER TABLE ADR.BENEFICIARY_SCI_H ADD (
  CONSTRAINT SYS_C00106529
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_SCI_H
  DROP CONSTRAINT SYS_C00106530;

ALTER TABLE ADR.BENEFICIARY_SCI_H ADD (
  CONSTRAINT SYS_C00106530
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMPLOYMENT_H
  DROP CONSTRAINT SYS_C00106541;

ALTER TABLE ADR.EMPLOYMENT_H ADD (
  CONSTRAINT SYS_C00106541
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMPLOYMENT_H
  DROP CONSTRAINT EMPLOYMENT_H_CHK;

ALTER TABLE ADR.EMPLOYMENT_H ADD (
  CONSTRAINT EMPLOYMENT_H_CHK
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMPLOYMENT_H
  DROP CONSTRAINT SYS_C00106539;

ALTER TABLE ADR.EMPLOYMENT_H ADD (
  CONSTRAINT SYS_C00106539
  CHECK ("EMPLOYMENT_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMPLOYMENT_H
  DROP CONSTRAINT SYS_C00106540;

ALTER TABLE ADR.EMPLOYMENT_H ADD (
  CONSTRAINT SYS_C00106540
  CHECK ("EMPLOYMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMPLOYMENT_H
  DROP CONSTRAINT SYS_C00106546;

ALTER TABLE ADR.EMPLOYMENT_H ADD (
  CONSTRAINT SYS_C00106546
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMPLOYMENT_H
  DROP CONSTRAINT SYS_C00106542;

ALTER TABLE ADR.EMPLOYMENT_H ADD (
  CONSTRAINT SYS_C00106542
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMPLOYMENT_H
  DROP CONSTRAINT SYS_C00106543;

ALTER TABLE ADR.EMPLOYMENT_H ADD (
  CONSTRAINT SYS_C00106543
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMPLOYMENT_H
  DROP CONSTRAINT SYS_C00106544;

ALTER TABLE ADR.EMPLOYMENT_H ADD (
  CONSTRAINT SYS_C00106544
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.EMPLOYMENT_H
  DROP CONSTRAINT SYS_C00106545;

ALTER TABLE ADR.EMPLOYMENT_H ADD (
  CONSTRAINT SYS_C00106545
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_021;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_021
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H
  DROP CONSTRAINT SYS_C0066312;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H ADD (
  CONSTRAINT SYS_C0066312
  CHECK ("MONETARY_BENEFIT_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H
  DROP CONSTRAINT SYS_C0066309;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H ADD (
  CONSTRAINT SYS_C0066309
  CHECK ("MONETARY_BENEFIT_DETAIL_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H
  DROP CONSTRAINT SYS_C0066310;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H ADD (
  CONSTRAINT SYS_C0066310
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H
  DROP CONSTRAINT SYS_C0066311;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H ADD (
  CONSTRAINT SYS_C0066311
  CHECK ("MONETARY_BENEFIT_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H
  DROP CONSTRAINT SYS_C0066318;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H ADD (
  CONSTRAINT SYS_C0066318
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H
  DROP CONSTRAINT SYS_C0066313;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H ADD (
  CONSTRAINT SYS_C0066313
  CHECK ("MONETARY_BENEFIT_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H
  DROP CONSTRAINT SYS_C0066314;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H ADD (
  CONSTRAINT SYS_C0066314
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H
  DROP CONSTRAINT SYS_C0066315;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H ADD (
  CONSTRAINT SYS_C0066315
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H
  DROP CONSTRAINT SYS_C0066316;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H ADD (
  CONSTRAINT SYS_C0066316
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H
  DROP CONSTRAINT SYS_C0066317;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H ADD (
  CONSTRAINT SYS_C0066317
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_055;

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_055
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H
  DROP CONSTRAINT SYS_C0067003;

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H ADD (
  CONSTRAINT SYS_C0067003
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H
  DROP CONSTRAINT SYS_C0067000;

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H ADD (
  CONSTRAINT SYS_C0067000
  CHECK ("BENEFICIARY_VISIT_SUMMARY_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H
  DROP CONSTRAINT SYS_C0067001;

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H ADD (
  CONSTRAINT SYS_C0067001
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H
  DROP CONSTRAINT SYS_C0067002;

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H ADD (
  CONSTRAINT SYS_C0067002
  CHECK ("BENEFICIARY_VISIT_SUMMARY_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H
  DROP CONSTRAINT SYS_C0067008;

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H ADD (
  CONSTRAINT SYS_C0067008
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H
  DROP CONSTRAINT SYS_C0067004;

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H ADD (
  CONSTRAINT SYS_C0067004
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H
  DROP CONSTRAINT SYS_C0067005;

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H ADD (
  CONSTRAINT SYS_C0067005
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H
  DROP CONSTRAINT SYS_C0067006;

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H ADD (
  CONSTRAINT SYS_C0067006
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H
  DROP CONSTRAINT SYS_C0067007;

ALTER TABLE ADR.BENEFICIARY_VISIT_SUMMARY_H ADD (
  CONSTRAINT SYS_C0067007
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INSURANCE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_043;

ALTER TABLE ADR.INSURANCE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_043
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INSURANCE_H
  DROP CONSTRAINT SYS_C0066784;

ALTER TABLE ADR.INSURANCE_H ADD (
  CONSTRAINT SYS_C0066784
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INSURANCE_H
  DROP CONSTRAINT SYS_C0066781;

ALTER TABLE ADR.INSURANCE_H ADD (
  CONSTRAINT SYS_C0066781
  CHECK ("INSURANCE_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INSURANCE_H
  DROP CONSTRAINT SYS_C0066782;

ALTER TABLE ADR.INSURANCE_H ADD (
  CONSTRAINT SYS_C0066782
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INSURANCE_H
  DROP CONSTRAINT SYS_C0066783;

ALTER TABLE ADR.INSURANCE_H ADD (
  CONSTRAINT SYS_C0066783
  CHECK ("INSURANCE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INSURANCE_H
  DROP CONSTRAINT SYS_C0066789;

ALTER TABLE ADR.INSURANCE_H ADD (
  CONSTRAINT SYS_C0066789
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INSURANCE_H
  DROP CONSTRAINT SYS_C0066785;

ALTER TABLE ADR.INSURANCE_H ADD (
  CONSTRAINT SYS_C0066785
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INSURANCE_H
  DROP CONSTRAINT SYS_C0066786;

ALTER TABLE ADR.INSURANCE_H ADD (
  CONSTRAINT SYS_C0066786
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INSURANCE_H
  DROP CONSTRAINT SYS_C0066787;

ALTER TABLE ADR.INSURANCE_H ADD (
  CONSTRAINT SYS_C0066787
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INSURANCE_H
  DROP CONSTRAINT SYS_C0066788;

ALTER TABLE ADR.INSURANCE_H ADD (
  CONSTRAINT SYS_C0066788
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CONFLICT_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_029;

ALTER TABLE ADR.CONFLICT_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_029
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CONFLICT_DETAIL_H
  DROP CONSTRAINT SYS_C0066509;

ALTER TABLE ADR.CONFLICT_DETAIL_H ADD (
  CONSTRAINT SYS_C0066509
  CHECK ("MILITARY_SERVICE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CONFLICT_DETAIL_H
  DROP CONSTRAINT SYS_C0066506;

ALTER TABLE ADR.CONFLICT_DETAIL_H ADD (
  CONSTRAINT SYS_C0066506
  CHECK ("CONFLICT_DETAIL_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CONFLICT_DETAIL_H
  DROP CONSTRAINT SYS_C0066507;

ALTER TABLE ADR.CONFLICT_DETAIL_H ADD (
  CONSTRAINT SYS_C0066507
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CONFLICT_DETAIL_H
  DROP CONSTRAINT SYS_C0066508;

ALTER TABLE ADR.CONFLICT_DETAIL_H ADD (
  CONSTRAINT SYS_C0066508
  CHECK ("CONFLICT_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CONFLICT_DETAIL_H
  DROP CONSTRAINT SYS_C0066514;

ALTER TABLE ADR.CONFLICT_DETAIL_H ADD (
  CONSTRAINT SYS_C0066514
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CONFLICT_DETAIL_H
  DROP CONSTRAINT SYS_C0066510;

ALTER TABLE ADR.CONFLICT_DETAIL_H ADD (
  CONSTRAINT SYS_C0066510
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CONFLICT_DETAIL_H
  DROP CONSTRAINT SYS_C0066511;

ALTER TABLE ADR.CONFLICT_DETAIL_H ADD (
  CONSTRAINT SYS_C0066511
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CONFLICT_DETAIL_H
  DROP CONSTRAINT SYS_C0066512;

ALTER TABLE ADR.CONFLICT_DETAIL_H ADD (
  CONSTRAINT SYS_C0066512
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CONFLICT_DETAIL_H
  DROP CONSTRAINT SYS_C0066513;

ALTER TABLE ADR.CONFLICT_DETAIL_H ADD (
  CONSTRAINT SYS_C0066513
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS_H
  DROP CONSTRAINT SYS_C0067249;

ALTER TABLE ADR.ADDRESS_H ADD (
  CONSTRAINT SYS_C0067249
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS_H
  DROP CONSTRAINT SYS_C0067255;

ALTER TABLE ADR.ADDRESS_H ADD (
  CONSTRAINT SYS_C0067255
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_062;

ALTER TABLE ADR.ADDRESS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_062
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS_H
  DROP CONSTRAINT SYS_C0067248;

ALTER TABLE ADR.ADDRESS_H ADD (
  CONSTRAINT SYS_C0067248
  CHECK ("ADDRESS_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS_H
  DROP CONSTRAINT SYS_C0067254;

ALTER TABLE ADR.ADDRESS_H ADD (
  CONSTRAINT SYS_C0067254
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS_H
  DROP CONSTRAINT SYS_C0067250;

ALTER TABLE ADR.ADDRESS_H ADD (
  CONSTRAINT SYS_C0067250
  CHECK ("ADDRESS_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS_H
  DROP CONSTRAINT SYS_C0067251;

ALTER TABLE ADR.ADDRESS_H ADD (
  CONSTRAINT SYS_C0067251
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS_H
  DROP CONSTRAINT SYS_C0067252;

ALTER TABLE ADR.ADDRESS_H ADD (
  CONSTRAINT SYS_C0067252
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ADDRESS_H
  DROP CONSTRAINT SYS_C0067253;

ALTER TABLE ADR.ADDRESS_H ADD (
  CONSTRAINT SYS_C0067253
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FEE_BASIS_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_030;

ALTER TABLE ADR.FEE_BASIS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_030
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FEE_BASIS_H
  DROP CONSTRAINT SYS_C0066531;

ALTER TABLE ADR.FEE_BASIS_H ADD (
  CONSTRAINT SYS_C0066531
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FEE_BASIS_H
  DROP CONSTRAINT SYS_C0066528;

ALTER TABLE ADR.FEE_BASIS_H ADD (
  CONSTRAINT SYS_C0066528
  CHECK ("FEE_BASIS_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FEE_BASIS_H
  DROP CONSTRAINT SYS_C0066529;

ALTER TABLE ADR.FEE_BASIS_H ADD (
  CONSTRAINT SYS_C0066529
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FEE_BASIS_H
  DROP CONSTRAINT SYS_C0066530;

ALTER TABLE ADR.FEE_BASIS_H ADD (
  CONSTRAINT SYS_C0066530
  CHECK ("FEE_BASIS_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FEE_BASIS_H
  DROP CONSTRAINT SYS_C0066536;

ALTER TABLE ADR.FEE_BASIS_H ADD (
  CONSTRAINT SYS_C0066536
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FEE_BASIS_H
  DROP CONSTRAINT SYS_C0066532;

ALTER TABLE ADR.FEE_BASIS_H ADD (
  CONSTRAINT SYS_C0066532
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FEE_BASIS_H
  DROP CONSTRAINT SYS_C0066533;

ALTER TABLE ADR.FEE_BASIS_H ADD (
  CONSTRAINT SYS_C0066533
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FEE_BASIS_H
  DROP CONSTRAINT SYS_C0066534;

ALTER TABLE ADR.FEE_BASIS_H ADD (
  CONSTRAINT SYS_C0066534
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FEE_BASIS_H
  DROP CONSTRAINT SYS_C0066535;

ALTER TABLE ADR.FEE_BASIS_H ADD (
  CONSTRAINT SYS_C0066535
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_014;

ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_014
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H
  DROP CONSTRAINT SYS_C0066170;

ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H ADD (
  CONSTRAINT SYS_C0066170
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H
  DROP CONSTRAINT SYS_C0066167;

ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H ADD (
  CONSTRAINT SYS_C0066167
  CHECK ("CATASTROPHIC_DISABILITY_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H
  DROP CONSTRAINT SYS_C0066168;

ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H ADD (
  CONSTRAINT SYS_C0066168
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H
  DROP CONSTRAINT SYS_C0066169;

ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H ADD (
  CONSTRAINT SYS_C0066169
  CHECK ("CATASTROPHIC_DISABILITY_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H
  DROP CONSTRAINT SYS_C0066175;

ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H ADD (
  CONSTRAINT SYS_C0066175
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H
  DROP CONSTRAINT SYS_C0066171;

ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H ADD (
  CONSTRAINT SYS_C0066171
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H
  DROP CONSTRAINT SYS_C0066172;

ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H ADD (
  CONSTRAINT SYS_C0066172
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H
  DROP CONSTRAINT SYS_C0066173;

ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H ADD (
  CONSTRAINT SYS_C0066173
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H
  DROP CONSTRAINT SYS_C0066174;

ALTER TABLE ADR.CATASTROPHIC_DISABILITY_H ADD (
  CONSTRAINT SYS_C0066174
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_017;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_017
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H
  DROP CONSTRAINT SYS_C0066244;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H ADD (
  CONSTRAINT SYS_C0066244
  CHECK ("FINANCIAL_STATEMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H
  DROP CONSTRAINT SYS_C0066241;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H ADD (
  CONSTRAINT SYS_C0066241
  CHECK ("FINANCIAL_EXPENSE_DETAIL_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H
  DROP CONSTRAINT SYS_C0066242;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H ADD (
  CONSTRAINT SYS_C0066242
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H
  DROP CONSTRAINT SYS_C0066243;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H ADD (
  CONSTRAINT SYS_C0066243
  CHECK ("FINANCIAL_EXPENSE_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H
  DROP CONSTRAINT SYS_C0066250;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H ADD (
  CONSTRAINT SYS_C0066250
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H
  DROP CONSTRAINT SYS_C0066245;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H ADD (
  CONSTRAINT SYS_C0066245
  CHECK ("FINANCIAL_EXPENSE_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H
  DROP CONSTRAINT SYS_C0066246;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H ADD (
  CONSTRAINT SYS_C0066246
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H
  DROP CONSTRAINT SYS_C0066247;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H ADD (
  CONSTRAINT SYS_C0066247
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H
  DROP CONSTRAINT SYS_C0066248;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H ADD (
  CONSTRAINT SYS_C0066248
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H
  DROP CONSTRAINT SYS_C0066249;

ALTER TABLE ADR.FINANCIAL_EXPENSE_DETAIL_H ADD (
  CONSTRAINT SYS_C0066249
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_033;

ALTER TABLE ADR.MILITARY_SERVICE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_033
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_H
  DROP CONSTRAINT SYS_C0066586;

ALTER TABLE ADR.MILITARY_SERVICE_H ADD (
  CONSTRAINT SYS_C0066586
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_H
  DROP CONSTRAINT SYS_C0066583;

ALTER TABLE ADR.MILITARY_SERVICE_H ADD (
  CONSTRAINT SYS_C0066583
  CHECK ("MILITARY_SERVICE_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_H
  DROP CONSTRAINT SYS_C0066584;

ALTER TABLE ADR.MILITARY_SERVICE_H ADD (
  CONSTRAINT SYS_C0066584
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_H
  DROP CONSTRAINT SYS_C0066585;

ALTER TABLE ADR.MILITARY_SERVICE_H ADD (
  CONSTRAINT SYS_C0066585
  CHECK ("MILITARY_SERVICE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_H
  DROP CONSTRAINT SYS_C0066592;

ALTER TABLE ADR.MILITARY_SERVICE_H ADD (
  CONSTRAINT SYS_C0066592
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_H
  DROP CONSTRAINT SYS_C0066587;

ALTER TABLE ADR.MILITARY_SERVICE_H ADD (
  CONSTRAINT SYS_C0066587
  CHECK ("STD_INSTITUTION_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_H
  DROP CONSTRAINT SYS_C0066588;

ALTER TABLE ADR.MILITARY_SERVICE_H ADD (
  CONSTRAINT SYS_C0066588
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_H
  DROP CONSTRAINT SYS_C0066589;

ALTER TABLE ADR.MILITARY_SERVICE_H ADD (
  CONSTRAINT SYS_C0066589
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_H
  DROP CONSTRAINT SYS_C0066590;

ALTER TABLE ADR.MILITARY_SERVICE_H ADD (
  CONSTRAINT SYS_C0066590
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_H
  DROP CONSTRAINT SYS_C0066591;

ALTER TABLE ADR.MILITARY_SERVICE_H ADD (
  CONSTRAINT SYS_C0066591
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_042;

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_042
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H
  DROP CONSTRAINT SYS_C0066768;

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H ADD (
  CONSTRAINT SYS_C0066768
  CHECK ("MILITARY_SERVICE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H
  DROP CONSTRAINT SYS_C0066765;

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H ADD (
  CONSTRAINT SYS_C0066765
  CHECK ("MILITARY_SERVICE_EPISODE_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H
  DROP CONSTRAINT SYS_C0066766;

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H ADD (
  CONSTRAINT SYS_C0066766
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H
  DROP CONSTRAINT SYS_C0066767;

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H ADD (
  CONSTRAINT SYS_C0066767
  CHECK ("MILITARY_SERVICE_EPISODE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H
  DROP CONSTRAINT SYS_C0066773;

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H ADD (
  CONSTRAINT SYS_C0066773
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H
  DROP CONSTRAINT SYS_C0066769;

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H ADD (
  CONSTRAINT SYS_C0066769
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H
  DROP CONSTRAINT SYS_C0066770;

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H ADD (
  CONSTRAINT SYS_C0066770
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H
  DROP CONSTRAINT SYS_C0066771;

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H ADD (
  CONSTRAINT SYS_C0066771
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H
  DROP CONSTRAINT SYS_C0066772;

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H ADD (
  CONSTRAINT SYS_C0066772
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT
  DROP CONSTRAINT SYS_C00160893;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT ADD (
  CONSTRAINT SYS_C00160893
  CHECK ("STD_INSTITUTION_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT
  DROP CONSTRAINT SYS_C00160898;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT ADD (
  CONSTRAINT SYS_C00160898
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT
  DROP CONSTRAINT SYS_C00160897;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT ADD (
  CONSTRAINT SYS_C00160897
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT
  DROP CONSTRAINT SYS_C00160891;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT ADD (
  CONSTRAINT SYS_C00160891
  CHECK ("PATIENT_PROVIDER_ASSIGNMENT_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT
  DROP CONSTRAINT SYS_C00160892;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT ADD (
  CONSTRAINT SYS_C00160892
  CHECK ("HEALTH_CARE_PROVIDER_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT
  DROP CONSTRAINT SYS_C00160899;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT ADD (
  CONSTRAINT SYS_C00160899
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT
  DROP CONSTRAINT SYS_C00160894;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT ADD (
  CONSTRAINT SYS_C00160894
  CHECK ("DATE_ASSIGNED" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT
  DROP CONSTRAINT SYS_C00160895;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT ADD (
  CONSTRAINT SYS_C00160895
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT
  DROP CONSTRAINT SYS_C00160896;

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT ADD (
  CONSTRAINT SYS_C00160896
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_058;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_058
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H
  DROP CONSTRAINT SYS_C0067129;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H ADD (
  CONSTRAINT SYS_C0067129
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H
  DROP CONSTRAINT SYS_C0067126;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H ADD (
  CONSTRAINT SYS_C0067126
  CHECK ("SITE_RECEIVED_ELIGIBILITY_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H
  DROP CONSTRAINT SYS_C0067127;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H ADD (
  CONSTRAINT SYS_C0067127
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H
  DROP CONSTRAINT SYS_C0067128;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H ADD (
  CONSTRAINT SYS_C0067128
  CHECK ("SITE_RECEIVED_ELIGIBILITY_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H
  DROP CONSTRAINT SYS_C0067134;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H ADD (
  CONSTRAINT SYS_C0067134
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H
  DROP CONSTRAINT SYS_C0067130;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H ADD (
  CONSTRAINT SYS_C0067130
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H
  DROP CONSTRAINT SYS_C0067131;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H ADD (
  CONSTRAINT SYS_C0067131
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H
  DROP CONSTRAINT SYS_C0067132;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H ADD (
  CONSTRAINT SYS_C0067132
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H
  DROP CONSTRAINT SYS_C0067133;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H ADD (
  CONSTRAINT SYS_C0067133
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY
  DROP CONSTRAINT AVCON_1172521913_PRIMA_000;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY ADD (
  CONSTRAINT AVCON_1172521913_PRIMA_000
  CHECK (PRIMARY_SECONDARY_OR_OTHER_IND IN ('P', 'S', 'O'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY
  DROP CONSTRAINT SYS_C0066419;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY ADD (
  CONSTRAINT SYS_C0066419
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY
  DROP CONSTRAINT SYS_C0066423;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY ADD (
  CONSTRAINT SYS_C0066423
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY
  DROP CONSTRAINT SYS_C0066418;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY ADD (
  CONSTRAINT SYS_C0066418
  CHECK ("SITE_RECEIVED_ELIGIBILITY_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY
  DROP CONSTRAINT SYS_C0066424;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY ADD (
  CONSTRAINT SYS_C0066424
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY
  DROP CONSTRAINT SYS_C0066420;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY ADD (
  CONSTRAINT SYS_C0066420
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY
  DROP CONSTRAINT SYS_C0066421;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY ADD (
  CONSTRAINT SYS_C0066421
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY
  DROP CONSTRAINT SYS_C0066422;

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY ADD (
  CONSTRAINT SYS_C0066422
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_040;

ALTER TABLE ADR.REGISTRY_TRAIT_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_040
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT_H
  DROP CONSTRAINT SYS_C0066712;

ALTER TABLE ADR.REGISTRY_TRAIT_H ADD (
  CONSTRAINT SYS_C0066712
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT_H
  DROP CONSTRAINT SYS_C0066710;

ALTER TABLE ADR.REGISTRY_TRAIT_H ADD (
  CONSTRAINT SYS_C0066710
  CHECK ("REGISTRY_TRAIT_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT_H
  DROP CONSTRAINT SYS_C0066711;

ALTER TABLE ADR.REGISTRY_TRAIT_H ADD (
  CONSTRAINT SYS_C0066711
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT_H
  DROP CONSTRAINT SYS_C0066716;

ALTER TABLE ADR.REGISTRY_TRAIT_H ADD (
  CONSTRAINT SYS_C0066716
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT_H
  DROP CONSTRAINT SYS_C0066713;

ALTER TABLE ADR.REGISTRY_TRAIT_H ADD (
  CONSTRAINT SYS_C0066713
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT_H
  DROP CONSTRAINT SYS_C0066714;

ALTER TABLE ADR.REGISTRY_TRAIT_H ADD (
  CONSTRAINT SYS_C0066714
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT_H
  DROP CONSTRAINT SYS_C0066715;

ALTER TABLE ADR.REGISTRY_TRAIT_H ADD (
  CONSTRAINT SYS_C0066715
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT
  DROP CONSTRAINT SYS_C0066604;

ALTER TABLE ADR.REGISTRY_TRAIT ADD (
  CONSTRAINT SYS_C0066604
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT
  DROP CONSTRAINT SYS_C0066606;

ALTER TABLE ADR.REGISTRY_TRAIT ADD (
  CONSTRAINT SYS_C0066606
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT
  DROP CONSTRAINT SYS_C0066605;

ALTER TABLE ADR.REGISTRY_TRAIT ADD (
  CONSTRAINT SYS_C0066605
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT
  DROP CONSTRAINT SYS_C0066603;

ALTER TABLE ADR.REGISTRY_TRAIT ADD (
  CONSTRAINT SYS_C0066603
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT
  DROP CONSTRAINT SYS_C0066602;

ALTER TABLE ADR.REGISTRY_TRAIT ADD (
  CONSTRAINT SYS_C0066602
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT
  DROP CONSTRAINT SYS_C0066600;

ALTER TABLE ADR.REGISTRY_TRAIT ADD (
  CONSTRAINT SYS_C0066600
  CHECK ("REGISTRY_TRAIT_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.REGISTRY_TRAIT
  DROP CONSTRAINT SYS_C0066601;

ALTER TABLE ADR.REGISTRY_TRAIT ADD (
  CONSTRAINT SYS_C0066601
  CHECK ("REGISTRY_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_041;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_041
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H
  DROP CONSTRAINT SYS_C0066727;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H ADD (
  CONSTRAINT SYS_C0066727
  CHECK ("STD_DISABILITYCONDITION_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H
  DROP CONSTRAINT SYS_C0066724;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H ADD (
  CONSTRAINT SYS_C0066724
  CHECK ("RATED_DISABILITY_DETAIL_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H
  DROP CONSTRAINT SYS_C0066725;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H ADD (
  CONSTRAINT SYS_C0066725
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H
  DROP CONSTRAINT SYS_C0066726;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H ADD (
  CONSTRAINT SYS_C0066726
  CHECK ("RATED_DISABILITY_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H
  DROP CONSTRAINT SYS_C0066733;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H ADD (
  CONSTRAINT SYS_C0066733
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H
  DROP CONSTRAINT SYS_C0066728;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H ADD (
  CONSTRAINT SYS_C0066728
  CHECK ("SERVICE_CONNECTED_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H
  DROP CONSTRAINT SYS_C0066729;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H ADD (
  CONSTRAINT SYS_C0066729
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H
  DROP CONSTRAINT SYS_C0066730;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H ADD (
  CONSTRAINT SYS_C0066730
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H
  DROP CONSTRAINT SYS_C0066731;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H ADD (
  CONSTRAINT SYS_C0066731
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H
  DROP CONSTRAINT SYS_C0066732;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H ADD (
  CONSTRAINT SYS_C0066732
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL
  DROP CONSTRAINT SYS_C0066152;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL ADD (
  CONSTRAINT SYS_C0066152
  CHECK ("SERVICE_CONNECTED_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL
  DROP CONSTRAINT SYS_C0066156;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL ADD (
  CONSTRAINT SYS_C0066156
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL
  DROP CONSTRAINT SYS_C0066150;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL ADD (
  CONSTRAINT SYS_C0066150
  CHECK ("RATED_DISABILITY_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL
  DROP CONSTRAINT SYS_C0066151;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL ADD (
  CONSTRAINT SYS_C0066151
  CHECK ("STD_DISABILITYCONDITION_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL
  DROP CONSTRAINT SYS_C0066157;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL ADD (
  CONSTRAINT SYS_C0066157
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL
  DROP CONSTRAINT SYS_C0066153;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL ADD (
  CONSTRAINT SYS_C0066153
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL
  DROP CONSTRAINT SYS_C0066154;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL ADD (
  CONSTRAINT SYS_C0066154
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.RATED_DISABILITY_DETAIL
  DROP CONSTRAINT SYS_C0066155;

ALTER TABLE ADR.RATED_DISABILITY_DETAIL ADD (
  CONSTRAINT SYS_C0066155
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_009;

ALTER TABLE ADR.PERSON_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_009
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_H
  DROP CONSTRAINT SYS_C0066043;

ALTER TABLE ADR.PERSON_H ADD (
  CONSTRAINT SYS_C0066043
  CHECK ("VPID_VALUE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_H
  DROP CONSTRAINT SYS_C0066039;

ALTER TABLE ADR.PERSON_H ADD (
  CONSTRAINT SYS_C0066039
  CHECK ("PERSON_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_H
  DROP CONSTRAINT SYS_C0066040;

ALTER TABLE ADR.PERSON_H ADD (
  CONSTRAINT SYS_C0066040
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_H
  DROP CONSTRAINT SYS_C0066041;

ALTER TABLE ADR.PERSON_H ADD (
  CONSTRAINT SYS_C0066041
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_H
  DROP CONSTRAINT SYS_C0066048;

ALTER TABLE ADR.PERSON_H ADD (
  CONSTRAINT SYS_C0066048
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_H
  DROP CONSTRAINT SYS_C0066044;

ALTER TABLE ADR.PERSON_H ADD (
  CONSTRAINT SYS_C0066044
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_H
  DROP CONSTRAINT SYS_C0066045;

ALTER TABLE ADR.PERSON_H ADD (
  CONSTRAINT SYS_C0066045
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_H
  DROP CONSTRAINT SYS_C0066046;

ALTER TABLE ADR.PERSON_H ADD (
  CONSTRAINT SYS_C0066046
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_H
  DROP CONSTRAINT SYS_C0066047;

ALTER TABLE ADR.PERSON_H ADD (
  CONSTRAINT SYS_C0066047
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_ETHNICITY_H
  DROP CONSTRAINT SYS_C0065938;

ALTER TABLE ADR.PERSON_ETHNICITY_H ADD (
  CONSTRAINT SYS_C0065938
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_ETHNICITY_H
  DROP CONSTRAINT SYS_C0065937;

ALTER TABLE ADR.PERSON_ETHNICITY_H ADD (
  CONSTRAINT SYS_C0065937
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_ETHNICITY_H
  DROP CONSTRAINT SYS_C0065939;

ALTER TABLE ADR.PERSON_ETHNICITY_H ADD (
  CONSTRAINT SYS_C0065939
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_ETHNICITY_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_003;

ALTER TABLE ADR.PERSON_ETHNICITY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_003
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_ETHNICITY_H
  DROP CONSTRAINT SYS_C0065934;

ALTER TABLE ADR.PERSON_ETHNICITY_H ADD (
  CONSTRAINT SYS_C0065934
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_ETHNICITY_H
  DROP CONSTRAINT SYS_C0065931;

ALTER TABLE ADR.PERSON_ETHNICITY_H ADD (
  CONSTRAINT SYS_C0065931
  CHECK ("PERSON_ETHNICITY_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_ETHNICITY_H
  DROP CONSTRAINT SYS_C0065932;

ALTER TABLE ADR.PERSON_ETHNICITY_H ADD (
  CONSTRAINT SYS_C0065932
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_ETHNICITY_H
  DROP CONSTRAINT SYS_C0065933;

ALTER TABLE ADR.PERSON_ETHNICITY_H ADD (
  CONSTRAINT SYS_C0065933
  CHECK ("PERSON_ETHNICITY_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_ETHNICITY_H
  DROP CONSTRAINT SYS_C0065940;

ALTER TABLE ADR.PERSON_ETHNICITY_H ADD (
  CONSTRAINT SYS_C0065940
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_ETHNICITY_H
  DROP CONSTRAINT SYS_C0065935;

ALTER TABLE ADR.PERSON_ETHNICITY_H ADD (
  CONSTRAINT SYS_C0065935
  CHECK ("STD_ETHNICITY_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_ETHNICITY_H
  DROP CONSTRAINT SYS_C0065936;

ALTER TABLE ADR.PERSON_ETHNICITY_H ADD (
  CONSTRAINT SYS_C0065936
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CONTACT
  DROP CONSTRAINT SYS_C0067212;

ALTER TABLE ADR.PERSON_CONTACT ADD (
  CONSTRAINT SYS_C0067212
  CHECK ("PERSON_CONTACT_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CONTACT
  DROP CONSTRAINT SYS_C0067216;

ALTER TABLE ADR.PERSON_CONTACT ADD (
  CONSTRAINT SYS_C0067216
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CONTACT
  DROP CONSTRAINT SYS_C0067210;

ALTER TABLE ADR.PERSON_CONTACT ADD (
  CONSTRAINT SYS_C0067210
  CHECK ("PERSON_CONTACT_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CONTACT
  DROP CONSTRAINT SYS_C0067211;

ALTER TABLE ADR.PERSON_CONTACT ADD (
  CONSTRAINT SYS_C0067211
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CONTACT
  DROP CONSTRAINT SYS_C0067217;

ALTER TABLE ADR.PERSON_CONTACT ADD (
  CONSTRAINT SYS_C0067217
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CONTACT
  DROP CONSTRAINT SYS_C0067213;

ALTER TABLE ADR.PERSON_CONTACT ADD (
  CONSTRAINT SYS_C0067213
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CONTACT
  DROP CONSTRAINT SYS_C0067214;

ALTER TABLE ADR.PERSON_CONTACT ADD (
  CONSTRAINT SYS_C0067214
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CONTACT
  DROP CONSTRAINT SYS_C0067215;

ALTER TABLE ADR.PERSON_CONTACT ADD (
  CONSTRAINT SYS_C0067215
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON
  DROP CONSTRAINT SYS_C0066486;

ALTER TABLE ADR.PERSON ADD (
  CONSTRAINT SYS_C0066486
  CHECK ("VPID_VALUE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON
  DROP CONSTRAINT SYS_C0066490;

ALTER TABLE ADR.PERSON ADD (
  CONSTRAINT SYS_C0066490
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON
  DROP CONSTRAINT SYS_C0066489;

ALTER TABLE ADR.PERSON ADD (
  CONSTRAINT SYS_C0066489
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON
  DROP CONSTRAINT SYS_C0066484;

ALTER TABLE ADR.PERSON ADD (
  CONSTRAINT SYS_C0066484
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON
  DROP CONSTRAINT SYS_C0066491;

ALTER TABLE ADR.PERSON ADD (
  CONSTRAINT SYS_C0066491
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON
  DROP CONSTRAINT SYS_C0066487;

ALTER TABLE ADR.PERSON ADD (
  CONSTRAINT SYS_C0066487
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON
  DROP CONSTRAINT SYS_C0066488;

ALTER TABLE ADR.PERSON ADD (
  CONSTRAINT SYS_C0066488
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL
  DROP CONSTRAINT SYS_C0066219;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL ADD (
  CONSTRAINT SYS_C0066219
  CHECK ("MONETARY_BENEFIT_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL
  DROP CONSTRAINT SYS_C0066223;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL ADD (
  CONSTRAINT SYS_C0066223
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL
  DROP CONSTRAINT SYS_C0066217;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL ADD (
  CONSTRAINT SYS_C0066217
  CHECK ("MONETARY_BENEFIT_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL
  DROP CONSTRAINT SYS_C0066218;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL ADD (
  CONSTRAINT SYS_C0066218
  CHECK ("MONETARY_BENEFIT_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL
  DROP CONSTRAINT SYS_C0066224;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL ADD (
  CONSTRAINT SYS_C0066224
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL
  DROP CONSTRAINT SYS_C0066220;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL ADD (
  CONSTRAINT SYS_C0066220
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL
  DROP CONSTRAINT SYS_C0066221;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL ADD (
  CONSTRAINT SYS_C0066221
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL
  DROP CONSTRAINT SYS_C0066222;

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL ADD (
  CONSTRAINT SYS_C0066222
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_PRINT_REQUEST
  DROP CONSTRAINT SYS_C0067226;

ALTER TABLE ADR.COM_PRINT_REQUEST ADD (
  CONSTRAINT SYS_C0067226
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_PRINT_REQUEST
  DROP CONSTRAINT SYS_C0067230;

ALTER TABLE ADR.COM_PRINT_REQUEST ADD (
  CONSTRAINT SYS_C0067230
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_PRINT_REQUEST
  DROP CONSTRAINT SYS_C0067229;

ALTER TABLE ADR.COM_PRINT_REQUEST ADD (
  CONSTRAINT SYS_C0067229
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_PRINT_REQUEST
  DROP CONSTRAINT SYS_C0067228;

ALTER TABLE ADR.COM_PRINT_REQUEST ADD (
  CONSTRAINT SYS_C0067228
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_PRINT_REQUEST
  DROP CONSTRAINT SYS_C0067224;

ALTER TABLE ADR.COM_PRINT_REQUEST ADD (
  CONSTRAINT SYS_C0067224
  CHECK ("COM_PRINT_REQUEST_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_PRINT_REQUEST
  DROP CONSTRAINT SYS_C0067225;

ALTER TABLE ADR.COM_PRINT_REQUEST ADD (
  CONSTRAINT SYS_C0067225
  CHECK ("COM_MAILING_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.COM_PRINT_REQUEST
  DROP CONSTRAINT SYS_C0067227;

ALTER TABLE ADR.COM_PRINT_REQUEST ADD (
  CONSTRAINT SYS_C0067227
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CHANGE_LOG
  DROP CONSTRAINT SYS_C00140211;

ALTER TABLE ADR.PERSON_CHANGE_LOG ADD (
  CONSTRAINT SYS_C00140211
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CHANGE_LOG
  DROP CONSTRAINT SYS_C00140214;

ALTER TABLE ADR.PERSON_CHANGE_LOG ADD (
  CONSTRAINT SYS_C00140214
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CHANGE_LOG
  DROP CONSTRAINT SYS_C00140209;

ALTER TABLE ADR.PERSON_CHANGE_LOG ADD (
  CONSTRAINT SYS_C00140209
  CHECK ("PERSON_CHANGE_LOG_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CHANGE_LOG
  DROP CONSTRAINT SYS_C00140210;

ALTER TABLE ADR.PERSON_CHANGE_LOG ADD (
  CONSTRAINT SYS_C00140210
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CHANGE_LOG
  DROP CONSTRAINT SYS_C00140215;

ALTER TABLE ADR.PERSON_CHANGE_LOG ADD (
  CONSTRAINT SYS_C00140215
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CHANGE_LOG
  DROP CONSTRAINT SYS_C00140212;

ALTER TABLE ADR.PERSON_CHANGE_LOG ADD (
  CONSTRAINT SYS_C00140212
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PERSON_CHANGE_LOG
  DROP CONSTRAINT SYS_C00140213;

ALTER TABLE ADR.PERSON_CHANGE_LOG ADD (
  CONSTRAINT SYS_C00140213
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN_VERIFICATION_DETAIL
  DROP CONSTRAINT SYS_C0065900;

ALTER TABLE ADR.SSN_VERIFICATION_DETAIL ADD (
  CONSTRAINT SYS_C0065900
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN_VERIFICATION_DETAIL
  DROP CONSTRAINT SYS_C0065903;

ALTER TABLE ADR.SSN_VERIFICATION_DETAIL ADD (
  CONSTRAINT SYS_C0065903
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN_VERIFICATION_DETAIL
  DROP CONSTRAINT SYS_C0065902;

ALTER TABLE ADR.SSN_VERIFICATION_DETAIL ADD (
  CONSTRAINT SYS_C0065902
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN_VERIFICATION_DETAIL
  DROP CONSTRAINT SYS_C0065899;

ALTER TABLE ADR.SSN_VERIFICATION_DETAIL ADD (
  CONSTRAINT SYS_C0065899
  CHECK ("SSN_VERIFICATION_DETAIL_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN_VERIFICATION_DETAIL
  DROP CONSTRAINT SYS_C0065904;

ALTER TABLE ADR.SSN_VERIFICATION_DETAIL ADD (
  CONSTRAINT SYS_C0065904
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SSN_VERIFICATION_DETAIL
  DROP CONSTRAINT SYS_C0065901;

ALTER TABLE ADR.SSN_VERIFICATION_DETAIL ADD (
  CONSTRAINT SYS_C0065901
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_008;

ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_008
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H
  DROP CONSTRAINT SYS_C0066033;

ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H ADD (
  CONSTRAINT SYS_C0066033
  CHECK ("PURPLE_HEART_REGISTRY_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H
  DROP CONSTRAINT SYS_C0066031;

ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H ADD (
  CONSTRAINT SYS_C0066031
  CHECK ("PURPLE_HEART_REGISTRY_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H
  DROP CONSTRAINT SYS_C0066032;

ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H ADD (
  CONSTRAINT SYS_C0066032
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H
  DROP CONSTRAINT SYS_C0066038;

ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H ADD (
  CONSTRAINT SYS_C0066038
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H
  DROP CONSTRAINT SYS_C0066034;

ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H ADD (
  CONSTRAINT SYS_C0066034
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H
  DROP CONSTRAINT SYS_C0066035;

ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H ADD (
  CONSTRAINT SYS_C0066035
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H
  DROP CONSTRAINT SYS_C0066036;

ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H ADD (
  CONSTRAINT SYS_C0066036
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H
  DROP CONSTRAINT SYS_C0066037;

ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H ADD (
  CONSTRAINT SYS_C0066037
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOMPETENT_RULING_H
  DROP CONSTRAINT AVCON_1172521913_TRANS_007;

ALTER TABLE ADR.INCOMPETENT_RULING_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_007
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOMPETENT_RULING_H
  DROP CONSTRAINT SYS_C0066017;

ALTER TABLE ADR.INCOMPETENT_RULING_H ADD (
  CONSTRAINT SYS_C0066017
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOMPETENT_RULING_H
  DROP CONSTRAINT SYS_C0066014;

ALTER TABLE ADR.INCOMPETENT_RULING_H ADD (
  CONSTRAINT SYS_C0066014
  CHECK ("INCOMPETENT_RULING_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOMPETENT_RULING_H
  DROP CONSTRAINT SYS_C0066015;

ALTER TABLE ADR.INCOMPETENT_RULING_H ADD (
  CONSTRAINT SYS_C0066015
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOMPETENT_RULING_H
  DROP CONSTRAINT SYS_C0066016;

ALTER TABLE ADR.INCOMPETENT_RULING_H ADD (
  CONSTRAINT SYS_C0066016
  CHECK ("INCOMPETENT_RULING_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOMPETENT_RULING_H
  DROP CONSTRAINT SYS_C0066022;

ALTER TABLE ADR.INCOMPETENT_RULING_H ADD (
  CONSTRAINT SYS_C0066022
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOMPETENT_RULING_H
  DROP CONSTRAINT SYS_C0066018;

ALTER TABLE ADR.INCOMPETENT_RULING_H ADD (
  CONSTRAINT SYS_C0066018
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOMPETENT_RULING_H
  DROP CONSTRAINT SYS_C0066019;

ALTER TABLE ADR.INCOMPETENT_RULING_H ADD (
  CONSTRAINT SYS_C0066019
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOMPETENT_RULING_H
  DROP CONSTRAINT SYS_C0066020;

ALTER TABLE ADR.INCOMPETENT_RULING_H ADD (
  CONSTRAINT SYS_C0066020
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.INCOMPETENT_RULING_H
  DROP CONSTRAINT SYS_C0066021;

ALTER TABLE ADR.INCOMPETENT_RULING_H ADD (
  CONSTRAINT SYS_C0066021
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION
  DROP CONSTRAINT SYS_C0067369;

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION ADD (
  CONSTRAINT SYS_C0067369
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION
  DROP CONSTRAINT SYS_C0067372;

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION ADD (
  CONSTRAINT SYS_C0067372
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION
  DROP CONSTRAINT SYS_C0067367;

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION ADD (
  CONSTRAINT SYS_C0067367
  CHECK ("ELIGIBILITY_VERIFICATION_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION
  DROP CONSTRAINT SYS_C0067368;

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION ADD (
  CONSTRAINT SYS_C0067368
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION
  DROP CONSTRAINT SYS_C0067373;

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION ADD (
  CONSTRAINT SYS_C0067373
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION
  DROP CONSTRAINT SYS_C0067370;

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION ADD (
  CONSTRAINT SYS_C0067370
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ELIGIBILITY_VERIFICATION
  DROP CONSTRAINT SYS_C0067371;

ALTER TABLE ADR.ELIGIBILITY_VERIFICATION ADD (
  CONSTRAINT SYS_C0067371
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IVM_MIGRATE
  DROP CONSTRAINT AVCON_1172521913_MARKE_000;

ALTER TABLE ADR.IVM_MIGRATE ADD (
  CONSTRAINT AVCON_1172521913_MARKE_000
  CHECK (MARKED_FLAG BETWEEN 0 AND 0 OR MARKED_FLAG BETWEEN 1 AND 1)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IVM_MIGRATE
  DROP CONSTRAINT AVCON_1172521913_REMIG_000;

ALTER TABLE ADR.IVM_MIGRATE ADD (
  CONSTRAINT AVCON_1172521913_REMIG_000
  CHECK (REMIGRATE_FLAG BETWEEN 0 AND 0 OR REMIGRATE_FLAG BETWEEN 1 AND 1)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IVM_MIGRATE
  DROP CONSTRAINT SYS_C0065969;

ALTER TABLE ADR.IVM_MIGRATE ADD (
  CONSTRAINT SYS_C0065969
  CHECK ("MARKED_FLAG" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IVM_MIGRATE
  DROP CONSTRAINT SYS_C0065974;

ALTER TABLE ADR.IVM_MIGRATE ADD (
  CONSTRAINT SYS_C0065974
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IVM_MIGRATE
  DROP CONSTRAINT SYS_C0065967;

ALTER TABLE ADR.IVM_MIGRATE ADD (
  CONSTRAINT SYS_C0065967
  CHECK ("IVM_MIGRATE_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IVM_MIGRATE
  DROP CONSTRAINT SYS_C0065968;

ALTER TABLE ADR.IVM_MIGRATE ADD (
  CONSTRAINT SYS_C0065968
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IVM_MIGRATE
  DROP CONSTRAINT SYS_C0065975;

ALTER TABLE ADR.IVM_MIGRATE ADD (
  CONSTRAINT SYS_C0065975
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IVM_MIGRATE
  DROP CONSTRAINT SYS_C0065970;

ALTER TABLE ADR.IVM_MIGRATE ADD (
  CONSTRAINT SYS_C0065970
  CHECK ("REMIGRATE_FLAG" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IVM_MIGRATE
  DROP CONSTRAINT SYS_C0065971;

ALTER TABLE ADR.IVM_MIGRATE ADD (
  CONSTRAINT SYS_C0065971
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IVM_MIGRATE
  DROP CONSTRAINT SYS_C0065972;

ALTER TABLE ADR.IVM_MIGRATE ADD (
  CONSTRAINT SYS_C0065972
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.IVM_MIGRATE
  DROP CONSTRAINT SYS_C0065973;

ALTER TABLE ADR.IVM_MIGRATE ADD (
  CONSTRAINT SYS_C0065973
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
  DROP CONSTRAINT SYS_C0067377;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT SYS_C0067377
  CHECK ("ENROLLMENT_OVERRIDDEN_FLAG" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
  DROP CONSTRAINT SYS_C0067378;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT SYS_C0067378
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
  DROP CONSTRAINT AVCON_1172521913_ENROL_000;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT AVCON_1172521913_ENROL_000
  CHECK (ENROLLMENT_OVERRIDDEN_FLAG BETWEEN 0
AND 0 OR ENROLLMENT_OVERRIDDEN_FLAG BETWEEN 1 AND 1)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
  DROP CONSTRAINT SYS_C0067376;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT SYS_C0067376
  CHECK ("EGT_SETTING_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
  DROP CONSTRAINT SYS_C0067382;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT SYS_C0067382
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
  DROP CONSTRAINT SYS_C0067381;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT SYS_C0067381
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
  DROP CONSTRAINT SYS_C0067380;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT SYS_C0067380
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
  DROP CONSTRAINT SYS_C0067379;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT SYS_C0067379
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
  DROP CONSTRAINT SYS_C0067374;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT SYS_C0067374
  CHECK ("ENROLLMENT_DETERMINATION_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.ENROLLMENT_DETERMINATION
  DROP CONSTRAINT SYS_C0067375;

ALTER TABLE ADR.ENROLLMENT_DETERMINATION ADD (
  CONSTRAINT SYS_C0067375
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR
  DROP CONSTRAINT SYS_C0066593;

ALTER TABLE ADR.SPECIAL_FACTOR ADD (
  CONSTRAINT SYS_C0066593
  CHECK ("SPECIAL_FACTOR_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR
  DROP CONSTRAINT SYS_C0066595;

ALTER TABLE ADR.SPECIAL_FACTOR ADD (
  CONSTRAINT SYS_C0066595
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR
  DROP CONSTRAINT SYS_C0066599;

ALTER TABLE ADR.SPECIAL_FACTOR ADD (
  CONSTRAINT SYS_C0066599
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR
  DROP CONSTRAINT SYS_C0066598;

ALTER TABLE ADR.SPECIAL_FACTOR ADD (
  CONSTRAINT SYS_C0066598
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR
  DROP CONSTRAINT SYS_C0066597;

ALTER TABLE ADR.SPECIAL_FACTOR ADD (
  CONSTRAINT SYS_C0066597
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR
  DROP CONSTRAINT SYS_C0066596;

ALTER TABLE ADR.SPECIAL_FACTOR ADD (
  CONSTRAINT SYS_C0066596
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.SPECIAL_FACTOR
  DROP CONSTRAINT SYS_C0066594;

ALTER TABLE ADR.SPECIAL_FACTOR ADD (
  CONSTRAINT SYS_C0066594
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE);
ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE MODIFY 
  FUTURE_DISCHARGE_SRC_TYPE_ID NULL;

ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE MODIFY 
  FUTURE_DISCHARGE_SRC_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE MODIFY 
  CODE NULL;

ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE MODIFY 
  CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE MODIFY 
  NAME NULL;

ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE MODIFY 
  ISACTIVE NULL;

ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE MODIFY 
  ISACTIVE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.FUTURE_DISCHARGE_SRC_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE MODIFY 
  MILITARY_FUTURE_DISCHARGE_ID NULL;

ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE MODIFY 
  MILITARY_FUTURE_DISCHARGE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE MODIFY 
  FUTURE_DISCHARGE_DATE NULL;

ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE MODIFY 
  FUTURE_DISCHARGE_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE MODIFY 
  MILITARY_SERVICE_ID NULL;

ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE MODIFY 
  MILITARY_SERVICE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE MODIFY 
  SERVICE_BRANCH_TYPE_ID NULL;

ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE MODIFY 
  SERVICE_BRANCH_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE MODIFY 
  SERVICE_ENTRY_DATE NULL;

ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE MODIFY 
  SERVICE_ENTRY_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE_H MODIFY 
  MILITARY_FUTURE_DISCHARGE_H_ID NULL;

ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE_H MODIFY 
  MILITARY_FUTURE_DISCHARGE_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE_H MODIFY 
  MILITARY_FUTURE_DISCHARGE_ID NULL;

ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE_H MODIFY 
  MILITARY_FUTURE_DISCHARGE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.MILITARY_FUTURE_DISCHARGE_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PURPOSE_OF_USE_TYPE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PURPOSE_OF_USE_TYPE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PURPOSE_OF_USE_TYPE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PURPOSE_OF_USE_TYPE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PURPOSE_OF_USE_TYPE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PURPOSE_OF_USE_TYPE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PURPOSE_OF_USE_TYPE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PURPOSE_OF_USE_TYPE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PURPOSE_OF_USE_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PURPOSE_OF_USE_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PURPOSE_OF_USE_TYPE MODIFY 
  CODE NULL;

ALTER TABLE ADR.PURPOSE_OF_USE_TYPE MODIFY 
  CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PURPOSE_OF_USE_TYPE MODIFY 
  NAME NULL;

ALTER TABLE ADR.PURPOSE_OF_USE_TYPE MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PURPOSE_OF_USE_TYPE MODIFY 
  ISACTIVE NULL;

ALTER TABLE ADR.PURPOSE_OF_USE_TYPE MODIFY 
  ISACTIVE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.STOP_COM_RSN_TYPE MODIFY 
  STOP_COM_RSN_TYPE_ID NULL;

ALTER TABLE ADR.STOP_COM_RSN_TYPE MODIFY 
  STOP_COM_RSN_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.STOP_COM_RSN_TYPE MODIFY 
  CODE NULL;

ALTER TABLE ADR.STOP_COM_RSN_TYPE MODIFY 
  CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.STOP_COM_RSN_TYPE MODIFY 
  NAME NULL;

ALTER TABLE ADR.STOP_COM_RSN_TYPE MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.STOP_COM_RSN_TYPE MODIFY 
  ISACTIVE NULL;

ALTER TABLE ADR.STOP_COM_RSN_TYPE MODIFY 
  ISACTIVE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.STOP_COM_RSN_TYPE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.STOP_COM_RSN_TYPE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.STOP_COM_RSN_TYPE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.STOP_COM_RSN_TYPE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.STOP_COM_RSN_TYPE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.STOP_COM_RSN_TYPE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.STOP_COM_RSN_TYPE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.STOP_COM_RSN_TYPE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.STOP_COM_RSN_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.STOP_COM_RSN_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CLOSE_APL_RSN_TYPE MODIFY 
  CLOSE_APL_RSN_TYPE_ID NULL;

ALTER TABLE ADR.CLOSE_APL_RSN_TYPE MODIFY 
  CLOSE_APL_RSN_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CLOSE_APL_RSN_TYPE MODIFY 
  CODE NULL;

ALTER TABLE ADR.CLOSE_APL_RSN_TYPE MODIFY 
  CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CLOSE_APL_RSN_TYPE MODIFY 
  NAME NULL;

ALTER TABLE ADR.CLOSE_APL_RSN_TYPE MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CLOSE_APL_RSN_TYPE MODIFY 
  ISACTIVE NULL;

ALTER TABLE ADR.CLOSE_APL_RSN_TYPE MODIFY 
  ISACTIVE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CLOSE_APL_RSN_TYPE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CLOSE_APL_RSN_TYPE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CLOSE_APL_RSN_TYPE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CLOSE_APL_RSN_TYPE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CLOSE_APL_RSN_TYPE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CLOSE_APL_RSN_TYPE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CLOSE_APL_RSN_TYPE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CLOSE_APL_RSN_TYPE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CLOSE_APL_RSN_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CLOSE_APL_RSN_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SORTBY_TYPE MODIFY 
  RPT_SORTBY_TYPE_ID NULL;

ALTER TABLE ADR.RPT_SORTBY_TYPE MODIFY 
  RPT_SORTBY_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SORTBY_TYPE MODIFY 
  CODE NULL;

ALTER TABLE ADR.RPT_SORTBY_TYPE MODIFY 
  CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SORTBY_TYPE MODIFY 
  ISACTIVE NULL;

ALTER TABLE ADR.RPT_SORTBY_TYPE MODIFY 
  ISACTIVE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SORTBY_TYPE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.RPT_SORTBY_TYPE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SORTBY_TYPE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.RPT_SORTBY_TYPE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SORTBY_TYPE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.RPT_SORTBY_TYPE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SORTBY_TYPE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.RPT_SORTBY_TYPE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SORTBY_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.RPT_SORTBY_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.RPT_SORTBY_TYPE MODIFY 
  DESCRIPTION NULL;

ALTER TABLE ADR.RPT_SORTBY_TYPE MODIFY 
  DESCRIPTION NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE_RSN_TYPE MODIFY 
  ISACTIVE NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE_RSN_TYPE MODIFY 
  ISACTIVE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE_RSN_TYPE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE_RSN_TYPE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE_RSN_TYPE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE_RSN_TYPE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE_RSN_TYPE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE_RSN_TYPE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE_RSN_TYPE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE_RSN_TYPE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE_RSN_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE_RSN_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE_RSN_TYPE MODIFY 
  MANUAL_OVERRIDE_RSN_TYPE_ID NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE_RSN_TYPE MODIFY 
  MANUAL_OVERRIDE_RSN_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE_RSN_TYPE MODIFY 
  CODE NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE_RSN_TYPE MODIFY 
  CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE_RSN_TYPE MODIFY 
  NAME NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE_RSN_TYPE MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE MODIFY 
  MANUAL_OVERRIDE_ID NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE MODIFY 
  MANUAL_OVERRIDE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE MODIFY 
  OVERRIDE_IND NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE MODIFY 
  OVERRIDE_IND NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE_H MODIFY 
  MANUAL_OVERRIDE_H_ID NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE_H MODIFY 
  MANUAL_OVERRIDE_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE_H MODIFY 
  MANUAL_OVERRIDE_ID NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE_H MODIFY 
  MANUAL_OVERRIDE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE_H MODIFY 
  OVERRIDE_IND NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE_H MODIFY 
  OVERRIDE_IND NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.MANUAL_OVERRIDE_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.MANUAL_OVERRIDE_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_SIMPROP_TRIGGERS MODIFY 
  SCHED_NAME NULL;

ALTER TABLE ADR.QRTZ_SIMPROP_TRIGGERS MODIFY 
  SCHED_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_SIMPROP_TRIGGERS MODIFY 
  TRIGGER_NAME NULL;

ALTER TABLE ADR.QRTZ_SIMPROP_TRIGGERS MODIFY 
  TRIGGER_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.QRTZ_SIMPROP_TRIGGERS MODIFY 
  TRIGGER_GROUP NULL;

ALTER TABLE ADR.QRTZ_SIMPROP_TRIGGERS MODIFY 
  TRIGGER_GROUP NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_TRANSMIT_H MODIFY 
  GEOCODE_TRANSMIT_H_ID NULL;

ALTER TABLE ADR.GEOCODE_TRANSMIT_H MODIFY 
  GEOCODE_TRANSMIT_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_TRANSMIT_H MODIFY 
  GEOCODE_TRANSMIT_ID NULL;

ALTER TABLE ADR.GEOCODE_TRANSMIT_H MODIFY 
  GEOCODE_TRANSMIT_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_TRANSMIT_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.GEOCODE_TRANSMIT_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_TRANSMIT_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.GEOCODE_TRANSMIT_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_TRANSMIT_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.GEOCODE_TRANSMIT_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_TRANSMIT_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.GEOCODE_TRANSMIT_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_TRANSMIT_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.GEOCODE_TRANSMIT_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_H MODIFY 
  WAITTIME_H_ID NULL;

ALTER TABLE ADR.WAITTIME_H MODIFY 
  WAITTIME_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_H MODIFY 
  WAITTIME_ID NULL;

ALTER TABLE ADR.WAITTIME_H MODIFY 
  WAITTIME_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_H MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.WAITTIME_H MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_H MODIFY 
  WAITTYPE_ID NULL;

ALTER TABLE ADR.WAITTIME_H MODIFY 
  WAITTYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_H MODIFY 
  STD_INSTITUTION_ID NULL;

ALTER TABLE ADR.WAITTIME_H MODIFY 
  STD_INSTITUTION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_H MODIFY 
  WAITLIST_START_DATE NULL;

ALTER TABLE ADR.WAITTIME_H MODIFY 
  WAITLIST_START_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.WAITTIME_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.WAITTIME_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.WAITTIME_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.WAITTIME_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.WAITTIME_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.WAITTIME_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_SERVICE_LOG MODIFY 
  CCN_SERVICE_LOG_ID NULL;

ALTER TABLE ADR.CCN_SERVICE_LOG MODIFY 
  CCN_SERVICE_LOG_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_SERVICE_LOG MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.CCN_SERVICE_LOG MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_SERVICE_LOG MODIFY 
  MAILING_ADDRESS_H_ID NULL;

ALTER TABLE ADR.CCN_SERVICE_LOG MODIFY 
  MAILING_ADDRESS_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_SERVICE_LOG MODIFY 
  VCELIGIBILITY_H_ID NULL;

ALTER TABLE ADR.CCN_SERVICE_LOG MODIFY 
  VCELIGIBILITY_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_SERVICE_LOG MODIFY 
  TRANSMISSION_DATE NULL;

ALTER TABLE ADR.CCN_SERVICE_LOG MODIFY 
  TRANSMISSION_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_SERVICE_LOG MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CCN_SERVICE_LOG MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_SERVICE_LOG MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CCN_SERVICE_LOG MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_SERVICE_LOG MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CCN_SERVICE_LOG MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_SERVICE_LOG MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CCN_SERVICE_LOG MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_SERVICE_LOG MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CCN_SERVICE_LOG MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CCN_CONTRACTOR MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CCN_CONTRACTOR MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CCN_CONTRACTOR MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CCN_CONTRACTOR MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CCN_CONTRACTOR MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR MODIFY 
  CCN_CONTRACTOR_ID NULL;

ALTER TABLE ADR.CCN_CONTRACTOR MODIFY 
  CCN_CONTRACTOR_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR MODIFY 
  CONTRACTOR_NAME NULL;

ALTER TABLE ADR.CCN_CONTRACTOR MODIFY 
  CONTRACTOR_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_H MODIFY 
  CCN_CONTRACTOR_H_ID NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_H MODIFY 
  CCN_CONTRACTOR_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_H MODIFY 
  CCN_CONTRACTOR_ID NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_H MODIFY 
  CCN_CONTRACTOR_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_H MODIFY 
  CONTRACTOR_NAME NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_H MODIFY 
  CONTRACTOR_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_REGION MODIFY 
  CCN_REGION_ID NULL;

ALTER TABLE ADR.CCN_REGION MODIFY 
  CCN_REGION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_REGION MODIFY 
  REGION_NAME NULL;

ALTER TABLE ADR.CCN_REGION MODIFY 
  REGION_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_REGION MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CCN_REGION MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_REGION MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CCN_REGION MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_REGION MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CCN_REGION MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_REGION MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CCN_REGION MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_REGION MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CCN_REGION MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_REGION MODIFY 
  CCN_CONTRACTOR_REGION_ID NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_REGION MODIFY 
  CCN_CONTRACTOR_REGION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_REGION MODIFY 
  CCN_CONTRACTOR_ID NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_REGION MODIFY 
  CCN_CONTRACTOR_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_REGION MODIFY 
  CCN_REGION_ID NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_REGION MODIFY 
  CCN_REGION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_REGION MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_REGION MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_REGION MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_REGION MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_REGION MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_REGION MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_REGION MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_REGION MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_REGION MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_REGION MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H MODIFY 
  CCN_CONTRACTOR_REGION_H_ID NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H MODIFY 
  CCN_CONTRACTOR_REGION_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H MODIFY 
  CCN_CONTRACTOR_REGION_ID NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H MODIFY 
  CCN_CONTRACTOR_REGION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H MODIFY 
  CCN_CONTRACTOR_ID NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H MODIFY 
  CCN_CONTRACTOR_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H MODIFY 
  CCN_REGION_ID NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H MODIFY 
  CCN_REGION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.CCN_CONTRACTOR_REGION_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_REGION_STATE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CCN_REGION_STATE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_REGION_STATE MODIFY 
  CCN_REGION_STATE_ID NULL;

ALTER TABLE ADR.CCN_REGION_STATE MODIFY 
  CCN_REGION_STATE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_REGION_STATE MODIFY 
  STATE_NAME NULL;

ALTER TABLE ADR.CCN_REGION_STATE MODIFY 
  STATE_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_REGION_STATE MODIFY 
  CCN_REGION_ID NULL;

ALTER TABLE ADR.CCN_REGION_STATE MODIFY 
  CCN_REGION_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_REGION_STATE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CCN_REGION_STATE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_REGION_STATE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CCN_REGION_STATE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_REGION_STATE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CCN_REGION_STATE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_REGION_STATE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CCN_REGION_STATE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_REGION_STATE_H MODIFY 
  CCN_REGION_STATE_H_ID NULL;

ALTER TABLE ADR.CCN_REGION_STATE_H MODIFY 
  CCN_REGION_STATE_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_REGION_STATE_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.CCN_REGION_STATE_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_REGION_STATE_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.CCN_REGION_STATE_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_STATION_H MODIFY 
  GEOCODE_STATION_H_ID NULL;

ALTER TABLE ADR.GEOCODE_STATION_H MODIFY 
  GEOCODE_STATION_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_STATION_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.GEOCODE_STATION_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.GEOCODE_STATION_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.GEOCODE_STATION_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_FILETRANSFER MODIFY 
  CCN_FILETRANSFER_ID NULL;

ALTER TABLE ADR.CCN_FILETRANSFER MODIFY 
  CCN_FILETRANSFER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_FILETRANSFER MODIFY 
  TRANSMISSION_TYPE_ID NULL;

ALTER TABLE ADR.CCN_FILETRANSFER MODIFY 
  TRANSMISSION_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_FILETRANSFER MODIFY 
  VCADMISTATUS_TYPE_ID NULL;

ALTER TABLE ADR.CCN_FILETRANSFER MODIFY 
  VCADMISTATUS_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_FILETRANSFER MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CCN_FILETRANSFER MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_FILETRANSFER MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CCN_FILETRANSFER MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_FILETRANSFER MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CCN_FILETRANSFER MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_FILETRANSFER MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CCN_FILETRANSFER MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_FILETRANSFER MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CCN_FILETRANSFER MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_FILETRANSFER_H MODIFY 
  CCN_FILETRANSFER_H_ID NULL;

ALTER TABLE ADR.CCN_FILETRANSFER_H MODIFY 
  CCN_FILETRANSFER_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_FILETRANSFER_H MODIFY 
  HISTORY_CREATED_DATE NULL;

ALTER TABLE ADR.CCN_FILETRANSFER_H MODIFY 
  HISTORY_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_FILETRANSFER_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.CCN_FILETRANSFER_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PCP_STAGE MODIFY 
  PCP_STAGE_ID NULL;

ALTER TABLE ADR.PCP_STAGE MODIFY 
  PCP_STAGE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PCP_STAGE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PCP_STAGE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PCP_STAGE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PCP_STAGE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PCP_STAGE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.PCP_STAGE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PCP_STAGE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PCP_STAGE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PCP_STAGE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PCP_STAGE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG MODIFY 
  CCN_RECEIVED_SERVICE_LOG_ID NULL;

ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG MODIFY 
  CCN_RECEIVED_SERVICE_LOG_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG MODIFY 
  CCN_SERVICE_LOG_ID NULL;

ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG MODIFY 
  CCN_SERVICE_LOG_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG MODIFY 
  CCN_CONTRACTOR_ID NULL;

ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG MODIFY 
  CCN_CONTRACTOR_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG MODIFY 
  ACK_DATE NULL;

ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG MODIFY 
  ACK_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CCN_RECEIVED_SERVICE_LOG MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.LOOKUP_TYPE MODIFY 
  LOOKUP_TYPE_ID NULL;

ALTER TABLE ADR.LOOKUP_TYPE MODIFY 
  LOOKUP_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.LOOKUP_TYPE MODIFY 
  TYPE_GROUP_NAME NULL;

ALTER TABLE ADR.LOOKUP_TYPE MODIFY 
  TYPE_GROUP_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.LOOKUP_TYPE MODIFY 
  CODE NULL;

ALTER TABLE ADR.LOOKUP_TYPE MODIFY 
  CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.LOOKUP_TYPE MODIFY 
  NAME NULL;

ALTER TABLE ADR.LOOKUP_TYPE MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.LOOKUP_TYPE MODIFY 
  ISACTIVE NULL;

ALTER TABLE ADR.LOOKUP_TYPE MODIFY 
  ISACTIVE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.LOOKUP_TYPE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.LOOKUP_TYPE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.LOOKUP_TYPE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.LOOKUP_TYPE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.LOOKUP_TYPE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.LOOKUP_TYPE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.LOOKUP_TYPE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.LOOKUP_TYPE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.LOOKUP_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.LOOKUP_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.LOOKUP_TYPE
  DROP CONSTRAINT LOOKUPTYPE_ISACTIVE_CONS;

ALTER TABLE ADR.LOOKUP_TYPE ADD (
  CONSTRAINT LOOKUPTYPE_ISACTIVE_CONS
  CHECK ( ISACTIVE IN ('0','1'))
  ENABLE VALIDATE);
ALTER TABLE ADR.NARRATIVE_REASON_TYPE MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.NARRATIVE_REASON_TYPE MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.NARRATIVE_REASON_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.NARRATIVE_REASON_TYPE MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.NARRATIVE_REASON_TYPE MODIFY 
  NARRATIVE_REASON_TYPE_ID NULL;

ALTER TABLE ADR.NARRATIVE_REASON_TYPE MODIFY 
  NARRATIVE_REASON_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.NARRATIVE_REASON_TYPE MODIFY 
  CODE NULL;

ALTER TABLE ADR.NARRATIVE_REASON_TYPE MODIFY 
  CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.NARRATIVE_REASON_TYPE MODIFY 
  NAME NULL;

ALTER TABLE ADR.NARRATIVE_REASON_TYPE MODIFY 
  NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.NARRATIVE_REASON_TYPE MODIFY 
  ISACTIVE NULL;

ALTER TABLE ADR.NARRATIVE_REASON_TYPE MODIFY 
  ISACTIVE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.NARRATIVE_REASON_TYPE MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.NARRATIVE_REASON_TYPE MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.NARRATIVE_REASON_TYPE MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.NARRATIVE_REASON_TYPE MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.NARRATIVE_REASON_TYPE MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.NARRATIVE_REASON_TYPE MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.HL7_STATS_MV MODIFY 
  MESSAGE_TRANSMISSION_TYPE_ID NULL;

ALTER TABLE ADR.HL7_STATS_MV MODIFY 
  MESSAGE_TRANSMISSION_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CI_TRANSACTION_LOG MODIFY 
  CI_TRANSACTION_LOG_ID NULL;

ALTER TABLE ADR.CI_TRANSACTION_LOG MODIFY 
  CI_TRANSACTION_LOG_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CI_TRANSACTION_LOG MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.CI_TRANSACTION_LOG MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CI_TRANSACTION_LOG MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.CI_TRANSACTION_LOG MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CI_TRANSACTION_LOG MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.CI_TRANSACTION_LOG MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CI_TRANSACTION_LOG MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.CI_TRANSACTION_LOG MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CI_TRANSACTION_LOG MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.CI_TRANSACTION_LOG MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CI_TRANSACTION_LOG
  DROP CONSTRAINT CI_TRANSACTION_LOG_CHK;

ALTER TABLE ADR.CI_TRANSACTION_LOG ADD (
  CONSTRAINT CI_TRANSACTION_LOG_CHK
  CHECK (ENTITY_TYPE IN ('Address', 'Email', 'Phone'))
  ENABLE VALIDATE);
ALTER TABLE ADR.PERSON_TRAITS_BKP MODIFY 
  PERSON_TRAITS_ID NULL;

ALTER TABLE ADR.PERSON_TRAITS_BKP MODIFY 
  PERSON_TRAITS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_TRAITS_BKP MODIFY 
  VPID_VALUE NULL;

ALTER TABLE ADR.PERSON_TRAITS_BKP MODIFY 
  VPID_VALUE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_TRAITS_BKP MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PERSON_TRAITS_BKP MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_TRAITS_BKP MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PERSON_TRAITS_BKP MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_TRAITS_BKP MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PERSON_TRAITS_BKP MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_TRAITS_BKP MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PERSON_TRAITS_BKP MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_TRAITS MODIFY 
  PERSON_TRAITS_ID NULL;

ALTER TABLE ADR.PERSON_TRAITS MODIFY 
  PERSON_TRAITS_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_TRAITS MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.PERSON_TRAITS MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_TRAITS MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.PERSON_TRAITS MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_TRAITS MODIFY 
  VPID_VALUE NULL;

ALTER TABLE ADR.PERSON_TRAITS MODIFY 
  VPID_VALUE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_TRAITS MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.PERSON_TRAITS MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.PERSON_TRAITS MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.PERSON_TRAITS MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TPA_TRANSMISSION_LOG MODIFY 
  TPA_TRANSMISSION_LOG_ID NULL;

ALTER TABLE ADR.TPA_TRANSMISSION_LOG MODIFY 
  TPA_TRANSMISSION_LOG_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TPA_TRANSMISSION_LOG MODIFY 
  PERSON_ID NULL;

ALTER TABLE ADR.TPA_TRANSMISSION_LOG MODIFY 
  PERSON_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TPA_TRANSMISSION_LOG MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.TPA_TRANSMISSION_LOG MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TPA_TRANSMISSION_LOG MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.TPA_TRANSMISSION_LOG MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TPA_TRANSMISSION_LOG MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.TPA_TRANSMISSION_LOG MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TPA_TRANSMISSION_LOG MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.TPA_TRANSMISSION_LOG MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.TPA_TRANSMISSION_LOG MODIFY 
  RECORD_MODIFIED_COUNT NULL;

ALTER TABLE ADR.TPA_TRANSMISSION_LOG MODIFY 
  RECORD_MODIFIED_COUNT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  APP_PARAMETER_H_ID NULL;

ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  APP_PARAMETER_H_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  APP_PARAMETER_ID NULL;

ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  APP_PARAMETER_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  APP_PARAMETER_TYPE_ID NULL;

ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  APP_PARAMETER_TYPE_ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  PARAMETER_NAME NULL;

ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  PARAMETER_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  PARAMETER_DESCRIPTION NULL;

ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  PARAMETER_DESCRIPTION NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  PARAMETER_VALUE NULL;

ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  PARAMETER_VALUE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  INACTIVE_FLAG NULL;

ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  INACTIVE_FLAG NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  RECORD_CREATED_BY NULL;

ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  RECORD_CREATED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  RECORD_CREATED_DATE NULL;

ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  RECORD_CREATED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  RECORD_MODIFIED_BY NULL;

ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  RECORD_MODIFIED_BY NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  RECORD_MODIFIED_DATE NULL;

ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  RECORD_MODIFIED_DATE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  TRANSACTION_TYPE_CODE NULL;

ALTER TABLE ADR.APP_PARAMETER_H MODIFY 
  TRANSACTION_TYPE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE ADR.CCN_DATALOAD_LOG_STG
  DROP CONSTRAINT CCN_DATALOAD_STAT_CONS;

ALTER TABLE ADR.CCN_DATALOAD_LOG_STG ADD (
  CONSTRAINT CCN_DATALOAD_STAT_CONS
  CHECK ( STATUS IN ('STARTED','COMPLETED'))
  ENABLE VALIDATE);
ALTER TABLE ADR.CCN_SERVICE_LOG_DOB_CONV MODIFY 
  CCN_SERVICE_LOG_ID NULL;

ALTER TABLE ADR.CCN_SERVICE_LOG_DOB_CONV MODIFY 
  CCN_SERVICE_LOG_ID NOT NULL
  ENABLE VALIDATE;
